/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.time.TimestampRequest;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntegralDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register((Class)IntegralDialectElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IntegralDialectElementSelector.class.getName();
    public static final String TIMESTAMP_DURATION = "security.wssecurity.integraldialectelementselector.duration";
    public static final String KEYSIGN_TYPE = "security.wssecurity.integraldialectelementselector.keysigntype";
    public static final String EXIST_STRTRANSFORM = "security.wssecurity.integraldialectelementselector.existstrtransform";
    public static final int BODY = 0;
    public static final int TIMESTAMP = 1;
    public static final int SECURITYTOKEN = 2;
    public static final int DSIGKEY = 3;
    public static final int ENCKEY = 4;
    public static final int MESSAGEID = 5;
    public static final int TO = 6;
    public static final int ACTION = 7;
    public static final int RELATESTO = 8;
    public static final int WSCONTEXT = 9;
    public static final int WSA_FROM = 10;
    public static final int WSA_REPLYTO = 11;
    public static final int WSA_FAULTTO = 12;
    public static final int WSA_ALL = 13;
    public static final String[] WASDIALECTS = new String[]{"body".intern(), "timestamp".intern(), "securitytoken".intern(), "dsigkey".intern(), "enckey".intern(), "messageid".intern(), "to".intern(), "action".intern(), "relatesto".intern(), "wscontext".intern(), "wsafrom".intern(), "wsareplyto".intern(), "wsafaultto".intern(), "wsaall".intern()};
    private static final String[] WSAELEMENTS = new String[]{"MessageID".intern(), "To".intern(), "Action".intern(), "RelatesTo".intern(), "From".intern(), "ReplyTo".intern(), "FaultTo".intern()};
    public static final int KS_KEYINFO = 0;
    public static final int KS_CHILDELEMENT = 1;
    public static final String[] KEYSIGNMETHOD = new String[]{"keyinfo", "keyinfochildelements"};

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        if (!(node instanceof Document)) {
            throw SoapSecurityException.format("security.wssecurity.IntegralDialectElementSelector.s01", node.getClass().getName(), Document.class.getName());
        }
        String string = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Dialect [" + string + "]"));
        }
        if (string == null) {
            throw SoapSecurityException.format("Null is not allowed as the WAS dialect");
        }
        if (!Constants.DIALECT_WAS.equals(string)) {
            throw SoapSecurityException.format(clsName + " does not allow the dialect: " + string + ".");
        }
        String string2 = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Keyword [" + string2 + "]"));
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean bl = "signature_mode".equals((String)v);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Mode [" + v + "]"));
        }
        String string3 = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Process type [" + string3 + "]"));
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Elements [" + objectArray + "]"));
        }
        Set set = (Set)map.get("com.ibm.ws.webservices.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Token generator configs [" + set + "]"));
        }
        String string4 = (String)map.get(KEYSIGN_TYPE);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The type of signing key [" + string4 + "]"));
        }
        boolean bl2 = ConfigUtil.isTrue((String)((String)map.get(EXIST_STRTRANSFORM)));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("STR-Transform exists [" + bl2 + "]"));
        }
        IDResolver iDResolver = (IDResolver)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ID resolver [" + iDResolver + "]"));
        }
        Duration duration = (Duration)map.get(TIMESTAMP_DURATION);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Duration [" + duration + "]"));
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce manager [" + nonceManager + "]"));
        }
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string5 = Constants.NAMESPACES[2][n];
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string6 = Constants.NAMESPACES[0][n];
        String string7 = Constants.NAMESPACES[1][n];
        Document document = (Document)node;
        Element element = document.getDocumentElement();
        Object object = null;
        if (WASDIALECTS[0].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[0] + "]"));
            }
            object = new XPathCanonicalizer.NodeListImpl();
            Element element2 = null;
            try {
                element2 = element instanceof SOAPEnvelope ? ((SOAPEnvelope)element).getBody() : DOMUtil.getOneChildElement((Element)element, (String)string5, (String)"Body");
            }
            catch (SOAPException sOAPException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception from SOAPEnvelope.getBody()" + sOAPException));
                }
                FFDCFilter.processException((Throwable)sOAPException, this.getClass().getName() + ".getElements", "273", this);
                throw new SoapSecurityException(sOAPException);
            }
            object.add((Node)element2);
        } else if (WASDIALECTS[1].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[1] + "]"));
            }
            object = bl ? IntegralDialectElementSelector.getTimestampForSignature(map) : IntegralDialectElementSelector.getTimestampForVerification(element, string7, map);
        } else if (WASDIALECTS[2].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[2] + "]"));
            }
            object = null;
            object = bl ? IntegralDialectElementSelector.getTokensForSignature(set, map) : IntegralDialectElementSelector.getTokensForVerification(set, map);
        } else if (WASDIALECTS[3].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[3] + "]"));
            }
            object = IntegralDialectElementSelector.getDsigKeyObjects(document, map, string4, bl2, iDResolver, string6);
        } else if (WASDIALECTS[4].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[4] + "]"));
            }
            object = IntegralDialectElementSelector.getEncKeyObjects(document, map, string4, bl2, iDResolver, string6);
        } else if (WASDIALECTS[5].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[5] + "]"));
            }
            object = this.getWSAElement(map, document, "MessageID");
        } else if (WASDIALECTS[6].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[6] + "]"));
            }
            object = this.getWSAElement(map, document, "To");
        } else if (WASDIALECTS[7].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[7] + "]"));
            }
            object = this.getWSAElement(map, document, "Action");
        } else if (WASDIALECTS[8].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[8] + "]"));
            }
            object = this.getWSAElement(map, document, "RelatesTo");
        } else if (WASDIALECTS[9].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[9] + "]"));
            }
            object = IntegralDialectElementSelector.getWSContextHeaderElement(document);
        } else if (WASDIALECTS[10].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[10] + "]"));
            }
            object = this.getWSAElement(map, document, "From");
        } else if (WASDIALECTS[11].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[11] + "]"));
            }
            object = this.getWSAElement(map, document, "ReplyTo");
        } else if (WASDIALECTS[12].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[12] + "]"));
            }
            object = this.getWSAElement(map, document, "FaultTo");
        } else if (WASDIALECTS[13].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[13] + "]"));
            }
            object = this.getWSAAllElements(map, document);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", string2);
        }
        if (string3 != null && bl) {
            object = IntegralDialectElementSelector.postprocess(document, string3, (NodeList)object, objectArray, duration, string6, string7, nonceManager, bl, false, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getElements(Node node,Map context)");
        }
        return object;
    }

    public static NodeList postprocess(Document document, String string, NodeList nodeList, Object[] objectArray, Duration duration, String string2, String string3, NonceManager nonceManager, boolean bl, boolean bl2, String string4, String string5) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("postprocess(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "String type[" + string + "]," + "NodeList list[" + nodeList + "]," + "Object[] elements[" + objectArray + "]," + "Duration duration[" + duration + "]," + "String nsWsse[" + string2 + "]," + "String nsWsu[" + string3 + "]," + "NoceManager nmanager[" + nonceManager + "])," + "boolean signature[" + bl + "]," + "boolean encryption[" + bl2 + "]," + "String dialect[" + string4 + "])," + "String keyword[" + string5 + "])"));
        }
        if (nodeList.getLength() == 0) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string4, string5);
        }
        Object object = new XPathCanonicalizer.NodeListImpl();
        String string6 = bl2 ? "weenc" : "wedsig";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = null;
            Element element2 = (Element)nodeList.item(i);
            if ("timestamp".equals(string)) {
                element = NonceUtil.getTimestamp(element2, string3);
                if (element == null) {
                    element = NonceUtil.createTimestamp(document, element2, string3, string6);
                    NonceUtil.addCreated(document, element, string3);
                    if (duration != null) {
                        NonceUtil.addExpires(document, element, duration, string3);
                    }
                }
            } else if ("nonce".equals(string) && (element = NonceUtil.getNonce(element2, string2)) == null) {
                element = NonceUtil.createNonce(document, element2, string2, nonceManager, string6);
            }
            if (objectArray == null) continue;
            boolean bl3 = false;
            for (int j = 0; j < objectArray.length; ++j) {
                if (!DOMUtil.equals((Node)((Node)objectArray[j]), (Node)element2)) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added the element [" + DOMUtil.getDisplayName((Node)element2) + "]"));
            }
            object.add((Node)element2);
        }
        if (bl2) {
            object = new PartList("http://www.w3.org/2001/04/xmlenc#Element", (NodeList)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postprocess(Document doc,String type,NodeList list,Object[] elements,Duration duration,String nsWsse,String nsWsu,NoceManager nmanager,boolean signature,boolean encryption,String dialect,String keyword) returns NodeList[" + object + "]"));
        }
        return object;
    }

    private static NodeList getTimestampForSignature(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTimestmapForSignature(Map context)");
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Request[] requestArray = RequestPool.get((Map)map, (Class)TimestampRequest.class);
        if (requestArray != null && requestArray.length > 0) {
            for (int i = 0; i < requestArray.length; ++i) {
                RequestMessagePool.EncryptedObject encryptedObject;
                TimestampRequest timestampRequest = (TimestampRequest)requestArray[i];
                if (!timestampRequest.isSigned()) continue;
                Element element = timestampRequest.getElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the element [" + DOMUtil.getDisplayName((Node)element) + "]."));
                }
                if ((encryptedObject = RequestMessagePool.convertElement(map, element, -1)) == null) {
                    nodeListImpl.add((Node)element);
                    continue;
                }
                if (encryptedObject.getEncryptedData() != null) {
                    nodeListImpl.add((Node)encryptedObject.getEncryptedData());
                }
                if (encryptedObject.getHeaderInfo() == null) continue;
                nodeListImpl.add((Node)encryptedObject.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimestmapForSignature(Map context)");
        }
        return nodeListImpl;
    }

    private static NodeList getTimestampForVerification(Element element, String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestmapForVerification(Element root[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + string + "]," + "Map context)"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        NodeList nodeList = element.getElementsByTagNameNS(string, "Timestamp");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (element2.hasAttribute("wasextention")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the timestamp element without WAS extention [" + element2 + "]"));
                }
                nodeListImpl.add((Node)element2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestmapForVerification(Element root,String nsWsu,Map context) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static NodeList getTokensForSignature(Set set, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTokensForSignature(Set configs[" + set + "]," + "Map context)"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Set set2 = TokenManager.getTokens(map);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TokenGeneratorConfig tokenGeneratorConfig = (TokenGeneratorConfig)iterator.next();
            if (!tokenGeneratorConfig.isStandAlone()) continue;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                Element element;
                RequestMessagePool.EncryptedObject encryptedObject;
                Token token = (Token)iterator2.next();
                if (!tokenGeneratorConfig.equals(token.getUsedTokenGenerator()) || token.isReferenced()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the token element [" + token.getElement() + "]"));
                }
                if ((encryptedObject = RequestMessagePool.convertElement(map, element = token.getElement(), -1)) == null) {
                    nodeListImpl.add((Node)element);
                    continue;
                }
                if (encryptedObject.getEncryptedData() != null) {
                    nodeListImpl.add((Node)encryptedObject.getEncryptedData());
                }
                if (encryptedObject.getHeaderInfo() == null) continue;
                nodeListImpl.add((Node)encryptedObject.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokensForSignature(Set configs,Map context) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static NodeList getTokensForVerification(Set set, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTokensForVerification(Set configs[" + set + "]," + "Map context)"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        if (set != null) {
            Set set2 = TokenManager.getTokens(map);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)iterator.next();
                if (tokenConsumerConfig.isUsedForVerification() || tokenConsumerConfig.isUsedForDecryption()) continue;
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    Token token = (Token)iterator2.next();
                    if (!tokenConsumerConfig.equals(token.getUsedTokenConsumer()) || token.isReferenced()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the token element [" + token.getElement() + "]"));
                    }
                    nodeListImpl.add((Node)token.getElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokensForVerification(Set configs,Map context) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    public static NodeList getHeaderElement(Document document, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHeaderElement(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "String ns[" + string + "]," + "String ln[" + string2 + "])"));
        }
        NodeList nodeList = null;
        Element element = WSSGenerator.getHeader(document, false);
        if (element != null) {
            nodeList = element.getElementsByTagNameNS(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getHeaderElement(Document doc,String ns,String ln) returns NodeList[" + nodeList + "]"));
        }
        return nodeList;
    }

    private static NodeList getDsigKeyObjects(Document document, Map map, String string, boolean bl, IDResolver iDResolver, String string2) throws SoapSecurityException {
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDsigKeyObjects(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Map context," + "String keyInfoType[" + string + "]," + "boolean existSTRTransform[" + bl + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string2 + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Element element = IntegralDialectElementSelector.getSecurityHeader(map, document);
        if (element != null && (nodeList = DOMUtil.getChildElements((Element)element, (String)Constants.NS_DSIG, (String)"Signature")) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2 = IntegralDialectElementSelector.getKeyObjects(document, (Element)nodeList.item(i), string, bl, iDResolver, string2);
                if (nodeList2.getLength() <= 0) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the key objects in the Signature element [" + DOMUtil.getDisplayName((Node)nodeList2.item(j)) + "]"));
                    }
                    nodeListImpl.add((Node)((Element)nodeList2.item(j)));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDsigKeyObjects(Document doc,Map context,String keyInfoType,boolean existSTRTransform,IDResolver idResolver,String nsWsse) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static NodeList getEncKeyObjects(Document document, Map map, String string, boolean bl, IDResolver iDResolver, String string2) throws SoapSecurityException {
        int n;
        NodeList nodeList;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncKeyObjects(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Map context," + "String keyInfoType[" + string + "]," + "boolean existSTRTransform[" + bl + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string2 + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Element element = IntegralDialectElementSelector.getSecurityHeader(map, document);
        NodeList nodeList2 = null;
        if (element != null && (nodeList2 = DOMUtil.getChildElements((Element)element, (String)Constants.NS_ENC, (String)"EncryptedKey")) != null && nodeList2.getLength() > 0) {
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                nodeList = IntegralDialectElementSelector.getKeyObjects(document, (Element)nodeList2.item(n2), string, bl, iDResolver, string2);
                if (nodeList.getLength() <= 0) continue;
                for (n = 0; n < nodeList.getLength(); ++n) {
                    nodeListImpl.add((Node)((Element)nodeList.item(n)));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the key objects in the EncryptedKey element [" + DOMUtil.getDisplayName((Node)nodeList.item(n)) + "]"));
                }
            }
        }
        if ((nodeList2 = document.getElementsByTagNameNS(Constants.NS_ENC, "EncryptedData")) != null && nodeList2.getLength() > 0) {
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                nodeList = IntegralDialectElementSelector.getKeyObjects(document, (Element)nodeList2.item(n2), string, bl, iDResolver, string2);
                if (nodeList.getLength() <= 0) continue;
                for (n = 0; n < nodeList.getLength(); ++n) {
                    nodeListImpl.add((Node)((Element)nodeList.item(n)));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the key objects in the EncryptedData element [" + DOMUtil.getDisplayName((Node)nodeList.item(n)) + "]"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncKeyObjects(Document doc,Map context,String keyInfoType,boolean existSTRTransform,IDResolver idResolver,String nsWsse) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static NodeList getKeyObjects(Document document, Element element, String string, boolean bl, IDResolver iDResolver, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyObjects(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String keyInfoType[" + string + "]," + "boolean existSTRTransform[" + bl + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string2 + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Element element2 = DOMUtil.getZeroOrOneElement((Element)element, (String)Constants.NS_DSIG, (String)"KeyInfo");
        if (element2 != null) {
            String string3;
            Element element3;
            if (KEYSIGNMETHOD[1].equals(string)) {
                element3 = DOMUtil.getFirstElement((Node)element2);
                while (element3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the element in the KeyInfo element [" + DOMUtil.getDisplayName((Node)element3) + "]"));
                    }
                    nodeListImpl.add((Node)element3);
                    element3 = DOMUtil.getNextElement((Node)element3);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the element in the KeyInfo element [" + DOMUtil.getDisplayName((Node)element2) + "]"));
                }
                nodeListImpl.add((Node)element2);
            }
            if (!bl && (element3 = DOMUtil.getFirstElement((Node)element2, (String)string2, (String)"SecurityTokenReference")) != null && (element3 = DOMUtil.getFirstElement((Node)element3, (String)string2, (String)"Reference")) != null && (string3 = element3.getAttribute("URI")) != null) {
                if (string3.length() < 2 || string3.charAt(0) != '#') {
                    throw new RuntimeException("Unsupported type of URI: " + string3);
                }
                element3 = iDResolver.resolveID(document, string3.substring(1));
                if (element3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the referenced element [" + DOMUtil.getDisplayName((Node)element3) + "]"));
                    }
                    nodeListImpl.add((Node)element3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyObjects(Document doc,Element parent,String keyInfoType,boolean existSTRTransform,IDResolver idResolver,String nsWsse) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    static NodeList getWSContextHeaderElement(Document document) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSContextHeaderElement(Document doc[" + DOMUtil.getDisplayName((Node)document) + "])"));
        }
        NodeList nodeList = null;
        Element element = WSSGenerator.getHeader(document, false);
        if (element != null) {
            nodeList = DOMUtil.getChildElements((Element)element, (String)Constants.NS_WSCTX_V1, (String)"Context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSContextHeaderElement(Document doc) returns NodeList[" + nodeList + "]"));
        }
        return nodeList;
    }

    private final NodeList getWSAElement(Map map, Document document, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSAElement(Map context, Node node[" + DOMUtil.getDisplayName((Node)document) + "], String [" + string + "])"));
        }
        NodeList nodeList = null;
        boolean bl = IntegralDialectElementSelector.isGenerator(map);
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (sOAPMessageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        Element element = WSSGenerator.getHeader(document, false);
        if (element != null) {
            if (bl) {
                String string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getting the element for [" + string + "] for generator"));
                }
                if ((string2 = (String)sOAPMessageContext.getProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace")) == null || string2.length() == 0) {
                    string2 = Constants.NS_WSADDRS[0];
                    Tr.info((TraceComponent)tc, (String)"security.wssecurity.WSEC6732I", (Object)new String[]{string2});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No outbound namespace defined for WS-Address, default [" + string2 + "] is used."));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Namespace for WS-Addressing outbound request [" + string2 + "]."));
                }
                nodeList = DOMUtil.getChildElements((Element)element, (String)string2, (String)string);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getting the element for [" + string + "] for consumer"));
                }
                boolean bl2 = false;
                String string3 = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    nodeList = DOMUtil.getChildElements((Element)element, (String)Constants.NS_WSADDRS[i], (String)string);
                    if (nodeList == null || nodeList.getLength() == 0) continue;
                    string3 = Constants.NS_WSADDRS[i];
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    String string4 = (String)sOAPMessageContext.getProperty("com.ibm.ws.wsaddressing.InboundNamespace");
                    if (string4 == null || string4.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No inbound WS-Addressing namespace is set, setting it to [" + string3 + "]."));
                        }
                        sOAPMessageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", (Object)string3);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Inbound WS-Addressing namespace was set to [" + string4 + "] and namespace found [" + string3 + "]."));
                        }
                        if (!string4.equals(string3)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"getWSAElement(Map context, Document doc, String elementName)");
                            }
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSAElement(Map context, Document doc, String elementName) returns " + this.toString(nodeList)));
        }
        return nodeList;
    }

    private final NodeList getWSAAllElements(Map map, Document document) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSAAllElements(Map context, Node node[" + DOMUtil.getDisplayName((Node)document) + "])"));
        }
        boolean bl = IntegralDialectElementSelector.isGenerator(map);
        Object object = new XPathCanonicalizer.NodeListImpl();
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (sOAPMessageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        Element element = WSSGenerator.getHeader(document, false);
        if (element != null) {
            if (bl) {
                String string;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getting all WSA elements for generator");
                }
                if ((string = (String)sOAPMessageContext.getProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace")) == null || string.length() == 0) {
                    string = Constants.NS_WSADDRS[0];
                    Tr.info((TraceComponent)tc, (String)"security.wssecurity.WSEC6732I", (Object)new String[]{string});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No outbound namespace defined for WS-Address, default [" + string + "] is used."));
                    }
                }
                object = this.getWSAAllElements(element, string, WSAELEMENTS);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getting all WSA elements for consumer");
                }
                boolean bl2 = false;
                String string = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    object = this.getWSAAllElements(element, Constants.NS_WSADDRS[i], WSAELEMENTS);
                    if (object == null || object.getLength() == 0) continue;
                    string = Constants.NS_WSADDRS[i];
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    String string2 = (String)sOAPMessageContext.getProperty("com.ibm.ws.wsaddressing.InboundNamespace");
                    if (string2 == null || string2.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No inbound WS-Addressing namespace is set, setting it to [" + string + "]."));
                        }
                        sOAPMessageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", string);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Inbound WS-Addressing namespace was set to [" + string2 + "] and namespace found [" + string + "]."));
                        }
                        if (!string2.equals(string)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"getWSAElement(Map context, Document doc, String elementName)");
                            }
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSAAllElements(Map context, Document doc) returns " + this.toString((NodeList)object)));
        }
        return object;
    }

    private final NodeList getWSAAllElements(Node node, String string, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getWSAAllElements(Node parent, String [" + string + "], String[] [" + this.toString(stringArray) + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (node2.getNodeType() != 1 || !DOMUtil.equals((Node)node2, (String)string, (String)stringArray[i])) continue;
                nodeListImpl.add(node2);
            }
        }
        return nodeListImpl;
    }

    protected static final Element getSecurityHeader(Map map, Document document) throws SoapSecurityException {
        Configuration configuration;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSecurityHeader(Map context, Document doc[" + DOMUtil.getDisplayName((Node)document) + "])"));
        }
        boolean bl = IntegralDialectElementSelector.isGenerator(map);
        String string = null;
        if (bl) {
            configuration = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (configuration != null) {
                string = configuration.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got generator actor " + string));
            }
        } else {
            configuration = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (configuration != null) {
                string = configuration.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got consumer actor " + string));
            }
        }
        configuration = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int n = 0;
        if (configuration != null && configuration instanceof Integer) {
            n = (Integer)((Object)configuration);
        }
        configuration = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (configuration != null && configuration instanceof Integer) {
            n2 = (Integer)((Object)configuration);
        }
        Element element = WSSGenerator.getHeader(document, false);
        Element element2 = WSSGenerator.getSecurityHeader(element, n, n2, string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityHeader(Map context, Document doc) returns " + element2));
        }
        return element2;
    }

    private final String toString(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]).append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static final boolean isGenerator(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGenerator(Map context)");
        }
        boolean bl = false;
        boolean bl2 = false;
        Object v = map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (v != null) {
            bl = true;
        }
        if ((v = map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) != null) {
            bl2 = true;
        }
        if (bl && bl2 || !bl && !bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not determine generator or consumer");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isGenerator(Map context)");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC6734E");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isGenerator(Map context) returns " + bl));
        }
        return bl;
    }

    private final String toString(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() == 0) {
            return "<empty>";
        }
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            stringBuffer.append(DOMUtil.toString((Node)nodeList.item(i))).append(", ");
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

