/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.w3c.dom.Node;

public class LoginProcessor
implements WSSConsumerComponent {
    public static final String AUTH_JAASCONFIG = "security.wssecurity.auth.login.jaasConfig";
    private static final TraceComponent tc = Tr.register((Class)LoginProcessor.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LoginProcessor.class.getName();
    private static final String JAASCONFIG_DEFAULT = "WSLogin";
    private static final String JAASCONFIG_IDASSERTION = "system.wssecurity.IDAssertion";
    private static final String JAASCONFIG_SIGNATURE = "system.wssecurity.Signature";
    private static final String CALLBACKHANDLER_FACTORY_DEFAULT = "com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl";
    private boolean _initialized = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Element target[" + DOMUtil.getDisplayName((Node)node) + "], " + "Map context)"));
        }
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        Token token = LoginProcessor.checkCaller(wSSConsumerConfig.getCallers(), map);
        this.login((String)wSSConsumerConfig.getProperties().get(AUTH_JAASCONFIG), token, map);
        TokenManager.finalizeSubject(map);
        this.cacheInformation(token, map);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Token checkCaller(Set set, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCaller(Set cconfigs[" + set + "]," + "Map context)"));
        }
        Token token = null;
        if (set != null) {
            Object object;
            Object object2;
            Result[] resultArray = ResultPool.get((Map)map, (Class)AuthResult.class);
            int n = resultArray.length;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("results.length=" + resultArray.length), (Object)resultArray);
            }
            if (n == 0) {
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s01");
            }
            if (n > 2) {
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s02");
            }
            AuthResult authResult = null;
            AuthResult authResult2 = null;
            if (resultArray.length == 1) {
                authResult = (AuthResult)resultArray[0];
                if (authResult.getToken() == null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s03");
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    object2 = (AuthResult)resultArray[i];
                    object = ((AuthResult)object2).getToken();
                    if (object == null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s03");
                    }
                    if (object.isTrusted()) {
                        if (authResult2 != null) {
                            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s04");
                        }
                        authResult2 = object2;
                        continue;
                    }
                    if (authResult != null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s05");
                    }
                    authResult = object2;
                }
            }
            if (tc.isDebugEnabled()) {
                if (authResult2 == null || authResult2.getToken() == null) {
                    Tr.debug((TraceComponent)tc, (String)("Caller token [" + authResult.getToken().getType() + "]"));
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Caller token [" + authResult.getToken().getType() + "], " + "TrustMethod token [" + authResult2.getToken().getType() + "]"));
                }
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (WSSConsumerConfig.CallerConfig)iterator.next();
                boolean bl = false;
                WSSConsumerConfig.CallerConfig callerConfig = object.getTrustMethod();
                if (callerConfig == null) {
                    if (authResult2 != null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s06");
                    }
                    bl = true;
                } else if (authResult2 == null) {
                    if (callerConfig.getTokenType() != null || callerConfig.getPart() != null) throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s07");
                    bl = true;
                } else {
                    object2 = callerConfig.getTokenType();
                    if (object2 == null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s08");
                    }
                    if (callerConfig.equals(authResult2._config)) {
                        bl = LoginProcessor.checkProperties(callerConfig, authResult2.getToken());
                    }
                }
                if (!bl) continue;
                bl = false;
                object2 = object.getTokenType();
                if (object2 == null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s09");
                }
                if (object.equals(authResult._config)) {
                    bl = LoginProcessor.checkProperties((WSSConsumerConfig.CallerConfig)object, authResult.getToken());
                }
                if (!bl) continue;
                if (token != null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s10");
                }
                token = authResult.getToken();
                break;
            }
        }
        if (!tc.isEntryEnabled()) return token;
        Tr.exit((TraceComponent)tc, (String)("checkCaller(Set cconfigs,Map context) returns Token[" + token + "]"));
        return token;
    }

    private static boolean checkProperties(WSSConsumerConfig.CallerConfig callerConfig, Token token) {
        boolean bl;
        block8: {
            Set set;
            Map map;
            block9: {
                block7: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("checkProperties(CallerConfig cconfig[" + callerConfig + "]," + "Token token[" + token + "])"));
                    }
                    bl = true;
                    map = callerConfig.getProperties();
                    if (map != null) break block7;
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"properties is null.");
                    break block8;
                }
                set = map.keySet();
                if (set != null && !set.isEmpty()) break block9;
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"CallerConfig's properties has no entry.");
                break block8;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CALLER_TOKEN_NS.equals(string) || com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CALLER_TOKEN_LN.equals(string)) continue;
                String string2 = (String)map.get(string);
                String[] stringArray = token.getAttributes(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("key [" + string + "], value [" + string2 + "], values [" + stringArray + "]."));
                }
                if (stringArray == null || stringArray.length == 0 || stringArray.length > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"values is invalid.");
                    }
                    bl = false;
                    break;
                }
                if (string2.equals(stringArray[0])) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("value [" + string2 + "] is different from values[0] [" + stringArray[0] + "]."));
                }
                bl = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkProperties(CallerConfig cconfig,Token token) returns boolean[" + bl + "]"));
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private void login(String var1_1, Token var2_2, Map var3_3) throws SoapSecurityException {
        block65: {
            block64: {
                block63: {
                    if (LoginProcessor.tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)LoginProcessor.tc, (String)("login(String jaasConfig[" + var1_1 + "]," + "Token token[" + var2_2 + "]," + "Map context)"));
                    }
                    var4_4 = (Subject)var3_3.get("com.ibm.wsspi.wssecurity.core.subject");
                    var5_5 = ContextManagerFactory.getInstance();
                    var6_6 = null;
                    if (var5_5 == null) {
                        Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.ctxmgr.isnull");
                    } else {
                        var6_6 = var5_5.getDefaultRealm();
                    }
                    var7_7 = null;
                    var8_8 = null;
                    try {
                        var7_7 = _wsCredToken._wsCredTokenMapper;
                        if (var7_7 != null && var4_4 != null) {
                            var8_8 = var7_7.createSubjectUniqueID(var4_4);
                        }
                    }
                    catch (Exception var9_9) {
                        Tr.processException((Throwable)var9_9, (String)(LoginProcessor.clsName + ".login"), (String)"411", (Object)this);
                        if (!LoginProcessor.tc.isDebugEnabled()) break block63;
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Caught exception while getting unique ID from subject.", (Object)new Object[]{var9_9});
                    }
                }
                if (LoginProcessor.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Unique ID from tokens in contextSubject: " + var8_8));
                }
                var9_10 = _authCacheClass._authCache;
                var10_11 = null;
                if (var9_10 == null) ** GOTO lbl40
                if (var8_8 == null || var8_8.length() == 0) {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Unique ID based on tokens is null. Look for Subject in AuthCache using token.");
                    }
                    var10_11 = this.getCachedSubjectUsingToken(var9_10, var2_2, var6_6);
                } else {
                    try {
                        var10_11 = var9_10.getSubject(var8_8);
                    }
                    catch (CacheException var11_12) {
                        Tr.processException((Throwable)var11_12, (String)(LoginProcessor.clsName + ".login"), (String)"434", (Object)this);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Caught exception while looking up subject from AuthCache.", (Object)new Object[]{var11_12});
                        }
                        break block64;
                    }
lbl40:
                    // 1 sources

                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Not looking Subject in cache because SecurityCache instance is null.");
                    }
                }
            }
            if (var10_11 != null) {
                var11_13 = (WSCredential)var10_11.getPublicCredentials(WSCredential.class).iterator().next();
                if (var11_13 != null) {
                    var12_14 = var11_13.isDestroyed();
                    var13_16 = false;
                    try {
                        var13_16 = var11_13.isForwardable();
                    }
                    catch (Exception var14_24) {
                        var12_14 = true;
                    }
                    var14_25 = var7_7.checkCushionValidityOfAllTokens(var10_11, var9_10.getCushion());
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        if (var13_16) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("credential is forwardable, subject valid = " + var14_25));
                        } else {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"non-forwardable Subject");
                        }
                    }
                    if (var12_14 || var13_16 && !var14_25) {
                        var10_11 = null;
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Credential has expired or is destroyed, logging in again.");
                        }
                    } else if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Cached subject is valid.");
                    }
                } else {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"No WSCredential in Subject, logging in again.");
                    }
                    var10_11 = null;
                }
            }
            if (var10_11 != null) break block65;
            if (LoginProcessor.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Subject not found in AuthCache.");
            }
            var11_13 = VaultImpl.getSecurityConfiguration();
            var12_15 = null;
            if (var11_13 != null) {
                var12_15 = var11_13.getAuthMechAuthAlias();
            }
            if (LoginProcessor.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("authMech is " + var12_15));
            }
            try {
                block67: {
                    block68: {
                        block66: {
                            if (!(var2_2 instanceof UsernameToken)) break block66;
                            var13_17 = (UsernameToken)var2_2;
                            var14_26 = var13_17.getUsername();
                            if (var14_26 == null || var14_26.length() == 0) {
                                Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.WSEC6735E", (Object)new Object[]{var2_2.getType().toString(), "Login cancelled: username string is null or empty."});
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s11", "Login cancelled: username string is null or empty.");
                            }
                            var15_30 = var13_17;
                            var16_32 = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return var15_30.getPassword();
                                }
                            });
                            var17_34 = null;
                            if (var16_32 != null) {
                                var17_34 = new String(var16_32);
                            }
                            if (var17_34 == null || var17_34.length() == 0) {
                                var14_26 = this.callingMappingLoginModule("system.wssecurity.IDAssertion", var2_2, var4_4, var14_26);
                                var10_11 = this.jaasLogin(var12_15, var14_26, var6_6);
                            } else {
                                var10_11 = this.jaasLogin(var12_15, var14_26, var6_6, var17_34);
                            }
                            LoginProcessor.addToSubject(var3_3, var10_11);
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)"UsernameToken found.");
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Username [" + var14_26 + "], Password [" + (var16_32 == null ? "null" : "not null") + "]."));
                            }
                            break block67;
                        }
                        if (!(var2_2 instanceof X509BSToken)) break block68;
                        var13_18 = (X509BSToken)var2_2;
                        var14_27 = UserRegistryProcessor.mapCertificate(var13_18.getCert());
                        if (var14_27 == null || var14_27.length() == 0) {
                            var14_27 = var2_2.getPrincipal();
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("User security from X509BSToken.getPrincipal() [" + var14_27 + "]"));
                            }
                        } else if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("User security from UserRegistryProcessor.mapCertificate() [" + var14_27 + "]"));
                        }
                        var14_27 = this.callingMappingLoginModule("system.wssecurity.Signature", var2_2, var4_4, var14_27);
                        var10_11 = this.jaasLogin(var12_15, var14_27, var6_6);
                        LoginProcessor.addToSubject(var3_3, var10_11);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"X509BSToken found.");
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Username [" + var13_18.getCert().getSubjectX500Principal().getName() + "]."));
                        }
                        break block67;
                    }
                    if (!(var2_2 instanceof LTPATokenWrapper)) ** GOTO lbl136
                    var14_28 = var13_19 = (LTPATokenWrapper)var2_2;
                    var15_31 = (WSCredential)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return var14_28.getWSCredential();
                        }
                    });
                    var16_33 = var13_19.getWSPrincipal();
                    if (var15_31 != null) {
                        this.addToSubject(var3_3, var15_31);
                        this.addToSubject(var3_3, var16_33);
                        this.addToSubject(var3_3, var2_2);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"LTPATokenWrapper found.");
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("WSCredential [" + var15_31 + "]."));
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("WSPrincipal [" + var16_33 + "]."));
                        }
                    } else {
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"No WSCredential found in LTPATokenWrapper.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSEC0168E");
lbl136:
                        // 1 sources

                        if (var2_2 instanceof LTPAToken) {
                            var13_20 = (LTPAToken)var2_2;
                            var14_29 = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return var13_20.getBytes();
                                }
                            });
                            if (var14_29 == null) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Null credential value found for the LTPA token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", "Login cancelled by invalid token.");
                            }
                            var10_11 = this.jaasLogin(var12_15, var14_29);
                            LoginProcessor.addToSubject(var3_3, var10_11);
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)"LTPA Token found.");
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Credential [" + var14_29 + "]."));
                            }
                        } else {
                            var13_21 = var2_2.getPrincipal();
                            if (var13_21 == null) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Null principal value found for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", "Login cancelled by invalid token.");
                            }
                            if ((var13_21 = var13_21.trim()).length() == 0) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Principal value is zero length value for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", "Login cancelled by invalid token.");
                            }
                            var13_21 = this.callingMappingLoginModule("system.wssecurity.IDAssertion", var2_2, var4_4, var13_21);
                            var10_11 = this.jaasLogin(var12_15, var13_21, var6_6);
                            LoginProcessor.addToSubject(var3_3, var10_11);
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Token [" + var2_2.getType() + "] found."));
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Principal [" + var2_2.getPrincipal() + "]."));
                            }
                        }
                    }
                }
                if (var7_7 == null || var10_11 == null || var9_10 == null) ** GOTO lbl189
                this.addTokensToLoginSubject(var3_3, var10_11);
                var8_8 = var7_7.createSubjectUniqueID(var10_11);
                if (var8_8 == null || var8_8.length() == 0) {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Unique ID is null. Adding Subject to AuthCache");
                    }
                    var9_10.insert(var10_11);
                }
                if (LoginProcessor.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Adding Subject with ID " + var8_8 + " to AuthCache"));
                }
                var9_10.insert(var10_11, new Object[]{var8_8});
            }
            catch (LoginException var13_22) {
                Tr.processException((Throwable)var13_22, (String)(LoginProcessor.clsName + ".login"), (String)"651", (Object)this);
                Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.WSEC6735E", (Object)new Object[]{var2_2.getType().toString(), var13_22});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", (Throwable)var13_22);
            }
            catch (Exception var13_23) {
                Tr.processException((Throwable)var13_23, (String)(LoginProcessor.clsName + ".login"), (String)"656", (Object)this);
                Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.WSEC6735E", (Object)new Object[]{var2_2.getType().toString(), var13_23});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", (Throwable)var13_23);
            }
        }
        if (LoginProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Subject found in AuthCache.");
        }
        LoginProcessor.addToSubject(var3_3, var10_11);
lbl189:
        // 4 sources

        if (LoginProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Subject after authentication: " + var10_11));
        }
        var2_2.setUsedToLogin(true);
        if (LoginProcessor.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)LoginProcessor.tc, (String)"login(String jaasConfig, Token token, Map context)");
        }
    }

    private String callingMappingLoginModule(String string, Token token, Subject subject, String string2) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callingMappingLoginModule(jassLoginConfig=[" + string + "], token=[" + token + "], contextSubject=[" + subject + "], identity=[" + string2 + "])"));
        }
        String string3 = null;
        try {
            Tr.debug((TraceComponent)tc, (String)"Normalizing identity");
            string3 = KeyStoreKeyLocator.encodedName(string2);
            Tr.debug((TraceComponent)tc, (String)("securityName=[" + string3 + "]"));
        }
        catch (KeyLocatorException keyLocatorException) {
            Tr.debug((TraceComponent)tc, (String)("Error normalizing identity, securityName=[" + string3 + "]"));
            string3 = string2;
        }
        WSCallbackHandlerFactoryImpl wSCallbackHandlerFactoryImpl = new WSCallbackHandlerFactoryImpl();
        wSCallbackHandlerFactoryImpl.setXMLToken(token.getElement());
        wSCallbackHandlerFactoryImpl.setUsername(string3);
        HashMap hashMap = new HashMap();
        wSCallbackHandlerFactoryImpl.setProperties(hashMap);
        LoginContext loginContext = new LoginContext(string, subject, wSCallbackHandlerFactoryImpl.newCallbackHandler());
        loginContext.login();
        String string4 = (String)hashMap.get("LoginUsername");
        if (string4 != null && (string4 = string4.trim()).length() != 0) {
            string3 = string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callingMappingLoginModule() returns " + string3));
        }
        return string3;
    }

    public static void addToSubject(Map map, final Subject subject) {
        final Subject subject2 = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator<Principal> iterator;
                Iterator<Object> iterator2;
                Iterator<Object> iterator3 = subject.getPublicCredentials().iterator();
                while (iterator3.hasNext()) {
                    iterator2 = iterator3.next();
                    if (iterator2 == null) continue;
                    if (!subject2.getPublicCredentials().contains(iterator2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding public object to Subject: " + iterator2));
                        }
                        subject2.getPublicCredentials().add(iterator2);
                        continue;
                    }
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.LoginProcessor.s15");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Public object already in Subject: " + iterator2));
                }
                iterator2 = subject.getPrivateCredentials().iterator();
                while (iterator2.hasNext()) {
                    iterator = iterator2.next();
                    if (iterator == null) continue;
                    if (!subject2.getPrivateCredentials().contains(iterator)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding private object to Subject: " + iterator));
                        }
                        subject2.getPrivateCredentials().add(iterator);
                        continue;
                    }
                    if (iterator instanceof Token) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("ws-sec Token private object already in Subject: " + iterator));
                        continue;
                    }
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.LoginProcessor.s16");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Private object already in Subject: " + iterator));
                }
                iterator = subject.getPrincipals().iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                    if (principal == null) continue;
                    if (!subject2.getPrincipals().contains(principal)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding principal object to Subject: " + principal));
                        }
                        subject2.getPrincipals().add(principal);
                        continue;
                    }
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.LoginProcessor.s14");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Principal object already in Subject: " + principal));
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject2);
    }

    private void addToSubject(Map map, final WSCredential wSCredential) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPublicCredentials().contains(wSCredential)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding WSCredential to Subject: " + wSCredential));
                    }
                    subject.getPublicCredentials().add(wSCredential);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WSCredential already in Subject: " + wSCredential));
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
    }

    private void addToSubject(Map map, final Token token) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrivateCredentials().contains(token)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding Token to Subject: " + token));
                    }
                    subject.getPrivateCredentials().add(token);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token already in Subject: " + token));
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
    }

    private void addToSubject(Map map, final WSPrincipal wSPrincipal) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrincipals().contains(wSPrincipal)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding WSPrincipal to Subject: " + wSPrincipal));
                    }
                    subject.getPrincipals().add(wSPrincipal);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WSPrincipal already in Subject: " + wSPrincipal));
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
    }

    private void addTokensToLoginSubject(Map map, final Subject subject) {
        final Subject subject2 = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator<Object> iterator = subject2.getPrivateCredentials().iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object == null) continue;
                    if (!subject.getPrivateCredentials().contains(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding private object to Subject: " + object));
                        }
                        subject.getPrivateCredentials().add(object);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Private object already in Subject: " + object));
                }
                return null;
            }
        });
    }

    private void cacheInformation(Token token, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cacheInformation(Token token[" + token + "]," + "Map context)"));
        }
        Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
        } else {
            contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", subject);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initial Sender is set.");
            }
            subject = (Subject)contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
            if (token instanceof X509BSToken) {
                X509Certificate x509Certificate = ((X509BSToken)token).getCert();
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", x509Certificate);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initial Cert is set.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheInformation(Token token,Map context)");
        }
    }

    private Subject getCachedSubjectUsingToken(SecurityCache securityCache, Token token, String string) {
        Subject subject;
        block17: {
            subject = null;
            if (securityCache != null && token != null) {
                try {
                    if (token instanceof UsernameToken) {
                        UsernameToken usernameToken = (UsernameToken)token;
                        String string2 = usernameToken.getUsername();
                        if (string2 != null && string2.length() > 0) {
                            char[] cArray = null;
                            final UsernameToken usernameToken2 = usernameToken;
                            cArray = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return usernameToken2.getPassword();
                                }
                            });
                            String string3 = null;
                            if (cArray != null) {
                                string3 = new String(cArray);
                            }
                            subject = string3 == null || string3.length() == 0 ? securityCache.getSubject(string, string2) : securityCache.getSubject(string, string2, string3);
                        }
                    } else if (token instanceof LTPATokenWrapper) {
                        subject = null;
                    } else if (token instanceof LTPAToken) {
                        final LTPAToken lTPAToken = (LTPAToken)token;
                        byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return lTPAToken.getBytes();
                            }
                        });
                        if (byArray != null) {
                            subject = securityCache.getSubject(byArray);
                        }
                    } else if (token instanceof X509BSToken) {
                        X509BSToken x509BSToken = (X509BSToken)token;
                        String string4 = UserRegistryProcessor.mapCertificate(x509BSToken.getCert());
                        if (string4 == null || string4.length() == 0) {
                            string4 = token.getPrincipal();
                        }
                        subject = securityCache.getSubject(string, string4);
                    } else if (token.getPrincipal() != null) {
                        subject = securityCache.getSubject(string, token.getPrincipal());
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception looking up Subject from AuthCache: " + exception));
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCachedSubjectUsingToken: returning Subject = " + subject));
        }
        return subject;
    }

    private Subject jaasLogin(String string, String string2, String string3) throws LoginException, WSLoginFailedException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        if (string2 == null || string2.length() == 0) {
            throw new WSLoginFailedException("Username is null.");
        }
        LoginContext loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string3, (String)null));
        loginContext.login();
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        return subject;
    }

    private Subject jaasLogin(String string, String string2, String string3, String string4) throws LoginException, WSLoginFailedException {
        if (string2 == null || string2.length() == 0 || string4 == null || string4.length() == 0) {
            throw new WSLoginFailedException("Username and/or password is null.");
        }
        LoginContext loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string3, string4));
        loginContext.login();
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        return subject;
    }

    private Subject jaasLogin(String string, byte[] byArray) throws LoginException, WSLoginFailedException {
        LoginContext loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray));
        loginContext.login();
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        return subject;
    }

    private static class _authCacheClass {
        static SecurityCache _authCache = null;
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            Method method2 = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method2 = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException((Throwable)exception, (String)(clsName + ".getAuthCacheGetInstanceMethod"), (String)"1121");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            return method2;
        }

        private static Class getAuthCacheClass() {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".getAuthCacheClass"), (String)"1148");
                throw new UndeclaredThrowableException(exception);
            }
            return clazz;
        }

        static {
            try {
                Method method2 = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method2 != null) {
                    _authCache = (SecurityCache)method2.invoke(null, null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug((TraceComponent)tc, (String)"AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "1105");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "1081");
            }
        }
    }
}

