/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.time;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.time.TimestampRequest;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimestampGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register((Class)TimestampGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[2][n];
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (v != null && v instanceof Integer) {
            n2 = (Integer)v;
        }
        String string2 = Constants.NAMESPACES[1][n2];
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", "Null", "the parent element");
        }
        Element element2 = NonceUtil.getTimestamp(element, string2);
        if (element2 != null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s01");
        }
        element2 = NonceUtil.createTimestamp(document, element, string2, null);
        TimestampGeneratorConfig timestampGeneratorConfig = (TimestampGeneratorConfig)map.remove("com.ibm.wsspi.wssecurity.config.timestampGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TimestampGeneratorConfig [" + timestampGeneratorConfig + "]."));
        }
        if (timestampGeneratorConfig.getSOAPHeaderAttribute()) {
            TimestampGenerator.setAttributeForSOAPHeader(element2, n, string, timestampGeneratorConfig.getTargetActor());
        }
        element2 = (Element)element.insertBefore(element2, element.getFirstChild());
        Element element3 = NonceUtil.addCreated(document, element2, string2);
        Element element4 = null;
        if (timestampGeneratorConfig.getDuration() != null) {
            element4 = NonceUtil.addExpires(document, element2, timestampGeneratorConfig.getDuration(), string2);
        }
        boolean bl2 = (bl = timestampGeneratorConfig.toBeSigned()) && n2 != 0;
        TimestampRequest timestampRequest = new TimestampRequest(bl);
        timestampRequest.setElement(element2);
        RequestPool.add((Map)map, (Request)timestampRequest);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static void setAttributeForSOAPHeader(Element element, int n, String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setAttributeForSOAPHeader(Element timestamp[" + DOMUtil.getDisplayName((Node)element) + "]," + "int soapVersion[" + n + "]," + "String nsSoap[" + string + "]," + "String actor[" + string2 + "])"));
        }
        String string4 = DOMUtil.getNamespacePrefix((Element)element, (String)string);
        if (string2 != null) {
            String string5 = string3 = n == 0 ? "actor" : "role";
            if (string4 == null || string4.length() <= 0) {
                string4 = "env";
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:env", string);
            }
            element.setAttributeNS(string, string4 + ":" + string3, string2);
        }
        if ((string3 = "1") != null) {
            if (string4 == null || string4.length() <= 0) {
                string4 = "env";
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:env", string);
            }
            element.setAttributeNS(string, string4 + ":mustUnderstand", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributeForSOAPHeader(Element timestamp,int soapVersion,String nsSoap,String actor)");
        }
    }

    public static void moveTimestamp(Document document, TimestampGeneratorConfig timestampGeneratorConfig, Map map, Map map2) throws SoapSecurityException {
        NodeList nodeList;
        Request[] requestArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("moveTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "TimestampGeneratorConfig config," + "Map selectors," + "Map context)"));
        }
        if ((requestArray = RequestPool.get((Map)map2, (Class)TimestampRequest.class)) == null || requestArray.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s13");
        }
        if (requestArray.length > 1) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
        }
        TimestampRequest timestampRequest = (TimestampRequest)requestArray[0];
        Element element = timestampRequest.getElement();
        RequestMessagePool.EncryptedObject encryptedObject = RequestMessagePool.convertElement(map2, element, -1);
        if (encryptedObject != null) {
            element = encryptedObject.getEncryptedData();
        }
        Map map3 = timestampGeneratorConfig.getProperties();
        String string = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String string2 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        if (string == null) {
            string = Constants.DIALECT_WAS;
            string2 = timestampGeneratorConfig.isSOAPHeaderElement() ? TimestampDialectElementSelector.WASDIALECTS[3] : TimestampDialectElementSelector.WASDIALECTS[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Moving the Timestamp element to Dialect[" + string + "], " + "Keyword[" + string2 + "]..."));
        }
        if ((nodeList = TimestampGenerator.getTimestamp(document, string, string2, "move", timestampRequest, encryptedObject, element, map, map2)) != null && nodeList.getLength() > 0) {
            if (nodeList.getLength() > 1) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s14");
            }
            element.getParentNode().removeChild(element);
            Element element2 = (Element)nodeList.item(0);
            element = (Element)element2.appendChild(element);
            if (encryptedObject != null) {
                encryptedObject.setEncryptedData(element);
            } else {
                timestampRequest.setElement(element);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Succeed to move the Timestamp element to Dialect[" + string + "], " + "Keyword[" + string2 + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"moveTimestamp(Document doc,TimestampGeneratorConfig config,Map selectors,Map context)");
        }
    }

    public static NodeList getTimestamp(Document document, String string, String string2, String string3, TimestampRequest timestampRequest, RequestMessagePool.EncryptedObject encryptedObject, Element element, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "String dialect[" + string + "]," + "String keyword[" + string2 + "]," + "String mode[" + string3 + "]," + "TimestampRequest trequest[" + timestampRequest + "]," + "EncryptedObject eobject[" + encryptedObject + "]," + "Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map selectors," + "Map context)"));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map2);
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", string);
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", string2);
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", string3);
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.element", new Object[]{element});
        ElementSelector elementSelector = null;
        if (Constants.DIALECT_WAS.equals(string)) {
            elementSelector = (ElementSelector)map.get(TimestampDialectElementSelector.class);
        } else if (Constants.DIALECT_FUNCTION.equals(string)) {
            elementSelector = (ElementSelector)map.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(string)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        NodeList nodeList = elementSelector.getElements(document, hashMap);
        if (encryptedObject != null) {
            Object[] objectArray = (Object[])hashMap.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
            encryptedObject.setEncryptedData((Element)objectArray[0]);
        } else if (timestampRequest != null) {
            Object[] objectArray = (Object[])hashMap.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
            timestampRequest.setElement((Element)objectArray[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimestamp(Document doc,String dialect,String keyword,String mode,TimestampRequest trequest,EncryptedObject eobject,Element element,Map context)");
        }
        return nodeList;
    }
}

