/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.time;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimestampChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register((Class)TimestampChecker.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampChecker.class.getName();
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[1][n];
        Document document = null;
        document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        TimestampConsumerConfig timestampConsumerConfig = (TimestampConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TimestampConsumerConfig [" + timestampConsumerConfig + "]."));
        }
        Set set = TimestampChecker.preprocess(document, timestampConsumerConfig, this._selectors, string, map);
        Result[] resultArray = ResultPool.get((Map)map, (Class)TimestampResult.class);
        if (resultArray != null && resultArray.length > 0) {
            ResultPool.remove((Map)map, (Result[])resultArray);
            for (int i = 0; i < resultArray.length; ++i) {
                object = (TimestampResult)resultArray[i];
                RequiredPart requiredPart = TimestampChecker.getRelatedPart(((TimestampResult)object)._element, set);
                if (requiredPart == null) continue;
                if (((TimestampResult)object)._ex != null) {
                    throw ((TimestampResult)object)._ex;
                }
                requiredPart._processed = true;
            }
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (RequiredPart)iterator.next();
            if (((RequiredPart)object)._processed) continue;
            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s01");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static Set preprocess(Document document, TimestampConsumerConfig timestampConsumerConfig, Map map, String string, Map map2) throws SoapSecurityException {
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("preprocess(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "TimestampConsumerConfig tconfig," + "Set selectors[" + map + "]," + "String nsWsu[" + string + "]," + "Map context)"));
        }
        HashSet<RequiredPart> hashSet = new HashSet<RequiredPart>();
        Map map3 = timestampConsumerConfig.getProperties();
        String string2 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
        boolean bl = ConfigUtil.isTrue((String)string2);
        String string3 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String string4 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        if (string3 == null) {
            string3 = Constants.DIALECT_WAS;
            string4 = bl ? TimestampDialectElementSelector.WASDIALECTS[5] : TimestampDialectElementSelector.WASDIALECTS[4];
        }
        if ((nodeList = TimestampGenerator.getTimestamp(document, string3, string4, "check", null, null, null, map, map2)) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string5 = element.getNamespaceURI();
                String string6 = element.getLocalName();
                if (!string.equals(string5) || !"Timestamp".equals(string6)) {
                    throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", string4);
                }
                RequiredPart requiredPart = new RequiredPart(element);
                hashSet.add(requiredPart);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preprocess(Document doc,TimestampConsumerConfig tconfig,Set selectors,String nsWsu,Map context)");
        }
        return hashSet;
    }

    private static RequiredPart getRelatedPart(Element element, Set set) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRelatedPart(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "Set requiredParts[" + set + "])"));
        }
        RequiredPart requiredPart = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RequiredPart requiredPart2 = (RequiredPart)iterator.next();
            if (DOMUtil.equals((Node)requiredPart2._element, (Node)element)) {
                requiredPart = requiredPart2;
                break;
            }
            if (requiredPart == null) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelatedPart(Element element,Set requiredParts)");
        }
        return requiredPart;
    }

    private static class RequiredPart {
        private Element _element;
        private boolean _processed;

        RequiredPart(Element element) {
            this._element = element;
            this._processed = false;
        }
    }
}

