/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;
import java.security.cert.X509Certificate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.LoginException;

public class WSUserRegistry
extends UserRegistry {
    private String realm = null;
    private static com.ibm.websphere.security.UserRegistry _userRegistry = null;
    private static UserMapping _userMapping = null;
    private static final String USERMAPPING_IMPL = "com.ibm.ws.security.core.UserMappingImpl";
    private static final TraceComponent tc = Tr.register((Class)WSUserRegistry.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSUserRegistry.class.getName();
    private static final Permission PERM = new WebSphereRuntimePermission("wssecurity.WSUserRegistry.mapCertificate");

    public String getRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (this.realm == null) {
            com.ibm.websphere.security.UserRegistry userRegistry = WSUserRegistry.getUserRegistry();
            if (userRegistry != null) {
                try {
                    this.realm = userRegistry.getRealm();
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSUserRegistry.token50", (Object)exception);
                    Tr.processException((Throwable)exception, (String)(clsName + ".getRealm"), (String)"59", (Object)((Object)this));
                }
            } else {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
                } else {
                    this.realm = contextManager.getDefaultRealm();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public String mapCertificate(X509Certificate x509Certificate) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate", (Object)new Object[]{x509Certificate});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(PERM);
        }
        String string = null;
        UserMapping userMapping = WSUserRegistry.getUserMapping();
        if (userMapping != null) {
            try {
                string = userMapping.mapCertificateToName(new X509Certificate[]{x509Certificate});
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".mapCertificate"), (String)"94", (Object)((Object)this));
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5185W", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", string);
        }
        return string;
    }

    public boolean checkUsername(String string) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkUsername");
        }
        com.ibm.websphere.security.UserRegistry userRegistry = WSUserRegistry.getUserRegistry();
        boolean bl = false;
        try {
            if (userRegistry != null) {
                bl = userRegistry.isValidUser(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + string + "] = " + bl));
                }
                if (!bl) {
                    String string2 = userRegistry.getUserSecurityName(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.getUserSecurityName()=" + string2));
                    }
                    bl = userRegistry.isValidUser(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + string2 + "] = " + bl));
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.checkUsername", (Object)exception);
            Tr.processException((Throwable)exception, (String)(clsName + ".checkUsername"), (String)"%C");
            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurityWSUserRegistry.token48", (String[])new String[]{string, exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkUsername(String username) returns boolean[" + bl + "]"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.ibm.websphere.security.UserRegistry getUserRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserRegistry");
        }
        if (_userRegistry == null && ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
                Object object = initialContext.lookup("UserRegistry");
                _userRegistry = (com.ibm.websphere.security.UserRegistry)PortableRemoteObject.narrow((Object)object, (Class)com.ibm.websphere.security.UserRegistry.class);
            }
            catch (NamingException namingException) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSUserRegistry.token48", (Object)namingException);
                Tr.processException((Throwable)namingException, (String)(clsName + ".getUserRegistry"), (String)"163");
            }
            finally {
                if (initialContext != null) {
                    try {
                        initialContext.close();
                    }
                    catch (NamingException namingException) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSUserRegistry.token48", (Object)namingException);
                        Tr.processException((Throwable)namingException, (String)(clsName + ".getUserRegistry"), (String)"170");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserRegistry", (Object)_userRegistry);
        }
        return _userRegistry;
    }

    private static UserMapping getUserMapping() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserMapping");
        }
        if (_userMapping == null && ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            try {
                Class clazz = WSUserRegistry.class;
                Class<?> clazz2 = Class.forName(USERMAPPING_IMPL);
                _userMapping = (UserMapping)clazz2.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.processException((Throwable)classNotFoundException, (String)(clsName + ".getUserMapping"), (String)"195");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5186E", (Object)new Object[]{USERMAPPING_IMPL, classNotFoundException});
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.processException((Throwable)illegalAccessException, (String)(clsName + ".getUserMapping"), (String)"198");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5188E", (Object)new Object[]{USERMAPPING_IMPL, illegalAccessException});
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".getUserMapping"), (String)"201");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5187E", (Object)new Object[]{USERMAPPING_IMPL, exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserMapping", (Object)_userMapping);
        }
        return _userMapping;
    }
}

