/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ws.webservices.wssecurity.handler.token.TokenCache;
import com.ibm.ws.webservices.wssecurity.token.PropagationToken;
import com.ibm.ws.webservices.wssecurity.token.TokenCacheManager;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;

public class TokenCacheManagerImpl
implements TokenCacheManager {
    private static final TraceComponent tc = Tr.register((Class)TokenCacheManagerImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenCacheManagerImpl.class.getName();
    private TokenCache _cache = null;
    private long _cushion = 0L;

    public TokenCacheManagerImpl(String string, int n, int n2, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("TokenCacheManagerImpl(String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "]" + "long cushion[" + l + "])"));
        }
        int n3 = ConfigConstants.validTokenCacheSize(n);
        int n4 = ConfigConstants.validTokenCacheTimeout(n2);
        if (string == null || string.length() == 0) {
            string = "WSSTokenCache";
        }
        this._cache = new TokenCache(string, n3, n4 * 1000, true, false);
        this._cushion = ConfigConstants.validTokenCushion(l);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TokenCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public PropagationToken getCachedToken(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCachedToken(String key[" + string + "])"));
        }
        PropagationToken propagationToken = null;
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The token cache is null.");
            }
        } else {
            Object object = this._cache.get(string);
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There is no object linked with the specified key [" + string + "]."));
                }
            } else if (object instanceof PropagationToken) {
                propagationToken = (PropagationToken)object;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There is an object linked with the specified key [" + string + "].  But it's not the Token object: " + object.getClass().getName()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCachedToken(String key) returns Token[" + propagationToken + "]"));
        }
        return propagationToken;
    }

    public void cacheToken(String string, PropagationToken propagationToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cacheToken(String key[" + string + "]," + "PropagationToken token[" + propagationToken + "]"));
        }
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified key is null or zero length.");
            }
        } else if (propagationToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified token is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The token cache is null.");
            }
        } else {
            this._cache.put(string, propagationToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheToken(String key, PropagationToken token");
        }
    }

    public long getCushion() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCushion()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCushion() returns " + this._cushion));
        }
        return this._cushion;
    }
}

