/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestReceiverConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseReceiverConfig;
import com.ibm.ws.webservices.wssecurity.util.CORBAHelper;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.SoapSecurityReceiver;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;

public class WSSoapSecurityReceiverBase
extends SoapSecurityReceiver {
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    private static final TraceComponent tc = Tr.register((Class)WSSoapSecurityReceiverBase.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSoapSecurityReceiverBase.class.getName();

    public void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    protected void initConfig(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initConfig(" + messageContextProxy + ")"));
        }
        boolean bl = true;
        String string = (String)this.getHandlerOption(GenericHandler.HANDLER_PARAM_ROLE);
        if (string != null && string.length() != 0) {
            bl = string.equals(GenericHandler.HANDLER_PARAM_ROLE_SERVER);
        } else {
            boolean bl2 = bl = !messageContextProxy.getPastPivot();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isServer=" + bl));
        }
        try {
            if (bl) {
                Object object;
                ReceiverConfig receiverConfig = (ReceiverConfig)messageContextProxy.getConfig("RequestReceiverConfig");
                if (receiverConfig == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.request.receiver.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    object = new StringBuffer("ReceiverConfig class name=");
                    object.append(receiverConfig.getClass().getName());
                    object.append(", source=");
                    if (receiverConfig instanceof WSEMFRequestReceiverConfig) {
                        object.append(((WSEMFRequestReceiverConfig)receiverConfig).getOrigin());
                    } else {
                        object.append("unknown");
                    }
                    object.append(", ReceiverConfig=").append(receiverConfig);
                    Tr.debug((TraceComponent)tc, (String)object.toString());
                }
                if (receiverConfig instanceof WSEMFRequestReceiverConfig) {
                    object = (WSEMFRequestReceiverConfig)receiverConfig;
                    String string2 = ((WSEMFRequestReceiverConfig)((Object)object)).getWSSENS();
                    if (string2 != null && string2.length() != 0) {
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", (Object)string2);
                    }
                    if ((string2 = ((WSEMFRequestReceiverConfig)((Object)object)).getWSUNS()) != null && string2.length() != 0) {
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", (Object)string2);
                    }
                }
                this.setMessageOption(CONFIG_KEY, receiverConfig);
            } else {
                ReceiverConfig receiverConfig = (ReceiverConfig)messageContextProxy.getConfig("ResponseReceiverConfig");
                if (receiverConfig == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.reponse.receiver.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("ReceiverConfig class name=");
                    stringBuffer.append(receiverConfig.getClass().getName());
                    stringBuffer.append(", source=");
                    if (receiverConfig instanceof WSEMFResponseReceiverConfig) {
                        stringBuffer.append(((WSEMFResponseReceiverConfig)receiverConfig).getOrigin());
                    } else {
                        stringBuffer.append("unknown");
                    }
                    stringBuffer.append(", ReceiverConfig=").append(receiverConfig);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                this.setMessageOption(CONFIG_KEY, receiverConfig);
            }
            super.initConfig(messageContextProxy);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Throwable throwable) {
            Tr.processException((Throwable)throwable, (String)(clsName + ".init"), (String)"96", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.FileConfigSSR.init", (Object)throwable);
            throw new IllegalArgumentException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initConfig(MessageContextProxy context)");
        }
    }

    public void invoke(MessageContextProxy messageContextProxy) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(" + messageContextProxy + ")"));
        }
        if (WSSoapSecurityUtil.getServiceHandler((MessageContext)messageContextProxy.get()) != null) {
            super.invoke(messageContextProxy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(MessageContextProxy context)");
        }
    }

    protected void processLoginResults(Result[] resultArray, MessageContextProxy messageContextProxy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processLoginResults(" + resultArray + "," + messageContextProxy + ")"));
        }
        if (resultArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No results, no initial sender is set");
            }
        } else {
            for (int i = 0; i < resultArray.length; ++i) {
                if (resultArray[i] instanceof LoginResult) {
                    Subject subject = ((LoginResult)resultArray[i]).getSubject();
                    CORBAHelper.pushCredential(subject, (MessageContext)messageContextProxy.get());
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    if (contextManager == null) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
                    } else {
                        contextManager.put("wssecurity.initial.sender.id", subject);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Initial Sender", (Object)subject);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"processLoginResults(Result[] results, MessageContext context)");
                    }
                    return;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"None of the results has a LoginResult, no initial sender is set");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLoginResults(Result[] results, MessageContext context)");
        }
    }

    protected void processCertificateResults(Result[] resultArray, Result[] resultArray2, MessageContextProxy messageContextProxy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processCertificateResults(" + resultArray + "," + resultArray2 + "," + messageContextProxy + ")"));
        }
        if (resultArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No resultSign, no signer certificate is set");
            }
        } else if (resultArray2.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No resultToken, no initial sender certificate is set");
            }
        } else {
            SignatureResult signatureResult;
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("result Sign length: " + resultArray.length));
                Tr.debug((TraceComponent)tc, (String)("result Token length: " + resultArray2.length));
            }
            X509Certificate x509Certificate = null;
            for (n = 0; n < resultArray.length; ++n) {
                if (!(resultArray[n] instanceof SignatureResult)) continue;
                signatureResult = (SignatureResult)resultArray[n];
                if (signatureResult.isAuthenticatedId()) {
                    x509Certificate = signatureResult.getCertificate();
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Found signer cert: " + x509Certificate));
                    break;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Signature result found, but it is not used as authenticated identity, therefore, original certificate is not saved");
            }
            if (x509Certificate != null) {
                Tr.debug((TraceComponent)tc, (String)("Signer Cert: " + x509Certificate));
            } else {
                Tr.debug((TraceComponent)tc, (String)"Signer Cert is null!");
                for (n = 0; n < resultArray2.length; ++n) {
                    if (!(resultArray2[n] instanceof TokenResult.X509)) continue;
                    signatureResult = (TokenResult.X509)resultArray2[n];
                    if (signatureResult.isAuthenticatedId()) {
                        x509Certificate = signatureResult.getCertificate();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("Found sender cert: " + x509Certificate));
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"X509 Token result found, but it is not used as authenticated identity, therefore, original certificate is not saved");
                }
            }
            if (x509Certificate != null) {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
                } else {
                    contextManager.put("com.ibm.ws.wssecurity.OriginalCert", x509Certificate);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Initial Cert", (Object)x509Certificate);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Initial Cert found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processCertificateResults(Result[] resultSign, Result[] resultToken, MessageContext context)");
        }
    }

    public String toString() {
        return "WSSoapSecurityReceiverBase(config=" + this.getMessageOption(CONFIG_KEY) + ")";
    }
}

