/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecuritySenderBase;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.SenderLogin;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;

public class WSSenderLogin
extends SenderLogin {
    private static final TraceComponent tc = Tr.register((Class)WSSenderLogin.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSenderLogin.class.getName();
    private String targetPort = null;
    private WSSoapSecuritySenderBase soapSecuritySender = null;
    private MessageContextProxy context = null;
    boolean isServer = true;

    public WSSenderLogin(WSSoapSecuritySenderBase wSSoapSecuritySenderBase, MessageContextProxy messageContextProxy, boolean bl) {
        this.soapSecuritySender = wSSoapSecuritySenderBase;
        this.context = messageContextProxy;
        this.isServer = bl;
    }

    protected void cacheUsernameTokenByTargetPort(TokenRequest.Username username) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cacheUsernameTokenByTargetPort", (Object)new Object[]{(String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"), username});
        }
        if (!this.isServer) {
            this.soapSecuritySender.saveTempObject("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken", username);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheUsernameTokenByTargetPort");
        }
    }

    protected TokenRequest.Username retrieveUsernameTokenByTargetPort() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retrieveUsernameTokenByTargetPort", (Object)new Object[]{(String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"), new Boolean(this.isServer)});
        }
        TokenRequest.Username username = null;
        if (!this.isServer) {
            username = (TokenRequest.Username)this.soapSecuritySender.getObject((String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveUsernameTokenByTargetPort", (Object)new Object[]{username});
        }
        return username;
    }

    protected String getInitialSenderId() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInitialSenderId");
        }
        String string = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        final Subject subject = (Subject)contextManager.get("wssecurity.initial.sender.id");
        if (tc.isDebugEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Tr.debug((TraceComponent)tc, (String)"Initial Sender", (Object)subject);
                    return null;
                }
            });
        }
        if (subject != null) {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential != null) {
                try {
                    string = wSCredential.getSecurityName();
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.noprincipal.found");
                    throw SoapSecurityException.format("security.wssecurity.noprincipal.found");
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.nocred.found");
                throw SoapSecurityException.format("security.wssecurity.nocred.found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInitialSenderId", string);
        }
        return string;
    }

    protected X509Certificate getInitialSenderCert() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInitialSenderCert");
        }
        X509Certificate x509Certificate = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        x509Certificate = (X509Certificate)contextManager.get("com.ibm.ws.wssecurity.OriginalCert");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initial Sender Cert", (Object)x509Certificate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInitialSenderCert", (Object)x509Certificate);
        }
        return x509Certificate;
    }
}

