/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wsext.SecurityResponseSenderServiceConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import java.text.ParseException;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class WSEMFResponseSenderConfig
extends PrivateSenderConfig {
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFResponseSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFResponseSenderConfig.class.getName();

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        this(securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, null);
    }

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        this.init(securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, classLoader);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    WSEMFResponseSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseSenderConfig()");
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    final void init(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string2;
        Object object7;
        Object object8;
        EObject eObject;
        int n;
        String string3;
        Object object9;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        String string4 = null;
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = null;
        if (wSSecurityService != null && (object9 = wSSecurityService.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)object9;
        }
        if (securityResponseSenderServiceConfig != null) {
            addCreatedTimeStamp = securityResponseSenderServiceConfig.getAddCreatedTimestamp();
            confidentiality = securityResponseSenderServiceConfig.getConfidentiality();
            integrity = securityResponseSenderServiceConfig.getIntegrity();
            string4 = securityResponseSenderServiceConfig.getActor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Response Sender Service Config (AddCreatedTimestamp, Confidentiality, Integrity, targetActor):", new Object[]{addCreatedTimeStamp, confidentiality, integrity, string4});
            }
        }
        if (!((ConfigValidation)(object9 = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration))).confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!((ConfigValidation)object9).integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (string != null) {
            string3 = string.trim();
            if (string3.length() != 0) {
                this.myactor = string3;
            }
        } else {
            this.myactor = null;
        }
        if (string4 != null) {
            string3 = string4.trim();
            if (string3.length() != 0) {
                this.targetactor = string3;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor + ", actor = " + this.targetactor);
        }
        this.enableCreatedTimestamp = false;
        this.duration = null;
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            string3 = addCreatedTimeStamp.getExpires();
            if (string3 != null && string3.length() > 0) {
                try {
                    this.duration = Duration.parse((String)string3);
                }
                catch (ParseException parseException) {
                    String string5 = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)parseException, clsName + ".WSEMFResponseSenderConfig", "178", (Object)this);
                    Tr.error(tc, string5, string3);
                    throw SoapSecurityException.format(string5, string3, (Throwable)parseException);
                }
            }
        }
        if (integrity != null) {
            int n2 = integrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                eObject = (Reference)integrity.getReferences().get(n);
                object8 = eObject.getPart();
                object7 = ((AbstractEnumerator)object8).getName();
                this.integralParts.add(object7);
                if (!((String)object7).equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
        }
        if (confidentiality != null) {
            int n3 = confidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                eObject = (ConfidentialPart)confidentiality.getConfidentialParts().get(n);
                object8 = eObject.getPart();
                object7 = ((AbstractEnumerator)object8).getName();
                this.confidentialParts.add(object7);
                if (!((String)object7).equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList eList = null;
        eObject = null;
        object8 = null;
        if (securityResponseSenderBindingConfig != null) {
            encryptionInfo = securityResponseSenderBindingConfig.getEncryptionInfo();
            eList = securityResponseSenderBindingConfig.getKeyLocators();
            eObject = securityResponseSenderBindingConfig.getSigningInfo();
            object7 = securityResponseSenderBindingConfig.getProperties();
            if (object7 != null) {
                object8 = ConfigConstants.getProperties((EList)object7, variableMap);
            }
            if (tc.isDebugEnabled()) {
                if (object8 != null) {
                    Tr.debug(tc, "Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo, Property):", new Object[]{encryptionInfo, eList, eObject, object8});
                } else {
                    Tr.debug(tc, "Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo):", new Object[]{encryptionInfo, eList, eObject});
                }
            }
        }
        if (object8 != null || object8.size() != 0) {
            object7 = (String)object8.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
            this.inclusiveNamespaces = ConfigUtil.isTrue((String)object7);
        }
        if (!((ConfigValidation)object9).senderSigningInfoValid((SigningInfo)eObject, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!((ConfigValidation)object9).encryptionInfoValid(encryptionInfo, eList, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (encryptionInfo != null) {
            object7 = encryptionInfo.getEncryptionKey();
            string2 = null;
            object6 = null;
            if (object7 != null) {
                string2 = object7.getName();
                object6 = object7.getLocatorRef();
            }
            object5 = encryptionInfo.getEncryptionMethod();
            object4 = null;
            if (object5 != null) {
                object4 = object5.getAlgorithm();
            }
            object3 = encryptionInfo.getKeyEncryptionMethod();
            object2 = null;
            if (object3 != null) {
                object2 = object3.getAlgorithm();
            }
            object = ConfigConstants.findKeyLocator(eList, (String)object6, variableMap, wSSecurityDefaultConfiguration, classLoader);
            if (object4 == null || string2 == null || object == null) {
                String string6 = "security.wssecurity.IncompleteEncryptionInfo";
                if (object4 == null) {
                    Tr.warning(tc, string6, "Data Encryption Algorithm");
                }
                if (string2 == null) {
                    Tr.warning(tc, string6, "Encryption Key Name");
                }
                if (object == null) {
                    Tr.warning(tc, string6, "Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings((String)object4, (String)object2, string2, (KeyLocator)object);
        }
        if (eObject != null) {
            object7 = eObject.getCanonicalizationMethod();
            string2 = null;
            if (object7 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CanonicalizationMethod defined");
                }
            } else {
                string2 = object7.getAlgorithm();
            }
            this.c14nMethod = string2;
            object6 = eObject.getSignatureMethod();
            object5 = null;
            if (object6 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SignatureMethod defined");
                }
            } else {
                object5 = object6.getAlgorithm();
            }
            this.signatureMethod = object5;
            object4 = eObject.getDigestMethod();
            object3 = null;
            if (object4 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No DigestMethod defined");
                }
            } else {
                object3 = object4.getAlgorithm();
            }
            this.digestMethod = object3;
            object2 = eObject.getSigningKey();
            if (object2 != null) {
                object = object2.getLocatorRef();
                this.keyName = object2.getName();
                this.keyLocator = ConfigConstants.findKeyLocator(eList, (String)object, variableMap, wSSecurityDefaultConfiguration, classLoader);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }
}

