/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class WSSecurityDefaultConsumerConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConsumerConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultConsumerConfig.class.getName();

    public WSSecurityDefaultConsumerConfig(Consumer consumer, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultConsumerConfig(Consumer, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{consumer, variableMap, wSSecurityDefaultConfiguration});
        }
        if (variableMap == null) {
            variableMap = ClientVariableMap.getInstance();
        }
        this.init(consumer, variableMap, wSSecurityDefaultConfiguration);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultConsumerConfig(Consumer, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }

    protected final void init(Consumer consumer, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        int n;
        int n2;
        PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfImpl;
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl;
        Transform transform;
        EList eList;
        EObject eObject;
        HashMap hashMap;
        Object object;
        Object object2;
        Object object3;
        String string;
        EObject eObject2;
        Object object4;
        EObject eObject3;
        int n3;
        int n4;
        Object object5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Consumer, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{consumer, variableMap, wSSecurityDefaultConfiguration});
        }
        ClassLoader classLoader = null;
        boolean bl = false;
        WebServicesSecurityAlgorithmHelper webServicesSecurityAlgorithmHelper = null;
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, Configuration> hashMap3 = new HashMap<String, Configuration>();
        bl = ConfigValidation.isFipsEnabled();
        if (bl) {
            webServicesSecurityAlgorithmHelper = new WebServicesSecurityAlgorithmHelper();
        }
        EList eList2 = null;
        EList eList3 = null;
        EList eList4 = null;
        List list = null;
        Map map = null;
        if (consumer != null) {
            eList2 = consumer.getEncryptionInfo();
            eList3 = consumer.getKeyInfo();
            eList4 = consumer.getSigningInfo();
            list = consumer.getTokenConsumer();
            object5 = consumer.getProperties();
            this._properties = object5 != null ? (map = ConfigConstants.getProperties(object5, variableMap)) : new HashMap();
            if (tc.isDebugEnabled()) {
                if (map != null) {
                    Tr.debug(tc, "Default Consumer Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers, Property):", new Object[]{eList4, eList2, eList3, list, map});
                } else {
                    Tr.debug(tc, "Default Consumer Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers):", new Object[]{eList4, eList2, eList3, list});
                }
            }
        }
        this._bypassSecurityHeader = ConfigUtil.setupBypassSecurityHeaderProperty((WSSecurityDefaultConfiguration)wSSecurityDefaultConfiguration, map, null);
        if (list != null) {
            n4 = list.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object5 = (TokenConsumer)list.get(n3);
                eObject3 = object5.getValueType();
                if (eObject3 == null) {
                    throw new SoapSecurityException("The valueType field for the token consumer named " + object5.getName() + " is missing");
                }
                object4 = new QName(ConfigUtil.trim((String)eObject3.getUri()), ConfigUtil.trim((String)eObject3.getLocalName()));
                eObject2 = object5.getPartReference();
                PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl = null;
                if (eObject2 != null && (string = ConfigUtil.trim((String)eObject2.getPart())) != null && string.length() > 0) {
                    tokenConsumerConfImpl = (PrivateConsumerConfig.TokenConsumerConfImpl)hashMap3.get(string);
                    if (tokenConsumerConfImpl == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                    }
                    if (!tokenConsumerConfImpl.getType().equals(object4)) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s30", (Object)new Object[]{tokenConsumerConfImpl.getType().toString(), ((QName)object4).toString()});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                if (tokenConsumerConfImpl == null) {
                    tokenConsumerConfImpl = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    tokenConsumerConfImpl._type = object4;
                }
                tokenConsumerConfImpl._name = ConfigUtil.trim((String)object5.getName());
                ConfigConstants.getProperties(tokenConsumerConfImpl._properties, object5.getProperties(), variableMap);
                tokenConsumerConfImpl._className = ConfigUtil.trim((String)object5.getClassname());
                object3 = object5.getJAASConfig();
                if (object3 != null) {
                    tokenConsumerConfImpl._jaasConfig = ConfigUtil.trim((String)object3.getConfigName());
                    ConfigConstants.getProperties(tokenConsumerConfImpl._jaasConfigProperties, object3.getProperties(), variableMap);
                }
                if ((object2 = object5.getCertPathSettings()) != null) {
                    object = object2.getTrustAnyCertificate();
                    if (object != null) {
                        tokenConsumerConfImpl._trustAny = true;
                    } else {
                        hashMap = object2.getTrustAnchorRef();
                        eObject = object2.getCertStoreRef();
                        if (hashMap != null || eObject != null) {
                            eList = null;
                            if (hashMap != null) {
                                transform = null;
                                Object var41_33 = null;
                                string = ConfigUtil.trim((String)hashMap.getRef());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "TrustAnchorRef = " + string);
                                }
                                tokenConsumerConfImpl._trustAnchorRef = string;
                                tokenConsumerConfImpl._trustAnchorKeyStore = (KeyStore)wSSecurityDefaultConfiguration.trustAnchors.get(string);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "_trustAnchorKeyStore = " + tokenConsumerConfImpl._trustAnchorKeyStore);
                                }
                                if (eObject != null) {
                                    Object object6;
                                    string = ConfigUtil.trim((String)eObject.getRef());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CertStoreRef = " + string);
                                    }
                                    if ((object6 = wSSecurityDefaultConfiguration.getWSCertStore(string)) == null) {
                                        String string2 = "security.wssecurity.ConfigValidation.csref.notfound";
                                        Tr.error(tc, string2, new Object[]{string});
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found CertStore for " + string);
                                        }
                                        tokenConsumerConfImpl._certStores.add(object6);
                                    }
                                }
                                tokenConsumerConfImpl._provider = var41_33;
                                tokenConsumerConfImpl._pkixBuilderParams = transform;
                            }
                        }
                    }
                    if (tokenConsumerConfImpl._trustAnchorRef != null && tokenConsumerConfImpl._provider == null) {
                        tokenConsumerConfImpl._provider = ConfigUtil.setupCertStoreProvider((WSSecurityDefaultConfiguration)wSSecurityDefaultConfiguration, (Map)map, (Map)tokenConsumerConfImpl._properties, (String)tokenConsumerConfImpl._name);
                    }
                }
                if ((object = object5.getTrustedIDEvaluatorRef()) != null) {
                    hashMap = ConfigUtil.trim((String)object.getRef());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding TrustID Evaluator Reference: " + (String)((Object)hashMap));
                    }
                    tokenConsumerConfImpl._trustedIDEvaluator = wSSecurityDefaultConfiguration.getTrustedIDEvaluator((String)((Object)hashMap));
                }
                hashMap2.clear();
                hashMap2.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                hashMap2.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tokenConsumerConfImpl._className);
                hashMap = new HashMap();
                try {
                    tokenConsumerConfImpl._instance = (TokenConsumerComponent)wSSFactory.createConsumer(hashMap2, hashMap);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", (Object)new Object[]{tokenConsumerConfImpl._className});
                }
                this._tokenConsumers.add(tokenConsumerConfImpl);
                string = ConfigUtil.trim((String)object5.getName());
                if (string == null || string.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s26");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + string);
                }
                hashMap3.put(string, tokenConsumerConfImpl);
            }
        }
        object5 = new ArrayList();
        if (eList3 != null) {
            n4 = eList3.size();
            for (n3 = 0; n3 < n4; ++n3) {
                eObject3 = (KeyInfo)eList3.get(n3);
                keyInfoContentConsumerConfImpl = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                keyInfoContentConsumerConfImpl._className = ConfigUtil.trim((String)eObject3.getClassname());
                keyInfoContentConsumerConfImpl._keyInfoType = ConfigUtil.trim((String)eObject3.getType());
                object4 = eObject3.getKeyLocatorMapping();
                if (object4 != null) {
                    string = ConfigUtil.trim((String)object4.getLocatorRef());
                    if (string != null && string.length() > 0) {
                        KeyLocatorProxy keyLocatorProxy = wSSecurityDefaultConfiguration.getKeyLocator(string);
                        if (keyLocatorProxy == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                        } else {
                            try {
                                keyInfoContentConsumerConfImpl._keyLocator = keyLocatorProxy.getKeyLocator6(classLoader);
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                Tr.warning(tc, "security.wssecurity.keylocator.is.null", (Object)new Object[]{soapSecurityException});
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the key locator mapping: " + string);
                            }
                        }
                    }
                    keyInfoContentConsumerConfImpl._keyName = ConfigUtil.trim((String)object4.getKeynameRef());
                }
                if ((eObject2 = eObject3.getTokenReference()) != null && (string = ConfigUtil.trim((String)eObject2.getTokenRef())) != null && string.length() > 0) {
                    keyInfoContentConsumerConfImpl._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)hashMap3.get(string);
                    if (keyInfoContentConsumerConfImpl._tokenConsumer == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the token reference: " + string);
                    }
                }
                ConfigConstants.getProperties(keyInfoContentConsumerConfImpl._properties, eObject3.getProperties(), variableMap);
                hashMap2.clear();
                hashMap2.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                hashMap2.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", keyInfoContentConsumerConfImpl._className);
                object3 = new HashMap();
                try {
                    keyInfoContentConsumerConfImpl._instance = (KeyInfoContentConsumerComponent)wSSFactory.createConsumer(hashMap2, (Map)object3);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", (Object)new Object[]{keyInfoContentConsumerConfImpl._className});
                }
                object5.add(keyInfoContentConsumerConfImpl);
                string = ConfigUtil.trim((String)eObject3.getName());
                if (string == null || string.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s28");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + string);
                }
                hashMap3.put(string, keyInfoContentConsumerConfImpl);
            }
        }
        if (eList2 != null) {
            n4 = eList2.size();
            for (n3 = 0; n3 < n4; ++n3) {
                eObject3 = (EncryptionInfo)eList2.get(n3);
                PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfImpl = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                object4 = eObject3.getEncryptionMethod();
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = ConfigUtil.trim((String)object4.getAlgorithm());
                if (!bl || webServicesSecurityAlgorithmHelper.getFipsDataEncryptionAlgorithms().contains(algorithmConfImpl._algorithm)) {
                    ConfigConstants.getProperties(algorithmConfImpl._properties, object4.getProperties(), variableMap);
                    encryptionConsumerConfImpl._dataEncryptionMethod = algorithmConfImpl;
                } else {
                    Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DataEncryptionMethod", algorithmConfImpl._algorithm});
                }
                eObject2 = eObject3.getKeyEncryptionMethod();
                if (eObject2 != null) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim((String)eObject2.getAlgorithm());
                    if (!bl || webServicesSecurityAlgorithmHelper.getFipsKeyEncryptionAlgorithms().contains(algorithmConfImpl._algorithm)) {
                        ConfigConstants.getProperties(algorithmConfImpl._properties, eObject2.getProperties(), variableMap);
                        encryptionConsumerConfImpl._keyEncryptionMethod = algorithmConfImpl;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"KeyEncryptionMethod", algorithmConfImpl._algorithm});
                    }
                }
                keyInfoConsumerConfImpl = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                object3 = eObject3.getEncryptionKeyInfo();
                if (object3 == null || object3.size() == 0) {
                    keyInfoConsumerConfImpl._contentConsumers = object5;
                } else {
                    keyInfoConsumerConfImpl._contentConsumers = new ArrayList();
                    n2 = object3.size();
                    for (n = 0; n < n2; ++n) {
                        object2 = (EncryptionKeyInfo)object3.get(n);
                        string = ConfigUtil.trim((String)object2.getKeyinfoRef());
                        if (string == null || string.length() <= 0) continue;
                        keyInfoContentConsumerConfImpl = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)hashMap3.get(string);
                        if (keyInfoContentConsumerConfImpl == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                            continue;
                        }
                        keyInfoConsumerConfImpl._contentConsumers.add(keyInfoContentConsumerConfImpl);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                }
                encryptionConsumerConfImpl._encryptionKeyInfo = keyInfoConsumerConfImpl;
                object2 = eObject3.getPartReference();
                if (object2 != null && (string = ConfigUtil.trim((String)object2.getPart())) != null && string.length() > 0) {
                    encryptionConsumerConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)hashMap3.get(string);
                    if (encryptionConsumerConfImpl._reference == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                ConfigConstants.getProperties(encryptionConsumerConfImpl._properties, eObject3.getProperties(), variableMap);
                this._encryptionConsumers.add(encryptionConsumerConfImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption consumer.");
            }
        }
        if (eList4 != null) {
            n4 = eList4.size();
            for (n3 = 0; n3 < n4; ++n3) {
                eObject3 = (SigningInfo)eList4.get(n3);
                PrivateConsumerConfig.SignatureConsumerConfImpl signatureConsumerConfImpl = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                object4 = eObject3.getCanonicalizationMethod();
                if (object4 == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim((String)object4.getAlgorithm());
                    ConfigConstants.getProperties(algorithmConfImpl._properties, object4.getProperties(), variableMap);
                    signatureConsumerConfImpl._canonicalizationMethod = algorithmConfImpl;
                }
                eObject2 = eObject3.getSignatureMethod();
                if (object4 == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim((String)eObject2.getAlgorithm());
                    if (!bl || webServicesSecurityAlgorithmHelper.getFipsSignatureAlgorithms().contains(algorithmConfImpl._algorithm)) {
                        ConfigConstants.getProperties(algorithmConfImpl._properties, eObject2.getProperties(), variableMap);
                        signatureConsumerConfImpl._signatureMethod = algorithmConfImpl;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"SignatureMethod", algorithmConfImpl._algorithm});
                    }
                }
                object3 = eObject3.getKeyInfoSignature();
                if (object3 != null) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim((String)object3.getType());
                    ConfigConstants.getProperties(algorithmConfImpl._properties, object3.getProperties(), variableMap);
                    signatureConsumerConfImpl._keyInfoSignature = algorithmConfImpl;
                }
                keyInfoConsumerConfImpl = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                object2 = eObject3.getSigningKeyInfo();
                if (object2 == null || object2.size() == 0) {
                    keyInfoConsumerConfImpl._contentConsumers = object5;
                } else {
                    keyInfoConsumerConfImpl._contentConsumers = new ArrayList();
                    n2 = object2.size();
                    for (n = 0; n < n2; ++n) {
                        object = (SigningKeyInfo)object2.get(n);
                        string = ConfigUtil.trim((String)object.getKeyinfoRef());
                        if (string == null || string.length() <= 0) continue;
                        keyInfoContentConsumerConfImpl = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)hashMap3.get(string);
                        if (keyInfoContentConsumerConfImpl == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                            continue;
                        }
                        keyInfoConsumerConfImpl._contentConsumers.add(keyInfoContentConsumerConfImpl);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                }
                signatureConsumerConfImpl._signingKeyInfo = keyInfoConsumerConfImpl;
                object = eObject3.getPartReference();
                if (object != null) {
                    n2 = object.size();
                    for (n = 0; n < n2; ++n) {
                        hashMap = (PartReference)object.get(n);
                        PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = new PrivateCommonConfig.SigningReferenceConfImpl();
                        string = ConfigUtil.trim((String)hashMap.getPart());
                        if (string != null && string.length() > 0) {
                            signingReferenceConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)hashMap3.get(string);
                            if (signingReferenceConfImpl._reference == null) {
                                Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", (Object)new Object[]{string});
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + string);
                            }
                        }
                        if ((eObject = hashMap.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                            algorithmConfImpl._algorithm = ConfigUtil.trim((String)eObject.getAlgorithm());
                            if (!bl || webServicesSecurityAlgorithmHelper.getFipsDigestAlgorithms().contains(algorithmConfImpl._algorithm)) {
                                ConfigConstants.getProperties(algorithmConfImpl._properties, eObject.getProperties(), variableMap);
                                signingReferenceConfImpl._digestMethod = algorithmConfImpl;
                            } else {
                                Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DigestMethod", algorithmConfImpl._algorithm});
                            }
                        }
                        eList = hashMap.getTransform();
                        if (eList != null) {
                            int n5 = eList.size();
                            for (int i = 0; i < n5; ++i) {
                                transform = (Transform)eList.get(i);
                                if (transform == null) continue;
                                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                                algorithmConfImpl._algorithm = ConfigUtil.trim((String)transform.getAlgorithm());
                                ConfigConstants.getProperties(algorithmConfImpl._properties, transform.getProperties(), variableMap);
                                signingReferenceConfImpl._transforms.add(algorithmConfImpl);
                            }
                        }
                        signatureConsumerConfImpl._references.add(signingReferenceConfImpl);
                    }
                }
                ConfigConstants.getProperties(signatureConsumerConfImpl._properties, eObject3.getProperties(), variableMap);
                this._signatureConsumers.add(signatureConsumerConfImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature consumer.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Consumer, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }
}

