/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.LDAPCertStore;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.token.LoginMapping;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WSSecurityDefaultConfiguration {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConfiguration.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = com.ibm.etools.webservice.wscommonbnd.KeyStore.class.getName();
    private static final String comp = "security.wssecurity";
    private static final WebSphereRuntimePermission GETLOGINMAPPINGPERM = new WebSphereRuntimePermission("wssecurity.getLoginMapping");
    private static final WebSphereRuntimePermission GETTRUSTANCHORPERM = new WebSphereRuntimePermission("wssecurity.getTrustAnchor");
    private static final WebSphereRuntimePermission GETTRUSTEDIDEVALUATORPERM = new WebSphereRuntimePermission("wssecurity.getTrustedIDEvaluator");
    private static final WebSphereRuntimePermission GETKEYLOCATORPERM = new WebSphereRuntimePermission("wssecurity.getKeyLocator");
    private static final WebSphereRuntimePermission GETCERTSTOREPERM = new WebSphereRuntimePermission("wssecurity.getCertStore");
    private static final WebSphereRuntimePermission WSSECURITYCONFIGPERM = new WebSphereRuntimePermission("wssecurity.wssecurity.config");
    private static final WebSphereRuntimePermission GETAMAPPERM = new WebSphereRuntimePermission("wssecurity.getAlgorithmMappings");
    private static final WebSphereRuntimePermission GETNCDISTAPPERM = new WebSphereRuntimePermission("wssecurity.isNonceCacheDistributed");
    private static final WebSphereRuntimePermission GETDEFCONPERM = new WebSphereRuntimePermission("wssecurity.getDefaultConsumerBinding");
    private static final WebSphereRuntimePermission GETDEFGENPERM = new WebSphereRuntimePermission("wssecurity.getDefaultGeneratorBinding");
    protected Map loginMappings = new HashMap();
    protected Map trustAnchors = new HashMap();
    protected Map trustedIDEvaluators = new HashMap();
    protected Map keyLocators = new HashMap();
    protected Map certStores = new HashMap();
    protected Map certs = new HashMap();
    protected Map crls = new HashMap();
    protected Map keyStores = new HashMap();
    protected Map properties = new HashMap();
    protected Set algorithmMappings = new HashSet();
    protected boolean useNonceCache = true;
    protected String nonceCacheName = "NonceDistributionCacheMap";
    protected int nonceCacheSize = 1024;
    protected int nonceCacheTimeout = 600;
    protected int nonceLength = 128;
    protected int nonceMaxAge = 300;
    protected int nonceClockSkew = 0;
    protected boolean nonceCacheDistributed = false;
    protected boolean useCertCache = true;
    protected String certCacheName = "WSSCertCache";
    protected int certCacheSize = 128;
    protected int certCacheTimeOut = 900;
    protected boolean useConfigCache = true;
    protected String configCacheName = "WSSReqGeneratorConfigMap";
    protected int configCacheSize = 128;
    protected int configCacheTimeToLive = 900;
    protected boolean useHardwareAcceleration = false;
    protected String hardwareConfigName = null;
    protected String useOffloadAllCrypto = "false";
    protected boolean offloadRSAPublicKeyCrypto = true;
    protected int hardwareCacheSize = 1000;
    protected boolean useTokenCache = true;
    protected String tokenCacheName = "WSSTokenCache";
    protected int tokenCacheSize = 128;
    protected int tokenCacheTimeOut = 900;
    protected long tokenCacheCushion = 600000L;
    protected WSSGeneratorConfig gconfig;
    protected WSSConsumerConfig cconfig;

    protected WSSecurityDefaultConfiguration() {
    }

    public LoginMapping getLoginMapping(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginMapping", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETLOGINMAPPINGPERM);
        }
        LoginMapping loginMapping = (LoginMapping)this.loginMappings.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginMapping", loginMapping);
        }
        return loginMapping;
    }

    public KeyStore getTrustAnchor(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAnchor", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETTRUSTANCHORPERM);
        }
        KeyStore keyStore = null;
        com.ibm.ws.webservices.wssecurity.config.KeyStore keyStore2 = (com.ibm.ws.webservices.wssecurity.config.KeyStore)this.trustAnchors.get(string);
        if (keyStore2 != null) {
            keyStore = keyStore2.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAnchor", keyStore);
        }
        return keyStore;
    }

    public com.ibm.ws.webservices.wssecurity.config.KeyStore getTrustAnchorKeyStoreConfig(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAnchorKeyStoreConfig", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETTRUSTANCHORPERM);
        }
        com.ibm.ws.webservices.wssecurity.config.KeyStore keyStore = (com.ibm.ws.webservices.wssecurity.config.KeyStore)this.trustAnchors.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAnchorKeyStoreConfig", keyStore);
        }
        return keyStore;
    }

    public TrustedIDEvaluator getTrustedIDEvaluator(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustedIDEvaluator", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETTRUSTEDIDEVALUATORPERM);
        }
        TrustedIDEvaluator trustedIDEvaluator = (TrustedIDEvaluator)this.trustedIDEvaluators.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustedIDEvaluator", trustedIDEvaluator);
        }
        return trustedIDEvaluator;
    }

    public KeyLocatorProxy getKeyLocator(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyLocator", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETKEYLOCATORPERM);
        }
        KeyLocatorProxy keyLocatorProxy = (KeyLocatorProxy)this.keyLocators.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyLocator", keyLocatorProxy);
        }
        return keyLocatorProxy;
    }

    public CertStore getCertStore(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertStore", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETCERTSTOREPERM);
        }
        CertStore certStore = null;
        Object v = this.certStores.get(string);
        if (v != null) {
            if (v instanceof CollectionCertStore) {
                CollectionCertStore collectionCertStore = (CollectionCertStore)v;
                certStore = collectionCertStore.getInstance();
            } else if (v instanceof LDAPCertStore) {
                LDAPCertStore lDAPCertStore = (LDAPCertStore)v;
                certStore = lDAPCertStore.getInstance();
            } else {
                Tr.error(tc, "security.wssecurity.default.config.bad.certstore.class", new Object[]{string, v.getClass().getName()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertStore", certStore);
        }
        return certStore;
    }

    public Object getWSCertStore(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSCertStore", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETCERTSTOREPERM);
        }
        Object v = this.certStores.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSCertStore", v);
        }
        return v;
    }

    public Set getAlgorithmMappings() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithmMappings");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithmMappings", this.algorithmMappings);
        }
        return this.algorithmMappings;
    }

    public boolean getNonceCacheDistributed() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheDistributed");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheDistributed", Boolean.toString(this.nonceCacheDistributed));
        }
        return this.nonceCacheDistributed;
    }

    public int getNonceCacheTimeout() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheTimeout");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheTimeout", new Integer(this.nonceCacheTimeout));
        }
        return this.nonceCacheTimeout;
    }

    public int getNonceMaxAge() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceMaxAge");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceMaxAge", new Integer(this.nonceMaxAge));
        }
        return this.nonceMaxAge;
    }

    public int getNonceClockSkew() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceClockSkew");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceClockSkew", new Integer(this.nonceClockSkew));
        }
        return this.nonceClockSkew;
    }

    public WSSConsumerConfig getDefaultConsumerBinding() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultConsumerBinding");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultConsumerBinding", this.cconfig);
        }
        return this.cconfig;
    }

    public WSSGeneratorConfig getDefaultGeneratorBinding() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultGeneratorBinding");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultGeneratorBinding", this.gconfig);
        }
        return this.gconfig;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void addProperties(Map map) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(map);
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.useCache");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.certificate.cacheName");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.certificate.cacheSize");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout");
        hashMap.remove("com.ibm.ws.wssecurity.config.token.certificate.useCache");
        hashMap.remove("com.ibm.ws.wssecurity.handler.configCacheName");
        hashMap.remove("com.ibm.ws.wssecurity.handler.configCacheSize");
        hashMap.remove("com.ibm.ws.wssecurity.handler.configCacheTimeToLive");
        hashMap.remove("com.ibm.ws.wssecurity.handler.useConfigCache");
        hashMap.remove("com.ibm.ws.wssecurity.handler.token.useCache");
        hashMap.remove("com.ibm.ws.wssecurity.handler.token.cacheName");
        hashMap.remove("com.ibm.ws.wssecurity.handler.token.cacheSize");
        hashMap.remove("com.ibm.ws.wssecurity.handler.token.cacheTimeout");
        hashMap.remove("com.ibm.ws.wssecurity.handler.token.cushion");
        hashMap.remove("com.ibm.ws.wssecurity.handler.GenConfigCacheKey");
        hashMap.remove("com.ibm.ws.wssecurity.handler.ConConfigCacheKey");
        hashMap.remove("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        hashMap.remove("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography");
        hashMap.remove("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
        hashMap.remove("com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours");
        this.properties.putAll(hashMap);
    }

    public String toString() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(WSSECURITYCONFIGPERM);
        }
        return "Configuration( LoginMappings = " + this.loginMappings + " TrustAnchors = " + this.trustAnchors + " TrustedIDEvaluators = " + this.trustedIDEvaluators + " KeyLocators = " + this.keyLocators + " CertStores = " + this.certStores + " AlgorithmMapping = " + this.algorithmMappings + " NonceCacheName = " + this.nonceCacheName + " NonceCacheSize = " + this.nonceCacheSize + " NonceCacheTimeout = " + this.nonceCacheTimeout + " NonceLength = " + this.nonceLength + " NonceMaxAge = " + this.nonceMaxAge + " NonceClockSkew = " + this.nonceClockSkew + " NonceCacheDistributed = " + this.nonceCacheDistributed + " CertCacheName = " + this.certCacheName + " CertCacheSize = " + this.certCacheSize + " CertCacheTimeout = " + this.certCacheTimeOut + " TokenCacheName = " + this.tokenCacheName + " TokenCacheSize = " + this.tokenCacheSize + " TokenCacheTimeout = " + this.tokenCacheTimeOut + " TokenCacheCushion = " + this.tokenCacheCushion + " DefaultGeneratorBinding = " + this.gconfig + " DefaultConsumerBindig = " + this.cconfig + " Hardware Acceleration = " + this.useHardwareAcceleration + " HardwareConfigName = " + this.hardwareConfigName + " OffloadAllCrypto  = " + this.useOffloadAllCrypto + " HardwareCacheSize  = " + this.hardwareCacheSize + " OffloadRSAPublicKeyCrypto  = " + this.offloadRSAPublicKeyCrypto + " Properties = " + this.properties + ")";
    }

    public boolean getUseHardwareAcceleration() {
        return this.useHardwareAcceleration;
    }

    public String getHardwareConfigName() {
        return this.hardwareConfigName;
    }

    public String getUseOffloadAllCrypto() {
        return this.useOffloadAllCrypto;
    }

    public boolean getOffloadRSAPublicKeyCrypto() {
        return this.offloadRSAPublicKeyCrypto;
    }

    public int getHardwareCacheSize() {
        return this.hardwareCacheSize;
    }
}

