/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmMapping;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.etools.webservice.wssecurity.Defaultbindings;
import com.ibm.etools.webservice.wssecurity.Generator;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.core.CertManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class WSSecurityClientComponentImpl
extends ComponentImpl
implements WSSecurityService {
    private WSSecurityDefaultConfiguration config = new WSSecurityDefaultConfiguration();
    private VariableMap varMap = null;
    private Object lock = new Object();
    private ClassLoader appClassLoader = null;
    private static final TraceComponent tc = Tr.register(WSSecurityClientComponentImpl.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
            Tr.exit(tc, "stop");
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        try {
            this.addService(WSSecurityService.class, this);
            this.varMap = ClientVariableMap.getInstance();
            this._refresh();
            NonceManagerFactory.init(true, "NonceDistributionCacheMap", 1024, 600, 128, false);
            CertManagerFactory.init(true, "NonceDistributionCacheMap", 1024, 600);
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException((Throwable)configurationError, this.getClass().getName() + ".initialize", "116", this);
            Tr.error(tc, "security.wssecurity.client.init.startfail", new Object[]{configurationError});
            throw configurationError;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".initialize", "120", this);
            Tr.error(tc, "security.wssecurity.client.init.startfail", new Object[]{exception});
            throw new ConfigurationError(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    public void refresh() throws RuntimeWarning {
        throw new RuntimeWarning(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.no.refresh"));
    }

    private void _refresh() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_refresh");
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
        try {
            String string = null;
            String string2 = null;
            Resource resource = null;
            Object object = null;
            String string3 = System.getProperty("wssecurity.defaultbindings.location");
            if (string3 != null && string3.length() > 0) {
                string = string3;
            }
            if (string != null) {
                Object object2;
                string2 = this.getFileURL(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client xmlFileURL to load: " + string2);
                }
                try {
                    object2 = new WASResourceSetImpl();
                    resource = object2.getResource(URI.createURI(string2), true);
                }
                catch (Exception exception) {
                    Tr.warning(tc, "security.wssecurity.client.wssecurity.xml.notfound", (Object)new Object[]{string2});
                    FFDCFilter.processException((Throwable)exception, WSSecurityClientComponentImpl.class.getName() + "._refresh", "174", this);
                    String string4 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.xml.notfound"), string2);
                    throw new ConfigurationWarning(string4, exception);
                }
                if (resource == null) {
                    Tr.warning(tc, "security.wssecurity.client.wssecurity.xml.notfound", (Object)new Object[]{string2});
                    object2 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.xml.notfound"), string2);
                    throw new ConfigurationWarning((String)object2);
                }
                object2 = resource.getContents();
                object = object2.get(0);
                if (object != null && object instanceof WSSecurity) {
                    object2 = (WSSecurity)object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loading the client-side ws-security.xml configuration, type = " + object.getClass().getName());
                    }
                } else {
                    Tr.error(tc, "security.wssecurity.load.client.wssecurity.xml", new Object[]{string2});
                    object2 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.client.wssecurity.xml"), string2);
                    throw new ConfigurationError((String)object2);
                }
                wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
                this.loadConfig((WSSecurity)object2, wSSecurityDefaultConfiguration);
                wSSecurityDefaultConfiguration.keyStores.clear();
                wSSecurityDefaultConfiguration.certs.clear();
                wSSecurityDefaultConfiguration.crls.clear();
                this.config = wSSecurityDefaultConfiguration;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration: ", new Object[]{this.config});
            }
        }
        catch (Exception exception) {
            String string = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.loading.config"), exception.getMessage());
            throw new ConfigurationError("Exception loading config: " + string, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_refresh");
        }
    }

    public String getFileURL(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        string2 = string2.startsWith("/") ? "file:" + string2 : "file:/" + string2;
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfig");
            Tr.exit(tc, "getConfig", this.config);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.config;
        }
    }

    private void loadConfig(WSSecurity wSSecurity, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        Defaultbindings defaultbindings;
        EList eList;
        CertStoreList certStoreList;
        EList eList2;
        EList eList3;
        Object object;
        Object object2;
        EObject eObject;
        Object object3;
        EList eList4;
        TrustAnchor trustAnchor;
        int n;
        EList eList5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig", new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
        if ((eList5 = wSSecurity.getLoginMappings()) == null || eList5.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No LoginMappings found.");
            }
        } else {
            int n2 = eList5.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n2 + " LoginMappings found.");
            }
            for (n = 0; n < n2; ++n) {
                LoginMapping loginMapping = (LoginMapping)eList5.get(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing LoginMapping: ", new Object[]{loginMapping});
                }
                try {
                    trustAnchor = ConfigConstants.readLoginMapping(loginMapping, this.varMap, this.appClassLoader);
                    wSSecurityDefaultConfiguration.loginMappings.put(trustAnchor.getAuthMethod(), trustAnchor);
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "security.wssecurity.load.loginmapping.failed", new Object[]{loginMapping.getAuthMethod(), throwable});
                }
            }
        }
        if ((eList4 = wSSecurity.getTrustAnchors()) == null || eList4.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No TrustAnchors found.");
            }
        } else {
            n = eList4.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n + " TrustAnchors found.");
            }
            for (int i = 0; i < n; ++i) {
                KeyStore keyStore;
                trustAnchor = (TrustAnchor)eList4.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing TrustAnchor: ", new Object[]{trustAnchor});
                }
                if ((keyStore = (KeyStore)wSSecurityDefaultConfiguration.keyStores.get(object3 = this.varMap.expand((eObject = trustAnchor.getKeyStore()).getPath()))) == null) {
                    object2 = eObject.getType();
                    object = eObject.getStorepass().toCharArray();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating keystore instance " + (String)object3 + " of type " + (String)object2);
                    }
                    keyStore = new KeyStore((String)object2, (String)object3, (char[])object);
                    wSSecurityDefaultConfiguration.keyStores.put(object3, keyStore);
                }
                wSSecurityDefaultConfiguration.trustAnchors.put(trustAnchor.getName(), keyStore);
            }
        }
        if ((eList3 = wSSecurity.getTrustedIDEvaluators()) == null || eList3.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No TrustedIDEvaluators found.");
            }
        } else {
            int n3 = eList3.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n3 + " TrustedIDEvaluators found.");
            }
            for (int i = 0; i < n3; ++i) {
                eObject = (TrustedIDEvaluator)eList3.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing TrustedIDEvaluator: ", new Object[]{eObject});
                }
                try {
                    wSSecurityDefaultConfiguration.trustedIDEvaluators.put(eObject.getName(), ConfigConstants.readTrustedIDEvaluator((TrustedIDEvaluator)eObject, this.varMap, this.appClassLoader));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "security.wssecurity.load.trustedidevaluator.failed", new Object[]{eObject.getName(), throwable});
                }
            }
        }
        if ((eList2 = wSSecurity.getKeyLocators()) == null || eList2.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No KeyLocators found.");
            }
        } else {
            int n4 = eList2.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n4 + " KeyLocators found.");
            }
            for (int i = 0; i < n4; ++i) {
                object3 = (KeyLocator)eList2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing KeyLocator: ", new Object[]{object3});
                }
                try {
                    wSSecurityDefaultConfiguration.keyLocators.put(object3.getName(), ConfigConstants.readKeyLocator((KeyLocator)object3, this.varMap));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "security.wssecurity.load.keylocator.failed", new Object[]{object3.getName(), throwable});
                }
            }
        }
        if ((certStoreList = wSSecurity.getCertStoreList()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No CertStoreList found.");
            }
        } else {
            EList eList6 = certStoreList.getLdapCertStores();
            if (eList6 == null || eList6.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No LDAPCertStores found.");
                }
            } else {
                int n5 = eList6.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n5 + " LDAPCertStores found.");
                }
                for (int i = 0; i < n5; ++i) {
                    object2 = (LDAPCertStore)eList6.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing LDAPCertStore: ", new Object[]{object2});
                    }
                    try {
                        object = null;
                        object = new com.ibm.ws.webservices.wssecurity.config.LDAPCertStore((LDAPCertStore)object2, this.varMap);
                        wSSecurityDefaultConfiguration.certStores.put(object2.getName(), object);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "security.wssecurity.load.ldapcertstore.failed", new Object[]{object2.getName(), throwable});
                    }
                }
            }
            if ((object3 = certStoreList.getCollectionCertStores()) == null || object3.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CollectionCertStores found.");
                }
            } else {
                int n6 = object3.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n6 + " collectionCertStores found.");
                }
                for (int i = 0; i < n6; ++i) {
                    object = (com.ibm.etools.webservice.wscommonbnd.CollectionCertStore)object3.get(i);
                    if (object == null) {
                        Tr.error(tc, "security.wssecurity.collectioncertstore.is.null");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process CollectionCertStore: ", new Object[]{object});
                    }
                    String string = object.getProvider();
                    HashSet<Object> hashSet = new HashSet<Object>();
                    EList eList7 = object.getX509Certificates();
                    EList eList8 = object.getCRL();
                    if ((eList7 == null || eList7.isEmpty()) && (eList8 == null || eList8.isEmpty())) {
                        Tr.error(tc, "security.wssecurity.x509certificates.is.null");
                        Tr.error(tc, "security.wssecurity.WSEC0134E");
                        continue;
                    }
                    String string2 = "Collection";
                    CollectionCertStoreParameters collectionCertStoreParameters = null;
                    try {
                        Object object4;
                        String string3;
                        EObject eObject2;
                        int n7;
                        int n8;
                        CertificateFactory certificateFactory = ConfigUtil.createCertificateFactory((String)"");
                        if (eList7 == null || eList7.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No X509 certificates in CollectionCertStore[" + object + "]");
                            }
                        } else {
                            n8 = eList7.size();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, n8 + " certificates found.");
                            }
                            for (n7 = 0; n7 < n8; ++n7) {
                                eObject2 = (X509Certificate)eList7.get(n7);
                                string3 = this.varMap.expand(eObject2.getPath());
                                if (string3 == null) {
                                    Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{object.getName()});
                                    continue;
                                }
                                object4 = null;
                                X509CRL x509CRL = null;
                                if (wSSecurityDefaultConfiguration.certs.containsKey(string3)) {
                                    object4 = (java.security.cert.X509Certificate)wSSecurityDefaultConfiguration.certs.get(string3);
                                } else if (wSSecurityDefaultConfiguration.crls.containsKey(string3)) {
                                    x509CRL = (X509CRL)wSSecurityDefaultConfiguration.crls.get(string3);
                                }
                                if (object4 == null && x509CRL == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Creating certificate or CRL: " + string3);
                                    }
                                    try {
                                        object4 = ConfigUtil.getX509Certificate((File)new File(string3), (CertificateFactory)certificateFactory);
                                        wSSecurityDefaultConfiguration.certs.put(string3, object4);
                                    }
                                    catch (Exception exception) {
                                        x509CRL = ConfigUtil.getX509CRL((File)new File(string3), (CertificateFactory)certificateFactory);
                                        wSSecurityDefaultConfiguration.crls.put(string3, x509CRL);
                                    }
                                }
                                if (x509CRL != null) {
                                    hashSet.add(x509CRL);
                                    continue;
                                }
                                hashSet.add(object4);
                            }
                        }
                        if (eList8 == null || eList8.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No X509 crls in CollectionCertStore[" + object + "]");
                            }
                        } else {
                            n8 = eList8.size();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, n8 + " CRLs found.");
                            }
                            for (n7 = 0; n7 < n8; ++n7) {
                                eObject2 = (com.ibm.etools.webservice.wscommonbnd.CRL)eList8.get(n7);
                                string3 = this.varMap.expand(eObject2.getPath());
                                if (string3 == null) {
                                    Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{object.getName()});
                                    continue;
                                }
                                object4 = (CRL)wSSecurityDefaultConfiguration.crls.get(string3);
                                if (object4 == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Creating certificate: " + string3);
                                    }
                                    object4 = ConfigUtil.getX509CRL((File)new File(string3), (CertificateFactory)certificateFactory);
                                    wSSecurityDefaultConfiguration.crls.put(string3, object4);
                                }
                                hashSet.add(object4);
                            }
                        }
                        collectionCertStoreParameters = new CollectionCertStoreParameters(hashSet);
                        CollectionCertStore collectionCertStore = null;
                        collectionCertStore = new CollectionCertStore(string2, collectionCertStoreParameters, string, object.getName());
                        wSSecurityDefaultConfiguration.certStores.put(object.getName(), collectionCertStore);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{object.getName(), throwable});
                    }
                }
            }
        }
        if ((eList = wSSecurity.getAlgorithmMapping()) == null || eList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No AlgorithmMappings found.");
            }
        } else {
            int n9 = eList.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n9 + " AlgorithmMappings found.");
            }
            for (int i = 0; i < n9; ++i) {
                AlgorithmMapping algorithmMapping = (AlgorithmMapping)eList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process AlgorithmMapping: ", new Object[]{algorithmMapping});
                }
                try {
                    wSSecurityDefaultConfiguration.algorithmMappings.add(ConfigConstants.readAlgorithmMapping(algorithmMapping, this.varMap));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "security.wssecurity.load.algorithmmapping.failed", new Object[]{algorithmMapping.getFactoryname(), throwable});
                }
            }
        }
        if ((defaultbindings = wSSecurity.getDefaultbindings()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No default bindings found.");
            }
        } else {
            Generator generator;
            Consumer consumer = defaultbindings.getConsumer();
            if (consumer != null) {
                wSSecurityDefaultConfiguration.cconfig = new WSSecurityDefaultConsumerConfig(consumer, this.varMap, wSSecurityDefaultConfiguration);
            }
            if ((generator = defaultbindings.getGenerator()) != null) {
                wSSecurityDefaultConfiguration.gconfig = null;
                try {
                    wSSecurityDefaultConfiguration.gconfig = new WSSecurityDefaultGeneratorConfig(generator, this.varMap, wSSecurityDefaultConfiguration);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.error(tc, "security.wssecurity.WSEC0135E", new Object[]{soapSecurityException.getMessage()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig", new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
    }
}

