/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.ResultMessagePool;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.VerificationResult;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedPartChecker;
import com.ibm.ws.webservices.wssecurity.enc.DecryptedPartChecker;
import com.ibm.ws.webservices.wssecurity.enc.DecryptionResult;
import com.ibm.ws.webservices.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.time.TimestampChecker;
import com.ibm.ws.webservices.wssecurity.time.TimestampConsumer;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.token.LoginProcessor;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.IDAssertionUsernameTokenConsumer;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register((Class)WSSConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSConsumer.class.getName();
    private Map _handlerOption = new HashMap();
    private Map _properties = new HashMap();
    private boolean _initialized = false;

    public void setHandlerOption(String string, Object object) {
        this._handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this._handlerOption.get(string);
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Node node, Map map) throws SoapSecurityException {
        Object object;
        SOAPPart sOAPPart;
        SOAPMessageContext sOAPMessageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        if ((sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        ResultPool.initialize((Map)map);
        WSSConsumer.adjustContext(sOAPMessageContext, map);
        TokenManager.initializeSubject(map);
        ResultMessagePool.initialize(map);
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSSConsumerConfig [" + wSSConsumerConfig + "]."));
        }
        TimestampConsumerConfig timestampConsumerConfig = wSSConsumerConfig.getTimestampConsumer();
        HashMap hashMap = new HashMap(this._properties);
        map.put(NonceManager.class, wSSConsumerConfig.getNonceManager());
        map.put(CertCacheManager.class, wSSConsumerConfig.getCertManager());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finished initializing the subject.");
        }
        boolean bl = wSSConsumerConfig.isTokenRequired() || wSSConsumerConfig.isVerificationRequired() || wSSConsumerConfig.isDecryptionRequired() || wSSConsumerConfig.isLoginRequired() || wSSConsumerConfig.isTimestampRequired();
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        SOAPPart sOAPPart2 = sOAPPart = sOAPMessage.getSOAPPart();
        SOAPEnvelope sOAPEnvelope = null;
        try {
            sOAPEnvelope = sOAPPart.getEnvelope();
        }
        catch (SOAPException sOAPException) {
            Tr.processException((Throwable)sOAPException, (String)(clsName + ".invoke"), (String)"229", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s01", (Object)new Object[]{sOAPException});
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s01", sOAPException);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, (String)(clsName + ".invoke"), (String)"235", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s02", (Object)new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s02", exception);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The original message to be processed by WSSConsumer: " + DOMUtil.toString((Node)sOAPPart2)));
        }
        if (!bl) {
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Starts WS-Security operation.");
        }
        HashMap hashMap2 = new HashMap();
        Element element = sOAPPart2.getDocumentElement();
        Element element2 = WSSGenerator.getHeader(sOAPPart2, false);
        if (element2 == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", "SOAP Header");
        }
        int n = NamespaceUtil.isSoap(element2.getNamespaceURI());
        if (tc.isDebugEnabled()) {
            object = null;
            object = n == 0 ? "The spec of SOAP is SOAP1.1." : (n == 1 ? "The spec of SOAP is SOAP1.2." : "Unknown spec of SOAP: " + element2.getNamespaceURI());
            Tr.debug((TraceComponent)tc, (String)object);
        }
        object = WSSConsumer.getSecurityHeaders(element2, n, wSSConsumerConfig.isUltimateReceiver(), wSSConsumerConfig.getMyActor());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(object.getLength() + " security headers found"));
        }
        if (object.getLength() == 0) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s38", (Object)wSSConsumerConfig.getMyActor());
        }
        boolean bl2 = false;
        String string = (String)sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness");
        if (string != null && string.equals("true")) {
            bl2 = true;
        }
        if (!bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Skipping the Id uniqueness check.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing the Id uniqueness check.");
            }
            IdUtil.getInstance().checkIdUniqueness((Document)sOAPPart2);
        }
        int n2 = -1;
        if (bl && object.getLength() == 0 && WSSConsumer.countSecurityHeaders(element2) > 0) {
            if (wSSConsumerConfig.getMyActor() == null || wSSConsumerConfig.getMyActor().trim().length() == 0) {
                if (!tc.isDebugEnabled()) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s39");
                Tr.debug((TraceComponent)tc, (String)("The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace, but it was not found."));
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s39");
            }
            if (!tc.isDebugEnabled()) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s40", wSSConsumerConfig.getMyActor());
            Tr.debug((TraceComponent)tc, (String)("The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace and the " + wSSConsumerConfig.getMyActor() + " actor, but it was not found."));
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s40", wSSConsumerConfig.getMyActor());
        }
        if (wSSConsumerConfig.isTimestampRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Processing the timestamp.");
            }
            NodeList nodeList = null;
            nodeList = WSSConsumer.getTimestampHeader(element2, -1, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(nodeList.getLength() + " timestamp headers found."));
            }
            if (nodeList.getLength() > 0) {
                n2 = NamespaceUtil.isWsu(((Element)nodeList.item(0)).getNamespaceURI());
                map.put("com.ibm.ws.webservices.wssecurity.constants.wssVersion", new Integer(n2));
                sOAPMessageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion", (Object)new Integer(n2));
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    WSSConsumer.callTimestampConsumer(timestampConsumerConfig, hashMap, element3, map);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Checking the required timestamp.");
                }
                WSSConsumer.checkRequiredTimestamp(sOAPPart2, wSSConsumerConfig.getTimestampConsumer(), hashMap, map);
            }
        }
        for (int i = 0; i < object.getLength(); ++i) {
            Element element4 = (Element)object.item(i);
            boolean bl3 = true;
            String string2 = element4.getAttributeNS(element2.getNamespaceURI(), "mustUnderstand");
            if (string2 != null && !"".equals(string2)) {
                bl3 = ConfigUtil.isTrue((String)string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mustUnderstand attribute is " + bl3));
            }
            try {
                Object object2;
                int n3 = NamespaceUtil.isWsse(element4.getNamespaceURI());
                if (n2 < 0) {
                    n2 = n3;
                    map.put("com.ibm.ws.webservices.wssecurity.constants.wssVersion", new Integer(n2));
                    sOAPMessageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion", (Object)new Integer(n2));
                } else if (n3 != n2) {
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s06");
                }
                if (tc.isDebugEnabled()) {
                    object2 = null;
                    object2 = n2 == 0 ? "The spec of WS-Security is 2004/01 ver." : "Unknown spec of WS-Security: " + element4.getNamespaceURI();
                    Tr.debug((TraceComponent)tc, (String)object2);
                }
                object2 = DOMUtil.getFirstElement((Node)element4);
                while (object2 != null) {
                    String string3 = object2.getLocalName();
                    String string4 = object2.getNamespaceURI();
                    n3 = NamespaceUtil.isWsu(string4);
                    if (n3 >= 0) {
                        if (n3 != n2) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", string4);
                        if (!string3.equals("Timestamp")) {
                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)object2), DOMUtil.getQualifiedName((Node)element4));
                        }
                    } else {
                        n3 = NamespaceUtil.isWsse(string4);
                        if (n3 >= 0) {
                            if (n3 != n2) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", string4);
                            if (string3.equals("UsernameToken")) {
                                WSSConsumer.callTokenConsumer(wSSConsumerConfig.getCallers(), wSSConsumerConfig.getTokenConsumers(), element, element4, (Element)object2, map, true, false, n2);
                            } else {
                                if (!string3.equals("BinarySecurityToken")) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)object2), DOMUtil.getQualifiedName((Node)element4));
                                WSSConsumer.callTokenConsumer(wSSConsumerConfig.getCallers(), wSSConsumerConfig.getTokenConsumers(), element, element4, (Element)object2, map, false, true, n2);
                            }
                        } else if (Constants.NS_DSIG.equals(string4)) {
                            if (!string3.equals("Signature")) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)object2), DOMUtil.getQualifiedName((Node)element4));
                            boolean bl4 = false;
                            Element element5 = DOMUtil.getNextElement((Node)object2);
                            while (element5 != null) {
                                String string5 = element5.getNamespaceURI();
                                String string6 = element5.getLocalName();
                                if (Constants.NS_ENC.equals(string5) && ("EncryptedKey".equals(string6) || "ReferenceList".equals(string6))) {
                                    bl4 = true;
                                }
                                element5 = DOMUtil.getNextElement((Node)element5);
                            }
                            WSSConsumer.callSignatureConsumer(wSSConsumerConfig.getSignatureConsumers(), hashMap, (Element)object2, bl4, map);
                        } else if (Constants.NS_ENC.equals(string4)) {
                            if (!string3.equals("EncryptedKey") && !string3.equals("ReferenceList")) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)object2), DOMUtil.getQualifiedName((Node)element4));
                            WSSConsumer.callEncryptionConsumer(wSSConsumerConfig.getEncryptionConsumers(), hashMap, (Element)object2, map);
                        } else {
                            WSSConsumer.callTokenConsumer(wSSConsumerConfig.getCallers(), wSSConsumerConfig.getTokenConsumers(), element, element4, (Element)object2, map, false, false, n2);
                        }
                    }
                    object2 = DOMUtil.getNextElement((Node)object2);
                }
                continue;
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, (String)(clsName + ".invoke"), (String)"516", (Object)this);
                if (bl3) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s23", (Object)soapSecurityException);
                    throw soapSecurityException;
                }
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s23", (Object)soapSecurityException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"All security handlers is processed.");
        }
        WSSConsumer.cleanSubject(map);
        if (wSSConsumerConfig.isVerificationRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the required integrity.");
            }
            WSSConsumer.checkRequiredIntegrity(sOAPPart2, hashMap, map);
        }
        if (wSSConsumerConfig.isDecryptionRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the required confidentiality.");
            }
            WSSConsumer.checkRequiredConfidentiality(sOAPPart2, hashMap, map);
        }
        if (wSSConsumerConfig.isTokenRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the required security token.");
            }
            WSSConsumer.checkRequiredSecurityToken(wSSConsumerConfig.getRequiredSecurityTokens(), wSSConsumerConfig.getCallers(), map);
        }
        if (wSSConsumerConfig.isLoginRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the caller.");
            }
            WSSConsumer.checkCaller(hashMap, map);
        }
        WSSConsumer.copyContextSubjectToMessageContext(sOAPMessageContext, map);
        WSSConsumer.mapTokenToMessageContext(sOAPMessageContext, map);
        SOAPHeaderElement sOAPHeaderElement = NamespaceUtil.getWsseHeaderByName(sOAPEnvelope, "Security");
        if (sOAPHeaderElement != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security header is processed.");
            }
            sOAPHeaderElement.setProcessed(true);
        }
        if ((sOAPHeaderElement = NamespaceUtil.getWsuHeaderByName(sOAPEnvelope, "Timestamp")) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Timestamp header is processed.");
            }
            sOAPHeaderElement.setProcessed(true);
        }
        ResultPool.finalize((Map)map);
        ResultMessagePool.finalize(map);
        WSSConsumer.cleanContext(map);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
    }

    public void onFault(SOAPMessageContext sOAPMessageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onFault(SOAPMessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onFault(SOAPMessageContext context)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", IdUtil.getInstance());
        this._properties.put(NonceUtil.class, new NonceUtil());
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.timestamp");
        this._properties.put(TimestampConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.signature");
        this._properties.put(SignatureConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.encryption");
        this._properties.put(EncryptionConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        WSSConsumerComponent wSSConsumerComponent = new VerifiedPartChecker();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(VerifiedPartChecker.class, wSSConsumerComponent);
        wSSConsumerComponent = new DecryptedPartChecker();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(DecryptedPartChecker.class, wSSConsumerComponent);
        wSSConsumerComponent = new TimestampChecker();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(TimestampChecker.class, wSSConsumerComponent);
        wSSConsumerComponent = new LoginProcessor();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(LoginProcessor.class, wSSConsumerComponent);
    }

    private static boolean adjustContext(SOAPMessageContext sOAPMessageContext, Map map) throws SoapSecurityException {
        return false;
    }

    public static NodeList getSecurityHeaders(Element element, int n, boolean bl, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSecurityHeaders(Element header[" + DOMUtil.getDisplayName((Node)element) + "]," + "int soapVersion[" + n + "]," + "boolean untimateReceiver[" + bl + "]," + "String actor[" + string + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Element element2 = DOMUtil.getFirstElement((Node)element);
        while (element2 != null) {
            block11: {
                block13: {
                    String string2;
                    block12: {
                        String string3 = element2.getNamespaceURI();
                        String string4 = element2.getLocalName();
                        if (NamespaceUtil.isWsse(string3) < 0 || !"Security".equals(string4)) break block11;
                        if (n == 1) {
                            string2 = element2.getAttributeNS(Constants.NS_SOAP12, "role");
                        } else if (n == 0) {
                            string2 = element2.getAttributeNS(Constants.NS_SOAP, "actor");
                        } else {
                            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(n));
                        }
                        if (string2 != null && string2.trim().length() != 0) break block12;
                        if (string != null && string.trim().length() != 0) break block11;
                        break block13;
                    }
                    if (n == 1 ? Constants.SOAP12_ROLE_NONE.equals(string2) || (Constants.SOAP12_ROLE_RECEIVER.equals(string2) ? !string2.equals(string) : !Constants.SOAP12_ROLE_NEXT.equals(string2) && !string2.equals(string)) : !Constants.SOAP11_ACTOR_NEXT.equals(string2) && !string2.equals(string)) break block11;
                }
                nodeListImpl.add((Node)element2);
            }
            element2 = DOMUtil.getNextElement((Node)element2);
        }
        if (nodeListImpl.getLength() > 1) {
            throw new SoapSecurityException("There are more than one wsse:Security elements to be processed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityHeaders(Element header,int soapVersion,int wssVersion,String actor) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static int countSecurityHeaders(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("countSecurityHeaders(Element header[" + DOMUtil.getDisplayName((Node)element) + "])"));
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement((Node)element);
        while (element2 != null) {
            if ("Security".equals(element2.getLocalName())) {
                ++n;
            }
            element2 = DOMUtil.getNextElement((Node)element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("countSecurityHeaders(Element header, returns " + n));
        }
        return n;
    }

    public static String getId(Node node) throws SoapSecurityException {
        Node node2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getId(Node node[" + DOMUtil.getDisplayName((Node)node) + "])"));
        }
        String string = null;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            string = IdUtil.getInstance().getIdAttributeName((Element)node2);
            if (string != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getNode(Node node) returns " + string));
                }
                return string;
            }
        }
        for (node2 = node.getFirstChild(); node2 != null && (node2.getNodeType() != 1 && node2.getNodeType() != 5 || (string = WSSConsumer.getId(node2)) == null); node2 = node2.getNextSibling()) {
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNode(Node node) returns " + string));
        }
        return string;
    }

    private static NodeList getTimestampHeader(Element element, int n, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestampHeader(Element root[" + DOMUtil.getDisplayName((Node)element) + "],"), (Object)("int wssVersion" + n + "]," + "boolean trace[" + bl + "])"));
        }
        String string = bl ? "TimestampTrace" : "Timestamp";
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        NodeList nodeList = n < 0 ? NamespaceUtil.getWsuElementsByTagName(element, string) : DOMUtil.getOneOrMoreElements((Element)element, (String)Constants.NAMESPACES[1][n], (String)string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.hasAttribute("wasextention")) continue;
            nodeListImpl.add((Node)element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestampHeader(Element root,int wssVersion,boolean trace) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static void callTimestampConsumer(TimestampConsumerConfig timestampConsumerConfig, Map map, Element element, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestampConsumer(TimestampConsumerConfig config,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        TimestampConsumer timestampConsumer = (TimestampConsumer)map.get(TimestampConsumer.class);
        map2.put("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey", timestampConsumerConfig);
        timestampConsumer.invoke(element, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimestampConsumer(TimestampConsumerConfig config,Map selectors,Element target,Map context)");
        }
    }

    public static void callTokenConsumer(Set set, Set set2, Element element, Element element2, Element element3, Map map, boolean bl, boolean bl2, int n) throws SoapSecurityException {
        Object object;
        boolean bl3;
        QName qName;
        TokenConsumerConfig tokenConsumerConfig;
        Iterator iterator;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callTokenConsumer(Set cconfigs,Set tconfigs,Element envelope[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)element2) + "]," + "Element target[" + DOMUtil.getDisplayName((Node)element3) + "]," + "Map context," + "boolean isUT[" + bl + "]," + "boolean isBST[" + bl2 + "]," + "int wssVersion" + n + "])"));
        }
        QName qName2 = null;
        if (element3.hasAttribute("ValueType")) {
            string = element3.getAttribute("ValueType");
            qName2 = DOMUtil.getQName(element3, string, n);
        }
        string = Constants.NAMESPACES[0][n];
        String string2 = ConfigUtil.trim((String)IdUtil.getInstance().getId(element3));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Target's value type is [" + qName2 + "]."));
            Tr.debug((TraceComponent)tc, (String)("UsernameToken flag is [" + bl + "]."));
            Tr.debug((TraceComponent)tc, (String)("BinarySecurityToken flag is [" + bl2 + "]."));
            Tr.debug((TraceComponent)tc, (String)("The identifier is [" + string2 + "]."));
        }
        HashSet<TokenConsumerConfig> hashSet = new HashSet<TokenConsumerConfig>();
        boolean bl4 = true;
        boolean bl5 = true;
        int n2 = 0;
        if (element != null && element2 != null && (bl2 || bl)) {
            bl4 = false;
            bl5 = false;
            n2 = WSSConsumer.getUsedFor(element, element2, string, string2);
            if (n2 == 1) {
                bl5 = true;
            } else if (n2 == 2) {
                bl4 = true;
            }
            if (tc.isDebugEnabled()) {
                if (bl5) {
                    Tr.debug((TraceComponent)tc, (String)"The token is used for signature verification.");
                } else if (bl4) {
                    Tr.debug((TraceComponent)tc, (String)"The token is used for decryption.");
                } else {
                    Tr.debug((TraceComponent)tc, (String)"The token is maybe stand-alone.");
                }
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                tokenConsumerConfig = (TokenConsumerConfig)iterator.next();
                if (tc.isDebugEnabled()) {
                    if (tokenConsumerConfig.isUsedForVerification()) {
                        Tr.debug((TraceComponent)tc, (String)"The configuration of token consumers is used for signature verification.");
                    } else if (tokenConsumerConfig.isUsedForDecryption()) {
                        Tr.debug((TraceComponent)tc, (String)"The configuration of token consumers is used for decryption.");
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"The configuration of token consumers is maybe used for stand-alone tokens.");
                    }
                }
                if (!(bl5 && tokenConsumerConfig.isUsedForVerification() || bl4 && tokenConsumerConfig.isUsedForDecryption()) && (bl5 || tokenConsumerConfig.isUsedForVerification() || bl4 || tokenConsumerConfig.isUsedForDecryption())) continue;
                qName = tokenConsumerConfig.getType();
                if (bl) {
                    if (!Constants.UNTOKEN.equals(qName)) continue;
                    bl3 = false;
                    object = tokenConsumerConfig.getInstance();
                    if (object != null && object instanceof IDAssertionUsernameTokenConsumer) {
                        bl3 = true;
                    }
                    Element element4 = DOMUtil.getZeroOrOneElement((Element)element3, (String)string, (String)"Password");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("isIDAssertionConsumer = " + bl3));
                        if (element4 == null) {
                            Tr.debug((TraceComponent)tc, (String)"password elem is null. (IDAssertion token)");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"password elem is not null. (Username token)");
                        }
                    }
                    if (bl3 && element4 != null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Not adding config for [" + qName + "] at this time. Token consumer " + "is IDAssertionUsernameTokenConsumer and token contains a password."));
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + qName + "]."));
                    }
                    hashSet.add(tokenConsumerConfig);
                    continue;
                }
                if (bl2) {
                    if (!NamespaceUtil.equals(qName2, qName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + qName + "]."));
                    }
                    hashSet.add(tokenConsumerConfig);
                    continue;
                }
                if (!qName.equals(new QName(element3.getNamespaceURI(), element3.getLocalName()))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added a config for [" + qName + "]."));
                }
                hashSet.add(tokenConsumerConfig);
            }
        }
        if (hashSet.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Since it can't select configuration of token cosumers based on the message, it uses all candidates.");
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                tokenConsumerConfig = (TokenConsumerConfig)iterator.next();
                qName = tokenConsumerConfig.getType();
                if (bl) {
                    if (!Constants.UNTOKEN.equals(qName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + qName + "]."));
                    }
                    hashSet.add(tokenConsumerConfig);
                    continue;
                }
                if (bl2) {
                    if (!NamespaceUtil.equals(qName2, qName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + qName + "]."));
                    }
                    hashSet.add(tokenConsumerConfig);
                    continue;
                }
                if (!qName.equals(new QName(element3.getNamespaceURI(), element3.getLocalName()))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added a config for [" + qName + "]."));
                }
                hashSet.add(tokenConsumerConfig);
            }
        }
        if (hashSet.isEmpty()) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)element3));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(hashSet.size() + " TokenConsumerConfig candidates found."));
        }
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE);
        boolean bl6 = false;
        bl3 = false;
        object = new Exception[hashSet.size()];
        int n3 = 0;
        SoapSecurityException soapSecurityException = null;
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            tokenConsumerConfig = (TokenConsumerConfig)iterator.next();
            try {
                WSSConsumer.callTokenConsumer(tokenConsumerConfig, element3, map);
                Token token = TokenManager.getUnprocessedToken(map);
                if (token != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unprocessed token [" + token + "] found."));
                    }
                    token.setProcessed(true);
                    if (!bl3 && set != null) {
                        WSSConsumer.checkCaller(set, tokenConsumerConfig, token, map);
                        bl3 = token.getCallerChecked();
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"All tokens are processed.");
                    }
                    if (set != null) {
                        WSSConsumer.checkCaller(set, tokenConsumerConfig, map);
                    }
                }
                bl6 = true;
                if (bl4 || bl5) continue;
                break;
            }
            catch (Exception exception) {
                object[n3++] = exception;
                soapSecurityException = exception instanceof SoapSecurityException ? (SoapSecurityException)exception : SoapSecurityException.format("security.wssecurity.WSSConsumer.s34", exception);
                Token token = TokenManager.getUnprocessedToken(map);
                if (token != null) {
                    if (!bl4 && !bl5) {
                        TokenManager.removeToken(map, token);
                        continue;
                    }
                    token.setError(soapSecurityException);
                    token.setProcessed(true);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"getUnprocessedToken returned null");
            }
        }
        if (!bl6) {
            if (hashSet.size() == 1) {
                throw soapSecurityException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(n3 + " exceptions were catched."));
                for (int i = 0; i < n3; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("No." + iterator + "'s exception: " + object[i]));
                }
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s13", object[n3 - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callTokenConsumer(Set cconfigs,Set tconfigs,Element envelope,Element security,Element target,Map context,boolean isUT,boolean isBST,int wssVersion");
        }
    }

    private static void callTokenConsumer(TokenConsumerConfig tokenConsumerConfig, Element element, Map map) throws SoapSecurityException {
        TokenConsumerComponent tokenConsumerComponent;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callTokenConsumer(TokenConsumerConfig config,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        if ((tokenConsumerComponent = tokenConsumerConfig.getInstance()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to get the TokenConsumer object: [" + tokenConsumerConfig + "]."));
            }
        } else {
            map.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tokenConsumerConfig);
            tokenConsumerComponent.invoke(element, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callTokenConsumer(TokenConsumerConfig config,Element target,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callSignatureConsumer(Set set, Map map, Element element, boolean bl, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callSignatureConsumer(Set sconfig,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "boolean copiedDOMTree[" + bl + "]," + "Map context)"));
        }
        if (set.size() > 0) {
            boolean bl2 = false;
            Exception[] exceptionArray = new Exception[set.size()];
            int n = 0;
            WSSConsumer.lockResults(map2, true, true);
            SignatureConsumerConfig signatureConsumerConfig = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                signatureConsumerConfig = (SignatureConsumerConfig)iterator.next();
                try {
                    WSSConsumer.callSignatureConsumer(signatureConsumerConfig, map, element, bl, map2);
                    bl2 = true;
                    break;
                }
                catch (Exception exception) {
                    exceptionArray[n++] = exception;
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(map2);
                    if (bl2) continue;
                    WSSConsumer.restoreResults(map2, true);
                }
            }
            if (!bl2) {
                if (set.size() == 1) {
                    if (exceptionArray[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptionArray[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s15", exceptionArray[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(n + " exceptions were catched."));
                    for (int i = 0; i < n; ++i) {
                        Tr.debug((TraceComponent)tc, (String)("No." + iterator + "'s exception: " + exceptionArray[i]));
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s11", exceptionArray[n - 1]);
            }
            WSSConsumer.lockResults(map2, true, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callSignatureConsumer(Set sconfig,Map selectors,Element target,boolean copiedDOMTree,Map context)");
        }
    }

    private static void callSignatureConsumer(SignatureConsumerConfig signatureConsumerConfig, Map map, Element element, boolean bl, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callSignatureConsumer(SignatureConsumerConfig config,Map properties,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "boolean copiedDOMTree[" + bl + "]," + "Map context)"));
        }
        SignatureConsumer signatureConsumer = (SignatureConsumer)map.get(SignatureConsumer.class);
        map2.put("com.ibm.wsspi.wssecurity.config.signatureConsumer.configKey", signatureConsumerConfig);
        if (bl) {
            map2.put("com.ibm.ws.webservices.wssecurity.constants.copiedDOMTree", "true");
        } else {
            map2.remove("com.ibm.ws.webservices.wssecurity.constants.copiedDOMTree");
        }
        signatureConsumer.invoke(element, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callSignatureConsumer(SignatureConsumerConfig config,Map selectors,Element target,boolean copiedDOMTree,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callEncryptionConsumer(Set set, Map map, Element element, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callEncryptionConsumer(Set econfig,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        boolean bl = false;
        Exception[] exceptionArray = new Exception[set.size()];
        int n = 0;
        if (set.size() > 0) {
            WSSConsumer.lockResults(map2, false, true);
            EncryptionConsumerConfig encryptionConsumerConfig = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                encryptionConsumerConfig = (EncryptionConsumerConfig)iterator.next();
                try {
                    WSSConsumer.callEncryptionConsumer(encryptionConsumerConfig, map, element, map2);
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    exceptionArray[n++] = exception;
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(map2);
                    if (bl) continue;
                    WSSConsumer.restoreResults(map2, false);
                }
            }
            if (!bl) {
                if (set.size() == 1) {
                    if (exceptionArray[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptionArray[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", exceptionArray[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(n + " exceptions were catched."));
                    for (int i = 0; i < n; ++i) {
                        Tr.debug((TraceComponent)tc, (String)("No." + iterator + "'s exception: " + exceptionArray[i]));
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s12", exceptionArray[n - 1]);
            }
            WSSConsumer.lockResults(map2, false, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callEncryptionConsumer(Set econfig,Map selectors,Element target,Map context)");
        }
    }

    private static void callEncryptionConsumer(EncryptionConsumerConfig encryptionConsumerConfig, Map map, Element element, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callEncryptionConsumer(EncryptionConsumerConfig config,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        EncryptionConsumer encryptionConsumer = (EncryptionConsumer)map.get(EncryptionConsumer.class);
        map2.put("com.ibm.wsspi.wssecurity.config.encryptionConsumer.configKey", encryptionConsumerConfig);
        encryptionConsumer.invoke(element, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callEncryptionConsumer(EncryptionConsumerConfig config,Map selectors,Element target,Map context)");
        }
    }

    private static void checkRequiredIntegrity(Document document, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredIntegrity(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "WSSConsumerConfig config," + "Map selectors," + "Map context)"));
        }
        WSSConsumerComponent wSSConsumerComponent = (WSSConsumerComponent)map.get(VerifiedPartChecker.class);
        wSSConsumerComponent.invoke(document, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredIntegrity(Document doc,Map selectors,Map context)");
        }
    }

    private static void checkRequiredConfidentiality(Document document, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredConfidentiality(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Map selectors," + "Map context)"));
        }
        WSSConsumerComponent wSSConsumerComponent = (WSSConsumerComponent)map.get(DecryptedPartChecker.class);
        wSSConsumerComponent.invoke(document, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredConfidentiality(Document doc,Map selectors,Map context)");
        }
    }

    private static void checkRequiredSecurityToken(Set set, Set set2, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredSecurityToken(Set tokens[" + set + "]," + "Set callers[" + set2 + "]," + "Map context)"));
        }
        Set set3 = TokenManager.getTokens(map);
        if (tc.isDebugEnabled()) {
            if (set3 == null) {
                Tr.debug((TraceComponent)tc, (String)"The subject has no Token object.");
            } else {
                Tr.debug((TraceComponent)tc, (String)(set3.size() + " tokens found in the subject."));
            }
        }
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)iterator.next();
            if (!ConfigUtil.isUsageRequired((String)tokenConsumerConfig.getUsage())) continue;
            bl = false;
            QName qName = tokenConsumerConfig.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking the value type [" + qName + "]..."));
            }
            if (set2 != null) {
                iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    WSSConsumerConfig.CallerConfig callerConfig = (WSSConsumerConfig.CallerConfig)iterator2.next();
                    if (callerConfig.getTokenConsumerType().equals(callerConfig.getTokenType()) || !qName.equals(callerConfig.getTokenConsumerType())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Remapped the value type [" + qName + "] to the value type [" + callerConfig.getTokenType() + "]."));
                    }
                    qName = callerConfig.getTokenType();
                }
            }
            if (set3 != null) {
                iterator2 = set3.iterator();
                while (iterator2.hasNext()) {
                    Token token = (Token)iterator2.next();
                    QName qName2 = token.getType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Comparing with the value type of the Token [" + qName2 + "]..."));
                    }
                    if (!qName.equals(qName2)) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"A corresponding token found.");
                    break;
                }
            }
            if (bl) continue;
            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.WSSConsumer.s14", tokenConsumerConfig.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredSecurityToken(Set tokens,Set callers,Map context)");
        }
    }

    private static void checkRequiredTimestamp(Document document, TimestampConsumerConfig timestampConsumerConfig, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "TimestampConsumerConfig config," + "Map selectors," + "Map context)"));
        }
        WSSConsumerComponent wSSConsumerComponent = (WSSConsumerComponent)map.get(TimestampChecker.class);
        map2.put("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey", timestampConsumerConfig);
        wSSConsumerComponent.invoke(document, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredTimestamp(Document doc,TimestampConsumerConfig config,Map selectors,Map context)");
        }
    }

    private static void checkCaller(Set set, TokenConsumerConfig tokenConsumerConfig, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCaller(Set cconfigs,TokenConsumerConfig tconfig,Map context)");
        }
        if (tokenConsumerConfig != null && set != null) {
            Set set2 = TokenManager.getTokens(map);
            if (set2.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(set2.size() + " tokens found."));
                }
            } else {
                set2 = null;
            }
            QName qName = tokenConsumerConfig.getType();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                boolean bl;
                Object object2;
                Object object3;
                QName qName2;
                Object object4;
                WSSConsumerConfig.CallerConfig callerConfig = (WSSConsumerConfig.CallerConfig)iterator.next();
                if (callerConfig.getPart() == null) {
                    object4 = callerConfig.getTokenType();
                    qName2 = callerConfig.getTokenConsumerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the Caller [" + qName2 + "], " + "TokenConsumer type [" + qName + "]."));
                    }
                    if (qName.equals(qName2) && set2 != null) {
                        object3 = set2.iterator();
                        while (object3.hasNext()) {
                            object2 = (Token)object3.next();
                            boolean bl2 = object2.getCallerChecked();
                            bl = object2.isTrusted();
                            QName qName3 = object2.getType();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Token type in the Caller [" + object4 + "] and " + "Token type [" + qName3 + "]."));
                                Tr.debug((TraceComponent)tc, (String)("Caller checked [" + bl2 + "]."));
                                Tr.debug((TraceComponent)tc, (String)("Token trusted [" + bl + "]."));
                            }
                            if (bl2 || bl || !((QName)object4).equals(qName3)) continue;
                            object = new AuthResult((Token)object2, callerConfig);
                            object2.setCallerChecked(true);
                            ResultPool.add((Map)map, (Result)object);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + object + "] into the ResultPool."));
                        }
                    }
                }
                if ((object4 = callerConfig.getTrustMethod()) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TrustMethod configuration found.");
                }
                if (object4.getPart() != null) continue;
                qName2 = object4.getTokenType();
                object3 = object4.getTokenConsumerType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the TrustMethod [" + object3 + "], " + "TokenConsumer type [" + qName + "]."));
                }
                if (!qName.equals(object3) || set2 == null) continue;
                object2 = set2.iterator();
                while (object2.hasNext()) {
                    Token token = (Token)object2.next();
                    bl = token.getCallerChecked();
                    boolean bl3 = token.isTrusted();
                    object = token.getType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Token type in the TrustMethod [" + qName2 + "] and " + "Token type [" + object + "]."));
                        Tr.debug((TraceComponent)tc, (String)("TrustMethod checked [" + bl + "]."));
                        Tr.debug((TraceComponent)tc, (String)("Token trusted [" + bl3 + "]."));
                    }
                    if (bl || !bl3 || !qName2.equals(object)) continue;
                    AuthResult authResult = new AuthResult(token, (WSSConsumerConfig.CallerConfig)object4);
                    token.setCallerChecked(true);
                    ResultPool.add((Map)map, (Result)authResult);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + authResult + "] into the ResultPool."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Set cconfig,TokenConsumerConfig tconfig,Map context)");
        }
    }

    private static void checkCaller(Set set, TokenConsumerConfig tokenConsumerConfig, Token token, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCaller(Set cconfigs,TokenConsumerConfig tconfig,Token token,Map context)");
        }
        if (tokenConsumerConfig != null && set != null) {
            QName qName = tokenConsumerConfig.getType();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                boolean bl;
                QName qName2;
                Object object2;
                WSSConsumerConfig.CallerConfig callerConfig = (WSSConsumerConfig.CallerConfig)iterator.next();
                if (callerConfig.getPart() == null) {
                    object2 = callerConfig.getTokenType();
                    qName2 = callerConfig.getTokenConsumerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the Caller [" + qName2 + "], " + "TokenConsumer type [" + qName + "]."));
                    }
                    if (qName.equals(qName2)) {
                        boolean bl2 = token.getCallerChecked();
                        bl = token.isTrusted();
                        QName qName3 = token.getType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Token type in the Caller [" + object2 + "] and " + "Token type [" + qName3 + "]."));
                            Tr.debug((TraceComponent)tc, (String)("Caller checked [" + bl2 + "]."));
                            Tr.debug((TraceComponent)tc, (String)("Token trusted [" + bl + "]."));
                        }
                        if (!bl2 && !bl && ((QName)object2).equals(qName3)) {
                            object = new AuthResult(token, callerConfig);
                            token.setCallerChecked(true);
                            ResultPool.add((Map)map, (Result)object);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + object + "] into the ResultPool."));
                            }
                        }
                    }
                }
                if ((object2 = callerConfig.getTrustMethod()) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TrustMethod configuration found.");
                }
                if (object2.getPart() != null) continue;
                qName2 = object2.getTokenType();
                QName qName4 = object2.getTokenConsumerType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the TrustMethod [" + qName4 + "], " + "TokenConsumer type [" + qName + "]."));
                }
                if (!qName.equals(qName4)) continue;
                bl = token.getCallerChecked();
                boolean bl3 = token.isTrusted();
                object = token.getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token type in the TrustMethod [" + qName2 + "] and " + "Token type [" + object + "]."));
                    Tr.debug((TraceComponent)tc, (String)("TrustMethod checked [" + bl + "]."));
                    Tr.debug((TraceComponent)tc, (String)("Token trusted [" + bl3 + "]."));
                }
                if (bl || !bl3 || !qName2.equals(object)) continue;
                AuthResult authResult = new AuthResult(token, (WSSConsumerConfig.CallerConfig)object2);
                token.setCallerChecked(true);
                ResultPool.add((Map)map, (Result)authResult);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + authResult + "] into the ResultPool."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Set cconfig,TokenConsumerConfig tconfig,Token token,Map context)");
        }
    }

    private static void checkCaller(Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCaller(Map selectors,Map context)");
        }
        WSSConsumerComponent wSSConsumerComponent = (WSSConsumerComponent)map.get(LoginProcessor.class);
        wSSConsumerComponent.invoke(null, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Map selectors, Map context)");
        }
    }

    private static void cleanSubject(Map map) throws SoapSecurityException {
        Set set;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
        if ((set = TokenManager.getTokens(map)) != null && set.size() > 0) {
            String string;
            Object object;
            Object object2;
            int n;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            Result[] resultArray = ResultPool.get((Map)map, (Class)VerificationResult.class);
            if (resultArray != null) {
                for (n = 0; n < resultArray.length; ++n) {
                    object2 = (VerificationResult)resultArray[n];
                    object = ((VerificationResult)object2).getToken();
                    if (object == null) continue;
                    string = object.getUniqueID();
                    if (hashMap.containsKey(string)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("WARNING: The token that has the same unique id [" + string + "] exists."));
                        Tr.debug((TraceComponent)tc, (String)("The already stored token is [" + hashMap.get(string) + "] and this is keeped."));
                        Tr.debug((TraceComponent)tc, (String)("A newly found token is [" + object + "] and this is ignored."));
                        continue;
                    }
                    hashMap.put(string, object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("The token whose unique id is [" + string + "]: <<<" + object + ">>>."));
                }
            }
            if ((resultArray = ResultPool.get((Map)map, (Class)DecryptionResult.class)) != null) {
                for (n = 0; n < resultArray.length; ++n) {
                    object2 = (DecryptionResult)resultArray[n];
                    object = ((DecryptionResult)object2).getToken();
                    if (object == null) continue;
                    string = object.getUniqueID();
                    if (hashMap.containsKey(string)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("WARNING: The token that has the same unique id [" + string + "] exists."));
                        Tr.debug((TraceComponent)tc, (String)("The already stored token is [" + hashMap.get(string) + "] and this is keeped."));
                        Tr.debug((TraceComponent)tc, (String)("A newly found token is [" + object + "] and this is ignored."));
                        continue;
                    }
                    hashMap.put(string, object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("The token whose unique id is [" + string + "]: <<<" + object + ">>>."));
                }
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (Token)iterator.next();
                if (object2.getError() != null || hashMap.containsKey(object = object2.getUniqueID())) continue;
                hashMap.put(object, object2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("The token whose unique id is [" + (String)object + "]: <<<" + object2 + ">>>."));
            }
            TokenManager.removeAllTokens(map);
            if (hashMap.size() > 0) {
                TokenManager.setTokens(map, hashMap.values());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
    }

    private static void cleanContext(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE);
        map.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        map.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
    }

    private static void mapTokenToMessageContext(SOAPMessageContext sOAPMessageContext, Map map) {
        block23: {
            Token token;
            block26: {
                Object object;
                Result[] resultArray;
                block25: {
                    Object object2;
                    block24: {
                        boolean bl;
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"mapTokenToMessageContext(SOAPMessageContext messageContext,Map context)");
                        }
                        int n = 0;
                        Set set = TokenManager.getTokens(map);
                        if (set != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(set.size() + " tokens found."));
                            }
                            if (set.size() > 0) {
                                Hashtable<String, Token> hashtable = new Hashtable<String, Token>();
                                resultArray = set.iterator();
                                while (resultArray.hasNext()) {
                                    token = (Token)resultArray.next();
                                    object2 = token.getId();
                                    if (object2 == null) {
                                        object2 = IdUtil.getInstance().makeUniqueId(null, "Token_") + "_" + ++n;
                                    }
                                    hashtable.put((String)object2, token);
                                }
                                sOAPMessageContext.setProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TOKEN_PROPERGATION, hashtable);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"A table of tokens is copied to the property in the MessageContext.");
                                }
                            }
                        }
                        if (!(bl = WSSecurityPlatformContextFactory.getInstance().isServer())) break block23;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This is server process. So the runtime is storing a signer certificate...");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking verification results...");
                        }
                        if ((resultArray = ResultPool.get((Map)map, (Class)VerificationResult.class)) != null && resultArray.length != 0) break block24;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No signer X509 certificate was found in the request message.");
                        }
                        break block23;
                    }
                    token = null;
                    if (resultArray.length != 1) break block25;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Only one verification token found.");
                    }
                    if (!((object = ((VerificationResult)(object2 = (VerificationResult)resultArray[0])).getToken()) instanceof X509BSToken)) break block26;
                    token = (X509BSToken)object;
                    break block26;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"More than one verification tokens found.");
                }
                for (int i = 0; i < resultArray.length; ++i) {
                    object = (VerificationResult)resultArray[i];
                    Token token2 = ((VerificationResult)object).getToken();
                    if (!(token2 instanceof X509BSToken) || !token2.getUsedToLogin()) continue;
                    token = (X509BSToken)token2;
                    break;
                }
            }
            if (token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to specify the one of X509 certificates in the request message.");
                }
                sOAPMessageContext.removeProperty("com.ibm.xml.soapsec.RequestCert");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The X509 token that includes a signer certificate [" + token + "]."));
                }
                X509Certificate x509Certificate = null;
                try {
                    x509Certificate = ((X509BSToken)token).getCert();
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s32", (Object)new Object[]{soapSecurityException});
                }
                if (x509Certificate == null) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s33");
                    sOAPMessageContext.removeProperty("com.ibm.xml.soapsec.RequestCert");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Signer certificate is stored in the message context [" + x509Certificate + "]."));
                    }
                    sOAPMessageContext.setProperty("com.ibm.xml.soapsec.RequestCert", (Object)x509Certificate);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapTokenToMessageContext(SOAPMessageContext messageContext,Map context)");
        }
    }

    private static void copyContextSubjectToMessageContext(SOAPMessageContext sOAPMessageContext, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"copyContextSubjectToMessageContext(SOAPMessageContext messageContext, Map context)");
        }
        Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        sOAPMessageContext.setProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TOKEN_WSSSUBJECT, (Object)subject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyContextSubjectToMessageContext(SOAPMessageContext messageContext, Map context)");
        }
    }

    private static void lockResults(Map map, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("lockResults(Map context,boolean signature[" + bl + "]," + "boolean locked[" + bl2 + "])"));
        }
        if (bl) {
            Result[] resultArray = ResultPool.get((Map)map, (Class)VerificationResult.class);
            if (resultArray != null && resultArray.length > 0) {
                for (int i = 0; i < resultArray.length; ++i) {
                    VerificationResult verificationResult = (VerificationResult)resultArray[i];
                    verificationResult.setLocked(bl2);
                }
            }
        } else {
            Result[] resultArray = ResultPool.get((Map)map, (Class)DecryptionResult.class);
            if (resultArray != null && resultArray.length > 0) {
                for (int i = 0; i < resultArray.length; ++i) {
                    DecryptionResult decryptionResult = (DecryptionResult)resultArray[i];
                    decryptionResult.setLocked(bl2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockResults(Map context,boolean signature,boolean locked)");
        }
    }

    private static void removeKeyInfoResults(Map map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
        if ((resultArray = ResultPool.get((Map)map, (Class)KeyInfoResult.class)) != null && resultArray.length > 0) {
            ResultPool.remove((Map)map, (Result[])resultArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreResults(Map map, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("restoreResults(Map context,boolean signature[" + bl + "])"));
        }
        if (bl) {
            VerificationResult verificationResult;
            Result[] resultArray = ResultPool.get((Map)map, (Class)VerificationResult.class);
            if (resultArray != null && resultArray.length > 0 && !(verificationResult = (VerificationResult)resultArray[resultArray.length - 1]).getLocked()) {
                List list;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Restoring a verification result [" + verificationResult + "]..."));
                }
                if ((list = verificationResult.getVerifiedParts()) != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        VerificationResult.VerifiedPart verifiedPart = (VerificationResult.VerifiedPart)list.get(i);
                        if (verifiedPart.getNonce() == null && verifiedPart.getTimestamp() == null) continue;
                        if (verifiedPart.getNonceFirst()) {
                            verifiedPart.getParent().appendChild(verifiedPart.getNonce());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)verifiedPart.getParent()) + "]."));
                            }
                            if (verifiedPart.getNonce() == null) continue;
                            verifiedPart.getParent().appendChild(verifiedPart.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Timestmap is restored into the node[" + DOMUtil.getDisplayName((Node)verifiedPart.getParent()) + "]."));
                            continue;
                        }
                        verifiedPart.getParent().appendChild(verifiedPart.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Timestamp is restored into the node[" + DOMUtil.getDisplayName((Node)verifiedPart.getParent()) + "]."));
                        }
                        if (verifiedPart.getNonce() == null) continue;
                        verifiedPart.getParent().appendChild(verifiedPart.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)verifiedPart.getParent()) + "]."));
                    }
                }
                ResultPool.remove((Map)map, (Result)verificationResult);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Removed the verification result.");
                }
            }
        } else {
            DecryptionResult decryptionResult;
            Result[] resultArray = ResultPool.get((Map)map, (Class)DecryptionResult.class);
            if (resultArray != null && resultArray.length > 0 && !(decryptionResult = (DecryptionResult)resultArray[resultArray.length - 1]).getLocked()) {
                List list;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Restoring a decryption result [" + decryptionResult + "]..."));
                }
                if ((list = decryptionResult.getDecryptedParts()) != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        DecryptionResult.DecryptedPart decryptedPart = (DecryptionResult.DecryptedPart)list.get(i);
                        if (decryptedPart.getNonce() == null && decryptedPart.getTimestamp() == null) continue;
                        if (decryptedPart.getNonceFirst()) {
                            decryptedPart.getParent().appendChild(decryptedPart.getNonce());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)decryptedPart.getParent()) + "]."));
                            }
                            if (decryptedPart.getNonce() == null) continue;
                            decryptedPart.getParent().appendChild(decryptedPart.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Timestmap is restored into the node[" + DOMUtil.getDisplayName((Node)decryptedPart.getParent()) + "]."));
                            continue;
                        }
                        decryptedPart.getParent().appendChild(decryptedPart.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Timestamp is restored into the node[" + DOMUtil.getDisplayName((Node)decryptedPart.getParent()) + "]."));
                        }
                        if (decryptedPart.getNonce() == null) continue;
                        decryptedPart.getParent().appendChild(decryptedPart.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)decryptedPart.getParent()) + "]."));
                    }
                }
                ResultPool.remove((Map)map, (Result)decryptionResult);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Removed the decryption result.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreResults(Map context,boolean signature)");
        }
    }

    private static int getUsedFor(Element element, Element element2, String string, String string2) {
        int n;
        block10: {
            NodeList nodeList;
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("getUsedFor(Element envelope[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)element2) + "]," + "String nsWsse[" + string + "]," + "String id[" + string2 + "])"));
                }
                n = 0;
                if (string2 == null || string2.length() <= 0) break block10;
                string2 = "#" + string2;
                nodeList = element.getElementsByTagNameNS(string, "Reference");
                if (nodeList != null && nodeList.getLength() != 0) break block11;
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"No wsse:Reference element found.");
                break block10;
            }
            int n2 = nodeList.getLength();
            if (tc.isDebugEnabled()) {
                if (n2 == 1) {
                    Tr.debug((TraceComponent)tc, (String)(n2 + " wsse:Reference element found."));
                } else {
                    Tr.debug((TraceComponent)tc, (String)(n2 + " wsse:Reference elements found."));
                }
            }
            for (int i = 0; i < n2; ++i) {
                Node node;
                Element element3;
                Element element4 = (Element)nodeList.item(i);
                String string3 = element4.getAttribute("URI");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing URI [" + string3 + "]..."));
                }
                if (!string2.equals(string3) || !DOMUtil.equals((Node)(element3 = DOMUtil.getAncestorElement((Element)element4, (String)string, (String)"Security")), (Node)element2)) continue;
                Element element5 = DOMUtil.getAncestorElement((Element)element4, (String)Constants.NS_DSIG, (String)"KeyInfo");
                if (element5 == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"ds:KeyInfo is not found as an ancestor.");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ds:KeyInfo is found as an ancestor.");
                }
                if ((node = element5.getParentNode()) == null || node.getNodeType() != 1) continue;
                if (DOMUtil.equals((Node)node, (String)Constants.NS_DSIG, (String)"Signature")) {
                    n = 1;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"The token is used for signature verification.");
                    break;
                }
                if (!DOMUtil.equals((Node)node, (String)Constants.NS_ENC, (String)"EncryptedKey") && !DOMUtil.equals((Node)node, (String)Constants.NS_ENC, (String)"EncryptedData")) continue;
                n = 2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"The token is used for decryption.");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getUsedFor(Element envelope,Element security,String nsWsse,String id) returns int[" + n + "]"));
        }
        return n;
    }
}

