/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;

public final class KeyStore {
    private String _type = null;
    private String _path = null;
    private char[] _storepass = null;
    private String _keyStoreRef = null;
    java.security.KeyStore _jks = null;
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStore.class.getName();
    private static final TraceComponent tc = Tr.register(KeyStore.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public KeyStore(String string, String string2, char[] cArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStore(type, path, storepass):", new Object[]{string, string2, "XXXXXX"});
        }
        this._type = string;
        this._path = string2;
        this._storepass = cArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KeyStore()");
        }
    }

    public KeyStore(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStore(keyStoreRef):", new Object[]{string});
        }
        this._keyStoreRef = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KeyStore()");
        }
    }

    public synchronized java.security.KeyStore getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (this._jks == null) {
            try {
                if (tc.isDebugEnabled()) {
                    if (this._keyStoreRef != null && this._keyStoreRef.length() != 0) {
                        Tr.debug(tc, "Opening keystore and keyStoreRef is: " + this._keyStoreRef);
                    } else {
                        Tr.debug(tc, "Opening keystore " + this._path + " of type " + this._type);
                    }
                }
                this._jks = this._keyStoreRef != null && this._keyStoreRef.length() != 0 ? ConfigUtil.getKeyStore((String)this._keyStoreRef) : ConfigUtil.getKeyStore((String)this._type, (File)new File(this._path), (char[])this._storepass);
            }
            catch (SoapSecurityException soapSecurityException) {
                FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".getInstance", "58", this);
                if (this._keyStoreRef != null && this._keyStoreRef.length() != 0) {
                    Tr.error(tc, "getting KeyStore Instance failed", new Object[]{this._keyStoreRef, soapSecurityException});
                }
                Tr.error(tc, "security.wssecurity.load.trustanchor.failed", new Object[]{this._path, soapSecurityException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns " + this._jks);
        }
        return this._jks;
    }

    public void validate() throws SoapSecurityException {
        if (this._keyStoreRef == null) {
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s13", this.toString());
            }
            if (this._path == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s14", this.toString());
            }
            if (this._storepass == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s15", this.toString());
            }
        } else if (!ConfigUtil.isValidWSKeyStore((String)this._keyStoreRef)) {
            throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s18", this.toString());
        }
    }

    public String getKeyStoreRef() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreRef()");
        }
        Tr.exit(tc, "getKeyStoreRef() returns:" + this._keyStoreRef);
        return this._keyStoreRef;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
        stringBuffer.append("type=[").append(this._type).append("], ");
        stringBuffer.append("path=[").append(this._path).append("], ");
        stringBuffer.append("password=[XXXXXXXX]");
        stringBuffer.append("keyStoreRef=[").append(this._keyStoreRef).append("], ");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

