/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CollectionCertStore {
    private String _algorithm = null;
    private CollectionCertStoreParameters _params = null;
    private Set _certNames = null;
    private String _provider = null;
    private String _name = null;
    private CertStore _certStore = null;
    private static final String comp = "security.wssecurity";
    private static final String clsName = CollectionCertStore.class.getName();
    private static final TraceComponent tc = Tr.register(CollectionCertStore.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public CollectionCertStore(String string, CollectionCertStoreParameters collectionCertStoreParameters, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CollectionCertStore(algorithm, params, provider, name):", new Object[]{string, collectionCertStoreParameters, string2, string3});
        }
        this._algorithm = string;
        this._params = collectionCertStoreParameters;
        this._provider = string2;
        this._name = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CollectionCertStore()");
        }
    }

    public CollectionCertStore(String string, Set set, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CollectionCertStore(algorithm, certNames, provider, name):", new Object[]{string, set, string2, string3});
        }
        this._algorithm = string;
        this._certNames = set;
        this._provider = string2;
        this._name = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CollectionCertStore()");
        }
    }

    public synchronized CertStore getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (this._certStore == null) {
            HashSet<X509Extension> hashSet = new HashSet<X509Extension>();
            if (this._params == null && this._certNames != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing CollectionCertStoreParameters");
                }
                try {
                    CertificateFactory certificateFactory = ConfigUtil.createCertificateFactory((String)"");
                    X509Certificate x509Certificate = null;
                    X509CRL x509CRL = null;
                    Iterator iterator = this._certNames.iterator();
                    while (iterator.hasNext()) {
                        block20: {
                            String string = (String)iterator.next();
                            x509Certificate = null;
                            x509CRL = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating certificate or CRL: " + string);
                            }
                            try {
                                x509Certificate = ConfigUtil.getX509Certificate((File)new File(string), (CertificateFactory)certificateFactory);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Created certificate: " + string);
                                }
                            }
                            catch (Exception exception) {
                                x509CRL = ConfigUtil.getX509CRL((File)new File(string), (CertificateFactory)certificateFactory);
                                if (!tc.isDebugEnabled()) break block20;
                                Tr.debug(tc, "Created CRL: " + string);
                            }
                        }
                        if (x509CRL != null) {
                            hashSet.add(x509CRL);
                            continue;
                        }
                        hashSet.add(x509Certificate);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating CollectionCertStoreParameters");
                    }
                    this._params = new CollectionCertStoreParameters(hashSet);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, clsName + ".getInstance", "120", this);
                    Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{this._name, exception});
                }
                this._certNames = null;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Opening CollectionCertStore \"" + this._name + "\" with algorithm \"" + this._algorithm + "\" and provider \"" + this._provider + "\"");
                }
                this._certStore = this._provider == null || "".equals(this._provider) ? CertStore.getInstance(this._algorithm, this._params) : CertStore.getInstance(this._algorithm, (CertStoreParameters)this._params, this._provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, clsName + ".getInstance", "134", this);
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s20", new Object[]{this._algorithm});
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                FFDCFilter.processException((Throwable)invalidAlgorithmParameterException, clsName + ".getInstance", "137", this);
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s21", new Object[]{this._params == null || this._params.toString() == null ? "" : this._params.toString()});
            }
            catch (NoSuchProviderException noSuchProviderException) {
                FFDCFilter.processException((Throwable)noSuchProviderException, clsName + ".getInstance", "140", this);
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s22", new Object[]{this._provider});
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, clsName + ".getInstance", "143", this);
                Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{this._name == null ? "" : this._name, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns " + this._certStore);
        }
        return this._certStore;
    }
}

