/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.toJava.XMLClientWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLMappingWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.client.ClientFactory;
import org.eclipse.jst.j2ee.client.ClientPackage;
import org.eclipse.jst.j2ee.client.internal.impl.ApplicationClientResourceFactory;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebAppResourceFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientPackage;
import org.eclipse.jst.j2ee.webservice.wsclient.internal.impl.WebServicesClientResourceFactory;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;

public class XMLWebServicesClientWriter
extends XMLClientWriter {
    private static final boolean DOJ2EE14 = true;
    private static final String EJBDD = "ejb-jar.xml";
    private static final String WEBDD = "web.xml";
    private static final String APPDD = "application-client.xml";
    private static final String WSCDD = "webservicesclient.xml";
    private String fileName = "";
    private String wsdlFile = "";
    private String mappingFile = "";
    private Webservice_clientPackage WCpkg = null;
    private Webservice_clientFactory WCfactory = null;
    private CommonFactory commonFactory = CommonFactory.eINSTANCE;

    public XMLWebServicesClientWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, definition, symbolTable);
    }

    protected String getFileName() {
        if (this.fileName.equals("")) {
            String string = this.emitter.getContainer() == Container.EJB ? EJBDD : (this.emitter.getContainer() == Container.WEB ? WEBDD : APPDD);
            this.fileName = this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + string;
        }
        return this.fileName;
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        String string = Utils.getName(this.INFdir) + '/';
        this.wsdlFile = string + "wsdl/" + Utils.getWSDLName(this.emitter.getWSDLURI());
        this.emitter.getToolEnv().mkdir(this.INFdir);
        this.emitter.getToolEnv().mkdir(this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + "wsdl");
        XMLMappingWriter xMLMappingWriter = new XMLMappingWriter(this.emitter, this.definition, this.symbolTable);
        this.mappingFile = string + Utils.getName(xMLMappingWriter.getFileName());
        if (this.emitter.getContainer() == Container.EJB) {
            this.writeEjbJar();
        } else if (this.emitter.getContainer() == Container.WEB) {
            this.writeWebApp();
        } else {
            this.writeApplicationClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWebApp() throws IOException {
        Object object;
        ConfigInit.init();
        String string = "webapplication.xmi";
        WebapplicationPackage webapplicationPackage = (WebapplicationPackage)EPackage.Registry.INSTANCE.getEPackage(string);
        WebapplicationFactory webapplicationFactory = webapplicationPackage.getWebapplicationFactory();
        URI uRI = URI.createURI(this.getFileName());
        WebAppResourceFactory webAppResourceFactory = new WebAppResourceFactory(EMF2DOMRendererFactory.INSTANCE);
        WebAppResource webAppResource = null;
        WebApp webApp = null;
        if (this.emitter.getToolEnv().fileExists(this.getFileName())) {
            webAppResource = (WebAppResource)new WebAppResourceFactory(EMF2DOMRendererFactory.INSTANCE).createResource(uRI);
            webApp = webapplicationFactory.createWebApp();
            object = null;
            try {
                object = this.emitter.getToolEnv().getInputStream(this.getFileName());
                webAppResource.load((InputStream)object, new HashMap());
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            webApp = webAppResource.getWebApp();
            if (this.non14XmlExistsMessage(webAppResource.getVersionID())) {
                webApp = null;
            }
        }
        if (webApp == null) {
            webAppResource = (WebAppResource)new WebAppResourceFactory(EMF2DOMRendererFactory.INSTANCE).createResource(uRI);
            webAppResource.setVersionID(14);
            webApp = webapplicationFactory.createWebApp();
            this.oldXmlExistsMessage();
        }
        object = this.symbolTable.getServices();
        Iterator iterator = object.values().iterator();
        while (iterator.hasNext()) {
            String string2;
            Service service = (Service)iterator.next();
            ServiceEntry serviceEntry = this.symbolTable.getServiceEntry(service.getQName());
            if (!serviceEntry.isReferenced() || !this.serviceRefNotExists(string2 = "service/" + service.getQName().getLocalPart(), webApp.getServiceRefs())) continue;
            webApp.getServiceRefs().add(this.createServiceRef(service));
        }
        webAppResource.getContents().add(webApp);
        this.writeModelToFile(webAppResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeApplicationClient() throws IOException {
        Object object;
        ConfigInit.init();
        String string = "client.xmi";
        ClientPackage clientPackage = (ClientPackage)EPackage.Registry.INSTANCE.getEPackage(string);
        ClientFactory clientFactory = clientPackage.getClientFactory();
        URI uRI = URI.createURI(this.getFileName());
        ApplicationClientResourceFactory applicationClientResourceFactory = new ApplicationClientResourceFactory(EMF2DOMRendererFactory.INSTANCE);
        ApplicationClientResource applicationClientResource = null;
        ApplicationClient applicationClient = null;
        if (this.emitter.getToolEnv().fileExists(this.getFileName())) {
            applicationClientResource = (ApplicationClientResource)new ApplicationClientResourceFactory(EMF2DOMRendererFactory.INSTANCE).createResource(uRI);
            applicationClient = clientFactory.createApplicationClient();
            object = null;
            try {
                object = this.emitter.getToolEnv().getInputStream(this.getFileName());
                applicationClientResource.load((InputStream)object, new HashMap());
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            applicationClient = applicationClientResource.getApplicationClient();
            if (this.non14XmlExistsMessage(applicationClientResource.getVersionID())) {
                applicationClient = null;
            }
        }
        if (applicationClient == null) {
            applicationClientResource = (ApplicationClientResource)new ApplicationClientResourceFactory(EMF2DOMRendererFactory.INSTANCE).createResource(uRI);
            applicationClientResource.setVersionID(14);
            applicationClient = clientFactory.createApplicationClient();
            this.oldXmlExistsMessage();
        }
        object = this.symbolTable.getServices();
        Iterator iterator = object.values().iterator();
        while (iterator.hasNext()) {
            String string2;
            Service service = (Service)iterator.next();
            ServiceEntry serviceEntry = this.symbolTable.getServiceEntry(service.getQName());
            if (!serviceEntry.isReferenced() || !this.serviceRefNotExists(string2 = "service/" + service.getQName().getLocalPart(), applicationClient.getServiceRefs())) continue;
            applicationClient.getServiceRefs().add(this.createServiceRef(service));
        }
        applicationClientResource.getContents().add(applicationClient);
        this.writeModelToFile(applicationClientResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEjbJar() throws IOException {
        Object object;
        ConfigInit.init();
        String string = "ejb.xmi";
        EjbPackage ejbPackage = (EjbPackage)EPackage.Registry.INSTANCE.getEPackage(string);
        EjbFactory ejbFactory = ejbPackage.getEjbFactory();
        URI uRI = URI.createURI(this.getFileName());
        EJBJarResourceFactory eJBJarResourceFactory = new EJBJarResourceFactory(EMF2DOMRendererFactory.INSTANCE);
        EJBResource eJBResource = null;
        EJBJar eJBJar = null;
        if (this.emitter.getToolEnv().fileExists(this.getFileName())) {
            eJBResource = (EJBResource)new EJBJarResourceFactory(EMF2DOMRendererFactory.INSTANCE).createResource(uRI);
            eJBJar = ejbFactory.createEJBJar();
            object = null;
            try {
                object = this.emitter.getToolEnv().getInputStream(this.getFileName());
                eJBResource.load((InputStream)object, new HashMap());
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            eJBJar = eJBResource.getEJBJar();
            if (this.non14XmlExistsMessage(eJBResource.getVersionID())) {
                eJBJar = null;
            }
        }
        if (eJBJar == null) {
            eJBResource = (EJBResource)new EJBJarResourceFactory(EMF2DOMRendererFactory.INSTANCE).createResource(uRI);
            eJBResource.setVersionID(14);
            eJBJar = ejbFactory.createEJBJar();
            this.oldXmlExistsMessage();
            object = ejbFactory.createSession();
            object.setName("___SET_THIS_TO_ejb-name___");
            object.setEjbClass(this.emitter.getToolEnv().getClassFactory().createClassRef("...SET.THIS.TO.ejb.classname..."));
            object.setSessionType(SessionType.get(1));
            object.setTransactionType(TransactionType.get(1));
            eJBJar.getEnterpriseBeans().add(object);
        }
        object = eJBJar.getEnterpriseBeans().iterator();
        while (object.hasNext()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)object.next();
            if (!(enterpriseBean instanceof Session)) continue;
            Map map = this.symbolTable.getServices();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                String string2;
                Service service = (Service)iterator.next();
                ServiceEntry serviceEntry = this.symbolTable.getServiceEntry(service.getQName());
                if (!serviceEntry.isReferenced() || !this.serviceRefNotExists(string2 = "service/" + service.getQName().getLocalPart(), enterpriseBean.getServiceRefs())) continue;
                enterpriseBean.getServiceRefs().add(this.createServiceRef(service));
            }
        }
        eJBResource.getContents().add(eJBJar);
        this.writeModelToFile(eJBResource);
    }

    protected void writeWebservicesClient() throws IOException {
        J2EEInit.init();
        URI uRI = URI.createURI(this.getFileName());
        Webservice_clientPackage webservice_clientPackage = (Webservice_clientPackage)EPackage.Registry.INSTANCE.getEPackage("webservice_client.xmi");
        Webservice_clientFactory webservice_clientFactory = webservice_clientPackage.getWebservice_clientFactory();
        WebServicesClientResourceFactory webServicesClientResourceFactory = new WebServicesClientResourceFactory(EMF2DOMRendererFactory.INSTANCE);
        WebServicesResource webServicesResource = (WebServicesResource)webServicesClientResourceFactory.createResource(uRI);
        J2EEResourceFactoryRegistry.INSTANCE.registerLastFileSegment(uRI.lastSegment(), webServicesClientResourceFactory);
        WebServicesClient webServicesClient = webservice_clientFactory.createWebServicesClient();
        ComponentScopedRefs componentScopedRefs = null;
        if ((this.emitter.getRole() == Role.CLIENT || this.emitter.getRole() == Role.DEVELOP_CLIENT) && this.emitter.getContainer() == Container.EJB) {
            componentScopedRefs = webservice_clientFactory.createComponentScopedRefs();
            webServicesClient.getComponentScopedRefs().add(componentScopedRefs);
            componentScopedRefs.setComponentName("??SET THIS TO component name link??");
        }
        Map map = this.symbolTable.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            ServiceEntry serviceEntry = this.symbolTable.getServiceEntry(service.getQName());
            if (!serviceEntry.isReferenced()) continue;
            if (componentScopedRefs == null) {
                webServicesClient.getServiceRefs().add(this.createServiceRef(service));
                continue;
            }
            componentScopedRefs.getServiceRefs().add(this.createServiceRef(service));
        }
        webServicesResource.getContents().add(webServicesClient);
        this.writeModelToFile(webServicesResource);
    }

    private boolean serviceRefNotExists(String string, EList eList) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServiceRef serviceRef = (ServiceRef)iterator.next();
            if (!serviceRef.getServiceRefName().equals(string)) continue;
            return false;
        }
        return true;
    }

    private ServiceRef createServiceRef(Service service) {
        if (this.WCfactory == null) {
            this.WCpkg = (Webservice_clientPackage)EPackage.Registry.INSTANCE.getEPackage("webservice_client.xmi");
            this.WCfactory = this.WCpkg.getWebservice_clientFactory();
        }
        ServiceEntry serviceEntry = this.symbolTable.getServiceEntry(service.getQName());
        String string = service.getQName().getLocalPart();
        String string2 = service.getQName().getNamespaceURI();
        ServiceRef serviceRef = this.WCfactory.createServiceRef();
        Description description = this.commonFactory.createDescription();
        description.setValue("WSDL Service " + string);
        serviceRef.getDescriptions().add(description);
        serviceRef.setServiceRefName("service/" + string);
        serviceRef.setServiceInterface(this.emitter.getToolEnv().getClassFactory().createClassRef(serviceEntry.getName()));
        serviceRef.setServiceRefName("service/" + string);
        serviceRef.setWsdlFile(this.wsdlFile);
        serviceRef.setJaxrpcMappingFile(this.mappingFile);
        QName qName = this.commonFactory.createQName();
        qName.setValues("pfx", string2, string);
        serviceRef.setServiceQname(qName);
        Iterator iterator = service.getPorts().values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port.getBinding().getQName());
            String string3 = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            if (string3 == null) continue;
            PortComponentRef portComponentRef = this.WCfactory.createPortComponentRef();
            portComponentRef.setServiceEndpointInterface(this.emitter.getToolEnv().getClassFactory().createClassRef(string3));
            serviceRef.getPortComponentRefs().add(portComponentRef);
        }
        return serviceRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeModelToFile(XMLResource xMLResource) throws IOException {
        HashMap hashMap = new HashMap();
        OutputStream outputStream = null;
        try {
            outputStream = this.emitter.getToolEnv().getOutputStream(this.getFileName());
            if (outputStream != null) {
                xMLResource.save(outputStream, hashMap);
            } else {
                this.emitter.getToolEnv().report(Messages.getMessage("FileWriteDenied", this.getFileName()));
            }
        }
        catch (IOException iOException) {
            this.emitter.getToolEnv().reportFatalErr(iOException.toString());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void oldXmlExistsMessage() {
        if (this.emitter.getToolEnv().fileExists(this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + WSCDD)) {
            this.emitter.getToolEnv().reporterr(Messages.getMessage("J2EEVersionWSCWarning", WSCDD));
        }
    }

    private boolean non14XmlExistsMessage(int n) {
        if (n != 14) {
            this.emitter.getToolEnv().reporterr(Messages.getMessage("J2EEVersionDDWarning"));
            return true;
        }
        return false;
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        return null;
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
    }

    protected void closePrintWriter(PrintWriter printWriter) {
    }
}

