/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Scenario;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaImplWriter
extends JavaClassWriter {
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, (String)symbolTable.getPortTypeEntry(bindingEntry.getBinding().getPortType().getQName()).getDynamicVar(JavaGeneratorFactory.IMPL_NAME), "templateImpl");
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bindingEntry;
    }

    public void generate() throws IOException {
        if (this.emitter.getScenario() == Scenario.WRD_BOTTOM_UP_SERVER) {
            return;
        }
        if (!this.isFileGenerated(this.getFileName())) {
            super.generate();
        }
    }

    protected void writeHeaderComments(PrintWriter printWriter) throws IOException {
        super.writeHeaderComments(printWriter);
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            Binding binding = this.bEntry.getBinding();
            Definition definition = this.emitter.getCurrentDefinition();
            printWriter.println("/**");
            printWriter.print(" * @WebSphere.WebService wsdlLocation=\"" + this.emitter.getWSDLURI() + "\"");
            printWriter.print(" targetNamespace=\"" + definition.getTargetNamespace() + "\"");
            printWriter.print(" name=\"" + binding.getPortType().getQName().getLocalPart() + "\"");
            Map map = this.symbolTable.getServices();
            boolean bl = false;
            Iterator iterator = map.values().iterator();
            block0: while (iterator.hasNext() && !bl) {
                Serializable serializable;
                Service service = (Service)iterator.next();
                Map map2 = service.getPorts();
                Iterator iterator2 = map2.values().iterator();
                while (iterator2.hasNext()) {
                    serializable = (Port)iterator2.next();
                    if (serializable.getBinding() != binding) continue;
                    printWriter.println(" serviceName=\"" + service.getQName().getLocalPart() + "\"");
                    bl = true;
                    break;
                }
                if (!bl) continue;
                boolean bl2 = false;
                serializable = binding.getPortType();
                Iterator iterator3 = map2.values().iterator();
                while (iterator3.hasNext()) {
                    Port port = (Port)iterator3.next();
                    if (port.getBinding().getPortType() == serializable) {
                        bl2 = this.writeBindingAnnotation(printWriter, port);
                    }
                    if (!bl2) continue;
                    continue block0;
                }
            }
            if (this instanceof JavaEJBImplWriter) {
                printWriter.print(" * @ejb.bean name=\"");
                printWriter.print(binding.getPortType().getQName().getLocalPart());
                printWriter.print('\"');
                printWriter.println(" type=StateLess");
            }
            printWriter.println(" */");
            printWriter.println();
        }
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = this.bEntry.getOperation(operation);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                printWriter.println();
                continue;
            }
            this.writeOperation(printWriter, bindingOperationEntry);
        }
    }

    protected String getImplementsText() {
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            return "";
        }
        String string = (String)this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        String string2 = "implements " + string;
        return string2;
    }

    protected void writeOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) throws IOException {
        Object object;
        Object object2;
        String string = (String)bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            printWriter.println("    /**");
            printWriter.println("     * @WebSphere.WebMethod");
            printWriter.println("     */");
            String string2 = " throws java.rmi.RemoteException";
            if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - string2.length());
            } else {
                int n;
                object2 = "throws ";
                object = "java.rmi.RemoteException, ";
                int n2 = string.lastIndexOf((String)object2);
                if (n2 != -1 && (n = string.lastIndexOf((String)object)) > n2) {
                    string = string.substring(0, n2 += ((String)object2).length()) + string.substring(n += ((String)object).length());
                }
            }
        }
        printWriter.println(string + " {");
        for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
            object2 = bindingOperationEntry.getParameter(i);
            if (((BindingParamEntry)object2).getMode() != 2) continue;
            object = new BooleanHolder(false);
            String string3 = Utils.getConstructorForParam((BindingParamEntry)object2, this.symbolTable, (BooleanHolder)object);
            if (((BooleanHolder)object).value) {
                printWriter.println("        try {");
            }
            printWriter.println("        " + ((Entry)object2).getName() + ".value = " + string3 + ";");
            if (!((BooleanHolder)object).value) continue;
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("        }");
        }
        if (bindingOperationEntry.getReturn() != null) {
            printWriter.print("        return ");
            if (bindingOperationEntry.getReturn().getMIMEType() != null) {
                printWriter.println("null;");
            } else {
                String string4 = (String)bindingOperationEntry.getReturn().getDynamicVar("parameterType");
                if (Utils.isPrimitiveType(string4)) {
                    if ("boolean".equals(string4)) {
                        printWriter.println("false;");
                    } else if ("byte".equals(string4)) {
                        printWriter.println("(byte)-3;");
                    } else if ("short".equals(string4)) {
                        printWriter.println("(short)-3;");
                    } else {
                        printWriter.println("-3;");
                    }
                } else {
                    printWriter.println("null;");
                }
            }
        }
        printWriter.println("    }");
        printWriter.println();
    }

    protected boolean writeBindingAnnotation(PrintWriter printWriter, Port port) {
        Binding binding = port.getBinding();
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
        int n = bindingEntry.getBindingType();
        if (n == 0) {
            String string = binding.getQName().getLocalPart();
            printWriter.print(" * @WebSphere.SOAPBinding");
            printWriter.print(" bindingName=\"" + string + "\"");
            if (port != null) {
                printWriter.print(" portName=\"" + port.getName() + "\"");
            }
            BindingOperationEntry bindingOperationEntry = this.findRepresentativeOperation(bindingEntry);
            printWriter.print(" style=");
            if (bindingEntry.getBindingStyle() == Style.DOCUMENT) {
                printWriter.print("DOCUMENT");
                if (bindingOperationEntry != null && !bindingOperationEntry.isWrapped()) {
                    printWriter.print(" parameterStyle=BARE");
                }
            } else {
                printWriter.print("RPC");
                if (bindingOperationEntry != null) {
                    printWriter.print(" use=");
                    if (bindingOperationEntry.getInputBodyUse() == Use.ENCODED) {
                        printWriter.print("ENCODED");
                    } else {
                        printWriter.print("LITERAL");
                    }
                }
            }
            printWriter.println();
            return true;
        }
        return false;
    }

    protected BindingOperationEntry findRepresentativeOperation(BindingEntry bindingEntry) {
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
            if (operationType != OperationType.REQUEST_RESPONSE && operationType != OperationType.ONE_WAY) continue;
            return bindingOperationEntry;
        }
        return null;
    }
}

