/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.fromJava.BeanPropertyDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class TypeEntryIntrospector {
    protected static Log log = LogFactory.getLog(TypeEntryIntrospector.class.getName());
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;
    private String INTROSPECT2 = "processedByIntrospect2";

    TypeEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(TypeEntry typeEntry) {
        if (typeEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        JavaHelpers javaHelpers = this.findType(typeEntry);
    }

    void introspect2(TypeEntry typeEntry) {
        boolean bl;
        Type type;
        if ((Boolean)typeEntry.getDynamicVar(this.INTROSPECT2) == Boolean.TRUE) {
            return;
        }
        typeEntry.setDynamicVar(this.INTROSPECT2, Boolean.TRUE);
        if (typeEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        JavaHelpers javaHelpers = this.findType(typeEntry);
        if (javaHelpers == null) {
            return;
        }
        if (!TypeEntryIntrospector.compatibleBeanTest(javaHelpers)) {
            return;
        }
        if (!(typeEntry instanceof Type)) {
            return;
        }
        JavaClass javaClass = (JavaClass)javaHelpers;
        Type type2 = ((Type)typeEntry).getExtensionBase();
        if (type2 != null) {
            this.introspect2(type2);
        }
        if ((type = ((Type)typeEntry).getRestrictionBase()) != null) {
            this.introspect2(type);
        }
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectClass00", typeEntry.getQName().toString(), javaClass.infoString()));
        }
        Type type3 = (Type)typeEntry;
        List list = BeanUtils.getPd(javaClass, this.emitter.getToolEnv());
        Boolean bl2 = (Boolean)type3.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        boolean bl3 = bl = bl2 != null ? bl2 : false;
        if (type3.isEnumeration()) {
            this.processEnumChildren(type3, javaClass);
            this.validateEnumeration(javaClass);
        } else {
            this.processChildren(type3, list, bl);
            if (bl) {
                this.validateException(type3, (JavaClass)javaHelpers);
            } else {
                this.validateBean(type3, javaHelpers);
            }
        }
    }

    JavaHelpers findType(TypeEntry typeEntry) {
        return TypeEntryIntrospector.locateClass(typeEntry, this.emitter, this.classFactory);
    }

    private void processChildren(Type type, List list, boolean bl) {
        if (type.getChildren() != null) {
            for (int i = 0; i < type.getChildren().size(); ++i) {
                ChildEntry childEntry = (ChildEntry)type.getChildren().get(i);
                TypeEntryIntrospector.processChild(type, childEntry, list, bl, this.emitter, this.symbolTable, this.classFactory);
            }
        }
    }

    static void processChild(Entry entry, ChildEntry childEntry, List list, boolean bl, Emitter emitter, SymbolTable symbolTable, ClassFactory classFactory) {
        Object object;
        int n;
        Object object2 = null;
        String string = childEntry.getName();
        for (n = 0; list != null && n < list.size() && object2 == null; ++n) {
            object = (BeanPropertyDescriptor)list.get(n);
            if (!((BeanPropertyDescriptor)object).getName().equals(string)) continue;
            object2 = object;
        }
        if (object2 == null) {
            string = childEntry.getQName().getLocalPart();
            for (n = 0; list != null && n < list.size() && object2 == null; ++n) {
                object = (BeanPropertyDescriptor)list.get(n);
                if (!((BeanPropertyDescriptor)object).getName().equals(string)) continue;
                object2 = object;
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, childEntry, string, false);
            }
        }
        if (object2 == null && "_value".equals(childEntry.getName()) && entry instanceof Type && ((Type)entry).isSimpleContent() && ((Type)entry).getExtensionBase() != null) {
            string = "value";
            for (n = 0; list != null && n < list.size() && object2 == null; ++n) {
                object = (BeanPropertyDescriptor)list.get(n);
                if (!((BeanPropertyDescriptor)object).getName().equals(string)) continue;
                object2 = object;
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, childEntry, string, false);
            }
        }
        if (object2 == null) {
            emitter.getToolEnv().reportFatalErr(Messages.getMessage(bl ? "noFaultProperty00" : "noBeanProperty00", entry.getName(), childEntry.getName()));
            return;
        }
        if (((BeanPropertyDescriptor)object2).isField()) {
            childEntry.setDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER, Boolean.TRUE);
        } else {
            childEntry.setDynamicVar(JavaGeneratorFactory.GET_METHOD_NAME, ((BeanPropertyDescriptor)object2).getReadMethodName());
            childEntry.setDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME, ((BeanPropertyDescriptor)object2).getWriteMethodName());
            if (!bl && ((BeanPropertyDescriptor)object2).getWriteMethodName() == null) {
                String string2 = Messages.getMessage("noSetterMethod00", entry.getName(), childEntry.getName(), ((BeanPropertyDescriptor)object2).getReadMethodName());
                childEntry.setDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME, Boolean.TRUE);
                Object object3 = object = symbolTable.getMetaInfo() == null ? null : (String)symbolTable.getMetaInfo().getProperty("MMDVersion");
                if ("1.0".equals(object)) {
                    emitter.getToolEnv().reportWarning(string2);
                } else {
                    emitter.getToolEnv().reportFatalErr(string2);
                }
            }
        }
        if (((BeanPropertyDescriptor)object2).hasCheckedException()) {
            entry.setDynamicVar("throwsCheckedException", Boolean.TRUE);
        }
        JavaGeneratorFactory.defaultChildJavaType(childEntry);
        String string3 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
        object = childEntry.getType();
        while (!(object instanceof Type) && !((TypeEntry)object).isCollectionTypeEntry()) {
            object = ((TypeEntry)object).getRefType();
        }
        BooleanHolder booleanHolder = new BooleanHolder();
        if (((BeanPropertyDescriptor)object2).getRawType() != null) {
            String string4 = TypeEntryIntrospector.compatibleTypeTest(((BeanPropertyDescriptor)object2).getRawType(), string3, (TypeEntry)object, emitter.getFactory().getBaseTypeMapping().getTypeMapping(), classFactory, symbolTable, emitter, false, true, booleanHolder);
            if (string4 == null) {
                emitter.getToolEnv().reportFatalErr(Messages.getMessage(bl ? "invalidFault02" : "incompatibleTypes02", entry.getName(), ((BeanPropertyDescriptor)object2).getRawType().getJavaName(), string3));
            } else if (!string4.equals(string3)) {
                childEntry.setDynamicVar(JavaGeneratorFactory.JAVA_TYPE, string4);
                if (booleanHolder.value) {
                    emitter.getToolEnv().reportWarning(Messages.getMessage(bl ? "invalidFault02" : "incompatibleTypes02", entry.getName(), ((BeanPropertyDescriptor)object2).getRawType().getJavaName(), string3));
                }
            }
        }
    }

    private void validateBean(Type type, JavaHelpers javaHelpers) {
        Object object;
        this.extensionCheck(type, javaHelpers);
        JavaClass javaClass = (JavaClass)this.classFactory.forName("java.lang.Throwable");
        if (javaClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        boolean bl = false;
        Method method2 = this.getPublicNoArgConstructor((JavaClass)javaHelpers);
        boolean bl2 = bl = method2 != null;
        if (!bl && !((JavaClass)javaHelpers).isInterface()) {
            bl = this.hasImplicitDefaultConstructor((JavaClass)javaHelpers);
        }
        if (bl && method2 != null && method2.getJavaExceptions() != null && method2.getJavaExceptions().size() > 0) {
            type.setDynamicVar("throwsCheckedException", Boolean.TRUE);
        }
        if (!bl) {
            object = this.classFactory.forName("com.ibm.ws.webservices.engine.encoding.SimpleType");
            boolean bl3 = bl = type.isSimpleTypeOrSimpleContent() && object.isAssignableFrom(javaHelpers);
        }
        if (!bl && !type.isAbstract()) {
            object = javaHelpers.getJavaName().substring(javaHelpers.getJavaName().lastIndexOf(46) + 1);
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidBean00", javaHelpers.getJavaName(), (String)object));
        }
    }

    private void validateException(Type type, JavaClass javaClass) {
        this.extensionCheck(type, javaClass);
        JavaClass javaClass2 = (JavaClass)this.classFactory.forName("java.lang.Throwable");
        if (javaClass2 == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        if (!javaClass2.isAssignableFrom(javaClass)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault00", javaClass.getJavaName(), "java.lang.Throwable"));
        }
        List list = (List)type.getDynamicVar("constructorOrder");
        List list2 = this.getChildEntryList(type);
        list2 = this.sort(list2, list, true);
        boolean bl = this.isNoArgJAXRPCException(javaClass, list2);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            bl2 = this.isNormalJAXRPCException(javaClass, list2, list);
            bl3 = this.isNoArgException(javaClass, list2);
            bl4 = this.isMessageArgException(javaClass, list2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            arrayList.add("JAXRPC-Normal");
        }
        if (bl) {
            arrayList.add("JAXRPC-NoArg");
        }
        if (bl3) {
            arrayList.add("Non-JAXRPC-NoArg");
        }
        if (bl4) {
            arrayList.add("Non-JAXRPC-MessageArg");
        }
        type.setDynamicVar("ExceptionInitStyles", arrayList);
        if (!bl && !bl2) {
            if (bl3 || bl4) {
                if (this.emitter.isDebug() || this.emitter.isVerbose()) {
                    String string = "User Exception " + javaClass.getJavaName() + " does not have a JAX-RPC compliant constructor. " + "An alternative instantiation will be used.";
                    this.symbolTable.getToolEnv().report(string);
                }
            } else {
                String string = javaClass.getJavaName().substring(javaClass.getJavaName().lastIndexOf(46) + 1);
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault01", javaClass.getJavaName(), string, String.valueOf(list.size())));
            }
        }
    }

    private boolean isNoArgJAXRPCException(JavaClass javaClass, List list) {
        if (list.size() != 0) {
            return false;
        }
        return this.getPublicNoArgConstructor(javaClass) != null || this.hasImplicitDefaultConstructor(javaClass);
    }

    private boolean isNormalJAXRPCException(JavaClass javaClass, List arrayList, List list) {
        if (arrayList.size() == 0) {
            return false;
        }
        List list2 = this.getPublicConstructorMethods(javaClass, arrayList.size());
        if (list2.size() == 0) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            List list3;
            Method method2 = (Method)list2.get(i);
            List list4 = this.getParamNames(javaClass, method2);
            if (this.match(arrayList, list4, false)) {
                list3 = new ArrayList(arrayList);
                list3 = this.sort(list3, list4, false);
            } else {
                list3 = arrayList;
            }
            if (!this.isCompatibleConstructor(method2, list3)) continue;
            if (list3 != arrayList) {
                list.clear();
                for (int j = 0; j < list3.size(); ++j) {
                    ChildEntry childEntry = (ChildEntry)list3.get(j);
                    list.add(childEntry.getQName().getLocalPart());
                }
            }
            return true;
        }
        return false;
    }

    private boolean isNoArgException(JavaClass javaClass, List list) {
        if (this.getPublicNoArgConstructor(javaClass) == null && !this.hasImplicitDefaultConstructor(javaClass)) {
            return false;
        }
        return this.areAllWriteable(list, false);
    }

    private boolean isMessageArgException(JavaClass javaClass, List list) {
        if (this.getPublicStringArgConstructor(javaClass) == null) {
            return false;
        }
        return this.areAllWriteable(list, true);
    }

    private List getChildEntryList(Type type) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Type type2 = type;
        while (type2 != null) {
            arrayList.add(type2);
            if (type2.getExtensionBase() != null) {
                type2 = type2.getExtensionBase();
                continue;
            }
            type2 = type2.getRestrictionBase();
        }
        ArrayList<ChildAttribute> arrayList2 = new ArrayList<ChildAttribute>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ChildEntry childEntry;
            int n;
            Type type3 = (Type)arrayList.get(i);
            Vector vector = type3.getChildren();
            if (vector == null) continue;
            for (n = 0; n < vector.size(); ++n) {
                if (!(vector.get(n) instanceof ChildAttribute)) continue;
                childEntry = (ChildAttribute)vector.get(n);
                arrayList2.add((ChildAttribute)childEntry);
            }
            for (n = 0; n < vector.size(); ++n) {
                if (!(vector.get(n) instanceof ChildElement)) continue;
                childEntry = (ChildElement)vector.get(n);
                arrayList2.add((ChildAttribute)childEntry);
            }
        }
        return arrayList2;
    }

    private List sort(List list, List list2, boolean bl) {
        if (this.isSorted(list, list2, bl)) {
            return list;
        }
        ArrayList<ChildEntry> arrayList = new ArrayList<ChildEntry>();
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            boolean bl2 = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl2) {
                ChildEntry childEntry = (ChildEntry)iterator.next();
                boolean bl3 = bl && childEntry.getQName().getLocalPart().equals(string) || !bl && childEntry.getName().equals(string);
                if (!bl3) continue;
                arrayList.add(childEntry);
                iterator.remove();
                bl2 = true;
            }
        }
        arrayList.addAll(list);
        return arrayList;
    }

    private boolean isSorted(List list, List list2, boolean bl) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            boolean bl2;
            ChildEntry childEntry = (ChildEntry)list.get(i);
            String string = (String)list2.get(i);
            boolean bl3 = bl2 = bl && childEntry.getQName().getLocalPart().equals(string) || !bl && childEntry.getName().equals(string);
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private boolean match(List list, List list2, boolean bl) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)list.get(i);
            boolean bl2 = false;
            for (int j = 0; j < list2.size() && !bl2; ++j) {
                String string = (String)list2.get(j);
                bl2 = bl && childEntry.getQName().getLocalPart().equals(string) || !bl && childEntry.getName().equals(string);
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private Method getPublicNoArgConstructor(JavaClass javaClass) {
        String string = javaClass.getJavaName().substring(javaClass.getJavaName().lastIndexOf(46) + 1);
        return javaClass.getPublicMethod(string, new ArrayList());
    }

    private boolean hasImplicitDefaultConstructor(JavaClass javaClass) {
        String string = javaClass.getJavaName().substring(javaClass.getJavaName().lastIndexOf(46) + 1);
        EList eList = javaClass.getMethods();
        if (eList == null) {
            return true;
        }
        for (int i = 0; i < eList.size(); ++i) {
            if (!((Method)eList.get(i)).getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    private Method getPublicStringArgConstructor(JavaClass javaClass) {
        String string = javaClass.getJavaName().substring(javaClass.getJavaName().lastIndexOf(46) + 1);
        JavaClass javaClass2 = (JavaClass)this.classFactory.forName("java.lang.String");
        if (javaClass2 == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.String"));
        }
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        arrayList.add(javaClass2);
        return javaClass.getPublicMethod(string, arrayList);
    }

    private List getPublicConstructorMethods(JavaClass javaClass, int n) {
        String string = javaClass.getJavaName().substring(javaClass.getJavaName().lastIndexOf(46) + 1);
        List list = javaClass.getPublicMethodsNamed(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            if (method2.getParameters().size() == n) continue;
            iterator.remove();
        }
        return list;
    }

    private boolean isCompatibleConstructor(Method method2, List list) {
        EList eList = method2.getParameters();
        if (list.size() != eList.size()) {
            return false;
        }
        for (int i = 0; i < eList.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)list.get(i);
            String string = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            JavaHelpers javaHelpers = this.classFactory.forName(string);
            JavaParameter javaParameter = (JavaParameter)eList.get(i);
            JavaHelpers javaHelpers2 = javaParameter.getJavaType();
            if (this.isAssignableFrom(javaHelpers2, javaHelpers)) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignableFrom(JavaHelpers javaHelpers, JavaHelpers javaHelpers2) {
        if (javaHelpers instanceof ArrayType && javaHelpers2 instanceof ArrayType) {
            return this.isAssignableFrom(((ArrayType)javaHelpers).getComponentTypeAsHelper(), ((ArrayType)javaHelpers2).getComponentTypeAsHelper());
        }
        return javaHelpers.isAssignableFrom(javaHelpers2);
    }

    private boolean areAllWriteable(List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)list.get(i);
            if (bl && childEntry.getName().equalsIgnoreCase("message") || this.isWriteable(childEntry)) continue;
            return false;
        }
        return true;
    }

    private boolean isWriteable(ChildEntry childEntry) {
        Boolean bl = (Boolean)childEntry.getDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER);
        String string = (String)childEntry.getDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME);
        return bl != null && bl != false || string != null;
    }

    private List getParamNames(JavaClass javaClass, Method method2) {
        ArrayList<String> arrayList = null;
        if (this.emitter.getToolEnv().isJavaIntrospectionAllowed()) {
            arrayList = this.getParamNamesReflect(javaClass, method2);
        }
        if (arrayList == null || arrayList.size() == 0) {
            arrayList = new ArrayList<String>();
            EList eList = method2.getParameters();
            for (int i = 0; i < eList.size(); ++i) {
                arrayList.add(((JavaParameter)eList.get(i)).getName());
            }
        }
        return arrayList;
    }

    private List getParamNamesReflect(JavaClass javaClass, Method method2) {
        Serializable serializable;
        block8: {
            String[] stringArray;
            Constructor constructor = null;
            try {
                serializable = ClassUtils.forName(javaClass.getJavaName(), false, this.emitter.getToolEnv().getClassLoader());
                stringArray = method2.getParameters();
                Class[] classArray = new Class[stringArray.size()];
                for (int i = 0; i < stringArray.size(); ++i) {
                    JavaParameter javaParameter = (JavaParameter)stringArray.get(i);
                    JavaHelpers javaHelpers = javaParameter.getJavaType();
                    classArray[i] = ClassUtils.forName(javaHelpers.getJavaName(), false, this.emitter.getToolEnv().getClassLoader());
                }
                constructor = ((Class)serializable).getDeclaredConstructor(classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializable = new ArrayList();
            if (constructor != null) {
                try {
                    stringArray = ParamNameExtractor.getParameterNamesFromDebugInfo(constructor);
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            ((ArrayList)serializable).add(stringArray[i]);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.emitter.isDebug() && !this.emitter.isVerbose()) break block8;
                    this.symbolTable.getToolEnv().report("Debug Info: Could not read parameter names for constructor, " + constructor + ".  Processing continues.");
                }
            }
        }
        return serializable;
    }

    private void extensionCheck(Type type, JavaHelpers javaHelpers) {
        Type type2 = type.getExtensionBase();
        if (type2 == null || type.isSimpleTypeOrSimpleContent()) {
            return;
        }
        JavaHelpers javaHelpers2 = this.findType(type2);
        JavaClass javaClass = ((JavaClass)javaHelpers).getSupertype();
        if (!javaClass.equals(javaHelpers2)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidBean02", javaHelpers.getJavaName(), javaClass.getJavaName(), type2.getName()));
        }
    }

    private void validateEnumeration(JavaClass javaClass) {
        List list = javaClass.getPublicMethodsNamed("getValue");
        if (list.size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "getValue"));
        }
        if ((list = javaClass.getPublicMethodsNamed("fromValue")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "fromValue"));
        }
        if ((list = javaClass.getPublicMethodsNamed("fromString")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "fromString"));
        }
        if ((list = javaClass.getPublicMethodsNamed("toString")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "toString"));
        }
        if ((list = javaClass.getPublicMethodsNamed("setValue")).size() > 0) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum01", javaClass.getJavaName(), "setValue"));
        }
    }

    private void processEnumChildren(Type type, JavaClass javaClass) {
        EList eList = javaClass.getFields();
        for (int i = 0; i < eList.size(); ++i) {
            Field field = (Field)eList.get(i);
            String string = com.ibm.ws.webservices.wsdl.fromJava.Utils.getInitialValue(field);
            if (string == null && field.getName().charAt(0) == '_') continue;
            ChildEnumValueEntry childEnumValueEntry = null;
            for (int j = 0; j < type.getChildren().size() && childEnumValueEntry == null; ++j) {
                ChildEnumValueEntry childEnumValueEntry2 = (ChildEnumValueEntry)type.getChildren().get(j);
                if (!childEnumValueEntry2.getEnumValue().equals(string)) continue;
                childEnumValueEntry = childEnumValueEntry2;
            }
            if (childEnumValueEntry == null) continue;
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(this.symbolTable, childEnumValueEntry, field.getName().substring(1), false);
        }
    }

    static String compatibleTypeTest(JavaHelpers javaHelpers, String string, TypeEntry typeEntry, TypeMapping typeMapping, ClassFactory classFactory, SymbolTable symbolTable, Emitter emitter, boolean bl, boolean bl2, BooleanHolder booleanHolder) {
        Object object;
        String string2 = javaHelpers.getJavaName();
        if (string2.equals(string)) {
            return string2;
        }
        if (string2.equals("javax.xml.soap.SOAPElement") || string2.equals("org.w3c.dom.Element")) {
            if (!bl) {
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
            }
            return string2;
        }
        QName qName = com.ibm.ws.webservices.wsdl.fromJava.Utils.getTypeQName(javaHelpers, typeMapping, emitter.getCustomRegistry(), classFactory);
        if (qName != null && qName.equals(typeEntry.getQName())) {
            if (string2 != string && (string2.equals(Utils.getWrapperType(string)) || string.equals(Utils.getWrapperType(string2)))) {
                if (bl2) {
                    booleanHolder.value = true;
                } else {
                    return null;
                }
            }
            return string2;
        }
        if (Constants.equals(typeEntry.getQName(), Constants.XSD_ANY) && string2.equals("javax.xml.soap.SOAPElement[]")) {
            return string2;
        }
        JavaHelpers javaHelpers2 = classFactory.forName("com.ibm.ws.webservices.engine.encoding.SimpleType");
        if (javaHelpers2 != null && ((Type)typeEntry).isSimpleType() && javaHelpers2.isAssignableFrom(javaHelpers)) {
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, typeEntry, string2, true);
            if (!bl) {
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
            }
            return string2;
        }
        if (((Type)typeEntry).isEnumeration() && string2.equals(((Entry)(object = ((Type)typeEntry).getRestrictionBase())).getName())) {
            if (!bl) {
                ((Type)typeEntry).setEnumeration(false);
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
            }
            return string2;
        }
        if (string.equals("java.lang.Object[]") && (object = classFactory.forName("java.util.Collection")).isAssignableFrom(javaHelpers)) {
            return string2;
        }
        if (string2.indexOf("[]") > 0) {
            object = typeEntry.getDimensions();
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 == null) {
                typeEntry2 = (TypeEntry)typeEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
                object = "[]";
            }
            if (typeEntry2 != null) {
                JavaHelpers javaHelpers3;
                if (((String)object).length() == 0) {
                    string2 = TypeEntryIntrospector.compatibleTypeTest(javaHelpers, string, typeEntry2, typeMapping, classFactory, symbolTable, emitter, bl, bl2, booleanHolder);
                    if (!bl && string2 != null) {
                        return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
                    }
                    return string2;
                }
                int n = string2.lastIndexOf((String)object);
                int n2 = string.lastIndexOf((String)object);
                if (n >= 0 && n2 >= 0 && (javaHelpers3 = classFactory.forName(string2.substring(0, n))) != null) {
                    String string3 = TypeEntryIntrospector.compatibleTypeTest(javaHelpers3, string.substring(0, n2), typeEntry2, typeMapping, classFactory, symbolTable, emitter, bl, bl2, booleanHolder);
                    if (string3 != null) {
                        string2 = string3 + (String)object;
                        if (!bl && string2 != null) {
                            return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
                        }
                        return string2;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private static String setJavaName(SymbolTable symbolTable, TypeEntry typeEntry, String string) {
        boolean bl;
        boolean bl2 = bl = typeEntry.getDynamicVar("oldName2") != null;
        if (bl && !string.equals(typeEntry.getName())) {
            return null;
        }
        com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, typeEntry, string, false);
        return string;
    }

    static boolean compatibleBeanTest(JavaHelpers javaHelpers) {
        if (!(javaHelpers instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)javaHelpers;
        String string = javaHelpers.getJavaName();
        if (javaClass.isArray() || javaHelpers.isPrimitive()) {
            return false;
        }
        return !string.startsWith("java.") && !string.startsWith("javax.") && !string.startsWith("com.ibm.ws.webservices.engine.types") && !string.startsWith("org.w3c.dom");
    }

    public static JavaHelpers locateClass(SymTabEntry symTabEntry, Emitter emitter, ClassFactory classFactory) {
        Object object;
        String string = "";
        JavaHelpers javaHelpers = null;
        TypeEntry typeEntry = (TypeEntry)symTabEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (typeEntry != null && (javaHelpers = classFactory.forName(string = emitter.getJavaName(symTabEntry.getQName()))) != null) {
            symTabEntry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
        }
        if (javaHelpers == null) {
            string = symTabEntry.getName();
            javaHelpers = classFactory.forName(string);
        }
        if (javaHelpers == null && typeEntry != null && (object = TypeEntryIntrospector.locateClass(typeEntry, emitter, classFactory)) != null) {
            string = object.getJavaName() + "[]";
            javaHelpers = classFactory.forName(string);
        }
        if (javaHelpers == null) {
            object = symTabEntry.getQName().getLocalPart();
            String string2 = emitter.getNamespaces().getCreate(symTabEntry.getQName().getNamespaceURI());
            string = string2 + "." + (String)object;
            javaHelpers = classFactory.forName(string);
            if (javaHelpers == null) {
                string = string2 + "." + JavaUtils.xmlNameToJavaClass((String)object);
                javaHelpers = classFactory.forName(string);
            }
            if (javaHelpers != null) {
                symTabEntry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
            }
        }
        if (javaHelpers != null && !string.equals(symTabEntry.getName())) {
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(emitter.getSymbolTable(), symTabEntry, string, false);
        }
        return javaHelpers;
    }
}

