/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.soap;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.enumtype.MIMEStyle;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.models.ModelBindingGenerator;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.ws.webservices.wsdl.extensions.ExtensionUtils;
import com.ibm.ws.webservices.wsdl.extensions.UsingAddressingExtensibilityElement;
import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.extensions.mime.MIMEContentImpl;
import com.ibm.wsdl.extensions.mime.MIMEMultipartRelatedImpl;
import com.ibm.wsdl.extensions.mime.MIMEPartImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;

public class SOAPBindingGenerator
extends ModelBindingGenerator {
    protected OptionDescriptor[] specificOptionDescriptors = new OptionDescriptor[]{new OptionDescriptor(this.bindingTypeName + ".soapAction", false, Messages.getMessage((String)"desc.soapAction", (String)this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".MIMEStyle", false, Messages.getMessage((String)"desc.MIMEStyle", (String)this.bindingTypeName))};
    private static Map axisTypeToMIMEString = new HashMap();

    public SOAPBindingGenerator(String string) {
        super(string);
    }

    public String getBindingTypeName() {
        return this.bindingTypeName;
    }

    public String getBindingName(Properties properties) {
        String string;
        String string2 = properties.getProperty(this.bindingTypeName + ".bindingName");
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = properties.getProperty("bindingName");
            string = this.bindingTypeName.equalsIgnoreCase("HTTP") ? string3 + "SoapBinding" : (this.bindingTypeName.equalsIgnoreCase("JMS") ? string3 + "JMSSoapBinding" : string3 + JavaUtils.capitalizeFirstChar(this.bindingTypeName) + "Binding");
        }
        return string;
    }

    public String getPortName(Properties properties) {
        String string;
        String string2 = properties.getProperty(this.bindingTypeName + ".servicePortName");
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = properties.getProperty("servicePortName");
            string = this.bindingTypeName.equalsIgnoreCase("HTTP") ? string3 : (this.bindingTypeName.equalsIgnoreCase("JMS") ? string3 + "JMS" : string3 + JavaUtils.capitalizeFirstChar(this.bindingTypeName));
        }
        return string;
    }

    public Binding makeBinding(Definition definition, PortType portType, QName qName, Properties properties) {
        Binding binding = this.getOtherBinding(definition, portType);
        Binding binding2 = definition.createBinding();
        binding2.setUndefined(false);
        binding2.setQName(qName);
        binding2.setPortType(portType);
        String string = properties.getProperty("style", "rpc");
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        sOAPBindingImpl.setStyle(string);
        sOAPBindingImpl.setTransportURI(this.getTransportURI());
        ExtensionUtils.addExtensibilityElement(binding2, new UsingAddressingExtensibilityElement());
        binding2.addExtensibilityElement(sOAPBindingImpl);
        if (portType.getOperations() != null) {
            boolean bl = false;
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement;
                Object object;
                Serializable serializable;
                Object object2;
                Operation operation = (Operation)iterator.next();
                BindingOperation bindingOperation = definition.createBindingOperation();
                bindingOperation.setName(operation.getName());
                bindingOperation.setOperation(operation);
                binding2.addBindingOperation(bindingOperation);
                SOAPOperationImpl sOAPOperationImpl = new SOAPOperationImpl();
                String string2 = properties.getProperty(this.bindingTypeName + ".soapAction");
                if (string2 == null) {
                    string2 = properties.getProperty("soapAction", "DEFAULT");
                }
                String string3 = "";
                if (string2.equalsIgnoreCase("OPERATION")) {
                    string3 = operation.getName();
                }
                sOAPOperationImpl.setSoapActionURI(string3);
                bindingOperation.addExtensibilityElement(sOAPOperationImpl);
                BindingOperation bindingOperation2 = this.getOtherBindingOperation(binding, operation);
                if (operation.getInput() != null) {
                    object2 = definition.createBindingInput();
                    object2.setName(operation.getInput().getName());
                    serializable = operation.getInput().getMessage();
                    object = this.getOtherInputElement(bindingOperation2);
                    extensibilityElement = this.getIfMIME((Message)serializable, (ExtensibilityElement)object, properties);
                    if (extensibilityElement == null) {
                        extensibilityElement = this.getSOAPBody((Message)serializable, properties);
                    } else {
                        bl = true;
                    }
                    object2.addExtensibilityElement(extensibilityElement);
                    bindingOperation.setBindingInput((BindingInput)object2);
                }
                if (operation.getOutput() != null) {
                    object2 = definition.createBindingOutput();
                    object2.setName(operation.getOutput().getName());
                    serializable = operation.getOutput().getMessage();
                    object = this.getOtherInputElement(bindingOperation2);
                    extensibilityElement = this.getIfMIME((Message)serializable, (ExtensibilityElement)object, properties);
                    if (extensibilityElement == null) {
                        extensibilityElement = this.getSOAPBody((Message)serializable, properties);
                    } else {
                        bl = true;
                    }
                    object2.addExtensibilityElement(extensibilityElement);
                    bindingOperation.setBindingOutput((BindingOutput)object2);
                }
                if (operation.getFaults() == null) continue;
                object2 = operation.getFaults().values().iterator();
                while (object2.hasNext()) {
                    serializable = (Fault)object2.next();
                    object = new BindingFaultImpl();
                    extensibilityElement = this.getSOAPFault(serializable.getMessage(), properties);
                    ((SOAPFault)extensibilityElement).setName(serializable.getName());
                    object.setName(serializable.getName());
                    object.addExtensibilityElement(extensibilityElement);
                    bindingOperation.addBindingFault((BindingFault)object);
                }
            }
            if (bl) {
                definition.addNamespace("mime", "http://schemas.xmlsoap.org/wsdl/mime/");
            }
        }
        return binding2;
    }

    private ExtensibilityElement getIfMIME(Message message, ExtensibilityElement extensibilityElement, Properties properties) {
        MIMEMultipartRelatedImpl mIMEMultipartRelatedImpl;
        block6: {
            Serializable serializable;
            int n;
            String string;
            block7: {
                mIMEMultipartRelatedImpl = null;
                string = properties.getProperty(this.bindingTypeName + ".MIMEStyle");
                if (string == null) {
                    string = properties.getProperty("MIMEStyle", MIMEStyle.WSDL11.toString());
                }
                if (!string.equals(MIMEStyle.WSDL11.toString())) break block6;
                if (!(extensibilityElement instanceof MIMEMultipartRelated)) break block7;
                MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)extensibilityElement;
                mIMEMultipartRelatedImpl = new MIMEMultipartRelatedImpl();
                mIMEMultipartRelatedImpl.setElementType(mIMEMultipartRelated.getElementType());
                mIMEMultipartRelatedImpl.setRequired(mIMEMultipartRelated.getRequired());
                List list = mIMEMultipartRelated.getMIMEParts();
                for (int i = 0; i < list.size(); ++i) {
                    Object var11_16;
                    MIMEPart mIMEPart = (MIMEPart)list.get(i);
                    List list2 = mIMEPart.getExtensibilityElements();
                    Object v0 = var11_16 = list2.isEmpty() ? null : list2.get(0);
                    if (var11_16 instanceof SOAPBody) {
                        SOAPBody sOAPBody = (SOAPBody)this.getSOAPBody(message, properties);
                        sOAPBody.setParts(((SOAPBody)var11_16).getParts());
                        MIMEPartImpl mIMEPartImpl = new MIMEPartImpl();
                        mIMEPartImpl.addExtensibilityElement(sOAPBody);
                        mIMEMultipartRelatedImpl.addMIMEPart(mIMEPartImpl);
                        continue;
                    }
                    mIMEMultipartRelatedImpl.addMIMEPart(mIMEPart);
                }
                break block6;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.sortTypes(message, arrayList, arrayList2, string);
            if (arrayList.size() <= 0) break block6;
            mIMEMultipartRelatedImpl = new MIMEMultipartRelatedImpl();
            MIMEPartImpl mIMEPartImpl = new MIMEPartImpl();
            mIMEMultipartRelatedImpl.addMIMEPart(mIMEPartImpl);
            SOAPBody sOAPBody = (SOAPBody)this.getSOAPBody(message, properties);
            mIMEPartImpl.addExtensibilityElement(sOAPBody);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (n = 0; n < arrayList2.size(); ++n) {
                serializable = (Part)arrayList2.get(n);
                arrayList3.add(serializable.getName());
            }
            if (arrayList3.size() > 0) {
                sOAPBody.setParts(arrayList3);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                mIMEPartImpl = new MIMEPartImpl();
                mIMEMultipartRelatedImpl.addMIMEPart(mIMEPartImpl);
                serializable = new MIMEContentImpl();
                mIMEPartImpl.addExtensibilityElement((ExtensibilityElement)((Object)serializable));
                Part part = (Part)arrayList.get(n);
                serializable.setPart(part.getName());
                serializable.setType(this.mimeType(part.getTypeName()));
                part.setTypeName(Constants.XSD_HEXBIN);
            }
        }
        return mIMEMultipartRelatedImpl;
    }

    private void sortTypes(Message message, List list, List list2, String string) {
        Iterator iterator = message.getParts().values().iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            QName qName = part.getTypeName();
            if (Constants.MIME_IMAGE.equals(qName) || Constants.MIME_PLAINTEXT.equals(qName) || Constants.MIME_MULTIPART.equals(qName) || Constants.MIME_SOURCE.equals(qName) || Constants.MIME_OCTETSTREAM.equals(qName) || Constants.WSI_SWAREF.equals(qName) || Constants.MIME_DATA_HANDLER.equals(qName) && string.equals(MIMEStyle.WSDL11.toString())) {
                list.add(part);
                continue;
            }
            list2.add(part);
        }
    }

    private String mimeType(QName qName) {
        return (String)axisTypeToMIMEString.get(qName);
    }

    private ExtensibilityElement getSOAPBody(Message message, Properties properties) {
        Object object;
        SOAPBodyImpl sOAPBodyImpl = new SOAPBodyImpl();
        String string = properties.getProperty("use", "encoded");
        if (string.equalsIgnoreCase("encoded")) {
            sOAPBodyImpl.setUse("encoded");
            object = new ArrayList<String>();
            ((ArrayList)object).add(properties.getProperty("encodingStyle", Constants.URI_DEFAULT_SOAP_ENC));
            sOAPBodyImpl.setEncodingStyles((List)object);
        } else {
            sOAPBodyImpl.setUse("literal");
        }
        object = properties.getProperty("style", "rpc");
        if (((String)object).equalsIgnoreCase("rpc")) {
            sOAPBodyImpl.setNamespaceURI(properties.getProperty("intfNS", "unknownInterfaceNamespace"));
        }
        return sOAPBodyImpl;
    }

    private SOAPFault getSOAPFault(Message message, Properties properties) {
        SOAPFaultImpl sOAPFaultImpl = new SOAPFaultImpl();
        String string = properties.getProperty("use", "encoded");
        if (!string.equalsIgnoreCase("encoded")) {
            sOAPFaultImpl.setUse("literal");
        } else {
            sOAPFaultImpl.setUse("encoded");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(properties.getProperty("encodingStyle", Constants.URI_DEFAULT_SOAP_ENC));
            sOAPFaultImpl.setEncodingStyles(arrayList);
        }
        return sOAPFaultImpl;
    }

    public ExtensibilityElement makePortAddress(Definition definition, Port port, Properties properties) {
        String string = properties.getProperty(this.bindingTypeName + ".location");
        if (string == null) {
            string = properties.getProperty("location");
        }
        if (this.bindingTypeName.equalsIgnoreCase("JMS")) {
            string = string.replace('|', '&');
        }
        SOAPAddressImpl sOAPAddressImpl = new SOAPAddressImpl();
        sOAPAddressImpl.setLocationURI(string);
        return sOAPAddressImpl;
    }

    public String getTransportURI() {
        if (this.bindingTypeName.equalsIgnoreCase("http")) {
            return "http://schemas.xmlsoap.org/soap/http";
        }
        return "http://schemas.xmlsoap.org/soap/jms";
    }

    public OptionDescriptor[] getOptionDescriptors() {
        int n;
        OptionDescriptor[] optionDescriptorArray = this.getDefaultOptionDescriptors();
        int n2 = optionDescriptorArray.length;
        int n3 = this.specificOptionDescriptors.length;
        OptionDescriptor[] optionDescriptorArray2 = new OptionDescriptor[n2 + n3];
        for (n = 0; n < n2; ++n) {
            optionDescriptorArray2[n] = optionDescriptorArray[n];
        }
        for (n = 0; n < n3; ++n) {
            optionDescriptorArray2[n + n2] = this.specificOptionDescriptors[n];
        }
        return optionDescriptorArray2;
    }

    private Binding getOtherBinding(Definition definition, PortType portType) {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            if (!binding.getPortType().getQName().equals(portType.getQName())) continue;
            return binding;
        }
        return null;
    }

    private BindingOperation getOtherBindingOperation(Binding binding, Operation operation) {
        if (binding == null || operation == null) {
            return null;
        }
        String string = operation.getName();
        Input input = operation.getInput();
        String string2 = input == null ? null : input.getName();
        Output output = operation.getOutput();
        String string3 = output == null ? null : output.getName();
        return binding.getBindingOperation(string, string2, string3);
    }

    private ExtensibilityElement getOtherInputElement(BindingOperation bindingOperation) {
        if (bindingOperation == null) {
            return null;
        }
        List list = bindingOperation.getBindingInput().getExtensibilityElements();
        return list.isEmpty() ? null : (ExtensibilityElement)list.get(0);
    }

    private ExtensibilityElement getOtherOutputElement(BindingOperation bindingOperation) {
        if (bindingOperation == null) {
            return null;
        }
        List list = bindingOperation.getBindingOutput().getExtensibilityElements();
        return list.isEmpty() ? null : (ExtensibilityElement)list.get(0);
    }

    protected ExtensibilityElement getBindingExtension(PortType portType) {
        return null;
    }

    protected ExtensibilityElement getBindingOperation(Operation operation) {
        return null;
    }

    protected Map getRequiredNamespaces() {
        return null;
    }

    static {
        axisTypeToMIMEString.put(Constants.MIME_IMAGE, "image/jpeg");
        axisTypeToMIMEString.put(Constants.MIME_PLAINTEXT, "text/plain");
        axisTypeToMIMEString.put(Constants.MIME_MULTIPART, "multipart/*");
        axisTypeToMIMEString.put(Constants.MIME_SOURCE, "text/xml");
        axisTypeToMIMEString.put(Constants.MIME_OCTETSTREAM, "application/octetstream");
        axisTypeToMIMEString.put(Constants.MIME_DATA_HANDLER, "application/octetstream");
        axisTypeToMIMEString.put(Constants.WSI_SWAREF, "application/octetstream");
    }
}

