/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPFault;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFaultElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.WebServicesFaultProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class SOAPFault
extends SOAPBodyElement
implements IBMSOAPFault {
    private Locale locale;

    SOAPFault(SOAPFactory sOAPFactory) {
        super(sOAPFactory.getSOAPConstants().getEnvelopeURI(), "Fault", sOAPFactory);
    }

    public void setFaultCode(String string) throws SOAPException {
        if (this._getFault() != null) {
            String string2 = SOAPFault.extractPrefixFromQName(string);
            String string3 = SOAPFault.extractLocalNameFromQName(string);
            String string4 = null;
            string2 = string2 == null ? "" : string2;
            Mapping mapping = this._getMappingScope().getMappingForPrefix(string2, false);
            if (mapping != null) {
                string4 = mapping.getNamespaceURI();
            }
            if (string4 != null && string4.length() > 0) {
                string = "{" + string4 + "}" + string3;
            }
            this._getFault().setFaultCodeAsString(string);
        } else {
            SOAPElement sOAPElement = this.getChildElement("", Constants.QNAME_FAULTCODE.getLocalPart());
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            Node node = this.getFirstChild();
            sOAPElement = this.getSOAPFactory().createSOAPElement("", Constants.QNAME_FAULTCODE.getLocalPart());
            sOAPElement = (SOAPElement)this.insertBefore(sOAPElement, node);
            sOAPElement.addTextNode(string);
        }
    }

    public void setFaultCode(javax.xml.soap.Name name) throws SOAPException {
        String string = name.getURI();
        String string2 = name.getLocalName();
        String string3 = name.getPrefix();
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            webServicesFault.setFaultCode(QNameTable.createQName(string, string2));
        } else {
            String string4 = string2;
            if (string3 != null && string3.length() > 0) {
                string4 = string3 + ":" + string4;
                if (this._getMappingScope().getMappingForPrefix(string3, false) == null) {
                    this.addNamespaceDeclaration(string3, string);
                }
            }
            this.setFaultCode(string4);
        }
    }

    public String getFaultCode() {
        if (this._getFault() != null) {
            return this._getFault().getFaultCode().toString();
        }
        SOAPElement sOAPElement = this._getChildElement("", Constants.QNAME_FAULTCODE.getLocalPart());
        if (sOAPElement != null) {
            return sOAPElement.getValue();
        }
        return null;
    }

    public QName getFaultCodeAsQName() {
        int n;
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            return webServicesFault.getFaultCode();
        }
        String string = this.getFaultCode();
        if (string == null) {
            return null;
        }
        if (string.startsWith("{") && (n = string.indexOf("}")) > 0) {
            String string2 = string.substring(1, n);
            string = string.substring(n + 1);
            return QNameTable.createQName(string2, string);
        }
        String string3 = SOAPFault.extractPrefixFromQName(string);
        String string4 = SOAPFault.extractLocalNameFromQName(string);
        String string5 = null;
        string3 = string3 == null ? "" : string3;
        SOAPElement sOAPElement = this._getChildElement("", Constants.QNAME_FAULTCODE.getLocalPart());
        Mapping mapping = sOAPElement._getMappingScope().getMappingForPrefix(string3, false);
        if (mapping != null) {
            string5 = mapping.getNamespaceURI();
        }
        return QNameTable.createQName(string5, string4);
    }

    public javax.xml.soap.Name getFaultCodeAsName() {
        QName qName = this.getFaultCodeAsQName();
        if (qName == null) {
            return null;
        }
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        String string3 = null;
        if (string != null) {
            string3 = this._getMappingScope().getOrCreatePrefix(string, null, false);
        }
        return new Name(string, string2, string3);
    }

    public void setFaultActor(String string) throws SOAPException {
        if (this._getFault() != null) {
            this._getFault().setFaultActor(string);
        } else {
            SOAPElement sOAPElement = this.getChildElement("", Constants.QNAME_FAULTACTOR.getLocalPart());
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            SOAPElement sOAPElement2 = this.getChildElement("", Constants.QNAME_FAULTDETAILS.getLocalPart());
            sOAPElement = this.getSOAPFactory().createSOAPElement("", Constants.QNAME_FAULTACTOR.getLocalPart());
            sOAPElement = (SOAPElement)this.insertBefore(sOAPElement, sOAPElement2);
            sOAPElement.addTextNode(string);
        }
    }

    public String getFaultActor() {
        if (this._getFault() != null) {
            return this._getFault().getFaultActor();
        }
        SOAPElement sOAPElement = this._getChildElement("", Constants.QNAME_FAULTACTOR.getLocalPart());
        if (sOAPElement != null) {
            return sOAPElement.getValue();
        }
        return null;
    }

    public void setFaultString(String string) throws SOAPException {
        if (this._getFault() != null) {
            this._getFault().setFaultString(string);
        } else {
            SOAPElement sOAPElement;
            SOAPElement sOAPElement2 = this.getChildElement("", Constants.QNAME_FAULTSTRING.getLocalPart());
            if (sOAPElement2 != null) {
                sOAPElement2.detachNode();
            }
            if ((sOAPElement = this.getChildElement("", Constants.QNAME_FAULTACTOR.getLocalPart())) == null) {
                sOAPElement = this.getChildElement("", Constants.QNAME_FAULTDETAILS.getLocalPart());
            }
            sOAPElement2 = this.getSOAPFactory().createSOAPElement("", Constants.QNAME_FAULTSTRING.getLocalPart());
            sOAPElement2 = (SOAPElement)this.insertBefore(sOAPElement2, sOAPElement);
            sOAPElement2.addTextNode(string);
        }
    }

    public void setFaultString(String string, Locale locale) throws SOAPException {
        this.setFaultString(string);
        this.locale = locale;
    }

    public Locale getFaultStringLocale() {
        return this.locale;
    }

    public String getFaultString() {
        if (this._getFault() != null) {
            return this._getFault().getFaultString();
        }
        SOAPElement sOAPElement = this._getChildElement("", Constants.QNAME_FAULTSTRING.getLocalPart());
        if (sOAPElement != null) {
            return sOAPElement.getValue();
        }
        return null;
    }

    public boolean isUserFault() {
        return this.getDetail() != null;
    }

    public javax.xml.soap.Detail getDetail() {
        return (javax.xml.soap.Detail)((Object)this._getChildElement("", Constants.QNAME_FAULTDETAILS.getLocalPart()));
    }

    public javax.xml.soap.Detail addDetail() throws SOAPException {
        if (this.getDetail() != null) {
            throw new SOAPException(Messages.getMessage("valuePresent"));
        }
        Detail detail = new Detail(this.soapFactory);
        detail = (Detail)this.addChildElement(detail);
        return detail;
    }

    protected WebServicesFault _getFault() {
        Object object = this.getAlternateContent();
        if (object instanceof WebServicesFault) {
            return (WebServicesFault)object;
        }
        return null;
    }

    public WebServicesFault getFault() {
        WebServicesFault webServicesFault = this._getFault();
        if (webServicesFault == null) {
            this.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
            try {
                webServicesFault = WebServicesFaultProcessor.createFault(this, this.getSOAPFactory().getDeserializationContext());
                this.setFault(webServicesFault);
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.getFault", "485", this);
                throw new RuntimeException(sAXException);
            }
        }
        return webServicesFault;
    }

    public void setFault(WebServicesFault webServicesFault) {
        try {
            this.removeContents();
            this.setAlternateContent(WebServicesFaultAlternateContent.create(webServicesFault));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.setFault", "472", this);
            throw new RuntimeException(exception);
        }
    }

    public void setFault(SOAPFaultException sOAPFaultException) {
        this.setFault(new WebServicesFault(sOAPFaultException));
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPFaultBuilder();
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        if ((string == null || string.length() == 0) && Constants.QNAME_FAULTDETAILS.getLocalPart().equals(string2)) {
            return new Detail(sOAPFactory);
        }
        return super.createChildElement(string, string2, sOAPFactory);
    }

    protected boolean isValidSAAJChild(Node node) {
        SOAPElement sOAPElement;
        Class<?> clazz = node.getClass();
        if (node instanceof SOAPElement && !(node instanceof Detail) && ((sOAPElement = (SOAPElement)node).getNamespaceURI() == null || sOAPElement.getNamespaceURI().length() == 0) && Constants.QNAME_FAULTDETAILS.getLocalPart().equals(sOAPElement.getLocalName())) {
            return false;
        }
        return (clazz.equals(SOAPElement.class) || clazz.equals(SOAPFaultElement.class) || clazz.equals(Detail.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    private SOAPElement _getChildElement(String string, String string2) {
        try {
            return this.getChildElement(string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.setFault", "519", this);
            throw new RuntimeException(exception);
        }
    }
}

