/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.BusinessObjectAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ElementAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.InputStreamAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValueAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponseAlternateContent;
import java.io.InputStream;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AlternateContentBase {
    private static Log log = LogFactory.getLog(AlternateContentBase.class.getName());
    protected SOAPElement owner;
    protected Object content;
    protected short contentFlag;
    public static short CONTENT_ONLY = 0;
    public static short CONTENT_PLUS_ATTRS = 1;
    public static short CONTENT_PLUS_TAG = (short)2;

    static AlternateContentBase create(Object object) {
        if (object instanceof AlternateContentBase) {
            return (AlternateContentBase)object;
        }
        if (object instanceof RequestResponse) {
            return RequestResponseAlternateContent.create((RequestResponse)object);
        }
        if (object instanceof ParamValue) {
            return ParamValueAlternateContent.create((ParamValue)object);
        }
        if (object instanceof InputStream) {
            return InputStreamAlternateContent.create((InputStream)object);
        }
        if (object instanceof Element) {
            return ElementAlternateContent.create((Element)object);
        }
        return BusinessObjectAlternateContent.create(object);
    }

    protected AlternateContentBase(Object object, short s) {
        this.content = object;
        this.contentFlag = s;
    }

    protected void attach(SOAPElement sOAPElement) throws SOAPException {
        if (this.hasContent() && sOAPElement.getNumChildren() > 0) {
            SOAPException sOAPException = new SOAPException(Messages.getMessage("childPresent"));
            log.error(Messages.getMessage("childPresent"), sOAPException);
            throw sOAPException;
        }
        if (sOAPElement.altContent != null) {
            SOAPException sOAPException = new SOAPException(Messages.getMessage("altContentAlreadySet00"));
            throw sOAPException;
        }
        this.owner = sOAPElement;
        sOAPElement.altContent = this;
    }

    protected void detach() {
        if (this.owner != null) {
            this.owner.altContent = null;
            this.owner = null;
        }
    }

    protected final boolean affectsTagQName() {
        return this.contentFlag == CONTENT_PLUS_TAG;
    }

    protected final boolean affectsTagAttributes() {
        return this.contentFlag != CONTENT_ONLY;
    }

    protected void removeChildNodes() {
        if (this.contentFlag == CONTENT_ONLY) {
            this.detach();
        } else {
            SOAPElement sOAPElement = this.owner;
            Element element = this.getDOMElement();
            if (element != null) {
                Object object;
                NamedNodeMap namedNodeMap = element.getAttributes();
                this.detach();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    object = (Attr)namedNodeMap.item(i);
                    sOAPElement.setAttribute(object.getName(), object.getValue());
                }
                if (this.contentFlag == CONTENT_PLUS_TAG) {
                    String string = element.getNamespaceURI();
                    string = string == null ? "" : string;
                    object = element.getLocalName();
                    String string2 = element.getPrefix();
                    sOAPElement.setQName(string, (String)object);
                    sOAPElement.setPrefix(string2);
                }
            } else {
                sOAPElement.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
                sOAPElement.removeContents();
            }
        }
    }

    protected boolean hasContent() {
        return true;
    }

    protected Object getContent() {
        return this.hasContent() ? this.content : null;
    }

    protected Element getDOMElement() {
        return null;
    }

    protected String getXMLString() throws Exception {
        return null;
    }

    protected InputSource getXMLInputSource() throws Exception {
        return null;
    }

    protected RequestResponse asRequestResponse() {
        SOAPElement sOAPElement = this.owner;
        this.owner.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
        if (sOAPElement.altContent != null && sOAPElement.altContent != this) {
            return sOAPElement.altContent.asRequestResponse();
        }
        return null;
    }

    protected boolean isBusinessObject() {
        return false;
    }

    protected abstract void serialize(SerializationContext var1, boolean var2) throws Exception;

    protected final MappingScope _getMappingScope(SOAPElement sOAPElement) {
        return sOAPElement._getMappingScope();
    }

    protected final MappingScope _getMappingScopeForAncestorsNotWritten(SerializationContext serializationContext) {
        MappingScope mappingScope = null;
        mappingScope = this.owner != null ? this.owner.getMappingScopeForAncestorsNotWritten(serializationContext) : new MappingScope();
        return mappingScope;
    }

    public boolean hasToEvents() {
        return false;
    }

    public void toEvents(PEventProcessor pEventProcessor) throws SAXException {
    }
}

