/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.IgnoreSoapBodyException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.WebServicesParserFactory;
import com.ibm.ws.webservices.utils.BAIS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class WebServicesParser
extends SAXParser {
    protected static Log log = LogFactory.getLog(WebServicesParser.class.getName());
    protected WebServicesParserFactory parserFactory;
    protected SAXParser saxParser;
    protected Exception parseException = null;

    WebServicesParser(WebServicesParserFactory webServicesParserFactory, SAXParserFactory sAXParserFactory) throws ParserConfigurationException, SAXException {
        this.parserFactory = webServicesParserFactory;
        this.saxParser = sAXParserFactory.newSAXParser();
        this.saxParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        if (log.isDebugEnabled()) {
            log.debug("WebSphere - XLXP Parser: " + (String)this.saxParser.getProperty("http://ibm.com/xlxp/properties/build-time-stamp"));
        }
    }

    public void recycle() {
        try {
            if (this.saxParser.getXMLReader() == null) {
                return;
            }
        }
        catch (SAXException sAXException) {
            return;
        }
        if (this.parseException == null) {
            this.parserFactory.recycle(this);
        }
    }

    public void parse(InputStream inputStream, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            this.setLexicalHandler(handlerBase);
            this.saxParser.parse(inputStream, handlerBase);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
    }

    public void parse(InputStream inputStream, HandlerBase handlerBase, String string) throws SAXException, IOException {
        try {
            this.setLexicalHandler(handlerBase);
            this.saxParser.parse(inputStream, handlerBase, string);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(handlerBase);
        }
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            this.setLexicalHandler(defaultHandler);
            this.saxParser.parse(inputStream, defaultHandler);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(defaultHandler);
        }
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler, String string) throws SAXException, IOException {
        try {
            this.setLexicalHandler(defaultHandler);
            this.saxParser.parse(inputStream, defaultHandler, string);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(defaultHandler);
        }
    }

    public void parse(String string, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            this.setLexicalHandler(handlerBase);
            this.saxParser.parse(string, handlerBase);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(handlerBase);
        }
    }

    public void parse(String string, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            this.setLexicalHandler(defaultHandler);
            this.saxParser.parse(string, defaultHandler);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(defaultHandler);
        }
    }

    public void parse(File file, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            this.setLexicalHandler(handlerBase);
            this.saxParser.parse(file, handlerBase);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(handlerBase);
        }
    }

    public void parse(File file, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            this.setLexicalHandler(defaultHandler);
            this.saxParser.parse(file, defaultHandler);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(defaultHandler);
        }
    }

    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            this.setLexicalHandler(handlerBase);
            this.saxParser.parse(inputSource, handlerBase);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(handlerBase);
        }
    }

    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            this.setLexicalHandler(defaultHandler);
            this.saxParser.parse(inputSource, defaultHandler);
        }
        catch (IgnoreSoapBodyException ignoreSoapBodyException) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException sAXException) {
            this.parseException = sAXException;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.parseException = iOException;
            throw iOException;
        }
        finally {
            this.resetLexicalHandler(defaultHandler);
        }
    }

    public InputStream getSubTreeAsStream() throws SAXException {
        if (this.saxParser == null) {
            return null;
        }
        try {
            InputStream inputStream = null;
            try {
                inputStream = (InputStream)this.saxParser.getProperty("http://ibm.com/xlxp/properties/subtree-as-stream");
            }
            catch (SAXException sAXException) {
                inputStream = (InputStream)this.saxParser.getProperty("http://w3.xml.ibm.com/b2b/properties/subtree-as-stream");
            }
            if (inputStream != null) {
                try {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    inputStream.close();
                    if (log.isDebugEnabled()) {
                        String string = new String(byArray);
                        log.debug("lazy parsed contents:" + string);
                    }
                    inputStream = BAIS.create((byte[])byArray);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.utils.Parser.getSubTreeAsStream", "244", this);
                    throw new SAXException(iOException);
                }
            }
            return inputStream;
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.webservices.engine.utils.Parser", "250", this);
            return null;
        }
    }

    private void setLexicalHandler(Object object) throws SAXException {
        if (object instanceof LexicalHandler) {
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", object);
        }
    }

    private void resetLexicalHandler(Object object) throws SAXException {
        if (object instanceof LexicalHandler) {
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", null);
        }
    }

    public Parser getParser() throws SAXException {
        return this.saxParser.getParser();
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.saxParser.getXMLReader();
    }

    public boolean isNamespaceAware() {
        return this.saxParser.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.saxParser.isValidating();
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.saxParser.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.saxParser.getProperty(string);
    }
}

