/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.PortComponentInfo;
import com.ibm.ws.webservices.deploy.ServiceImplInfo;
import com.ibm.wsspi.webservices.models.WSModels;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

class WSDeploymentDescriptorAccessor {
    private static TraceComponent tc = Tr.register(WSDeploymentDescriptorAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final EObject refObject;
    private final AppDeploymentInfo appDeploymentInfo;
    private final AppDeploymentTask appDeploymentTask;
    private final String moduleURIString;
    private WebServices ws = null;

    WSDeploymentDescriptorAccessor(EObject eObject, AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.refObject = eObject;
        this.appDeploymentInfo = appDeploymentInfo;
        this.appDeploymentTask = appDeploymentTask;
        this.moduleURIString = util.formUriString(appDeploymentInfo, eObject);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor: moduleURIString=" + this.moduleURIString);
        }
        String string = "";
        if (eObject instanceof WebApp) {
            string = "WEB-INF/webservices.xml";
        } else if (eObject instanceof EJBJar) {
            string = "META-INF/webservices.xml";
        } else {
            Tr.error(tc, "WSWS0020E", "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module");
        }
        ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
        try {
            this.ws = WSModels.getWebServices(moduleFile.getLoadStrategy(), string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor.WSDeploymentDescriptorAccessor", "112", this);
            Object[] objectArray = new Object[]{string, util.formUriString(appDeploymentInfo, eObject), exception};
            String string2 = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0011E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + string2);
            }
            Tr.error(tc, "WSWS0011E", objectArray);
            throw new AppDeploymentException(string2, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    String[] getWebserviceDescriptionNames() throws AppDeploymentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebserviceDescriptionNames for " + this.moduleURIString);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.ws == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebserviceDescriptionNames for " + this.moduleURIString + " The module does not contain a Web Services" + " Deployment Descriptor");
            }
            return new String[0];
        }
        int n = this.ws.getWebServiceDescriptions().size();
        for (int i = 0; i < n; ++i) {
            String string;
            object = (WebServiceDescription)this.ws.getWebServiceDescriptions().get(i);
            if (object == null) {
                string = "For the module \"" + this.moduleURIString + "\" getWebServicesDescription returned " + "null for webservices-description stanza number " + i;
                Tr.error(tc, "WSWS0020E", string);
                throw new AppDeploymentException(string, null);
            }
            string = object.getWebServiceDescriptionName();
            String string2 = null;
            if (string != null) {
                string2 = string;
            }
            if (string == null || string2 == null) {
                Object[] objectArray = new Object[]{this.moduleURIString, new Integer(i)};
                String string3 = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0027E"), objectArray);
                Tr.error(tc, "WSWS0027E", objectArray);
                throw new AppDeploymentException(string3, null);
            }
            arrayList.add(string2);
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            object = "getWSDLFiles for " + this.moduleURIString + ": About to return an array of wsld-file names. " + "The array length is " + stringArray.length + " The array contents are:\n";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + "\t" + stringArray[i];
            }
            Tr.exit(tc, (String)object);
        }
        return stringArray;
    }

    PortComponentInfo[] getPortComponentDataForWebserviceDescriptionElement(String string) throws AppDeploymentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortComponentDataForWebserviceDescriptionElement for " + this.moduleURIString + ": wsdlFile=" + string);
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (this.ws == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPortComponentDataForWebserviceDescriptionElement for " + this.moduleURIString + " The module does not contain a Web Services" + " Deployment Descriptor");
            }
            return new PortComponentInfo[0];
        }
        int n = this.ws.getWebServiceDescriptions().size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string2;
            object = (WebServiceDescription)this.ws.getWebServiceDescriptions().get(i);
            if (object == null) {
                string2 = "For the module \"" + this.moduleURIString + "\" getWebServicesDescription returned " + "null for webservices-description stanza number " + i;
                Tr.error(tc, "WSWS0020E", string2);
                throw new AppDeploymentException(string2, null);
            }
            string2 = object.getWebServiceDescriptionName();
            String string3 = null;
            if (string2 != null) {
                string3 = string2;
            }
            if (string2 == null || string3 == null) {
                Object[] objectArray = new Object[]{this.moduleURIString, new Integer(i)};
                String string4 = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0027E"), objectArray);
                Tr.error(tc, "WSWS0027E", objectArray);
                throw new AppDeploymentException(string4, null);
            }
            if (!string3.equals(string)) continue;
            int n2 = object.getPortComponents().size();
            for (int j = 0; j < n2; ++j) {
                Object object2;
                Object[] objectArray;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                ServiceImplInfo serviceImplInfo = null;
                PortComponent portComponent = (PortComponent)object.getPortComponents().get(j);
                if (portComponent != null) {
                    objectArray = portComponent.getPortComponentName();
                    object2 = portComponent.getWsdlPort();
                    String string8 = null;
                    String string9 = null;
                    if (object2 != null) {
                        string8 = object2.getNamespaceURI();
                        string9 = object2.getLocalPart();
                    }
                    if (objectArray != null) {
                        string5 = objectArray;
                    }
                    if (string8 != null) {
                        string6 = string8;
                    }
                    if (string9 != null) {
                        string7 = string9;
                    }
                    serviceImplInfo = this.getServerImplInfo(portComponent);
                }
                if (string5 == null || string6 == null || string7 == null || serviceImplInfo == null) {
                    objectArray = new Object[]{this.moduleURIString, new Integer(j), new Integer(i)};
                    Tr.error(tc, "WSWS0022E", objectArray);
                    object2 = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0022E"), objectArray);
                    throw new AppDeploymentException((String)object2, null);
                }
                objectArray = new PortComponentInfo(string5, string6, string7, serviceImplInfo.getLinkValue(), serviceImplInfo.getLinkType());
                arrayList.add(objectArray);
            }
        }
        PortComponentInfo[] portComponentInfoArray = arrayList.toArray(new PortComponentInfo[0]);
        if (tc.isEntryEnabled()) {
            object = "getPortComponentDataForWSDL for " + this.moduleURIString + ": About to return an array of PortComponentInfo objects. " + "The array length is " + portComponentInfoArray.length + " The array contents are:\n";
            for (int i = 0; i < portComponentInfoArray.length; ++i) {
                object = (String)object + "\t" + portComponentInfoArray[i];
            }
            Tr.exit(tc, (String)object);
        }
        return portComponentInfoArray;
    }

    boolean isModuleWebServiceEnabled(AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isModuleWebServiceEnabled for module " + this.moduleURIString);
        }
        String string = null;
        if (this.refObject instanceof WebApp) {
            string = "WEB-INF/webservices.xml";
        } else if (this.refObject instanceof EJBJar) {
            string = "META-INF/webservices.xml";
        } else {
            String string2 = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error(tc, "WSWS0020E", string2);
            throw new AppDeploymentException(string2, null);
        }
        ModuleFile moduleFile = this.appDeploymentInfo.getModuleFileForDD(this.refObject);
        boolean bl2 = moduleFile.getLoadStrategy().getContainer().containsFile(string);
        boolean bl3 = bl = bl2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isModuleWebServiceEnabled for module " + this.moduleURIString + " returning " + bl);
        }
        return bl;
    }

    boolean isModuleWebServiceEnabledClient() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isModuleWebServiceEnabledClient for module " + this.moduleURIString);
        }
        String string = null;
        if (this.refObject instanceof WebApp) {
            string = "WEB-INF/ibm-webservicesclient-bnd.xmi";
        } else if (this.refObject instanceof EJBJar) {
            string = "META-INF/ibm-webservicesclient-bnd.xmi";
        } else {
            String string2 = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error(tc, "WSWS0020E", string2);
            throw new AppDeploymentException(string2, null);
        }
        ModuleFile moduleFile = this.appDeploymentInfo.getModuleFileForDD(this.refObject);
        boolean bl = moduleFile.getLoadStrategy().getContainer().containsFile(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isModuleWebServiceEnabledClient for module " + this.moduleURIString + " returning " + bl);
        }
        return bl;
    }

    String getWsdlFileForWebserviceDescriptionName(String string) throws AppDeploymentException {
        if (this.ws == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWsdlFileForWebserviceDescriptionName for " + this.moduleURIString + " The module does not contain a Web Services" + " Deployment Descriptor");
            }
            return null;
        }
        int n = this.ws.getWebServiceDescriptions().size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string2;
            WebServiceDescription webServiceDescription = (WebServiceDescription)this.ws.getWebServiceDescriptions().get(i);
            if (webServiceDescription == null) {
                string2 = "For the module \"" + this.moduleURIString + "\" getWsdlFileForWebserviceDescriptionName returned " + "null for webservices-description stanza number " + i;
                Tr.error(tc, "WSWS0020E", string2);
                throw new AppDeploymentException(string2, null);
            }
            string2 = webServiceDescription.getWebServiceDescriptionName();
            String string3 = null;
            if (string2 != null) {
                string3 = string2;
            }
            if (string2 == null || string3 == null) {
                Object[] objectArray = new Object[]{this.moduleURIString, new Integer(i)};
                String string4 = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0027E"), objectArray);
                Tr.error(tc, "WSWS0027E", objectArray);
                throw new AppDeploymentException(string4, null);
            }
            if (!string3.equals(string)) continue;
            String string5 = webServiceDescription.getWsdlFile();
            String string6 = null;
            if (string5 != null) {
                string6 = string5;
            }
            if (string5 == null || string6 == null) {
                Object[] objectArray = new Object[]{this.moduleURIString, new Integer(i)};
                String string7 = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0021E"), objectArray);
                Tr.error(tc, "WSWS0021E", objectArray);
                throw new AppDeploymentException(string7, null);
            }
            return string6;
        }
        return null;
    }

    private ServiceImplInfo getServerImplInfo(PortComponent portComponent) {
        ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
        if (serviceImplBean == null) {
            return null;
        }
        EJBLink eJBLink = serviceImplBean.getEEJBLink();
        ServletLink servletLink = serviceImplBean.getEServletLink();
        if (eJBLink != null && servletLink != null || eJBLink == null && servletLink == null) {
            return null;
        }
        String string = null;
        ServiceImplInfo serviceImplInfo = null;
        if (eJBLink != null) {
            string = eJBLink.getEjbLink();
            if (string == null) {
                serviceImplInfo = null;
            }
            serviceImplInfo = new ServiceImplInfo(string, 0);
        } else if (servletLink != null) {
            string = servletLink.getServletLink();
            if (string == null) {
                serviceImplInfo = null;
            }
            serviceImplInfo = new ServiceImplInfo(string, 1);
        }
        return serviceImplInfo;
    }
}

