/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.environment.common.ClassPath;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.resource.ResourceManagerFactoryImpl;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.DeployWebService;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.enabler.EndpointEnabler;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class WSDeployTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(WSDeployTask.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String ENABLE_ENDPOINT_OPTION = "enableEndpoint";
    public static final String ENABLE_HTTP_ROUTER_SECURITY_OPTION = "enableHttpRouterSecurity";
    private static final String WEBSERVICES_BUNDLE_NAME = "com.ibm.ws.runtime_6.1.0";

    public WSDeployTask() {
        this.appTaskName = "WSDeployTask";
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages");
    }

    public boolean performTask() throws AdminException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
        EARFile eARFile = installScheduler.getEarFile(false, true);
        Hashtable hashtable = installScheduler.getProperties();
        Object v = hashtable.get("deployws");
        Boolean bl = (Boolean)hashtable.get(ENABLE_ENDPOINT_OPTION);
        Boolean bl2 = (Boolean)hashtable.get(ENABLE_HTTP_ROUTER_SECURITY_OPTION);
        boolean bl3 = DeployUtils.isWebServicesSecurityEnabled(eARFile);
        if (v != null && ((Boolean)v).booleanValue()) {
            ClassPath classPath;
            String string;
            ConsoleEnvironment consoleEnvironment;
            Object object4;
            object3 = AppUtils.getAppTempDeployDir(installScheduler);
            object2 = (String)object3 + File.separator + "ws" + File.separator + AppUtils.getAppDeployFileName(installScheduler.getAppName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "temp deployment ear name", object2);
            }
            object = (Hashtable)hashtable.get("deployws.options");
            String string2 = (String)((Hashtable)object).get("deployws.classpath");
            String string3 = (String)((Hashtable)object).get("deployws.jardirs");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "{classpath, jardirs}", new Object[]{string2, string3});
            }
            DeployModel deployModel = new DeployModel();
            deployModel.setInputFile(installScheduler.getEarPath());
            deployModel.setOutputFile((String)object2);
            deployModel.setCodeGenOnly(false);
            deployModel.setGenDebug(false);
            deployModel.setKeepFiles(false);
            deployModel.setIgnoreErrors_(false);
            ClassPath classPath2 = new ClassPath();
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                classPath2.appendPath(string2);
            }
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                object4 = new StringTokenizer(string3, ";");
                consoleEnvironment = new String[((StringTokenizer)object4).countTokens()];
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    string = ((StringTokenizer)object4).nextToken();
                    classPath = new ClassPath();
                    classPath.appendDir(string);
                    classPath2.appendPath(classPath);
                }
            }
            if ((object4 = this.getWASLibDir()) != null) {
                consoleEnvironment = new ClassPath();
                consoleEnvironment.appendDir((String)object4);
                classPath2.appendPath((ClassPath)consoleEnvironment);
                string = this.getWebServicesJarPath();
                classPath2.appendPath(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not obtain the WAS lib directory");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "class path: ", classPath2);
            }
            deployModel.setClassPath(classPath2);
            consoleEnvironment = new ConsoleEnvironment();
            consoleEnvironment.setProgressMonitor(new ProgressMonitor(){

                public void report(String string) {
                }

                public ProgressMonitor getChildProgressMonitor() {
                    return null;
                }
            });
            string = ResourceManagerFactoryImpl.getInstance();
            string.register("file", consoleEnvironment.getResourceManager());
            classPath = new DeployWebService();
            classPath.setDeployModel(deployModel);
            Status status = classPath.execute((Environment)consoleEnvironment);
            int n = status.getSeverity();
            String string4 = status.getMessage();
            switch (n) {
                case 4: {
                    Tr.error(tc, "WSWS0038E", string4);
                    this.iterateError(status);
                    installScheduler.propagateTaskEvent(this.createNotification("Failed", "WSWS0038E", new String[]{string4}));
                    if (status.getThrowable() != null) {
                        throw new AdminException(status.getThrowable(), string4);
                    }
                    throw new AdminException(string4);
                }
                case 2: {
                    Tr.warning(tc, "WSWS0039W", string4);
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0039W", new String[]{string4}));
                    break;
                }
                case 1: {
                    Tr.info(tc, "WSWS0040I", string4);
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0040I", new String[]{string4}));
                    break;
                }
                case 0: {
                    Tr.audit(tc, "WSWS0041I");
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0041I", null));
                }
            }
            installScheduler.setEarPath((String)object2);
        }
        if (bl != null && bl.booleanValue()) {
            try {
                eARFile = installScheduler.getEarFile();
                object3 = new EndpointEnabler();
                object2 = new Properties();
                if (bl2 != null && bl2.booleanValue()) {
                    ((Properties)object2).setProperty("http.enableRouterSecurity", "true");
                }
                object3.enableEarFile(eARFile, (Properties)object2);
                if (object3.isModified()) {
                    object = new CopyWSDLFilesToRouterWAR(eARFile, this.getResourceBundle());
                    ((CopyWSDLFilesToRouterWAR)object).copyFiles();
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0048I", null));
                    eARFile.save();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.WSDeployTask.performTask", "286", this);
                throw new AdminException(exception);
            }
        }
        if (bl3) {
            object3 = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
            object2 = null;
            if (object3 != null) {
                object2 = ((ResourceBundle)object3).getString("security.wssecurity.appinstall.warning");
            }
            if (object2 == null) {
                object2 = "WSEC0106W: Your application may have Web Services Security enabled. If it does, you must go to the Enterprise Application Management panels to configure the binding information for Web Services Security. The binding information for Web Services Security is not collected during application deployment. If it is not properly configured, your application may not start or be usable.";
            }
            installScheduler.propagateTaskEvent(this.createTranslatedNotification("InProgress", (String)object2, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private String getWASLibDir() {
        String string = System.getProperty("was.install.root");
        if (string == null) {
            string = System.getProperty("user.install.root");
        }
        if (string != null) {
            string = string + "/lib";
        }
        return string;
    }

    private String getWebServicesJarPath() {
        String string = System.getProperty("was.install.root");
        if (string == null) {
            string = System.getProperty("user.install.root");
        }
        if (string != null) {
            string = string + "/plugins/com.ibm.ws.runtime_6.1.0.jar";
        }
        return string;
    }

    private String getJ2eeJarPath() {
        String string = System.getProperty("was.install.root");
        if (string == null) {
            string = System.getProperty("user.install.root");
        }
        if (string != null) {
            string = string + "/lib/j2ee.jar";
        }
        return string;
    }

    private void iterateError(Status status) {
        Status[] statusArray = status.getChildren();
        for (int i = 0; i < statusArray.length; ++i) {
            Status status2 = statusArray[i];
            if (status2 == null) continue;
            String string = status2.getMessage();
            Tr.error(tc, "WSWS0038E", string);
            this.iterateError(status2);
        }
    }
}

