/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.BindingChoices;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.ejb.EJBJar;

public class BindingChoicesHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(BindingChoices.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BindingChoicesHelper.createTask(): taskName=" + string);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "BindingChoicesHelper.createTask(): taskName=" + string);
            }
            return new BindingChoices(appDeploymentController);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.BindingChoicesHelper.createTask", "76", this);
            Tr.error(tc, "WSWS0020E", exception);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createTask: Error instantiating task", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "BindingChoicesHelper.createTask(): returning null:  taskName=" + string);
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BindingChoicesHelper.prepareTask()");
        }
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        appDeploymentTask.setIsSufficientlyDone(true);
        String[][] stringArray = BindingChoicesHelper.createTaskData(appDeploymentInfo, appDeploymentTask);
        if (stringArray == null) {
            appDeploymentTask.setIsTaskDisabled(true);
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = appDeploymentTask.getColumnNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
            stringArray = util.buildTaskData(new Vector(arrayList), appDeploymentTask.getColumnNames().length);
            appDeploymentTask.setTaskData(stringArray);
            return;
        }
        appDeploymentTask.setIsTaskDisabled(false);
        appDeploymentTask.setTaskData(stringArray);
        Map map = this.getDefaultsFromBindingsFile(appDeploymentInfo, appDeploymentTask);
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            String string2 = stringArray[i][1];
            Map map2 = (Map)map.get(string);
            String string3 = (String)map2.get(string2);
            stringArray[i][2] = string3 != null ? string3 : "";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingChoicesHelper.prepareTask(), at the end: the taskData contains\n:" + DeployUtils.taskDataToString(stringArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BindingChoicesHelper.prepareTask()");
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BindingChoicesHelper.completeTask()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingChoicesHelper.completeTask(), at the beginning: the taskData contains\n:" + DeployUtils.taskDataToString(appDeploymentTask.getTaskData()));
        }
        HashMap hashMap = new HashMap();
        String[][] stringArray = appDeploymentTask.getTaskData();
        if (stringArray == null) {
            return;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            object4 = stringArray[i][0];
            object3 = stringArray[i][1];
            object2 = stringArray[i][2];
            if (!hashMap.containsKey(object4)) {
                hashMap.put(object4, new HashMap());
            }
            object = (Map)hashMap.get(object4);
            object.put(object3, object2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingChoicesHelper.completeTask(): the moduleToProtocolAndUserInputMapTo contains\n" + BindingChoicesHelper.moduleToProtocolAndUserInputMapToString(hashMap));
        }
        Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
        object4 = vector.iterator();
        while (object4.hasNext()) {
            String[] stringArray2;
            String string;
            Map map;
            object3 = (EObject)object4.next();
            object2 = new WSDeploymentDescriptorAccessor((EObject)object3, appDeploymentInfo, appDeploymentTask);
            if (!((WSDeploymentDescriptorAccessor)object2).isModuleWebServiceEnabled(appDeploymentTask) || (map = (Map)hashMap.get(string = (stringArray2 = util.separateUriString((String)(object = util.formUriString(appDeploymentInfo, (EObject)object3))))[0])) == null) continue;
            ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD((EObject)object3);
            WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(moduleFile, appDeploymentTask);
            wSBindingsFileAccessor.setDefaultURLInfo(map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BindingChoicesHelper.completeTask()");
        }
    }

    public static String[][] createTaskData(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        String string;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BindingChoicesHelper.createTaskData()");
        }
        HashMap hashMap = new HashMap();
        Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
        Set set = vector.iterator();
        while (set.hasNext()) {
            object4 = (EObject)set.next();
            stringArray = new WSDeploymentDescriptorAccessor((EObject)object4, appDeploymentInfo, appDeploymentTask);
            if (!stringArray.isModuleWebServiceEnabled(appDeploymentTask)) continue;
            String string2 = util.formUriString(appDeploymentInfo, (EObject)object4);
            object3 = util.separateUriString(string2);
            object2 = object3[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingChoicesHelper.createTaskData(): beginning to process module " + (String)object2);
            }
            object = appDeploymentInfo.getModuleFileForDD((EObject)object4);
            string = DeployUtils.createWorkingDirectory(appDeploymentTask);
            BindingChoicesHelper.extractModulesFilesToTmpDir(appDeploymentTask, string2, (ModuleFile)object, string);
            String[] stringArray2 = stringArray.getWebserviceDescriptionNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                Object object5;
                String string3 = stringArray.getWsdlFileForWebserviceDescriptionName(stringArray2[i]);
                BindingChoicesHelper.verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(appDeploymentTask, string2, (ModuleFile)object, string3);
                String string4 = "file:" + string + "/";
                int n = string3.lastIndexOf(47);
                int n2 = string3.lastIndexOf(92);
                int n3 = n > n2 ? n : n2;
                String string5 = string4;
                String string6 = string3;
                if (n3 >= 0 && string3.length() > n3) {
                    object5 = string3.substring(0, n3 + 1);
                    string6 = string3.substring(n3 + 1);
                    string5 = string4 + (String)object5;
                }
                object5 = new WSDLFactoryImpl();
                WSDLReader wSDLReader = ((WSDLFactory)object5).newWSDLReader();
                Definition definition = null;
                try {
                    definition = wSDLReader.readWSDL(null, string5 + string6);
                }
                catch (WSDLException wSDLException) {
                    FFDCFilter.processException(wSDLException, "com.ibm.ws.webservices.deploy.BindingChoicesHelper.createTaskData()", "374");
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0020E"), appDeploymentTask.getName()), null);
                }
                Map map = definition.getServices();
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    Service service = (Service)iterator.next();
                    Map map2 = service.getPorts();
                    Iterator iterator2 = map2.values().iterator();
                    block5: while (iterator2.hasNext()) {
                        Port port = (Port)iterator2.next();
                        Binding binding = port.getBinding();
                        List list = binding.getExtensibilityElements();
                        String string7 = null;
                        Iterator iterator3 = list.iterator();
                        while (iterator3.hasNext()) {
                            Set set2;
                            Object object6;
                            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator3.next();
                            QName qName = extensibilityElement.getElementType();
                            if (!qName.getLocalPart().equals("binding")) continue;
                            string7 = qName.getNamespaceURI();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "BindingChoicesHelper.createTaskData() processing module [" + (String)object2 + "]: wsdl File [" + string3 + "]: service [" + service.getQName() + "]: port [" + port.getName() + "]: binding namespace [" + string7 + "]");
                            }
                            String string8 = null;
                            if (string7.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                                if (extensibilityElement instanceof SOAPBinding && ((String)(object6 = (set2 = (SOAPBinding)extensibilityElement).getTransportURI())).endsWith("jms")) {
                                    string8 = "JMS";
                                }
                            } else if (string7.equals("http://www.ibm.com/ns/2003/06/wsdl/mp/ejb")) {
                                string8 = "EJB";
                            }
                            if (string8 == null) continue block5;
                            set2 = hashMap.keySet();
                            if (!set2.contains(string8)) {
                                hashMap.put(string8, new HashSet());
                            }
                            object6 = (Set)hashMap.get(string8);
                            object6.add(object2);
                            continue block5;
                        }
                    }
                }
            }
            DeployUtils.deleteWorkingDirectory(string);
        }
        set = hashMap.keySet();
        if (set.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "BindingChoicesHelper.createTaskData(): returning null");
            }
            return null;
        }
        object4 = new ArrayList();
        stringArray = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            object4.add(stringArray[i]);
        }
        String[][] stringArray3 = set.iterator();
        while (stringArray3.hasNext()) {
            object3 = (String)stringArray3.next();
            object2 = (Set)hashMap.get(object3);
            object = object2.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                object4.add(string);
                object4.add(object3);
                object4.add("");
                object4.add("no");
                object4.add("");
                object4.add("");
            }
        }
        stringArray3 = util.buildTaskData(new Vector(object4), appDeploymentTask.getColumnNames().length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BindingChoicesHelper.createTaskData(): taskData String[][]:" + DeployUtils.taskDataToString(stringArray3));
        }
        return stringArray3;
    }

    public static void extractModulesFilesToTmpDir(AppDeploymentTask appDeploymentTask, String string, ModuleFile moduleFile, String string2) throws AppDeploymentException {
        try {
            moduleFile.extractTo(string2, 10);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.BindingChoicesHelper.extractModulesFiletToTmpDir", "403", "BindingChoicesHelper");
            Exception exception2 = exception instanceof SaveFailureException ? ((SaveFailureException)exception).getNestedException() : exception;
            Object[] objectArray = new Object[]{string, exception2};
            String string3 = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0005E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingChoicesHelper.extractModulesFilesToTmpDir(): " + string3);
            }
            Tr.error(tc, "WSWS0005E", objectArray);
            throw new AppDeploymentException(string3, exception2);
        }
    }

    public static void verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(AppDeploymentTask appDeploymentTask, String string, ModuleFile moduleFile, String string2) throws AppDeploymentException {
        if (!moduleFile.getLoadStrategy().getContainer().containsFile(string2)) {
            Object[] objectArray = new Object[]{string, string2};
            String string3 = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0016E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingChoicesHelper.verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(): " + string3);
            }
            throw new AppDeploymentException(string3, null);
        }
    }

    private Map getDefaultsFromBindingsFile(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        HashMap hashMap = new HashMap();
        Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
        Object object = vector.iterator();
        while (object.hasNext()) {
            WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor;
            EObject eObject = (EObject)object.next();
            if (!(eObject instanceof EJBJar) || !(wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask)).isModuleWebServiceEnabled(appDeploymentTask)) continue;
            String string = util.formUriString(appDeploymentInfo, eObject);
            String[] stringArray = util.separateUriString(string);
            String string2 = stringArray[0];
            ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
            WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(moduleFile, appDeploymentTask);
            HashMap hashMap2 = new HashMap();
            Map map = wSBindingsFileAccessor.getDefaultURLInfo();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                hashMap2.put(string3, map.get(string3));
            }
            hashMap.put(string2, hashMap2);
        }
        if (tc.isDebugEnabled()) {
            object = new String("BindingChoicesHelper.getDefaultsFromBindingsFile(): returning:\n");
            object = (String)object + BindingChoicesHelper.moduleToProtocolAndUserInputMapToString(hashMap);
            Tr.debug(tc, (String)object);
        }
        return hashMap;
    }

    private static String moduleToProtocolAndUserInputMapToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("\t for module: ").append(string).append("\n");
            Map map2 = (Map)map.get(string);
            Iterator iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = (String)map2.get(string2);
                stringBuffer.append("\t\t ").append(string2).append("->").append(string3).append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

