/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.BoundedBuffer;
import com.ibm.ws.util.ThreadPoolListener;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ThreadPool {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 5000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected int poolSize_ = 0;
    protected int activeThreads = 0;
    protected long keepAliveTime_ = 5000L;
    protected BoundedBuffer requestBuffer;
    protected boolean shutdown_ = false;
    protected final Map threads_;
    protected int threadid = 0;
    protected boolean growasneeded = false;
    protected int threadpriority = 5;
    private static ThreadPoolListener[] ZERO_TP_LISTENERS = new ThreadPoolListener[0];
    protected ThreadPoolListener[] threadPoolListeners;
    protected String name;
    private static Field threadLocalsField;
    static Object[] ZERO_OBJECTS;

    public ThreadPool(int n, int n2, ThreadPoolListener[] threadPoolListenerArray) {
        this(null, n, n2, threadPoolListenerArray);
    }

    public ThreadPool(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public ThreadPool(String string, int n, int n2, ThreadPoolListener[] threadPoolListenerArray) {
        this.name = string;
        this.maximumPoolSize_ = n2;
        this.minimumPoolSize_ = n;
        this.threads_ = new HashMap();
        this.requestBuffer = new BoundedBuffer((n + n2) / 2);
        this.threadPoolListeners = threadPoolListenerArray == null ? ZERO_TP_LISTENERS : (ThreadPoolListener[])threadPoolListenerArray.clone();
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = n;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = n;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long l) {
        this.keepAliveTime_ = l;
    }

    protected void addThread(Runnable runnable) {
        Worker worker = new Worker(runnable, this.threadid++);
        this.threads_.put(worker, worker);
        ++this.poolSize_;
        ++this.activeThreads;
        this.fireThreadCreated(this.poolSize_);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++n2;
                } else {
                    break;
                }
                continue;
            }
        }
        return n2;
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized void interruptAll() {
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread2 = (Thread)iterator.next();
            thread2.interrupt();
        }
    }

    public synchronized boolean awaitTerminationAfterShutdown(long l) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long l2 = l;
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        do {
            this.wait(l2);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((l2 = l - (System.currentTimeMillis() - l3)) > 0L);
        return false;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    protected synchronized void workerDone(Worker worker, boolean bl) {
        this.threads_.remove(worker);
        if (bl) {
            --this.activeThreads;
            --this.poolSize_;
        }
        if (this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        this.fireThreadDestroyed(this.poolSize_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        Runnable runnable = null;
        boolean bl = true;
        while (true) {
            long l;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (bl) {
                    --this.activeThreads;
                }
                if (!(this.poolSize_ <= this.maximumPoolSize_ || this.growasneeded && bl)) {
                    --this.poolSize_;
                    return null;
                }
                l = this.shutdown_ ? 0L : (this.poolSize_ <= this.minimumPoolSize_ ? -1L : this.keepAliveTime_);
            }
            runnable = l >= 0L ? (Runnable)this.requestBuffer.poll(l) : (Runnable)this.requestBuffer.take();
            threadPool = this;
            synchronized (threadPool) {
                if (runnable == null) {
                    runnable = (Runnable)this.requestBuffer.poll(0L);
                }
                if (runnable != null) {
                    ++this.activeThreads;
                    break;
                }
                if (this.poolSize_ > this.minimumPoolSize_) {
                    --this.poolSize_;
                    break;
                }
            }
            bl = false;
        }
        return runnable;
    }

    public void setGrowAsNeeded(boolean bl) {
        this.growasneeded = bl;
    }

    public boolean isGrowAsNeeded() {
        return this.growasneeded;
    }

    public void setThreadPriority(int n) {
        this.threadpriority = n;
    }

    public int getThreadPriority() {
        return this.threadpriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) throws InterruptedException {
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            if (bl2) {
                Thread.yield();
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (!this.shutdown_) {
                    if (!bl) {
                        bl = this.requestBuffer.offer(runnable, 0L);
                    }
                    if (this.growasneeded && !bl && !bl2) {
                        bl2 = true;
                        continue;
                    }
                    int n = this.poolSize_;
                    if (bl && n - this.activeThreads > this.requestBuffer.size()) {
                        return;
                    }
                    if (n < this.maximumPoolSize_ || this.growasneeded) {
                        this.addThread(null);
                    }
                    if (bl) {
                        return;
                    }
                }
            }
            this.requestBuffer.put(runnable);
            bl = true;
        }
    }

    public void addThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n];
        System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n - 1);
        threadPoolListenerArray[n - 1] = threadPoolListener;
        this.threadPoolListeners = threadPoolListenerArray;
    }

    public void removeThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n;
        for (n = 0; n < this.threadPoolListeners.length && this.threadPoolListeners[n] != threadPoolListener; ++n) {
        }
        if (n < this.threadPoolListeners.length) {
            int n2 = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n2];
            System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n);
            System.arraycopy(this.threadPoolListeners, n + 1, threadPoolListenerArray, n, n2 - n - 1);
            this.threadPoolListeners = threadPoolListenerArray;
        }
    }

    protected void fireThreadCreated(int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(this, n);
        }
    }

    protected void fireThreadStarted(int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(this, n, n2);
        }
    }

    protected void fireThreadReturned(int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(this, n, n2);
        }
    }

    protected void fireThreadDestroyed(int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(this, n);
        }
    }

    public synchronized boolean areRequestsOutstanding() {
        if (this.poolSize_ == 0) {
            return false;
        }
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread2 = (Thread)iterator.next();
            if (!thread2.isAlive()) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ZERO_OBJECTS = new Object[0];
    }

    class Worker
    extends Thread {
        protected Runnable firstTask_;
        private String id;
        protected Map threadLocalsMap;
        Object[] wsThreadLocals;

        protected Worker(Runnable runnable, int n) {
            super(ThreadPool.this.name + " : " + n);
            this.id = null;
            this.wsThreadLocals = ZERO_OBJECTS;
            this.firstTask_ = runnable;
            this.setPriority(ThreadPool.this.getThreadPriority());
            this.setDaemon(true);
            this.initThreadLocal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Runnable runnable = this.firstTask_;
            try {
                this.firstTask_ = null;
                if (runnable != null) {
                    ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    try {
                        runnable.run();
                    }
                    finally {
                        ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                        if (this.threadLocalsMap != null) {
                            if (this.threadLocalsMap == Collections.EMPTY_MAP) {
                                this.initThreadLocal();
                            }
                            this.threadLocalsMap.clear();
                        } else {
                            try {
                                threadLocalsField.set(this, null);
                            }
                            catch (IllegalAccessException illegalAccessException) {}
                        }
                    }
                }
                while ((runnable = ThreadPool.this.getTask()) != null) {
                    ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    try {
                        runnable.run();
                    }
                    finally {
                        ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                        if (this.threadLocalsMap != null) {
                            if (this.threadLocalsMap == Collections.EMPTY_MAP) {
                                this.initThreadLocal();
                            }
                            this.threadLocalsMap.clear();
                            continue;
                        }
                        try {
                            threadLocalsField.set(this, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                }
                ThreadPool.this.workerDone(this, runnable != null);
            }
            catch (InterruptedException interruptedException) {
                ThreadPool.this.workerDone(this, runnable != null);
                catch (Throwable throwable) {
                    ThreadPool.this.workerDone(this, runnable != null);
                    throw throwable;
                }
            }
        }

        private void initThreadLocal() {
            try {
                Object object = threadLocalsField.get(this);
                if (object instanceof Map) {
                    this.threadLocalsMap = (Map)object;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

