/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyManagerData;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.TrustManagerData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.KeyManagerHolder;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.TrustManagerHolder;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.core.WSX509KeyManager;
import com.ibm.ws.ssl.core.WSX509TrustManager;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import com.ibm.wsspi.ssl.TrustManagerExtendedInfo;
import java.lang.reflect.Method;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractJSSEProvider
implements JSSEProvider {
    private static final TraceComponent tc = Tr.register(AbstractJSSEProvider.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private static HashMap sslContextCacheJAVAX = new HashMap();
    private static HashMap sslContextCacheJSSE2 = new HashMap();
    private static boolean handlersInitialized = false;
    private static String SSL_SOCKET_FACTORY_NAME = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    private static String SSL_SERVER_SOCKET_FACTORY_NAME = "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory";
    private static String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public AbstractJSSEProvider() {
        block3: {
            if (JSSEProviderFactory.isFipsEnabled()) {
                try {
                    JSSEProviderFactory.initializeFips();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception caught initializing FIPS.", new Object[]{exception});
                }
            }
        }
    }

    public void initializeHandlers(String string) {
        if (string == null) {
            string = "com.ibm.net.ssl.www2.protocol";
        }
        AbstractJSSEProvider.registerPackage(string);
        if (!handlersInitialized) {
            AbstractJSSEProvider.addHandlers(string);
        }
    }

    public String getDefaultSSLSocketFactoryClass(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultSSLSocketFactoryClass: " + string);
        }
        return string;
    }

    public abstract String getSSLProtocolPackageHandler();

    public String[] getCiphersForSecurityLevel(boolean bl, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCiphersForSecurityLevel: ", new Object[]{new Boolean(bl), string});
        }
        String[] stringArray = null;
        if (bl) {
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            stringArray = sSLSocketFactory.getSupportedCipherSuites();
        } else {
            SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            stringArray = sSLServerSocketFactory.getSupportedCipherSuites();
        }
        return SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(stringArray, string);
    }

    public SSLContext getSSLContext(Map map, SSLConfig sSLConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext", new Object[]{map});
        }
        SSLContext sSLContext = (SSLContext)sslContextCacheJAVAX.get(sSLConfig);
        ThreadManager.getInstance().setOutboundConnectionInfo(map);
        if (sSLContext != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLContext -> (from cache)");
            }
            return sSLContext;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContext cache miss, generating new SSLContext.");
        }
        sSLContext = this.getSSLContextInstance(sSLConfig);
        TrustManagerHolder trustManagerHolder = new TrustManagerHolder();
        KeyManagerHolder keyManagerHolder = new KeyManagerHolder();
        this.getKeyTrustManagers(map, sSLConfig, keyManagerHolder, trustManagerHolder);
        TrustManager[] trustManagerArray = trustManagerHolder.getTrustManagers();
        KeyManager[] keyManagerArray = keyManagerHolder.getKeyManagers();
        if (keyManagerArray == null || trustManagerArray == null) {
            throw new com.ibm.websphere.ssl.SSLException("Null trust or key managers.");
        }
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        if (sslContextCacheJAVAX.size() > 100) {
            sslContextCacheJAVAX.clear();
        }
        sslContextCacheJAVAX.put(sSLConfig, sSLContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContext cache size: " + sslContextCacheJAVAX.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContext -> (new)");
        }
        return sSLContext;
    }

    public com.ibm.jsse2.SSLContext getSSLContext_JSSE2(Map map, SSLConfig sSLConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext_JSSE2", new Object[]{map});
        }
        com.ibm.jsse2.SSLContext sSLContext = (com.ibm.jsse2.SSLContext)sslContextCacheJSSE2.get(sSLConfig);
        ThreadManager.getInstance().setOutboundConnectionInfo(map);
        if (sSLContext != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLContext_JSSE2 -> (from cache)");
            }
            return sSLContext;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContextJAVAX cache miss, generating new SSLContext.");
        }
        sSLContext = this.getSSLContextInstanceJSSE2(sSLConfig);
        TrustManagerHolder trustManagerHolder = new TrustManagerHolder();
        KeyManagerHolder keyManagerHolder = new KeyManagerHolder();
        this.getKeyTrustManagers(map, sSLConfig, keyManagerHolder, trustManagerHolder);
        TrustManager[] trustManagerArray = trustManagerHolder.getTrustManagers();
        KeyManager[] keyManagerArray = keyManagerHolder.getKeyManagers();
        if (keyManagerArray == null || trustManagerArray == null) {
            throw new com.ibm.websphere.ssl.SSLException("Null trust or key managers.");
        }
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        if (sslContextCacheJSSE2.size() > 100) {
            sslContextCacheJSSE2.clear();
        }
        sslContextCacheJSSE2.put(sSLConfig, sSLContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSLContextJSSE2 cache size: " + sslContextCacheJSSE2.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContext_JSSE2");
        }
        return sSLContext;
    }

    private void getKeyTrustManagers(Map map, SSLConfig sSLConfig, KeyManagerHolder keyManagerHolder, TrustManagerHolder trustManagerHolder) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyTrustManagers", new Object[]{map, sSLConfig});
        }
        TrustManagerFactory trustManagerFactory = null;
        KeyManagerFactory keyManagerFactory = null;
        Object var7_7 = null;
        KeyStore keyStore = null;
        KeyStore keyStore2 = null;
        String string = "unknown";
        if (map != null) {
            string = (String)map.get("com.ibm.ssl.direction");
        }
        try {
            Object object;
            boolean bl = SSLConfigManager.getInstance().isServerProcess();
            String string2 = this.getSSLContextProperty("com.ibm.ssl.trustStoreName", sSLConfig, bl);
            WSKeyStore wSKeyStore = null;
            if (string2 != null) {
                wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string2);
            }
            String string3 = wSKeyStore != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreProvider", wSKeyStore, bl) : this.getSSLContextProperty("com.ibm.ssl.trustStoreProvider", sSLConfig, bl);
            String string4 = wSKeyStore != null ? this.getSSLContextProperty("com.ibm.ssl.keyStore", wSKeyStore, bl) : this.getSSLContextProperty("com.ibm.ssl.trustStore", sSLConfig, bl);
            String string5 = wSKeyStore != null ? this.getSSLContextProperty("com.ibm.ssl.keyStorePassword", wSKeyStore, bl) : this.getSSLContextProperty("com.ibm.ssl.trustStorePassword", sSLConfig, bl);
            String string6 = wSKeyStore != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreScope", wSKeyStore, bl) : this.getSSLContextProperty("com.ibm.ssl.trustStoreScope", sSLConfig, bl);
            String string7 = wSKeyStore != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreType", wSKeyStore, bl) : this.getSSLContextProperty("com.ibm.ssl.trustStoreType", sSLConfig, bl);
            String string8 = this.getSSLContextProperty("com.ibm.ssl.keyStoreName", sSLConfig, bl);
            WSKeyStore wSKeyStore2 = null;
            if (string8 != null) {
                wSKeyStore2 = KeyStoreManager.getInstance().getKeyStore(string8);
            }
            String string9 = wSKeyStore2 != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreProvider", wSKeyStore2, bl) : this.getSSLContextProperty("com.ibm.ssl.keyStoreProvider", sSLConfig, bl);
            String string10 = wSKeyStore2 != null ? this.getSSLContextProperty("com.ibm.ssl.keyStore", wSKeyStore2, bl) : this.getSSLContextProperty("com.ibm.ssl.keyStore", sSLConfig, bl);
            String string11 = wSKeyStore2 != null ? this.getSSLContextProperty("com.ibm.ssl.keyStorePassword", wSKeyStore2, bl) : this.getSSLContextProperty("com.ibm.ssl.keyStorePassword", sSLConfig, bl);
            String string12 = wSKeyStore2 != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreScope", wSKeyStore2, bl) : this.getSSLContextProperty("com.ibm.ssl.keyStoreScope", sSLConfig, bl);
            String string13 = wSKeyStore2 != null ? this.getSSLContextProperty("com.ibm.ssl.keyStoreType", wSKeyStore2, bl) : this.getSSLContextProperty("com.ibm.ssl.keyStoreType", sSLConfig, bl);
            boolean bl2 = false;
            boolean bl3 = false;
            String string14 = this.getSSLContextProperty("com.ibm.ssl.contextProvider", sSLConfig, bl);
            String string15 = this.getSSLContextProperty("com.ibm.ssl.protocol", sSLConfig, bl);
            String string16 = this.getSSLContextProperty("com.ibm.ssl.keyManager", sSLConfig, bl);
            String string17 = this.getSSLContextProperty("com.ibm.ssl.trustManager", sSLConfig, bl);
            String string18 = this.getSSLContextProperty("com.ibm.ssl.customTrustManagers", sSLConfig, bl);
            String string19 = this.getSSLContextProperty("com.ibm.ssl.customKeyManager", sSLConfig, bl);
            String string20 = this.getSSLContextProperty("com.ibm.ssl.clientAuthentication", sSLConfig, bl);
            String string21 = this.getSSLContextProperty("com.ibm.ssl.keyStoreClientAlias", sSLConfig, bl);
            String string22 = this.getSSLContextProperty("com.ibm.ssl.keyStoreServerAlias", sSLConfig, bl);
            boolean bl4 = this.getSSLContextProperty("com.ibm.ssl.tokenEnabled", sSLConfig, bl).equals("true");
            String string23 = this.getSSLContextProperty("com.ibm.ssl.tokenLibraryFile", sSLConfig, bl);
            String string24 = this.getSSLContextProperty("com.ibm.ssl.tokenPassword", sSLConfig, bl);
            String string25 = this.getSSLContextProperty("com.ibm.ssl.tokenType", sSLConfig, bl);
            String string26 = this.getSSLContextProperty("com.ibm.ssl.tokenSlot", sSLConfig, bl);
            int n = string26 != null ? Integer.valueOf(string26) : 0;
            char[] cArray = null;
            if (string4 != null && string5 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using trust store: " + string4);
                }
                keyStore2 = KeyStoreManager.getInstance().getKeyStore(string2, string7, string3, string4, string5, string6, false, sSLConfig);
            } else if (string23 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No trust store specified, but found hardware crypto");
                }
                if ((object = pkcsStoreList.insert(string25, string23, string24, false, string14, false)) != null) {
                    keyStore2 = ((WSPKCSInKeyStore)object).getTS();
                    trustManagerFactory = ((WSPKCSInKeyStore)object).getTMF();
                    bl2 = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No trust store specified and no hardware crypto defined");
                }
                if (string.equals("inbound") && string20.equals("false")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "trust store permitted to be null since this is inbound and client auth is false");
                    }
                } else {
                    throw new IllegalArgumentException("Invalid trust file name of null");
                }
            }
            if (!bl2) {
                trustManagerFactory = this.getTrustManagerFactoryInstance(string17, string14);
                trustManagerFactory.init(keyStore2);
            }
            if (string10 != null && string11 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using software keystore: " + string10);
                }
                if (string13.equals(string7) && string9.equals(string3) && string10.equals(string4) && string11.equals(string5)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reusing key store from Trust Manager");
                    }
                    keyStore = keyStore2;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating new key store for Key Manager");
                    }
                    keyStore = KeyStoreManager.getInstance().getKeyStore(string8, string13, string9, string10, string11, string12, false, sSLConfig);
                }
                if (string11 != null) {
                    cArray = string11.toCharArray();
                }
            } else if (string23 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No key store specified, but found hardware crypto");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reusing key store from Trust Manager");
                }
                if ((object = pkcsStoreList.insert(string25, string23, string24, true, string14, false)) != null) {
                    keyStore = ((WSPKCSInKeyStore)object).getKS();
                    keyManagerFactory = ((WSPKCSInKeyStore)object).getKMF();
                    bl3 = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No key store specified and no hardware crypto defined");
                }
                throw new IllegalArgumentException("No key store specified and no hardware crypto defined");
            }
            if (!bl3) {
                keyManagerFactory = this.getKeyManagerFactoryInstance(string16, string14);
                try {
                    keyManagerFactory.init(keyStore, cArray);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    throw new UnrecoverableKeyException(unrecoverableKeyException.getMessage() + ": invalid password for file '" + string10 + "'");
                }
            }
            object = null;
            if (string19 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing custom KeyManager.");
                }
                object = this.getCustomKeyManager(keyManagerFactory, keyStore, cArray, sSLConfig, string19);
            }
            WSX509KeyManager wSX509KeyManager = new WSX509KeyManager(keyStore, cArray, keyManagerFactory, sSLConfig, (X509KeyManager)object);
            if (string22 != null && string22.length() > 0) {
                wSX509KeyManager.setServerAlias(string22, n);
            }
            if (string21 != null && string21.length() > 0) {
                wSX509KeyManager.setClientAlias(string21, n);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing WSX509KeyManager.", new Object[]{string22, string21, string26});
            }
            KeyManager[] keyManagerArray = new KeyManager[]{wSX509KeyManager};
            keyManagerHolder.setKeyManagers(keyManagerArray);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            TrustManager[] trustManagerArray2 = null;
            if (string18 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing custom TrustManagers.");
                }
                if ((trustManagerArray2 = this.getTrustManagerArray(trustManagerArray, keyStore2, sSLConfig, string18)) != null) {
                    trustManagerArray = trustManagerArray2;
                }
            }
            WSX509TrustManager wSX509TrustManager = new WSX509TrustManager(trustManagerArray, map, sSLConfig, keyStore2, string4, string5);
            TrustManager[] trustManagerArray3 = new TrustManager[]{wSX509TrustManager};
            trustManagerHolder.setTrustManagers(trustManagerArray3);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during init, " + exception);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider", "458", this);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyTrustManagers");
        }
    }

    private String getSSLContextProperty(String string, Properties properties, boolean bl) {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        } else {
            string2 = System.getProperty(string);
            if (string2 == null) {
                string2 = SSLConfigManager.getInstance().getGlobalProperty(string);
            }
        }
        return string2;
    }

    public X509KeyManager getCustomKeyManager(KeyManagerFactory keyManagerFactory, KeyStore keyStore, char[] cArray, SSLConfig sSLConfig, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomKeyManager", string);
        }
        KeyManagerData keyManagerData = SSLConfigManager.getInstance().getKeyManagerData(string);
        X509KeyManager x509KeyManager = null;
        KeyManagerFactory keyManagerFactory2 = null;
        if (keyManagerData != null) {
            String string2 = keyManagerData.getAlgorithm();
            String string3 = keyManagerData.getKeyManagerClass();
            if (string3 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading custom key manager class: " + string3);
                }
                if ((x509KeyManager = this.loadCustomKeyManager(string3)) != null && x509KeyManager instanceof KeyManagerExtendedInfo) {
                    ((KeyManagerExtendedInfo)((Object)x509KeyManager)).setCustomProperties(keyManagerData.getAdditionalKeyManagerAttrs());
                }
            } else if (string2 != null) {
                String string4 = keyManagerData.getProvider();
                keyManagerFactory2 = this.getKeyManagerFactoryInstance(string2, string4);
                try {
                    keyManagerFactory2.init(keyStore, cArray);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    throw new UnrecoverableKeyException(unrecoverableKeyException.getMessage());
                }
                KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
                if (keyManagerArray != null && keyManagerArray[0] != null) {
                    x509KeyManager = (X509KeyManager)keyManagerArray[0];
                }
                if (x509KeyManager != null && x509KeyManager instanceof KeyManagerExtendedInfo) {
                    ((KeyManagerExtendedInfo)((Object)x509KeyManager)).setCustomProperties(keyManagerData.getAdditionalKeyManagerAttrs());
                }
            }
        } else if (string.indexOf(".") != -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading custom key manager class: " + string);
            }
            x509KeyManager = this.loadCustomKeyManager(string);
        } else {
            String string5 = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
            keyManagerFactory2 = this.getKeyManagerFactoryInstance(string, string5);
            try {
                keyManagerFactory2.init(keyStore, cArray);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new UnrecoverableKeyException(unrecoverableKeyException.getMessage());
            }
            KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
            if (keyManagerArray != null && keyManagerArray[0] != null) {
                x509KeyManager = (X509KeyManager)keyManagerArray[0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomKeyManager");
        }
        return x509KeyManager;
    }

    public TrustManager[] getTrustManagerArray(TrustManager[] trustManagerArray, KeyStore keyStore, SSLConfig sSLConfig, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustManagerArray", string);
        }
        ArrayList<TrustManager> arrayList = new ArrayList<TrustManager>();
        X509TrustManager x509TrustManager = null;
        TrustManagerFactory trustManagerFactory = null;
        for (int i = 0; i < trustManagerArray.length; ++i) {
            arrayList.add(trustManagerArray[i]);
        }
        String[] stringArray = string.split(",");
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                TrustManager[] trustManagerArray2;
                String string2;
                TrustManagerData trustManagerData = SSLConfigManager.getInstance().getTrustManagerData(stringArray[i]);
                if (trustManagerData != null) {
                    string2 = trustManagerData.getAlgorithm();
                    trustManagerArray2 = trustManagerData.getTrustManagerClass();
                    if (trustManagerArray2 != null) {
                        x509TrustManager = this.loadCustomTrustManager((String)trustManagerArray2);
                        if (x509TrustManager != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding custom trust manager \"" + (String)trustManagerArray2 + "\" to the trust manager list.");
                            }
                            arrayList.add(x509TrustManager);
                        }
                        if (x509TrustManager == null || !(x509TrustManager instanceof TrustManagerExtendedInfo)) continue;
                        ((TrustManagerExtendedInfo)((Object)x509TrustManager)).setCustomProperties(trustManagerData.getAdditionalTrustManagerAttrs());
                        continue;
                    }
                    if (string2 == null) continue;
                    String string3 = trustManagerData.getProvider();
                    trustManagerFactory = this.getTrustManagerFactoryInstance(string2, string3);
                    trustManagerFactory.init(keyStore);
                    TrustManager[] trustManagerArray3 = trustManagerFactory.getTrustManagers();
                    if (trustManagerArray3 != null && trustManagerArray3[0] != null) {
                        x509TrustManager = (X509TrustManager)trustManagerArray3[0];
                    }
                    if (x509TrustManager != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding custom trust manager \"" + (String)trustManagerArray2 + "\" to the trust manager list.");
                        }
                        arrayList.add(x509TrustManager);
                    }
                    if (x509TrustManager == null || !(x509TrustManager instanceof TrustManagerExtendedInfo)) continue;
                    ((TrustManagerExtendedInfo)((Object)x509TrustManager)).setCustomProperties(trustManagerData.getAdditionalTrustManagerAttrs());
                    continue;
                }
                if (stringArray[i] != null && stringArray[i].indexOf(".") != -1) {
                    x509TrustManager = this.loadCustomTrustManager(stringArray[i]);
                    if (x509TrustManager == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding custom trust manager \"" + stringArray[i] + "\" to the trust manager list.");
                    }
                    arrayList.add(x509TrustManager);
                    continue;
                }
                if (stringArray[i] == null) continue;
                string2 = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
                trustManagerFactory = this.getTrustManagerFactoryInstance(stringArray[i], string2);
                trustManagerFactory.init(keyStore);
                trustManagerArray2 = trustManagerFactory.getTrustManagers();
                if (trustManagerArray2 != null && trustManagerArray2[0] != null) {
                    x509TrustManager = (X509TrustManager)trustManagerArray2[0];
                }
                if (x509TrustManager == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding custom trust manager \"" + stringArray[i] + "\" to the trust manager list.");
                }
                arrayList.add(x509TrustManager);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustManagerArray");
        }
        return arrayList.toArray(new TrustManager[0]);
    }

    public URLStreamHandler getURLStreamHandler(SSLConfig sSLConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURLStreamHandler");
        }
        URLStreamHandler uRLStreamHandler = null;
        Properties properties = null;
        try {
            properties = ThreadManager.getInstance().getPropertiesOnThread();
            ThreadManager.getInstance().setPropertiesOnThread(sSLConfig);
            uRLStreamHandler = this.getHandler();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURLStreamHandler");
            }
            URLStreamHandler uRLStreamHandler2 = uRLStreamHandler;
            return uRLStreamHandler2;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getURLStreamHandler().", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.getURLStreamHandler", "694", this);
            if (exception instanceof com.ibm.websphere.ssl.SSLException) {
                throw (SSLException)exception;
            }
            throw new com.ibm.websphere.ssl.SSLException(exception);
        }
        finally {
            ThreadManager.getInstance().setPropertiesOnThread(properties);
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(SSLConfig sSLConfig) throws com.ibm.websphere.ssl.SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory");
        }
        try {
            SSLContext sSLContext = this.getSSLContext(null, sSLConfig);
            if (sSLContext != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSSLServerSocketFactory");
                }
                return sSLContext.getServerSocketFactory();
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLServerSocketFactory().", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.getSSLServerSocketFactory", "725", this);
            if (exception instanceof com.ibm.websphere.ssl.SSLException) {
                throw (com.ibm.websphere.ssl.SSLException)exception;
            }
            throw new com.ibm.websphere.ssl.SSLException(exception);
        }
        throw new com.ibm.websphere.ssl.SSLException("SSLContext could not be created to return an SSLServerSocketFactory.");
    }

    public SSLSocketFactory getSSLSocketFactory(Map map, SSLConfig sSLConfig) throws Exception {
        SSLContext sSLContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLSocketFactory", new Object[]{map});
        }
        if ((sSLContext = this.getSSLContext(map, sSLConfig)) != null) {
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLSocketFactory -> " + sSLSocketFactory.getClass().getName());
            }
            return sSLSocketFactory;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLSocketFactory -> NULL");
        }
        throw new com.ibm.websphere.ssl.SSLException("SSLContext could not be created to return an SSLSocketFactory.");
    }

    public SSLContext getSSLContextInstance(SSLConfig sSLConfig) throws com.ibm.websphere.ssl.SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContextInstance");
        }
        final String string = JSSEProviderFactory.isFipsEnabled() ? "IBMJSSE2" : sSLConfig.getProperty("com.ibm.ssl.contextProvider");
        final String string2 = JSSEProviderFactory.isFipsEnabled() ? "TLS" : sSLConfig.getProperty("com.ibm.ssl.protocol");
        String string3 = sSLConfig.getProperty("com.ibm.ssl.alias");
        String string4 = sSLConfig.getProperty("com.ibm.ssl.configURLLoadedFrom");
        SSLContext sSLContext = null;
        if (string2 == null) {
            throw new IllegalArgumentException("Protocol is not specified.");
        }
        try {
            sSLContext = (SSLContext)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                    if (string != null) {
                        return SSLContext.getInstance(string2, string);
                    }
                    return SSLContext.getInstance(string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting SSL context.", new Object[]{exception});
            }
            if (exception instanceof NoSuchAlgorithmException) {
                String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.no.such.algorithm.CWPKI0028E", new Object[]{string2, string3, string4, exception.getMessage()}, "CWPKI0028E: SSL handshake protocol " + string2 + " is not valid.  This protocol is specified in the SSL configuration alias " + string3 + " loaded from SSL configuration file " + string4 + ".  The extended error message is: " + exception.getMessage() + ".");
                Tr.error(tc, string5);
                throw new com.ibm.websphere.ssl.SSLException(string5, exception);
            }
            if (exception instanceof NoSuchProviderException) {
                String string6 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.invalid.context.provider.CWPKI0029E", new Object[]{"IBMJSSE2", string3, string4, exception.getMessage()}, "CWPKI0029E: SSL context provider IBMJSSE2 is not valid.  This provider is specified in the SSL configuration alias " + string3 + " loaded from SSL configuration file " + string4 + ".  The extended error message is: " + exception.getMessage() + ".");
                Tr.error(tc, string6);
                throw new com.ibm.websphere.ssl.SSLException(string6, exception);
            }
            throw new com.ibm.websphere.ssl.SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextInstance");
        }
        return sSLContext;
    }

    public com.ibm.jsse2.SSLContext getSSLContextInstanceJSSE2(SSLConfig sSLConfig) throws com.ibm.websphere.ssl.SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContextInstanceJSSE2");
        }
        com.ibm.jsse2.SSLContext sSLContext = null;
        final String string = JSSEProviderFactory.isFipsEnabled() ? "TLS" : sSLConfig.getProperty("com.ibm.ssl.protocol");
        String string2 = sSLConfig.getProperty("com.ibm.ssl.alias");
        String string3 = sSLConfig.getProperty("com.ibm.ssl.configURLLoadedFrom");
        if (string == null) {
            throw new IllegalArgumentException("Protocol is not specified.");
        }
        try {
            sSLContext = (com.ibm.jsse2.SSLContext)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                    return com.ibm.jsse2.SSLContext.getInstance((String)string, (String)"IBMJSSE2");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting SSL context.", new Object[]{exception});
            }
            if (exception instanceof NoSuchAlgorithmException) {
                String string4 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.no.such.algorithm.CWPKI0028E", new Object[]{string, string2, string3, exception.getMessage()}, "CWPKI0028E: SSL handshake protocol " + string + " is not valid.  This protocol is specified in the SSL configuration alias " + string2 + " loaded from SSL configuration file " + string3 + ".  The extended error message is: " + exception.getMessage() + ".");
                Tr.error(tc, string4);
                throw new com.ibm.websphere.ssl.SSLException(string4, exception);
            }
            if (exception instanceof NoSuchProviderException) {
                String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.invalid.context.provider.CWPKI0029E", new Object[]{"IBMJSSE2", string2, string3, exception.getMessage()}, "CWPKI0029E: SSL context provider IBMJSSE2 is not valid.  This provider is specified in the SSL configuration alias " + string2 + " loaded from SSL configuration file " + string3 + ".  The extended error message is: " + exception.getMessage() + ".");
                Tr.error(tc, string5);
                throw new com.ibm.websphere.ssl.SSLException(string5, exception);
            }
            throw new com.ibm.websphere.ssl.SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextInstanceJSSE2");
        }
        return sSLContext;
    }

    public TrustManagerFactory getTrustManagerFactoryInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] stringArray;
        String string3 = string2;
        if (string.indexOf(PKGNAME_DELIMITER) != -1 && (stringArray = string.split("\\|")) != null && stringArray.length == 2) {
            string = stringArray[0];
            string3 = stringArray[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return TrustManagerFactory.getInstance(" + string + ", " + string3 + ")");
        }
        return TrustManagerFactory.getInstance(string, string3);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] stringArray;
        String string3 = string2;
        if (string.indexOf(PKGNAME_DELIMITER) != -1 && (stringArray = string.split("\\|")) != null && stringArray.length == 2) {
            string = stringArray[0];
            string3 = stringArray[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return KeyManagerFactory.getInstance(" + string + ", " + string2 + ")");
        }
        return KeyManagerFactory.getInstance(string, string2);
    }

    public KeyStore getKeyStoreInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyStore.getInstance(" + string + ", " + string2 + ")");
        }
        if (string2 != null) {
            return KeyStore.getInstance(string, string2);
        }
        return KeyStore.getInstance(string);
    }

    protected static void registerPackage(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerPackage -> " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(URL_HANDLER_PROP);
        if (string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current package list: " + string2);
            }
            object = new StringTokenizer(string2, PKGNAME_DELIMITER);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        object = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ((StringBuffer)object).append(string3);
            if (!iterator.hasNext()) continue;
            ((StringBuffer)object).append('|');
        }
        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction((StringBuffer)object){
            private final /* synthetic */ StringBuffer val$currentPackages;
            {
                this.val$currentPackages = stringBuffer;
            }

            public Object run() {
                System.setProperty(URL_HANDLER_PROP, this.val$currentPackages.toString());
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerPackage");
        }
    }

    public URLStreamHandler getHandler() throws Exception {
        String string = this.getSSLProtocolPackageHandler() + ".https.Handler";
        URLStreamHandler uRLStreamHandler = null;
        try {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            uRLStreamHandler = classLoader != null ? (URLStreamHandler)classLoader.loadClass(string).newInstance() : (URLStreamHandler)Class.forName(string).newInstance();
            return uRLStreamHandler;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.getHandler", "992", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading https stream handler.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.load.https.stream.handler.CWPKI0025E", new Object[]{string, exception.getMessage()});
            throw exception;
        }
    }

    public static void addHandlers(String string) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addHandlers", new Object[]{string});
            }
            if (!handlersInitialized) {
                if (!CertificateManager.getInstance().isKeyCertJarAvailable()) {
                    AbstractJSSEProvider.setDefaultSocketFactories();
                }
                try {
                    if (!AbstractJSSEProvider.queryHandler()) {
                        AbstractJSSEProvider.createStreamHandler();
                    }
                    if (!AbstractJSSEProvider.queryProvider("https")) {
                        String string2 = string + ".https.Handler";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding handler: " + string2);
                        }
                        AbstractJSSEProvider.addProvider("https", string2);
                    }
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        if (!AbstractJSSEProvider.queryProvider("safkeyring")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding handler:  com.ibm.crypto.provider.safkeyring.Handler");
                            }
                            AbstractJSSEProvider.addProvider("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
                        }
                        if (!AbstractJSSEProvider.queryProvider("safkeyringhw")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding handler: com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
                            }
                            AbstractJSSEProvider.addProvider("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
                        }
                    }
                    handlersInitialized = true;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.addHandlers", "1038");
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Unable to set safkeyring stream handler", throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addHandlers");
        }
    }

    public static void setDefaultSocketFactories() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultSocketFactories");
        }
        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.setProperty("ssl.SocketFactory.provider", SSL_SOCKET_FACTORY_NAME);
                Security.setProperty("ssl.ServerSocketFactory.provider", SSL_SERVER_SOCKET_FACTORY_NAME);
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "setDefaultSocketFactories", "The following socket factories have been set: " + SSL_SOCKET_FACTORY_NAME + " and " + SSL_SERVER_SOCKET_FACTORY_NAME);
            Tr.exit(tc, "setDefaultSocketFactories");
        }
    }

    private X509KeyManager loadCustomKeyManager(String string) throws Exception {
        X509KeyManager x509KeyManager = null;
        try {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            if (classLoader != null) {
                try {
                    x509KeyManager = (X509KeyManager)classLoader.loadClass(string).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (x509KeyManager == null) {
                x509KeyManager = (X509KeyManager)Class.forName(string).newInstance();
            }
            return x509KeyManager;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.loadCustomKeyManager", "1096", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading custom KeyManager.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.load.keymanager.error.CWPKI0021E", new Object[]{string, exception.getMessage()});
            throw exception;
        }
    }

    private X509TrustManager loadCustomTrustManager(String string) throws Exception {
        X509TrustManager x509TrustManager = null;
        try {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            if (classLoader != null) {
                try {
                    x509TrustManager = (X509TrustManager)classLoader.loadClass(string).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (x509TrustManager == null) {
                x509TrustManager = (X509TrustManager)Class.forName(string).newInstance();
            }
            return x509TrustManager;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.loadCustomTrustManager", "1133", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading custom TrustManager.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.load.trustmanager.error.CWPKI0020E", new Object[]{string, exception.getMessage()});
            throw exception;
        }
    }

    private static boolean queryHandler() {
        block3: {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method method2 = clazz.getMethod("queryHandler", null);
                Boolean bl = (Boolean)method2.invoke(null, null);
                if (bl != null) {
                    return bl;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.queryHandler", "1167");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception: ", new Object[]{exception});
            }
        }
        return false;
    }

    private static boolean queryProvider(String string) {
        block3: {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method method2 = clazz.getMethod("queryProvider", String.class);
                Boolean bl = (Boolean)method2.invoke(null, string);
                if (bl != null) {
                    return bl;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.queryProvider", "1187");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception: ", new Object[]{exception});
            }
        }
        return false;
    }

    private static void addProvider(String string, String string2) {
        block2: {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method method2 = clazz.getMethod("addProvider", String.class, String.class);
                method2.invoke(null, string, string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.addProvider", "1180");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception: ", new Object[]{exception});
            }
        }
    }

    private static void createStreamHandler() {
        block2: {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.runtime.util.StreamHandlerUtils");
                Method method2 = clazz.getMethod("createStreamHandler", null);
                method2.invoke(null, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.provider.AbstractJSSEProvider.createStreamHandler", "1223");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception: ", new Object[]{exception});
            }
        }
    }

    public static void clearSSLContextCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearSSLContextCache");
        }
        if (sslContextCacheJAVAX != null && sslContextCacheJAVAX.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing standard javax.net.ssl.SSLContext cache.");
            }
            sslContextCacheJAVAX.clear();
        }
        if (sslContextCacheJSSE2 != null && sslContextCacheJSSE2.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing com.ibm.jsse2.SSLContext cache.");
            }
            sslContextCacheJSSE2.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearSSLContextCache");
        }
    }
}

