/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class WSKeyStoreRemotable
extends WSKeyStore {
    private static final TraceComponent tc = Tr.register(WSKeyStoreRemotable.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String name = null;
    private static Map connectorPropMap = null;
    private KeyStore ks = null;

    public WSKeyStoreRemotable(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        super(keyStore);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStoreRemotable(WSKeyStore wSKeyStore) {
        Enumeration<?> enumeration = wSKeyStore.propertyNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                this.setProperty(string, wSKeyStore.getProperty(string));
            }
        }
    }

    public WSKeyStoreRemotable(KeyStoreInfo keyStoreInfo) {
        super(keyStoreInfo);
    }

    public WSKeyStoreRemotable() {
    }

    public Object[] invokeKeyStoreCommand(String string, Object[] objectArray) throws KeyException {
        return this.invokeKeyStoreCommand(string, objectArray, Boolean.FALSE);
    }

    public Object[] invokeKeyStoreCommand(String string, Object[] objectArray, Boolean bl) throws KeyException {
        Object[] objectArray2;
        block38: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeKeyStoreCommand", new Object[]{string});
            }
            objectArray2 = null;
            try {
                Object[] objectArray3;
                Object object;
                String string2 = this.getProperty("com.ibm.ssl.keyStoreHostList");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStoreHostList is " + string2);
                }
                if (string2 != null && !string2.equals("")) {
                    String string3 = "\\|";
                    if (string2.indexOf(44) >= 0) {
                        string3 = ",";
                    }
                    String[] stringArray = string2.split(string3);
                    this.hostInListAreGood(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4;
                        Properties properties;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Locating connector properties for host: " + stringArray[i]);
                        }
                        if ((properties = (Properties)connectorPropMap.get(string4 = stringArray[i].toLowerCase())) != null) {
                            String string5;
                            String[] stringArray2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the node connector props, proceeding to call SSLAdmin MBean using AdminClient.");
                            }
                            if ((stringArray2 = (string5 = properties.getProperty("SOAP HOST|PORT")).split("\\|")) != null && stringArray2.length == 2) {
                                properties.setProperty("host", stringArray2[0]);
                                properties.setProperty("port", stringArray2[1]);
                                properties.setProperty("type", "SOAP");
                                properties.setProperty("isInternal", "true");
                                AdminClient adminClient = AdminClientFactory.createAdminClient(properties);
                                String string6 = properties.getProperty("queryString");
                                ObjectName objectName = new ObjectName(string6);
                                Set set = adminClient.queryNames(objectName, null);
                                ObjectName objectName2 = null;
                                if (set.isEmpty()) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "invokeKeyStoreCommand: SSLAdmin MBean was not found using queryString " + string6);
                                    }
                                    throw new KeyException("Cannot get AdminClient to make remote keystore request.");
                                }
                                objectName2 = (ObjectName)set.iterator().next();
                                if (objectName2 != null) {
                                    String string7 = this.getProperty("com.ibm.ssl.keyStoreName");
                                    objectArray2 = (Object[])adminClient.invoke(objectName2, "invokeRemoteKeyStoreCommand", new Object[]{string7, string, objectArray}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                                    continue;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invokeKeyStoreCommand: SSLAdmin is null.");
                                }
                                throw new KeyException("Cannot get SSLAdmin MBean to make remote keystore request.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "invokeKeyStoreCommand: Host/Port property is null.");
                            }
                            throw new KeyException("Cannot get host and port from connector properties.");
                        }
                        Tr.error(tc, "ssl.cannot.find.node.from.hostlist.CWPKI0039E", new Object[]{string4, this.getProperty("com.ibm.ssl.keyStoreName")});
                    }
                    break block38;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not remote, Calling local KeyStoreCommand via MBean call .");
                }
                if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    return super.invokeKeyStoreCommand(string, objectArray, bl);
                }
                String string8 = this.getProperty("com.ibm.ssl.keyStoreType");
                if (!string8.equals("JCERACFKS")) {
                    return super.invokeKeyStoreCommand(string, objectArray, bl);
                }
                ObjectName objectName = null;
                String string9 = this.getProperty("com.ibm.ssl.keyStoreScope");
                if (string9 != null && !string9.equals("")) {
                    object = new ManagementScopeData(string9);
                    objectArray3 = "WebSphere:type=SSLAdmin";
                    if (((ManagementScopeData)object).getCellName() != null) {
                        objectArray3 = (String)objectArray3 + ",cell=" + ((ManagementScopeData)object).getCellName();
                    }
                    if (((ManagementScopeData)object).getNodeName() != null) {
                        objectArray3 = (String)objectArray3 + ",node=" + ((ManagementScopeData)object).getNodeName();
                    }
                    if (((ManagementScopeData)object).getProcessName() != null) {
                        objectArray3 = (String)objectArray3 + ",process=" + ((ManagementScopeData)object).getProcessName();
                    }
                    objectArray3 = (String)objectArray3 + ",*";
                    objectName = new ObjectName((String)objectArray3);
                } else {
                    objectName = new ObjectName("WebSphere:type=SSLAdmin,*");
                }
                object = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                if (!object.hasNext()) {
                    if (tc.isDebugEnabled()) {
                        Tr.exit(tc, "SSLAdmin MBean not found. ");
                    }
                    return null;
                }
                objectArray3 = null;
                while (object.hasNext()) {
                    String string10 = this.getProperty("com.ibm.ssl.keyStoreName");
                    objectName = (ObjectName)object.next();
                    objectArray2 = (Object[])AdminServiceFactory.getAdminService().invoke(objectName, "invokeRemoteKeyStoreCommand", new Object[]{string10, string, objectArray}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                    if (string.substring(0, 3).equals("set")) {
                        return objectArray2;
                    }
                    if (string.equals("aliases")) {
                        String[] stringArray;
                        String[] stringArray3;
                        Object object2;
                        List<Object> list;
                        List<String> list2;
                        if (objectArray2 == null) continue;
                        if (objectArray3 == null) {
                            list2 = Arrays.asList((String[])objectArray2);
                            list = new ArrayList();
                            object2 = list2.iterator();
                            while (object2.hasNext()) {
                                list.add((String)object2.next());
                            }
                            stringArray3 = list.toArray(new String[list.size()]);
                            objectArray3 = stringArray3;
                            if (!tc.isEntryEnabled()) continue;
                            Tr.exit(tc, "invokeRemoteKeyStoreCommand - merged Aliases list is ", objectArray3);
                            continue;
                        }
                        list2 = Arrays.asList((String[])objectArray3);
                        list = Arrays.asList((String[])objectArray2);
                        object2 = new ArrayList();
                        stringArray3 = list.iterator();
                        Iterator<String> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            object2.add(iterator.next());
                        }
                        while (stringArray3.hasNext()) {
                            stringArray = (String[])stringArray3.next();
                            if (object2.contains(stringArray)) continue;
                            object2.add(stringArray);
                        }
                        stringArray = object2.toArray(new String[object2.size()]);
                        objectArray3 = stringArray;
                        continue;
                    }
                    if (!(string.equals("isKeyEntry") | string.equals("isCertificateEntry") | string.equals("containsAlias") ? objectArray2 != null && (Boolean)objectArray2[0] != false : objectArray2 != null && objectArray2.length > 0 && objectArray2[0] != null)) continue;
                    return objectArray2;
                }
                if (string.equals("aliases")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeRemoteKeyStoreCommand - final merged Aliases list is ", objectArray3);
                    }
                    return objectArray3;
                }
                return objectArray2;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception executing KeyStore method.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.invokeKeyStoreCommand", "460", this);
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeKeyStoreCommand");
        }
        return objectArray2;
    }

    private String printParms(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray == null || objectArray.length == 0) {
            stringBuffer.append("null or empty parms");
            return stringBuffer.toString();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("parm ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(", ");
        }
        String string = stringBuffer.toString();
        if (string.endsWith(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static void setConnectorMap(Map map) {
        connectorPropMap = map;
    }

    private void hostInListAreGood(String[] stringArray) throws KeyException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            Properties properties;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Locating connector properties for host: " + stringArray[i]);
            }
            if ((properties = (Properties)connectorPropMap.get(string = stringArray[i].toLowerCase())) != null) continue;
            String string2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.cannot.find.node.from.hostlist.CWPKI0039E", new Object[]{string, this.getProperty("com.ibm.ssl.keyStoreName")}, "Cannot find Node connector properties for the hostname " + string + " in the hostlist for keystore " + this.getProperty("com.ibm.ssl.keyStoreName") + ".");
            throw new KeyException(string2);
        }
    }
}

