/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.signerCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.signerCertificates.SignerCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RetrieveSignerFromPort
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RetrieveSignerFromPort.class, "SSL", "com.ibm.ws.ssl.commands.signerCertificates");
    private String host = null;
    private Integer port = null;
    private String certificateAlias = null;
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String sslConfigName = null;
    private String sslConfigScopeName = null;
    private ObjectName sslCfgObjName = null;
    private KeyStoreInfo ksInfo = null;

    public RetrieveSignerFromPort(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public RetrieveSignerFromPort(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            Object var6_8 = null;
            this.host = (String)this.getParameter(CommandConstants.HOST);
            this.port = (Integer)this.getParameter(CommandConstants.PORT);
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            this.sslConfigName = (String)this.getParameter(CommandConstants.CONFIG_NAME);
            this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "host=" + this.host + " port=" + this.port + " certificateAlias=" + this.certificateAlias + " sslConfigName=" + this.sslConfigName + " sslConfigScopeName=" + this.sslConfigScopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            if (this.sslConfigName != null) {
                AttributeList attributeList = new AttributeList();
                if (this.sslConfigScopeName == null) {
                    this.sslConfigScopeName = commandHelper.defaultCellScope(objectName3);
                    Tr.debug(tc, "Default cell scopeName: " + this.sslConfigScopeName);
                }
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslConfigName);
                this.sslCfgObjName = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.REPERTOIRE, attributeList, this.sslConfigScopeName);
                if (this.sslCfgObjName == null) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.sslConfigName, this.sslConfigScopeName}, this.sslConfigName + " does not exist within the management scope " + this.sslConfigScopeName);
                    throw new CommandValidationException(string);
                }
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.getSignerAndAddToKeyStore(this.host, this.port, this.sslConfigName, this.ksInfo);
            taskCommandResultImpl.setResult("Signer Certificate Successfully added to keyStore.");
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void getSignerAndAddToKeyStore(String string, Integer n, String string2, KeyStoreInfo keyStoreInfo) throws Exception {
        try {
            Certificate[] certificateArray = SignerCertificateHelper.retrieveSigner(this.host, n, string2);
            if (certificateArray == null) {
                String string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.no.signer.CWPKI0661E", new Object[]{this.host, n}, "Unable to get signer information from hostname \"" + this.host + "\" and port \"" + n + "\".  Verify hostname and port are correct.");
                throw new CommandValidationException(string3);
            }
            this.addCertToKeyStore((X509Certificate)certificateArray[0], this.certificateAlias, keyStoreInfo);
            Session session = this.getConfigSession();
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo.getLocation());
            PersonalCertificateHelper.markSSLConfigChanged(keyStoreInfo, session);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage());
        }
    }

    public void addCertToKeyStore(X509Certificate x509Certificate, String string, KeyStoreInfo keyStoreInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCertToKeyStore");
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String string2 = "containsAlias";
            Object[] objectArray = new Object[]{string};
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
            if (((Boolean)objectArray2[0]).booleanValue()) {
                String string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{string, keyStoreInfo.getName()}, "Alias \"" + string + " already exists in key store \"" + keyStoreInfo.getName() + "\".");
                throw new KeyStoreException(string3);
            }
            string2 = "checkIfSignerAlreadyExists";
            objectArray = new Object[]{x509Certificate};
            objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
            if (((Boolean)objectArray2[0]).booleanValue()) {
                String string4 = "Certificate already exists in key store.  May be under a different alias name.";
                throw new KeyStoreException(string4);
            }
            string2 = "setCertificateEntry";
            objectArray = new Object[]{string, x509Certificate};
            wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCertToKeyStore");
        }
    }
}

