/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListPersonalCertificates
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListPersonalCertificates.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String scopeName = null;

    public ListPersonalCertificates(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListPersonalCertificates(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            taskCommandResultImpl.setResult(this.personalCertificateList(session, configService, this.keyStoreName, this.scopeName));
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public List personalCertificateList(Session session, ConfigService configService, String string, String string2) throws Exception {
        KeyStoreInfo keyStoreInfo = null;
        List list = null;
        try {
            keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, configService, string, string2);
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        try {
            list = this.getPersonalCerts(keyStoreInfo);
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        return list;
    }

    public List getPersonalCerts(KeyStoreInfo keyStoreInfo) throws Exception {
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>();
        AttributeList attributeList = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + locale);
            }
        }
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String string = "aliases";
            Object[] objectArray = null;
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string, objectArray);
            if (objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object[] objectArray3;
                    X509Certificate x509Certificate;
                    string = "isKeyEntry";
                    String string2 = (String)objectArray2[i];
                    objectArray = new Object[]{string2};
                    Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string, objectArray);
                    if (!((Boolean)objectArray4[0]).booleanValue() || (x509Certificate = (X509Certificate)(objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string = "getCertificate", objectArray = new Object[]{string2}))[0]) == null || CertificateRequestHelper.isKeyCertReq(x509Certificate, string2) != null) continue;
                    attributeList = PersonalCertificateHelper.getCertAttrlist(string2, x509Certificate, locale);
                    arrayList.add(attributeList);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Alias list from keystore is null.  The server mbean may not be availible.");
            }
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        return arrayList;
    }
}

