/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyWSCertExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyWSCertExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsCertExpMonitorName = null;
    private Boolean autoReplace = null;
    private Boolean deleteOld = null;
    private Integer daysBeforeNotification = null;
    private String wsScheduleName = null;
    private String wsNotificationName = null;
    private Boolean isEnabled = null;
    private ObjectName wsCertExpMonitorObjName = null;
    private ObjectName wsNotificationObjName = null;
    private ObjectName wsScheduleObjName = null;

    public ModifyWSCertExpMonitor(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifyWSCertExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            Object object;
            AttributeList attributeList;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.wsCertExpMonitorName = (String)this.getParameter(CommandConstants.NAME);
            this.autoReplace = (Boolean)this.getParameter(CommandConstants.AUTO_REPLACE);
            this.deleteOld = (Boolean)this.getParameter(CommandConstants.DELETE_OLD);
            this.daysBeforeNotification = (Integer)this.getParameter(CommandConstants.DAYS_BEFORE_NOTIFICATION);
            this.wsScheduleName = (String)this.getParameter(CommandConstants.WS_SCHEDULE_NAME);
            this.wsNotificationName = (String)this.getParameter(CommandConstants.WS_NOTIFICATION_NAME);
            this.isEnabled = (Boolean)this.getParameter(CommandConstants.IS_ENABLED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsCertExpMonitorName: " + this.wsCertExpMonitorName);
                Tr.debug(tc, "autoReplace: " + (this.autoReplace == null ? "null" : this.autoReplace.toString()));
                Tr.debug(tc, "deleteOld: " + (this.deleteOld == null ? "null" : this.deleteOld.toString()));
                Tr.debug(tc, "daysBeforeNotiflication: " + this.daysBeforeNotification);
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
                Tr.debug(tc, "wsNotificationName: " + this.wsNotificationName);
                Tr.debug(tc, "isEnabled: " + (this.isEnabled == null ? "null" : this.isEnabled.toString()));
            }
            if ((attributeList = (AttributeList)configService.getAttribute(session, objectName, CommandConstants.WS_CERT_EXP_MONITOR)) == null) {
                String string = "No wsCertExpMonitor in the security.xml.";
                throw new CommandValidationException(string);
            }
            Object object2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.NAME);
            if (this.wsCertExpMonitorName.equals(object2)) {
                object = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                if (((ObjectName[])object).length > 0) {
                    this.wsCertExpMonitorObjName = object[0];
                }
            } else {
                String string = "wsCertExpMonitor name not found.";
                throw new CommandValidationException(string);
            }
            object2 = new CommandHelper();
            object = new AttributeList();
            if (this.wsScheduleName != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)object, CommandConstants.NAME, this.wsScheduleName);
                this.wsScheduleObjName = ((CommandHelper)object2).getObjectName(configService, session, objectName, CommandConstants.WS_SCHEDULES, (AttributeList)object, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wsScheduleObjName: " + this.wsScheduleObjName);
                }
            }
            ((ArrayList)object).clear();
            if (this.wsNotificationName != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)object, CommandConstants.NAME, this.wsNotificationName);
                this.wsNotificationObjName = ((CommandHelper)object2).getObjectName(configService, session, objectName, CommandConstants.WS_NOTIFICATIONS, (AttributeList)object, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wsNotificationObjName: " + this.wsNotificationObjName);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.modifyWSCertExpMonitor.validate", "184", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsCertExpMonitorName);
            if (this.autoReplace != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.AUTO_REPLACE, this.autoReplace);
            }
            if (this.deleteOld != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DELETE_OLD, this.deleteOld);
            }
            if (this.daysBeforeNotification != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DAYS_BEFORE_NOTIFICATION, this.daysBeforeNotification);
            }
            if (this.wsScheduleObjName != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName);
            }
            if (this.wsNotificationObjName != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.WS_NOTIFICATION, this.wsNotificationObjName);
            }
            if (this.isEnabled != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.IS_ENABLED, this.isEnabled);
            }
            configService.setAttributes(session, this.wsCertExpMonitorObjName, attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

