/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteWSCertExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteWSCertExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsCertExpMonitorName = null;
    private ObjectName wsCertExpMonitorObjName = null;

    public DeleteWSCertExpMonitor(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteWSCertExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            String string;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.wsCertExpMonitorName = (String)this.getParameter(CommandConstants.NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsCertExpMonitorName: " + this.wsCertExpMonitorName);
            }
            boolean bl = false;
            AttributeList attributeList = (AttributeList)configService.getAttribute(session, objectName, CommandConstants.WS_CERT_EXP_MONITOR);
            if (attributeList != null && this.wsCertExpMonitorName.equals(string = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.NAME))) {
                bl = true;
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                if (objectNameArray.length > 0) {
                    this.wsCertExpMonitorObjName = objectNameArray[0];
                }
            }
            if (!bl) {
                string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0682E", new Object[]{this.wsCertExpMonitorName}, this.wsCertExpMonitorName + "does not exist");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.deleteWSCertExpMonitor.validate", "136");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.wsCertExpMonitorObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

