/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import java.util.ArrayList;
import javax.management.ObjectName;

public class ManagementScopeHelper {
    private static TraceComponent tc = Tr.register(ManagementScopeHelper.class, "SSL", "com.ibm.ws.ssl.commands.ManagementScope");
    private static String[] outbound_endpoints = new String[]{"IIOP", "HTTP", "SIP", "BUS_CLIENT", "BUS_TO_WEBSPHERE_MQ", "BUS_TO_BUS", "LDAP", "ADMIN_IIOP", "ADMIN_SOAP"};

    public static boolean validScopeName(Session session, ConfigService configService, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validScopeName ");
        }
        String string2 = string;
        boolean bl = true;
        Object var5_5 = null;
        ObjectName objectName = null;
        String string3 = null;
        ManagementScopeData managementScopeData = new ManagementScopeData(string2);
        String string4 = managementScopeData.getScopeType();
        String string5 = managementScopeData.getNodeGroupName();
        String string6 = managementScopeData.getNodeName();
        String string7 = managementScopeData.getProcessName();
        String string8 = managementScopeData.getEndPointName();
        String string9 = managementScopeData.getClusterName();
        String string10 = managementScopeData.getCellName();
        if (managementScopeData != null) {
            block30: {
                if (string4.equalsIgnoreCase("endpoint") && (string7 == null || string6 == null)) {
                    bl = false;
                    return bl;
                }
                if (string4.equalsIgnoreCase("server") && string6 == null) {
                    bl = false;
                    return bl;
                }
                try {
                    objectName = configService.resolve(session, "Cell=")[0];
                    if (objectName != null) {
                        string3 = (String)configService.getAttribute(session, objectName, "name");
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "Exception while getting the cell: " + exception.getMessage());
                }
            }
            if (string10 != null) {
                if (string3.equalsIgnoreCase(string10)) {
                    if (string5 != null && !ManagementScopeHelper.getScopeData(session, configService, "NodeGroup", string5)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not a valid nodegroup name in: " + string);
                        }
                        bl = false;
                    }
                    if (string6 != null) {
                        if (!ManagementScopeHelper.getScopeData(session, configService, "Node", string6)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not a valid node name in: " + string);
                            }
                            bl = false;
                        } else if (string7 != null) {
                            if (!ManagementScopeHelper.getServer(session, configService, string6, string7)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Not a valid server name in: " + string);
                                }
                                bl = false;
                            } else if (string8 != null && !ManagementScopeHelper.getEndpoint(session, configService, string6, string8)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Not a valid endpoint name in: " + string);
                                }
                                bl = false;
                            }
                        }
                    }
                    if (string9 != null && !ManagementScopeHelper.getScopeData(session, configService, "ServerCluster", string9)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not a valid cluster name in: " + string);
                        }
                        bl = false;
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid cell name in: " + string);
                    }
                    bl = false;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No cell in scope: " + string);
                }
                bl = false;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not a valid scope format in " + string);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validScopeName");
        }
        return bl;
    }

    private static boolean getScopeData(Session session, ConfigService configService, String string, String string2) {
        boolean bl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getScopeData ");
            }
            bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name :" + string + " and value:" + string2);
            }
            ObjectName[] objectNameArray = null;
            try {
                objectNameArray = configService.resolve(session, string + "=" + string2);
                if (objectNameArray[0] != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ScopeData is : " + objectNameArray[0]);
                    }
                    bl = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ScopeData is not found.");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, string2 + " for " + string + " was not found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeData");
        }
        return bl;
    }

    private static boolean getServer(Session session, ConfigService configService, String string, String string2) {
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServer ");
            }
            ObjectName objectName = null;
            bl = false;
            try {
                ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string);
                objectName = objectNameArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node", objectName);
                }
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName2, null);
                for (int i = 0; i < objectNameArray2.length; ++i) {
                    String string3 = (String)configService.getAttribute(session, objectNameArray2[i], "name");
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverName: " + string2 + " found.");
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception in getServer: " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServer");
        }
        return bl;
    }

    private static boolean getEndpoint(Session session, ConfigService configService, String string, String string2) {
        boolean bl;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEndpoint ");
            }
            ObjectName objectName = null;
            bl = false;
            try {
                int n;
                ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string);
                objectName = objectNameArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node", objectName);
                }
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, ConfigServiceHelper.createObjectName(null, "ServerEntry"), null);
                for (n = 0; n < objectNameArray2.length; ++n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServerEntry", objectNameArray2[n]);
                    }
                    ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectNameArray2[n], "specialEndpoints", false);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ObjectName objectName2 = (ObjectName)arrayList.get(i);
                        String string3 = (String)configService.getAttribute(session, objectName2, "endPointName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EndPoint is", string3);
                        }
                        if (!string3.equalsIgnoreCase(string2)) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getEndpoint");
                        }
                        bl = true;
                        return bl;
                    }
                }
                if (!bl) {
                    for (n = 0; n < outbound_endpoints.length; ++n) {
                        if (!outbound_endpoints[n].equalsIgnoreCase(string2)) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getEndpoint");
                        }
                        bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception in getEndpoint: " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpoint");
        }
        return bl;
    }

    public static boolean checkScopeType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkScopeType ");
        }
        if (string.equalsIgnoreCase("Cell") || string.equalsIgnoreCase("Server") || string.equalsIgnoreCase("NodeGroup") || string.equalsIgnoreCase("Cluster") || string.equalsIgnoreCase("Node") || string.equalsIgnoreCase("EndPoint")) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkScopeType");
        }
        return false;
    }
}

