/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeySet
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeySet.class, "SSL", "com.ibm.ws.ssl.commands.CreateKeySet");
    private String keySetName = null;
    private String aliasPrefix = null;
    private String password = null;
    private Integer maxKeyReferences = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String scopeName = null;
    private Boolean isKeyPair = null;
    private Boolean deleteOldKeys = null;
    private String keyGenerationClass = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName scopeObjName = null;
    private boolean createMgmScope = false;

    public CreateKeySet(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateKeySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = null;
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                }
                this.keySetName = (String)this.getParameter(CommandConstants.NAME);
                this.aliasPrefix = (String)this.getParameter(CommandConstants.ALIAS_PREFIX);
                this.password = (String)this.getParameter(CommandConstants.PASSWORD);
                this.maxKeyReferences = (Integer)this.getParameter(CommandConstants.MAX_KEY_REFERENCES);
                this.deleteOldKeys = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_KEYS);
                this.keyGenerationClass = (String)this.getParameter(CommandConstants.KEY_GENERATION_CLASS);
                this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
                this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
                this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                this.isKeyPair = (Boolean)this.getParameter(CommandConstants.IS_KEY_PAIR);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetName: " + this.keySetName);
                    Tr.debug(tc, "scopeName: " + this.scopeName);
                    Tr.debug(tc, "aliasPrefix: " + this.aliasPrefix);
                    Tr.debug(tc, "password: " + this.password);
                    Tr.debug(tc, "maxKeyReferences: " + this.maxKeyReferences);
                    Tr.debug(tc, "deleteOldKeys: " + (this.deleteOldKeys == null ? "null" : this.deleteOldKeys.toString()));
                    Tr.debug(tc, "keyGenerationClass: " + this.keyGenerationClass);
                    Tr.debug(tc, "keyStoreName: " + this.keyStoreName);
                    Tr.debug(tc, "keyStoreScopeName: " + this.keyStoreScopeName);
                    Tr.debug(tc, "isKeyPair: " + (this.isKeyPair == null ? "null" : this.isKeyPair.toString()));
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.scopeName == null) {
                    this.scopeName = commandHelper.defaultCellScope(objectName3);
                } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(string);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(objectName3);
                }
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
                boolean bl = commandHelper.exists(configService, session, objectName, CommandConstants.KEY_SETS, attributeList, this.scopeName);
                if (bl) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keySetName, this.scopeName}, this.keySetName + " in the management scope " + this.scopeName + " already exists.");
                    throw new CommandValidationException(string);
                }
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                boolean bl2 = commandHelper.exists(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (!bl2) {
                    this.createMgmScope = true;
                } else {
                    this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                }
                if (this.keyStoreName == null) break block19;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
                this.keyStoreObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_STORES, attributeList, this.keyStoreScopeName);
                AttributeList attributeList2 = configService.getAttributes(session, this.keyStoreObjName, null, true);
                if (attributeList2 != null) {
                    boolean bl3 = commandHelper.withInScope(configService, session, attributeList2, this.scopeName);
                    if (!bl3) {
                        String string = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0605E", "Key store is not within Key set management scope.");
                        throw new CommandValidationException(string);
                    }
                    break block19;
                }
                String string = "Attribute list for KeyStore is null.";
                throw new CommandValidationException(string);
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration:", configServiceException.getMessage());
                }
                throw new CommandValidationException(configServiceException.getMessage());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.createKeySet.validate", "217");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration:", exception.getMessage());
                }
                throw new CommandValidationException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        ObjectName objectName = null;
        try {
            Object object;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            if (this.createMgmScope) {
                object = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, ((ManagementScopeData)object).getScopeType());
                this.scopeObjName = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS_PREFIX, this.aliasPrefix);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.PASSWORD, this.password);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MAX_KEY_REFERENCES, this.maxKeyReferences);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DELETE_OLD_KEYS, this.deleteOldKeys);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_GENERATION_CLASS, this.keyGenerationClass);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.IS_KEY_PAIR, this.isKeyPair);
            if (this.keyStoreObjName != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_STORE, this.keyStoreObjName);
            }
            if ((object = configService.createConfigData(session, objectName, CommandConstants.KEY_SETS, null, attributeList)) != null) {
                taskCommandResultImpl.setResult(object);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

