/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceJMXEvent;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.Notification;

public class WorkSpaceManagerMBean
extends RuntimeCollaborator
implements WorkSpaceListener {
    private static final TraceComponent tc = Tr.register(WorkSpaceManagerMBean.class, null, null);
    private Set workspaces = Collections.synchronizedSet(new HashSet());
    protected long notif_num = 0L;
    private static WorkSpaceManagerMBean instance = new WorkSpaceManagerMBean();
    private static boolean active = false;

    private WorkSpaceManagerMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkSpaceManagerMBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkSpaceManagerMBean");
        }
    }

    public Set getWorkSpaces() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpaces");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpaces", this.workspaces);
        }
        return this.workspaces;
    }

    public static WorkSpaceManagerMBean getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    public static boolean isActive() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isActive" + active);
        }
        return active;
    }

    public static void setActive(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActive" + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActive");
        }
        active = bl;
    }

    public void handle(WorkSpaceEvent workSpaceEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle", workSpaceEvent);
        }
        if (workSpaceEvent.getType() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WorkSpace has become invalid");
            }
            WorkSpace workSpace = (WorkSpace)workSpaceEvent.getSource();
            String string = workSpace.getUserName();
            this.workspaces.remove(string);
            WorkSpaceJMXEvent workSpaceJMXEvent = new WorkSpaceJMXEvent(string, 10);
            Notification notification = new Notification("websphere.workspace.event", this.getObjectName(), this.notif_num++);
            notification.setUserData(workSpaceJMXEvent);
            this.sendWorkSpaceNotification(notification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle");
        }
    }

    protected void workSpaceCreated(WorkSpace workSpace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "workSpaceCreated", workSpace);
        }
        workSpace.addWorkSpaceListener(this);
        String string = workSpace.getUserName();
        this.workspaces.add(string);
        WorkSpaceJMXEvent workSpaceJMXEvent = new WorkSpaceJMXEvent(string, 11);
        Notification notification = new Notification("websphere.workspace.event", this.getObjectName(), this.notif_num++);
        notification.setUserData(workSpaceJMXEvent);
        this.sendWorkSpaceNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "workSpaceCreated");
        }
    }

    protected void workSpaceRemoved(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "workSpaceRemoved", string);
        }
        this.workspaces.remove(string);
        WorkSpaceJMXEvent workSpaceJMXEvent = new WorkSpaceJMXEvent(string, 12);
        Notification notification = new Notification("websphere.workspace.event", this.getObjectName(), this.notif_num++);
        notification.setUserData(workSpaceJMXEvent);
        this.sendWorkSpaceNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "workSpaceRemoved");
        }
    }

    private void sendWorkSpaceNotification(Notification notification) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendWorkSpaceNotification", notification);
            }
            try {
                super.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "MBeanException onsendWorkSpaceNotification - ", mBeanException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendWorkSpaceNotification");
        }
    }
}

