/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.ContextUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class ContextUtilImpl
implements ContextUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ContextUtilImpl.class);

    public RepositoryContext move(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "move context: " + repositoryContext.getURI() + ", under context: " + repositoryContext2.getURI());
        }
        RepositoryContext repositoryContext3 = this.copy(repositoryContext, repositoryContext2, repositoryContext.getName());
        ((RepositoryContextImpl)repositoryContext).remove();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "move context returned: " + repositoryContext3.getURI());
        }
        return repositoryContext3;
    }

    public RepositoryContext rename(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rename context: " + repositoryContext.getName() + ", to name: " + string);
        }
        RepositoryContext repositoryContext2 = this.copy(repositoryContext, repositoryContext.getParent(), string);
        ((RepositoryContextImpl)repositoryContext).remove();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rename context returned: " + repositoryContext2.getURI());
        }
        return repositoryContext2;
    }

    public RepositoryContext copy(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy context: " + repositoryContext.getURI() + ", under context: " + repositoryContext2.getURI());
        }
        RepositoryContext repositoryContext3 = this.copy(repositoryContext, repositoryContext2, repositoryContext.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copy context returned: " + repositoryContext3.getURI());
        }
        return repositoryContext3;
    }

    private RepositoryContext copy(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, String string) throws WorkSpaceException {
        RepositoryContext repositoryContext3 = repositoryContext2.create(repositoryContext.getType(), string);
        List list = repositoryContext.getAllList(false);
        for (int i = 0; i < list.size(); ++i) {
            this.copyFile(repositoryContext3, (WorkSpaceFile)list.get(i));
            repositoryContext3.notifyChanged(0, ((WorkSpaceFile)list.get(i)).getName());
        }
        List list2 = repositoryContext.getChildren();
        for (int i = 0; i < list2.size(); ++i) {
            this.copy((RepositoryContext)list2.get(i), repositoryContext3);
        }
        return repositoryContext3;
    }

    private void copyFile(RepositoryContext repositoryContext, WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        String string = workSpaceFile.getURI();
        String string2 = repositoryContext.getURI() + '/' + workSpaceFile.getName();
        try {
            workSpaceFile.getContext().extract(workSpaceFile.getName(), false);
            WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
            FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
            FileAccessorUtil.copyFile(fileAccessor, string, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String string, String string2) throws IOException {
        boolean bl = tc.isDebugEnabled();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            if (bl) {
                Tr.debug(tc, "Reading " + string + " size = " + file.length());
            }
            fileInputStream = new FileInputStream(file);
            if (bl) {
                Tr.debug(tc, "Writing " + string2);
            }
            File file2 = new File(string2);
            fileOutputStream = new FileOutputStream(file2);
            int n = 0;
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray, 0, 4096)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

