/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.Identity;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.authorize.WSPolicyContextHandlerImpl;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.ChallengeReply;
import com.ibm.ws.security.web.DenyReply;
import com.ibm.ws.security.web.PermitReply;
import com.ibm.ws.security.web.RedirectReply;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.TAIChallengeReply;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAccessManager;
import com.ibm.ws.security.web.WebAccessPermission;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebReply;
import com.ibm.ws.security.web.WebResourceCollectionConstraints;
import com.ibm.ws.security.web.WebSecurityConfigException;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import java.io.Serializable;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public abstract class WebCollaborator {
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    public static final String pnWebServer = "$webServer";
    public static final String pnVirtualHost = "$virtualHost";
    public static final String pnRemoteHost = "$remoteHost";
    public static final String pnUri = "$uri";
    public static final String pnMethod = "$method";
    public static final String pnIsSSL = "$isSSL";
    public static final String pnCertificate = "$certificate";
    public static final String pnCipher = "$cipher";
    public static final String pnAuthorization = "Authorization";
    public static final String pnCookie = "Cookie";
    protected static WebReply PERMIT_REPLY = new PermitReply();
    protected static WebReply DENY_AUTHZ_FAILED = new DenyReply("AuthorizationFailed");
    protected static WebReply DENY_AUTHN_FAILED = new DenyReply("AuthenticationFailed");
    protected static WebReply DENY_CONFIG_ERROR = new DenyReply("Configuration error");
    private static final TraceComponent tc = Tr.register(WebCollaborator.class, null, "com.ibm.ejs.resources.security");
    protected boolean securityEnabled;
    protected static WebAuthenticator authenticator = null;
    protected AccessManager authorizer = null;
    protected static ContextManager contextManager;
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int GROUPID = 2;
    protected boolean authDone = false;
    private static Object _lockObject;
    private WebAppCache webCache = null;
    private static boolean custom_auth_mech;
    private static String custom_jaas_config;
    private static TrustAssociationManager taManager;
    private static AuthCache cache;
    private static WSCallbackHandlerFactory cbkFactory;
    private ArrayList adminAppList = null;
    private WebAttributes webSecAttrs;
    private static AuditHandlerImpl auditHandler;
    private static J2EEAuditEventFactory auditFactory;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static String[] jaccHandlerKeyArray;
    private static WSPolicyContextHandlerImpl wpch;
    private static boolean initialized;
    private static boolean persistCred;
    private static boolean alwaysLogin;
    private static final String PERSIST_CRED = "persisting";
    private static final String ALWAYS_LOGIN = "always";

    protected abstract WebAppCache getWebCache();

    public WebCollaborator() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void createAuthorizationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthorizationManager");
        }
        this.authorizer = new WebAccessManager();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthorizationManager");
        }
    }

    public void initialize() throws Exception {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            this.securityEnabled = false;
            try {
                this.securityEnabled = SecurityContext.isSecurityEnabled();
                if (this.securityEnabled && !initialized) {
                    Object object;
                    contextManager = ContextManagerFactory.getInstance();
                    String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                    if (!string.equals("SWAM")) {
                        taManager = TrustAssociationManager.getInstance();
                        cache = AuthCache.getInstance();
                        custom_jaas_config = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
                        String string2 = (String)SecurityConfig.getConfig().getValue("security.enablePluggableAuthentication");
                        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes")) {
                            custom_auth_mech = true;
                        }
                    } else {
                        custom_jaas_config = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
                    }
                    AuditServiceImpl auditServiceImpl = (AuditServiceImpl)AuditServiceImpl.getAuditService();
                    if (auditServiceImpl != null) {
                        auditHandler = (AuditHandlerImpl)auditServiceImpl.newAuditHandler("WAS.security", "WAS.security");
                        if (auditHandler != null) {
                            auditFactory = (J2EEAuditEventFactory)auditHandler.getAuditEventFactory("J2EE");
                        }
                        if (auditFactory != null && !((Class)(object = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory"))).isInstance(auditFactory)) {
                            auditFactory = null;
                        }
                    }
                    authenticator = WebAuthenticator.create(custom_jaas_config, auditHandler, auditFactory);
                    if (SecurityConfig.isJACCEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting the PolicyContextHandlers for JACCfor web.");
                        }
                        jaccHandlerKeyArray = new String[]{"javax.security.auth.Subject.container", "javax.servlet.http.HttpServletRequest"};
                        wpch = WSPolicyContextHandlerImpl.getInstance();
                    }
                    if ((object = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.web.webAuthReq")) != null) {
                        if (((String)object).equalsIgnoreCase(PERSIST_CRED)) {
                            persistCred = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Persist authenticated credential even URI is not protected.");
                            }
                        }
                        if (((String)object).equalsIgnoreCase(ALWAYS_LOGIN)) {
                            alwaysLogin = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "always set credential on executed thread regardless authorization.");
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.initialize", "335", this);
                if (this.securityEnabled) {
                    Tr.error(tc, "security.web.initerror");
                }
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "initialize", new Object[]{exception});
            }
        }
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void addWebApp(String string, String string2, WebApp webApp, DeployedModule deployedModule) throws WebSecurityConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWebApp", new Object[]{string, string2, webApp});
        }
        if (this.webCache == null) {
            this.webCache = this.getWebCache();
        }
        try {
            this.webCache.addWebApp(string, string2, webApp, deployedModule);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.web.WebCollaborator.addWebApp", "371", this);
            WebSecurityConfigException webSecurityConfigException = new WebSecurityConfigException(throwable.getMessage(), null);
            webSecurityConfigException.initCause(throwable);
            if (tc.isEventEnabled()) {
                Tr.debug(tc, "addWebApp excption", webSecurityConfigException);
            }
            throw webSecurityConfigException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWebApp");
        }
    }

    private boolean isAdminApp(String string) {
        return WSAccessManager.checkIfAdminApp(string);
    }

    protected WebReply authorize(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl, String string2) throws WebSecurityException {
        Serializable serializable;
        SecurityRole[] securityRoleArray;
        WebAccessContext webAccessContext;
        String string3;
        String string4;
        String string5;
        ArrayList arrayList;
        Subject subject;
        WebReply webReply;
        block59: {
            WebAttributes webAttributes;
            boolean bl2;
            AuthenticationResult authenticationResult;
            block58: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "authorize", new Object[]{httpServletRequest, httpServletResponse, string, new Boolean(bl), string2});
                }
                if (auditHandler != null) {
                    auditHandler.setAppName(null);
                }
                webReply = null;
                authenticationResult = null;
                subject = null;
                arrayList = null;
                string5 = "???";
                bl2 = false;
                string4 = WebCollaborator.getURI(httpServletRequest);
                if (string4 == null || string4.length() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize: throw WebSecurityException");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 4)) {
                        auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.DENIED, "INVALID_RESOURCE", httpServletRequest.getSession().getId(), null, string4, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.bad.uri.denied.audit", null);
                    }
                    return new DenyReply("Invalid URI passed to Security Collaborator.");
                }
                string3 = httpServletRequest.getMethod();
                webAccessContext = this.webCache.getWebAccessContext(string2, string);
                webAttributes = null;
                if (webAccessContext != null) {
                    webAttributes = webAccessContext.getWebAttributes();
                }
                if (!httpServletRequest.isSecure() && (webReply = this.checkDataConstraints(webAccessContext, string4, string3, httpServletRequest)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize: ", webReply);
                    }
                    return webReply;
                }
                if (webAttributes != null && (persistCred || alwaysLogin)) {
                    bl2 = true;
                    authenticationResult = this.SetAuthenticatedSubjectIfNeeded(webAttributes, httpServletRequest, httpServletResponse);
                    if (alwaysLogin) {
                        webReply = this.handleAlwaysLogin(authenticationResult, webAttributes, string4, string3);
                    }
                    if (webReply != null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "authorize", webReply);
                        }
                        return webReply;
                    }
                }
                if ((webReply = this.validSecAttrs(string, string4, string3, false, string2)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize: ", webReply);
                    }
                    return webReply;
                }
                if (webAccessContext.getEnterpriseAppName() != null) {
                    if (auditHandler != null) {
                        auditHandler.setAppName(webAccessContext.getEnterpriseAppName());
                    }
                } else if (auditHandler != null) {
                    auditHandler.setAppName(webAccessContext.getWebAppName());
                }
                if (this.unsupportedAuthMech(webAttributes)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Digest Authentication Mechanism is used and is not supported : sending DenyReply response");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize: ");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 4)) {
                        auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.DENIED, "UNSUPPORTED_AUTHN_MECH", httpServletRequest.getSession().getId(), null, string4, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.unsupported.auth.mechanism.audit", new Object[]{webAttributes.getChallengeType()});
                    }
                    return new DenyReply("Authentication Failed : DIGEST not supported");
                }
                securityRoleArray = this.getRequiredRoles(webAccessContext, string4, string3);
                if (securityRoleArray == PermissionRoleMap.NO_REQUIRED_ROLES) {
                    webReply = PERMIT_REPLY;
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("No required roles for ");
                        stringBuffer.append(string4).append(".").append(string3);
                        Tr.debug(tc, stringBuffer.toString());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize", webReply);
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string4, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.no.auth.constraint.audit", null);
                    }
                    return webReply;
                }
                boolean bl3 = false;
                bl3 = this.authorizer.isEveryoneGranted(webAccessContext, securityRoleArray);
                if (bl3) {
                    webReply = PERMIT_REPLY;
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("Unprotected URI is ");
                        stringBuffer.append(string4).append(".").append(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, stringBuffer.toString());
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize", webReply);
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string4, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.everyone.audit", null);
                    }
                    return webReply;
                }
                if (tc.isDebugEnabled()) {
                    serializable = new StringBuffer("URI -  ");
                    ((StringBuffer)serializable).append(string4).append(".").append(string3).append(" is protected");
                    Tr.debug(tc, ((StringBuffer)serializable).toString());
                }
                serializable = null;
                try {
                    serializable = contextManager.getCallerSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Saving previous subject " + serializable);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "614", this);
                    if (!tc.isDebugEnabled()) break block58;
                    Tr.debug(tc, "Exception occurred when trying to get initial Caller Subject ");
                }
            }
            if (bl) {
                if (!bl2) {
                    authenticationResult = authenticator.authenticate(webAttributes, httpServletRequest, httpServletResponse);
                }
                if (authenticationResult == null) {
                    Tr.error(tc, "authResult is null");
                    return DENY_AUTHN_FAILED;
                }
                webReply = this.checkAuthStatus(authenticationResult, webAttributes);
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize", webReply);
                    }
                    return webReply;
                }
                subject = authenticationResult.getSubject();
                arrayList = authenticationResult.getCookies();
                string5 = authenticationResult.getUserName();
                if (!bl2) {
                    try {
                        contextManager.setCallerSubject(subject);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "657", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred when setting credentials for 'current'. ");
                        }
                    }
                }
            } else {
                try {
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "670", this);
                    if (!tc.isDebugEnabled()) break block59;
                    Tr.debug(tc, "Invalid credentials retrieved from security  'current'.");
                }
            }
        }
        boolean bl4 = false;
        try {
            this.checkAuthorization(webAccessContext, securityRoleArray, subject);
            bl4 = true;
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, "com.ibm.ws.security.web.WebCollaborator.authorize", "692", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAuthorization() failed, here is the message in the exception: " + accessException.getMessage());
            }
            Tr.audit(tc, "security.web.authz.failed.foruser", new Object[]{string5, string3, string + string4, accessException.getMessage()});
            try {
                contextManager.setCallerSubject((Subject)serializable);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "701", this);
            }
        }
        if (bl4) {
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string4, "WEB", string3, providerName, true, subject, "security.audit.authz.success.audit", null);
            }
        } else if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 4)) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), null, string4, "WEB", string3, providerName, true, subject, "security.audit.authz.denied.audit", null);
        }
        webReply = this.createReply(bl4, string4, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authorize", webReply);
        }
        return webReply;
    }

    protected WebReply authorizeForJACC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl, String string2, String string3) throws WebSecurityException {
        WebResourcePermission webResourcePermission;
        String string4;
        String string5;
        ArrayList arrayList;
        Subject subject;
        String string6;
        String string7;
        WebReply webReply;
        block40: {
            WebUserDataPermission webUserDataPermission;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "authorizeForJACC");
            }
            if (this.isAdminApp(string3)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorizeForJACC: app is an adminApp: " + string3);
                }
                return this.authorize(httpServletRequest, httpServletResponse, string, bl, string3);
            }
            webReply = null;
            string7 = WebCollaborator.getURI(httpServletRequest);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI resolved is: " + string7);
            }
            string6 = httpServletRequest.getMethod();
            String[] stringArray = new String[]{string6};
            boolean bl2 = false;
            subject = null;
            arrayList = null;
            string5 = "???";
            WebAccessContext webAccessContext = this.webCache.getWebAccessContext(string3, string);
            WebAttributes webAttributes = null;
            if (webAccessContext != null) {
                webAttributes = webAccessContext.getWebAttributes();
            }
            AuthenticationResult authenticationResult = null;
            StringBuffer stringBuffer = new StringBuffer(WSAccessManager.getContextID(string3));
            if (stringBuffer == null) {
                throw new WebSecurityException("Cannot get the contextID for application: " + string3, new DenyReply("Cannot get the contextID for application: " + string3));
            }
            stringBuffer.append("/").append(string2);
            string4 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "contextID = " + string4);
            }
            if (!httpServletRequest.isSecure() && !this.checkDataConstraints(string4, httpServletRequest, webUserDataPermission = new WebUserDataPermission(string7, stringArray, null)) && (webReply = this.getRedirectURL(httpServletRequest, string7, string6)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorizeForJACC: ", webReply);
                }
                return webReply;
            }
            if (webAttributes != null && (persistCred || alwaysLogin)) {
                bl2 = true;
                authenticationResult = this.SetAuthenticatedSubjectIfNeeded(webAttributes, httpServletRequest, httpServletResponse);
                if (alwaysLogin) {
                    webReply = this.handleAlwaysLogin(authenticationResult, webAttributes, string7, string6);
                }
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize", webReply);
                    }
                    return webReply;
                }
            }
            if ((webReply = this.validSecAttrs(string, string7, string6, true, string3)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorizeForJACC: ", webReply);
                }
                return webReply;
            }
            if (httpServletRequest.isSecure() && !this.checkDataConstraints(string4, httpServletRequest, webUserDataPermission = new WebUserDataPermission(string7, stringArray, "CONFIDENTIAL"))) {
                webReply = DENY_AUTHZ_FAILED;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebUserDataPermission: " + webUserDataPermission + " is Excluded.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorizeForJACC: ", webReply);
                }
                return webReply;
            }
            boolean bl3 = false;
            webResourcePermission = new WebResourcePermission(string7, stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "preAuthorize: WebResourcePermission = " + webResourcePermission);
            }
            if (bl3 = this.checkJaccAccess(webResourcePermission, string4, httpServletRequest, null, null, string6)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "preAuthorize is true for web: " + string7 + ". exit value true");
                }
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 0)) {
                    auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string7, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.everyone.audit", null);
                }
                return PERMIT_REPLY;
            }
            if (bl) {
                if (!bl2) {
                    authenticationResult = authenticator.authenticate(webAttributes, httpServletRequest, httpServletResponse);
                }
                if (authenticationResult == null) {
                    Tr.error(tc, "authResult is null");
                    return DENY_AUTHN_FAILED;
                }
                webReply = this.checkAuthStatus(authenticationResult, webAttributes);
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorizeForJACC", webReply);
                    }
                    return webReply;
                }
                subject = authenticationResult.getSubject();
                arrayList = authenticationResult.getCookies();
                string5 = authenticationResult.getUserName();
                if (!bl2) {
                    try {
                        contextManager.setCallerSubject(subject);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "905", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred when setting credentials for 'current'. ");
                        }
                    }
                }
            } else {
                try {
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "918", this);
                    if (!tc.isDebugEnabled()) break block40;
                    Tr.debug(tc, "Invalid credentials retrieved from security  'current'.");
                }
            }
        }
        boolean bl4 = false;
        bl4 = this.checkJaccAccess(webResourcePermission, string4, httpServletRequest, subject, string5, string6);
        if (bl4) {
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string7, "WEB", string6, providerName, true, subject, "security.audit.authz.success.audit", null);
            }
        } else if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 4)) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), null, string7, "WEB", string6, providerName, true, subject, "security.audit.authz.denied.audit", null);
        }
        webReply = this.createReply(bl4, string7, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authorizeForJACC", webReply);
        }
        return webReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkJaccAccess(WebResourcePermission webResourcePermission, String string, HttpServletRequest httpServletRequest, Subject subject, String string2, String string3) {
        boolean bl;
        block19: {
            block18: {
                bl = false;
                final HashMap hashMap = new HashMap();
                final Subject subject2 = subject;
                final String string4 = string;
                final WebResourcePermission webResourcePermission2 = webResourcePermission;
                final HttpServletRequest httpServletRequest2 = httpServletRequest;
                Boolean bl2 = new Boolean(false);
                bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws PolicyContextException {
                        Principal[] principalArray;
                        PolicyContext.setContextID(string4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Registering JACC context handlers");
                        }
                        for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                            PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                        }
                        hashMap.put(jaccHandlerKeyArray[0], subject2);
                        hashMap.put(jaccHandlerKeyArray[1], httpServletRequest2);
                        ProtectionDomain protectionDomain = null;
                        if (subject2 != null && subject2.getPrincipals().size() > 0) {
                            principalArray = subject2.getPrincipals().toArray(new Principal[subject2.getPrincipals().size()]);
                            protectionDomain = new ProtectionDomain(SecurityConfig.getNullCodeSource(), null, null, principalArray);
                        } else {
                            protectionDomain = SecurityConfig.getNullProtectionDomain();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting JACC handler data");
                        }
                        PolicyContext.setHandlerData(hashMap);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling JACC implies");
                        }
                        principalArray = new Boolean(Policy.getPolicy().implies(protectionDomain, webResourcePermission2));
                        return principalArray;
                    }
                });
                bl = bl2;
                if (!tc.isDebugEnabled()) break block18;
                if (bl) {
                    if (subject2 == null) {
                        Tr.debug(tc, "hasAccess is true for web during preauthorize");
                    } else {
                        Tr.debug(tc, "hasAccess is true for web during authorize");
                    }
                    break block18;
                }
                if (subject2 == null) {
                    Tr.debug(tc, "hasAccess is false for web during preauthorize");
                    break block18;
                }
                Tr.debug(tc, "hasAccess is false for web during authorize");
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "1036", this);
            }
            break block19;
            catch (Exception exception) {
                try {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "1020", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkAuthorization() failed with the exception: " + exception);
                    }
                    Tr.audit(tc, "security.web.authz.failed.foruser", new Object[]{string2, string3, string, exception.getMessage()});
                }
                catch (Throwable throwable) {
                    try {
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + exception2);
                        }
                        FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.security.web.WebCollaborator.authorize", "1036", this);
                    }
                    throw throwable;
                }
                try {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + exception3);
                    }
                    FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.security.web.WebCollaborator.authorize", "1036", this);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean checkDataConstraints(String string, HttpServletRequest httpServletRequest, WebUserDataPermission webUserDataPermission) throws WebSecurityException {
        boolean bl;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkConstraints");
            }
            Object var4_4 = null;
            bl = false;
            final WebUserDataPermission webUserDataPermission2 = webUserDataPermission;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebUserDataPermission = " + webUserDataPermission2);
            }
            final String string2 = string;
            final HashMap hashMap = new HashMap();
            final HttpServletRequest httpServletRequest2 = httpServletRequest;
            Boolean bl2 = new Boolean(false);
            bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    PolicyContext.setContextID(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                    }
                    hashMap.put(jaccHandlerKeyArray[1], httpServletRequest2);
                    ProtectionDomain protectionDomain = SecurityConfig.getNullProtectionDomain();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData(hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling JACC implies");
                    }
                    Boolean bl = new Boolean(Policy.getPolicy().implies(protectionDomain, webUserDataPermission2));
                    return bl;
                }
            });
            bl = bl2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "1124", this);
            }
            break block20;
            catch (Exception exception) {
                try {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.checkDataConstraints", "1107", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during checkDataConstraints call: " + exception);
                    }
                    Tr.audit(tc, "security.web.authz.checkdataconstraint.failed", new Object[]{string, exception});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + exception2);
                        }
                        FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.security.web.WebCollaborator.authorize", "1124", this);
                    }
                    throw throwable;
                }
                try {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + exception3);
                    }
                    FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.security.web.WebCollaborator.authorize", "1124", this);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug(tc, "hasUserDataJaccAccess is true for web");
            } else {
                Tr.debug(tc, "hasUserDataJaccAccess is false for web");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkConstraints", String.valueOf(bl));
        }
        return bl;
    }

    private boolean isSSLRequired(WebAccessContext webAccessContext, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSSLRequired");
        }
        WebAccessPermission webAccessPermission = new WebAccessPermission(string, string2);
        return webAccessContext.getConstraints().isSSLRequired(webAccessContext, webAccessPermission);
    }

    protected SecurityRole[] getRequiredRoles(WebAccessContext webAccessContext, String string, String string2) {
        WebAccessPermission webAccessPermission = new WebAccessPermission(string, string2);
        return webAccessContext.getConstraints().getRequiredRoles(webAccessContext, webAccessPermission);
    }

    protected void checkAuthorization(WebAccessContext webAccessContext, String string, String string2, Subject subject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization");
            }
            if (auditFactory != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, subject, "security.audit.authz.disabled.audit", null);
            }
            return;
        }
        Object var5_5 = null;
        try {
            this.authorizer.checkAccess(webAccessContext, string, string2, new WSPrincipal(subject));
            if (auditFactory != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, subject, "security.audit.authz.success.audit", null);
            }
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, "com.ibm.ws.security.web.WebCollaborator.checkAuthorization", "1247", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization: throw AccessException");
            }
            if (auditFactory != null && auditFactory.isActive(1, 4)) {
                auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", null, accessException, string, "WEB", string2, providerName, true, subject, "security.audit.authz.denied.audit", null);
            }
            throw accessException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAuthorization");
        }
    }

    protected void checkAuthorization(WebAccessContext webAccessContext, SecurityRole[] securityRoleArray, Subject subject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization");
            }
            return;
        }
        boolean bl = this.authorizer.isGrantedAnyRole(webAccessContext, securityRoleArray, subject);
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization: throw AccessException");
            }
            int n = securityRoleArray.length;
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Authorization failed, Not granted any of the required roles: ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(securityRoleArray[i].getRoleName()).append(" ");
            }
            throw new AccessException(stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAuthorization");
        }
    }

    protected String getCookieValue(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", string2);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCookieValue", "no cookie");
            }
            return null;
        }
        int n = 0;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreElements()) {
            String string5 = stringTokenizer.nextToken();
            String string6 = null;
            String string7 = null;
            int n2 = string5.indexOf("=");
            if (n2 == 0 || n2 == string5.length()) break;
            string6 = string5.substring(0, n2).trim();
            if (!string6.equals(string2) && string6.charAt(0) == '$') continue;
            string7 = string5.substring(n2 + 1);
            if (string7.startsWith("\"") && string7.endsWith("\"")) {
                string7 = string7.substring(1, string7.length() - 1);
            }
            if (string6.charAt(0) == '$') {
                if (string6.equalsIgnoreCase("$Version")) {
                    n = Integer.parseInt(string7);
                    continue;
                }
                if (string6.equalsIgnoreCase("$Domain")) {
                    string3 = string7;
                    continue;
                }
                if (!string6.equalsIgnoreCase("$Path")) continue;
                string4 = string7;
                continue;
            }
            if (!string6.equalsIgnoreCase(string2)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCookieValue", string7);
            }
            return string7;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue: null");
        }
        return null;
    }

    private String getCookieValue(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", string);
        }
        String string2 = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                string2 = cookieArray[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue", string2);
        }
        return string2;
    }

    public boolean isUserInRole(String string, String string2, String string3, HttpServletRequest httpServletRequest) {
        boolean bl;
        block16: {
            if (!SecurityConfig.isJACCEnabled()) {
                return this.isUserInRole(string, string2, string3);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isUserInRoleForJACC");
            }
            Subject subject = null;
            Object var6_6 = null;
            bl = false;
            if (this.securityEnabled) {
                try {
                    WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                    String string4 = string3 + ":" + string2;
                    if (webComponentMetaData == null) break block16;
                    String string5 = ((WebModuleMetaData)webComponentMetaData.getModuleMetaData()).getConfiguration().getModuleName();
                    String string6 = ((WebModuleMetaData)webComponentMetaData.getModuleMetaData()).getApplicationMetaData().getName();
                    if (this.isAdminApp(string6)) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isUserInRoleForJACC: The app is an adminApp: " + string6);
                        }
                        return this.isUserInRole(string, string2, string3);
                    }
                    SecurityMetaData securityMetaData = (SecurityMetaData)webComponentMetaData.getSecurityMetaData();
                    String string7 = null;
                    if (securityMetaData != null) {
                        string7 = securityMetaData.getServletName();
                    }
                    try {
                        bl = string7 != null ? this.checkJaccUserInRolePerm(string7, string, string6, string5, subject, httpServletRequest) : this.checkJaccUserInRolePerm(nullString, string, string6, string5, subject, httpServletRequest);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.isUserInRole", "1487", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception: ", exception);
                        }
                        bl = false;
                    }
                    if (tc.isDebugEnabled()) {
                        if (bl) {
                            Tr.debug(tc, "hasJaccAccess is true for web role ref");
                        } else {
                            Tr.debug(tc, "hasJaccAccess is false for web role ref");
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.isUserInRole", "1502", this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Exception: ", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserInRoleForJACC", String.valueOf(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkJaccUserInRolePerm(String string, String string2, String string3, String string4, Subject subject, HttpServletRequest httpServletRequest) {
        boolean bl;
        block19: {
            bl = false;
            StringBuffer stringBuffer = new StringBuffer(WSAccessManager.getContextID(string3));
            if (stringBuffer == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the contextID for application: " + string3 + ". Returning false.");
                }
                return false;
            }
            stringBuffer.append("/").append(string4);
            String string5 = stringBuffer.toString();
            final WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission(string, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebRoleRefPermission = " + webRoleRefPermission);
            }
            final String string6 = string5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "contextID: " + string6);
            }
            final HashMap hashMap = new HashMap();
            final Subject subject2 = subject;
            final HttpServletRequest httpServletRequest2 = httpServletRequest;
            Boolean bl2 = new Boolean(false);
            bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    Principal[] principalArray;
                    PolicyContext.setContextID(string6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                    }
                    hashMap.put(jaccHandlerKeyArray[0], subject2);
                    hashMap.put(jaccHandlerKeyArray[1], httpServletRequest2);
                    ProtectionDomain protectionDomain = null;
                    if (subject2 != null && subject2.getPrincipals().size() > 0) {
                        principalArray = subject2.getPrincipals().toArray(new Principal[subject2.getPrincipals().size()]);
                        protectionDomain = new ProtectionDomain(SecurityConfig.getNullCodeSource(), null, null, principalArray);
                    } else {
                        protectionDomain = SecurityConfig.getNullProtectionDomain();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData(hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling JACC implies");
                    }
                    principalArray = new Boolean(Policy.getPolicy().implies(protectionDomain, webRoleRefPermission));
                    return principalArray;
                }
            });
            bl = bl2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.authorize", "1600", this);
            }
            break block19;
            catch (Exception exception) {
                try {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security. web.WebCollaborator.checkUserInRole", "1582", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during isUserInRolecall: " + exception);
                    }
                    Tr.audit(tc, "security.web.authz.isuserinrole.failed", new Object[]{string5, exception});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + exception2);
                        }
                        FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.security.web.WebCollaborator.authorize", "1600", this);
                    }
                    throw throwable;
                }
                try {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + exception3);
                    }
                    FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.security.web.WebCollaborator.authorize", "1600", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserInRole", String.valueOf(bl));
        }
        return bl;
    }

    protected static IPrivateRequestAttributes getPrivateAttributes(HttpServletRequest httpServletRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateAttributes");
        }
        IPrivateRequestAttributes iPrivateRequestAttributes = null;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        if (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            iPrivateRequestAttributes = (IPrivateRequestAttributes)httpServletRequest2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateAttributes", new Object[]{iPrivateRequestAttributes});
        }
        return iPrivateRequestAttributes;
    }

    protected static void setPrivateAttributes(HttpServletRequest httpServletRequest, String string, Object object) {
        HttpServletRequest httpServletRequest2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPrivateAttributes", new Object[]{string, object});
        }
        if ((httpServletRequest2 = httpServletRequest) instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            ((IPrivateRequestAttributes)httpServletRequest2).setPrivateAttribute(string, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPrivateAttributes");
        }
    }

    public Principal getUserPrincipal() {
        Serializable serializable;
        String string;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUserPrincipal");
            }
            string = null;
            if (this.securityEnabled) {
                try {
                    serializable = contextManager.getCallerSubject();
                    final WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(serializable);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Caller credential: ", wSCredential);
                    }
                    if (serializable == null || wSCredential.isUnauthenticated()) break block15;
                    if (contextManager.getPlatformHelper().isZOS()) {
                        try {
                            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    PlatformCredential platformCredential = null;
                                    String string = (String)wSCredential.get("com.ibm.wsspi.security.token.caller_principal_class");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Requested principal class is: " + string);
                                    }
                                    if ("com.ibm.ws.security.zos.Principal".equals(string)) {
                                        platformCredential = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                                    }
                                    if (platformCredential != null) {
                                        return platformCredential.getUserId();
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.WebCollaborator", "1729", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception getting CallerPrincipalClass: ", new Object[]{privilegedActionException.getException()});
                            }
                            string = null;
                        }
                    }
                    boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.FullyQualifiedUserName");
                    if (string == null) {
                        string = wSCredential.getSecurityName();
                    }
                    if (bl) {
                        String string2 = wSCredential.getRealmName();
                        if (string2 == null || string2.length() == 0) {
                            string2 = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                        }
                        string = string2 + "/" + string;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.security.web.WebCollaborator", "1758");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception", exception);
                    }
                    string = null;
                }
            }
        }
        serializable = null;
        if (string != null) {
            serializable = new Identity(new String(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserPrincipal", serializable);
        }
        return serializable;
    }

    protected boolean SetUnauthenticatedSubjectIfNeeded(Subject subject, Subject subject2) {
        boolean bl;
        block6: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SetUnauthenticatedSubjectIfNeeded");
            }
            if (subject == null && subject2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoked and received Subject are null, setting it anonymous/unauthenticated.");
                }
                try {
                    contextManager.setInvocationSubject(SubjectHelper.createUnauthenticatedSubject());
                    bl = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.SetUnauthenticatedSubjectIfNeeded", "1793", this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "setUnauthenticated Subject threw an unexpected exception" + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SetUnauthenticatedSubjectIfNeeded:" + bl);
        }
        return bl;
    }

    private int getHTTPSPort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHTTPSPort: " + n);
        }
        ArrayList arrayList = null;
        String string = null;
        int n2 = -1;
        Map map = (Map)SecurityConfig.getConfig().getValue("host.virtualhosts");
        List list = (List)SecurityConfig.getConfig().getValue("webcontainer.transports");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            arrayList = (ArrayList)map.get(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (tc.isDebugEnabled() && string2 != null) {
                    Tr.debug(tc, "Port " + string2 + " in virtual host " + string);
                }
                n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (string2 == null || n2 != n) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found HTTP port " + string2 + " in virtual host " + string);
                }
                for (int j = 0; j < list.size(); ++j) {
                    Integer n3 = (Integer)list.get(j);
                    if (n3 == null) continue;
                    int n4 = n3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking if port " + n4 + " is in the same virtual host.");
                    }
                    for (int k = 0; k < arrayList.size(); ++k) {
                        String string3 = (String)arrayList.get(k);
                        n2 = -1;
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (string3 != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Port " + n2 + " in virtual host " + string);
                        }
                        if (string3 == null || n2 != n4) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "Found HTTPS port " + n4 + " in virtual host " + string);
                        }
                        return n4;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHTTPSPort: SSL port not found");
        }
        return -1;
    }

    protected boolean unsupportedAuthMech(WebAttributes webAttributes) {
        String string = webAttributes.getChallengeType();
        return string.equalsIgnoreCase("DIGEST");
    }

    public boolean isUserInRole(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserInRole");
        }
        Subject subject = null;
        WebAccessContext webAccessContext = null;
        if (this.securityEnabled) {
            Object object;
            block19: {
                try {
                    object = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                    String string4 = string3 + ":" + string2;
                    String string5 = null;
                    if (object != null) {
                        string5 = ((WebModuleMetaData)object.getModuleMetaData()).getApplicationMetaData().getName();
                    }
                    if ((webAccessContext = this.webCache.getWebAccessContext(string5, string4)) == null) {
                        return false;
                    }
                    if (object != null) {
                        String string6 = ((WebModuleMetaData)object.getModuleMetaData()).getConfiguration().getModuleName();
                        SecurityMetaData securityMetaData = (SecurityMetaData)object.getSecurityMetaData();
                        if (securityMetaData != null) {
                            String string7 = securityMetaData.getServletName();
                            EList eList = securityMetaData.getSecurityRoleRefs();
                            Iterator iterator = eList.iterator();
                            while (iterator.hasNext()) {
                                SecurityRoleRef securityRoleRef = (SecurityRoleRef)iterator.next();
                                String string8 = securityRoleRef.getName();
                                if (!string8.equals(string)) continue;
                                String string9 = securityRoleRef.getLink();
                                SecurityRole securityRole = WCCMHelper.createSecurityRole(string9, string9);
                                return this.authorizer.isGrantedRole(webAccessContext, securityRole, new WSPrincipal(subject));
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "In isUserInRole, security metadata is null");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In isUserInRole, WebComponentMetaData is null");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.isUserInRole", "2008", this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "Exception: ", exception);
                }
            }
            object = WCCMHelper.createSecurityRole(string, string);
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found security role named " + string);
                }
                if (webAccessContext != null && subject != null) {
                    return this.authorizer.isGrantedRole(webAccessContext, (SecurityRole)object, new WSPrincipal(subject));
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find security role named " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserInRole");
        }
        return false;
    }

    protected WebReply checkDataConstraints(WebAccessContext webAccessContext, String string, String string2, HttpServletRequest httpServletRequest) throws WebSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkConstraints");
        }
        WebReply webReply = null;
        if (this.isSSLRequired(webAccessContext, string, string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request should be over SSL to access the resource. Redirecting to HTTPS...");
            }
            webReply = this.getRedirectURL(httpServletRequest, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkConstraints", webReply);
        }
        return webReply;
    }

    static String getURI(HttpServletRequest httpServletRequest) {
        int n;
        String string = httpServletRequest.getServletPath();
        String string2 = httpServletRequest.getPathInfo();
        if (string2 != null) {
            string = string.concat(string2);
        }
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "URI requested: " + string);
        }
        if (string != null && (n = (string = WSUtil.resolveURI(string)).indexOf(";")) != -1) {
            string = string.substring(0, n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "URI returned: " + string);
        }
        return string;
    }

    private boolean checkValidURI(String string) {
        return string != null && string.length() != 0;
    }

    private WebReply unprotectedSpecialURI(WebAttributes webAttributes, String string, String string2) {
        if (webAttributes != null) {
            String string3 = null;
            String string4 = null;
            if (webAttributes.getChallengeType().equals("FORM") && (string3 = webAttributes.getLoginURL()) != null && (string4 = webAttributes.getReloginURL()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " We have a custom login or error page request, web app login URL:[" + string3 + "], errorPage URL:[" + string4 + "], and the requested URI:[" + string + "]");
                }
                if (string3.equals(string) || string4.equals(string)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize, login or error page[" + string + "]  requested, permit: ", PERMIT_REPLY);
                    }
                    if (auditFactory != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, "security.audit.service.login.audit", null);
                    }
                    return PERMIT_REPLY;
                }
                if (string != null && string.equals("/j_security_check") && string2 != null && string2.equals("POST")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize, login or error page[" + string + "]  requested, permit: ", PERMIT_REPLY);
                    }
                    if (auditFactory != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, "security.audit.service.login.audit", null);
                    }
                    return PERMIT_REPLY;
                }
            }
        }
        return null;
    }

    private WebReply handleAlwaysLogin(AuthenticationResult authenticationResult, WebAttributes webAttributes, String string, String string2) {
        WebReply webReply = this.unprotectedSpecialURI(webAttributes, string, string2);
        if (webReply != null) {
            return webReply;
        }
        if (authenticationResult == null) {
            Tr.error(tc, "authResult is null");
            return DENY_AUTHN_FAILED;
        }
        webReply = this.checkAuthStatus(authenticationResult, webAttributes);
        return webReply;
    }

    private AuthenticationResult SetAuthenticatedSubjectIfNeeded(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult;
        block3: {
            authenticationResult = authenticator.authenticate(webAttributes, httpServletRequest, httpServletResponse);
            if (authenticationResult != null && authenticationResult.getStatus() == 1) {
                try {
                    contextManager.setCallerSubject(authenticationResult.getSubject());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebCollaborator.SetAuthenticatedSubjectIfNeeded", "599", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception occurred when setting credentials for 'current'. ");
                }
            }
        }
        return authenticationResult;
    }

    private WebReply validSecAttrs(String string, String string2, String string3, boolean bl, String string4) {
        WebReply webReply = null;
        WebAccessContext webAccessContext = this.webCache.getWebAccessContext(string4, string);
        if (webAccessContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Web App config found.");
            }
            StringBuffer stringBuffer = new StringBuffer("Cannot create a web security context for this request.");
            webReply = new DenyReply(stringBuffer.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authorize", webReply);
            }
            if (auditFactory != null && auditFactory.isActive(3, 4)) {
                auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.DENIED, "CONTEXT_NONEXIST", null, null, string2, "WEB", string3, providerName, true, "security.audit.service.no.context.audit", null);
            }
            return webReply;
        }
        if (webAccessContext.getEnterpriseAppName() != null) {
            if (auditHandler != null) {
                auditHandler.setAppName(webAccessContext.getEnterpriseAppName());
            }
        } else if (auditHandler != null) {
            auditHandler.setAppName(webAccessContext.getWebAppName());
        }
        WebAttributes webAttributes = webAccessContext.getWebAttributes();
        if (!bl) {
            if (webAttributes == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No WebAttributes for context root = ");
                    stringBuffer.append(string);
                    Tr.debug(tc, stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorize: ", PERMIT_REPLY);
                }
                if (auditFactory != null && auditFactory.isActive(3, 0)) {
                    auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string2, "WEB", string3, providerName, true, "security.audit.service.no.webattrs.audit", null);
                }
                return PERMIT_REPLY;
            }
            WebResourceCollectionConstraints webResourceCollectionConstraints = webAccessContext.getConstraints().getConstraints(webAccessContext, string2, string3);
            if (webResourceCollectionConstraints == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No WebConstraints for URI = ");
                    stringBuffer.append(string2);
                    stringBuffer.append(", method = ");
                    stringBuffer.append(string3);
                    Tr.debug(tc, stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorize: ", PERMIT_REPLY);
                }
                if (auditFactory != null && auditFactory.isActive(3, 0)) {
                    auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string2, "WEB", string3, providerName, true, "security.audit.service.no.security.audit", null);
                }
                return PERMIT_REPLY;
            }
        }
        webReply = this.unprotectedSpecialURI(webAttributes, string2, string3);
        return webReply;
    }

    private WebReply checkAuthStatus(AuthenticationResult authenticationResult, WebAttributes webAttributes) {
        WebReply webReply = null;
        switch (authenticationResult.getStatus()) {
            case 2: {
                webReply = DENY_AUTHN_FAILED;
                Tr.audit(tc, "security.authn.failed", new Object[]{authenticationResult.getReason()});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", webReply);
                }
                return webReply;
            }
            case 3: {
                webReply = new ChallengeReply(webAttributes.getRealm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authentication failed - sending a 401");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", webReply);
                }
                return webReply;
            }
            case 5: {
                webReply = new TAIChallengeReply(authenticationResult.getTAIChallengeCode());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TAI authentication challenge - sending " + authenticationResult.getTAIChallengeCode());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", webReply);
                }
                return webReply;
            }
            case 4: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "redirecting to another url");
                }
                webReply = authenticationResult.getCookies() != null ? new RedirectReply(authenticationResult.getRedirectURL(), authenticationResult.getCookies()) : new RedirectReply(authenticationResult.getRedirectURL());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", webReply);
                }
                return webReply;
            }
            case 0: 
            case 6: {
                Tr.audit(tc, "security.authn.failed", new Object[]{new Integer(authenticationResult.getStatus())});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication failed. Status: " + authenticationResult.getStatus());
                }
                webReply = DENY_AUTHN_FAILED;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", webReply);
                }
                return webReply;
            }
        }
        return webReply;
    }

    private WebReply createReply(boolean bl, String string, ArrayList arrayList) {
        WebReply webReply = null;
        if (bl) {
            webReply = new PermitReply(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization check for uri: " + string + " succeeded. ");
            }
        } else {
            webReply = DENY_AUTHZ_FAILED;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization check for uri: " + string + " failed. ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReply", webReply);
        }
        return webReply;
    }

    private WebReply getRedirectURL(HttpServletRequest httpServletRequest, String string, String string2) {
        int n;
        String string3;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRedirectURL");
        }
        StringBuffer stringBuffer = HttpUtils.getRequestURL(httpServletRequest);
        String string4 = stringBuffer.toString();
        int n3 = string4.indexOf(47);
        if ((n2 = (string3 = string4.substring(n3 += 2, n = string4.indexOf(47, n3))).lastIndexOf(58)) != -1) {
            String string5 = string3.substring(n2 + 1);
            int n4 = Integer.parseInt(string5);
            int n5 = this.getHTTPSPort(n4);
            String string6 = Integer.toString(n5);
            stringBuffer.replace(n3 + n2 + 1, n, string6);
        }
        stringBuffer.replace(0, 4, "https");
        if (httpServletRequest.getQueryString() != null) {
            stringBuffer.append("?");
            stringBuffer.append(httpServletRequest.getQueryString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Redirected to " + stringBuffer.toString());
        }
        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 5)) {
            auditFactory.sendAccessAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DATA_REDIRECT", httpServletRequest.getSession().getId(), null, string, "WEB", string2, providerName, true, "security.audit.service.secure.redirect.audit", new Object[]{stringBuffer.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRedirectURL", stringBuffer.toString());
        }
        return new RedirectReply(stringBuffer.toString());
    }

    static {
        _lockObject = new Object();
        custom_auth_mech = false;
        custom_jaas_config = null;
        taManager = null;
        cache = null;
        cbkFactory = null;
        auditHandler = null;
        auditFactory = null;
        initialized = false;
        persistCred = false;
        alwaysLogin = false;
    }
}

