/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereBaseTrustAssociationInterceptor;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.web.TAIWrapper;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public final class TrustAssociationManager {
    public static final String TRUSTED_SERVER_TYPE_WEBSEAL36 = "WebSeal3.6";
    private static TraceComponent tc = Tr.register(TrustAssociationManager.class, null, "com.ibm.ejs.resources.security");
    private static TrustAssociationManager myInstance = null;
    private static String firstPassList = "";
    private TAIWrapper[] interceptors = null;
    private int interceptorCount = 0;
    private boolean isTrustAssociationEnabled = false;

    public static void create() {
        if (myInstance == null) {
            myInstance = new TrustAssociationManager();
        }
    }

    public static TrustAssociationManager getInstance() {
        return myInstance;
    }

    private TrustAssociationManager() {
        this.initialize();
    }

    TAIWrapper getInterceptor(HttpServletRequest httpServletRequest, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterceptor()");
        }
        for (int i = 0; i < this.interceptorCount; ++i) {
            TAIWrapper tAIWrapper = this.interceptors[i];
            if (bl && firstPassList.indexOf(tAIWrapper.getClassName()) != -1 || !bl && firstPassList.indexOf(tAIWrapper.getClassName()) == -1) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Check if target interceptor [" + i + "]: " + tAIWrapper.getName() + " ...");
                    }
                    if (tAIWrapper.isTargetInterceptor(httpServletRequest)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found interceptor: " + tAIWrapper.getName());
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getInterceptor()");
                        }
                        return tAIWrapper;
                    }
                }
                catch (WebTrustAssociationException webTrustAssociationException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "interceptor " + tAIWrapper.getName() + " throws exception", webTrustAssociationException);
                    }
                    FFDCFilter.processException(webTrustAssociationException, "com.ibm.ws.security.web.TrustAssociationManager.getInterceptor", "93");
                }
                continue;
            }
            if (!tc.isEntryEnabled()) continue;
            Tr.debug(tc, "Interceptor " + tAIWrapper.getClassName() + " skipped.  First pass list = '" + firstPassList + "' First pass: " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterceptor");
        }
        return null;
    }

    boolean isTrustAssociationEnabled() {
        return this.isTrustAssociationEnabled;
    }

    int getInterceptorsCount() {
        return this.interceptorCount;
    }

    public void cleanTAInterceptors() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanTAInterceptor");
        }
        for (int i = 0; i < this.interceptorCount; ++i) {
            this.interceptors[i].cleanup();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanTAInterceptor");
        }
    }

    private void initialize() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if ((string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism")).equals("LTPA")) {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.trustAssociationEnabled");
            if (bl != null && bl.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trust Association enabled: Trying to load the interceptors");
                }
                firstPassList = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.InvokeTAIbeforeSSO");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First pass list: " + firstPassList);
                }
                String string2 = null;
                try {
                    List list = (List)SecurityConfig.getConfig().getValue("security.ltpa.trustAssociations");
                    if (list.size() == 0) {
                        this.isTrustAssociationEnabled = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No interceptors provided for Trust Association");
                        }
                    } else {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        if (classLoader == null) {
                            Tr.error(tc, "security.web.ta.classloaderr");
                            this.isTrustAssociationEnabled = false;
                        } else {
                            int n;
                            ArrayList arrayList = new ArrayList(list.size());
                            for (n = 0; n < list.size(); ++n) {
                                Properties properties = (Properties)list.get(n);
                                string2 = (String)properties.get("com.ibm.wsspi.security.TAIClassName");
                                if (string2 == null) {
                                    Tr.error(tc, "security.web.ta.nointclass", new Object[]{string2});
                                    continue;
                                }
                                try {
                                    String string3;
                                    String string4;
                                    String string5;
                                    int n2;
                                    Class<?> clazz = classLoader.loadClass(string2);
                                    Object obj = clazz.newInstance();
                                    Tr.audit(tc, "security.web.ta.loadclass", new Object[]{string2});
                                    if (obj instanceof WebSphereBaseTrustAssociationInterceptor) {
                                        if (properties != null && properties.size() > 0) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Trust Properties = ", properties);
                                            }
                                            int n3 = ((WebSphereBaseTrustAssociationInterceptor)obj).init(properties);
                                            n2 = 0;
                                            string5 = (String)properties.get("com.ibm.websphere.security.trustassociation.ignoreInitStatus");
                                            if (string5 == null || !string5.equalsIgnoreCase("true")) {
                                                string4 = (String)properties.get("com.ibm.websphere.security.trustassociation.initStatus");
                                                if (string4 != null) {
                                                    n2 = Integer.valueOf(string4);
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Success Status for TAI is : " + n2);
                                                    }
                                                }
                                                if (n3 != n2) {
                                                    string3 = Integer.toString(n3);
                                                    Tr.error(tc, "security.web.ta.initerr", new Object[]{string2, string3});
                                                    if (!tc.isDebugEnabled()) continue;
                                                    Tr.debug(tc, "The Trust Association Implementation file " + string2 + " init method returned error status: " + n3 + ". The expected status for success is " + n2);
                                                    continue;
                                                }
                                            } else if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "The Trust Association Implementation file " + string2 + " init method returned status: " + n3);
                                            }
                                        }
                                        String string6 = ((WebSphereBaseTrustAssociationInterceptor)obj).getVersion();
                                        Tr.audit(tc, "security.web.ta.intsig", new Object[]{string6});
                                    } else if (obj instanceof TrustAssociationInterceptor) {
                                        if (properties != null && properties.size() > 0) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Trust Properties = ", properties);
                                            }
                                            int n4 = ((TrustAssociationInterceptor)obj).initialize(properties);
                                            n2 = 0;
                                            string5 = (String)properties.get("com.ibm.websphere.security.trustassociation.ignoreInitStatus");
                                            if (string5 == null || !string5.equalsIgnoreCase("true")) {
                                                string4 = (String)properties.get("com.ibm.websphere.security.trustassociation.initStatus");
                                                if (string4 != null) {
                                                    n2 = Integer.valueOf(string4);
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Success Status for TAI is : " + n2);
                                                    }
                                                }
                                                if (n4 != n2) {
                                                    string3 = Integer.toString(n4);
                                                    Tr.error(tc, "security.web.ta.initerr", new Object[]{string2, string3});
                                                    if (!tc.isDebugEnabled()) continue;
                                                    Tr.debug(tc, "The Trust Association Implementation file " + string2 + " init method returned error status: " + n4 + ". The expected status for success is " + n2);
                                                    continue;
                                                }
                                            } else if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "The Trust Association Implementation file " + string2 + " init method returned status: " + n4);
                                            }
                                        }
                                        String string7 = ((TrustAssociationInterceptor)obj).getVersion();
                                        Tr.audit(tc, "security.web.ta.intsig", new Object[]{string7});
                                    }
                                    arrayList.add(obj);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Adding Interceptor: " + string2);
                                    continue;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "178", this);
                                    Tr.error(tc, "security.web.ta.loadclasserr", new Object[]{string2});
                                    continue;
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {
                                    FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "178", this);
                                    Tr.error(tc, "security.web.ta.loadclasserr", new Object[]{string2});
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "197", this);
                                    Tr.error(tc, "security.web.ta.initerr", new Object[]{string2, throwable});
                                }
                            }
                            this.interceptorCount = arrayList.size();
                            if (this.interceptorCount != 0) {
                                this.interceptors = new TAIWrapper[this.interceptorCount];
                                for (n = 0; n < this.interceptorCount; ++n) {
                                    this.interceptors[n] = new TAIWrapper(arrayList.get(n));
                                }
                                this.isTrustAssociationEnabled = true;
                            } else {
                                this.isTrustAssociationEnabled = false;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Number of Interceptors added are: " + this.interceptorCount);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "207", this);
                    this.isTrustAssociationEnabled = false;
                    Tr.error(tc, "security.web.ta.initerr", new Object[]{string2, exception});
                }
            } else {
                this.isTrustAssociationEnabled = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trust Association not enabled");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }
}

