/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.portletapplication.Portlet;
import com.ibm.etools.portletapplication.PortletApplication;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.portletcontainer.util.PortletModelHelper;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class SecurityMetaDataListener
implements MetaDataListener {
    private static TraceComponent tc = Tr.register(SecurityMetaDataListener.class);

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        MetaData metaData;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "metaDataCreated: " + metaDataEvent);
        }
        if ((metaData = metaDataEvent.getMetaData()) instanceof WebModuleMetaData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebModuleMetaData " + metaData);
            }
            DeployedObject deployedObject = metaDataEvent.getDeployedObject();
            WebApp webApp = (WebApp)deployedObject.getDeploymentDescriptor();
            WebAppConfig webAppConfig = ((WebModuleMetaData)metaData).getConfiguration();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "webModuleDD " + webApp);
                Tr.debug(tc, "config " + webAppConfig);
            }
            this.populateSecurityModuleMetaData(webApp, webAppConfig);
        } else if (metaData instanceof WebComponentMetaData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebComponentMetaData " + metaData);
            }
            DeployedObject deployedObject = metaDataEvent.getDeployedObject();
            IServletConfig iServletConfig = ((WebComponentMetaData)metaData).getServletConfig();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "config " + iServletConfig);
            }
            WebApp webApp = (WebApp)deployedObject.getDeploymentDescriptor();
            Servlet servlet = webApp.getServletNamed(iServletConfig.getServletName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servlet " + servlet);
            }
            PortletApplication portletApplication = null;
            Portlet portlet = null;
            if (servlet == null && (portletApplication = PortletModelHelper.getPortletApplication((DeployedObject)deployedObject)) != null) {
                String string = iServletConfig.getServletName();
                portlet = PortletModelHelper.getPortletNamed((PortletApplication)portletApplication, (String)string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Portlet " + portlet);
                }
            }
            if (servlet != null || portlet != null) {
                this.populateSecurityComponentMetaData(servlet, portlet, iServletConfig);
            }
        }
    }

    private void populateSecurityModuleMetaData(WebApp webApp, WebAppConfig webAppConfig) {
        WebAttributes webAttributes = null;
        SecurityMetaData securityMetaData = new SecurityMetaData();
        webAttributes = new WebAttributes(webApp);
        WebModuleMetaData webModuleMetaData = webAppConfig.getMetaData();
        securityMetaData.setWebAttributes(webAttributes);
        webModuleMetaData.setSecurityMetaData((Object)securityMetaData);
    }

    private void populateSecurityComponentMetaData(Servlet servlet, Portlet portlet, IServletConfig iServletConfig) {
        EList eList = null;
        String string = "";
        SecurityMetaData securityMetaData = new SecurityMetaData();
        eList = servlet != null ? servlet.getSecurityRoleRefs() : portlet.getSecurityRoleRefs();
        string = iServletConfig.getServletName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rolerefs = " + eList + " name = " + string);
        }
        WebComponentMetaData webComponentMetaData = iServletConfig.getMetaData();
        securityMetaData.setSecurityRoleRefs(eList);
        securityMetaData.setServletName(string);
        webComponentMetaData.setSecurityMetaData((Object)securityMetaData);
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "metaDataDestroyed: " + metaDataEvent);
        }
    }
}

