/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.wsspi.security.token.KerberosToken;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ietf.jgss.GSSCredential;

public class KerberosTokenImpl
extends AbstractTokenImpl
implements KerberosToken {
    private byte[] tokenBytes = null;
    private GSSCredential gssCredential = null;
    private Hashtable kerberosData = null;
    private String KERBEROS_MECH = "1.2.840.113554.1.2.2";
    private String KERBEROS_OID = "oid:" + this.KERBEROS_MECH;
    private ContextManager contextManager = null;
    private String tokenName = "com.ibm.ws.security.token.KerberosTokenImpl";
    private boolean forwardable = false;
    private boolean isReadOnly = false;
    private short version = 1;
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final TraceComponent tc = Tr.register(KerberosTokenImpl.class, null, "com.ibm.ejs.resources.security");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        if (byArray != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using byte[] to create token for OID: " + this.KERBEROS_OID);
                }
                this.gssCredential = Krb5WSCredentialUtils.validateToken((byte[])byArray);
                this.kerberosData = new Hashtable();
                if (this.gssCredential == null || !tc.isDebugEnabled()) return;
                Tr.debug(tc, "GSSCredential initialized");
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.KerberosTokenImpl", "77", this);
                Tr.debug(tc, "Exception validating token.", new Object[]{exception});
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("KerberosTokenImpl: Invalid authentication data");
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
    }

    public void initializeToken(GSSCredential gSSCredential) throws WSLoginFailedException {
        try {
            this.gssCredential = gSSCredential;
            this.kerberosData = new Hashtable();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.KerberosTokenImpl", "103", this);
            this.contextManager.setRootException(exception);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (this.gssCredential == null) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("KerberosTokenImpl: no gssCredential in Subject");
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
    }

    public boolean isValid() {
        int n = 0;
        try {
            n = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{exception});
        }
        return n > 0;
    }

    public long getExpiration() {
        int n = -1;
        try {
            n = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{exception});
            return -1L;
        }
        return (long)(n * 1000) + System.currentTimeMillis();
    }

    public boolean isForwardable() {
        return false;
    }

    public String getPrincipal() {
        if (this.gssCredential != null) {
            String string = null;
            try {
                string = ((Object)this.gssCredential.getName()).toString();
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception getting principal name from GSSCredential.", new Object[]{exception});
            }
            return string;
        }
        Tr.debug(tc, "GSSCredential is null, cannot get principal.");
        return null;
    }

    public String getUniqueID() {
        return this.getPrincipal();
    }

    public byte[] getBytes() {
        return null;
    }

    public String getName() {
        return this.tokenName;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public String[] getAttributes(String string) {
        String string2 = (String)this.kerberosData.get(string);
        if (string2 != null) {
            String[] stringArray = new String[]{string2};
            return stringArray;
        }
        return null;
    }

    public String[] addAttribute(String string, String string2) {
        Object object;
        if ((string.startsWith("com.ibm.wsspi.security") || string.startsWith("com.ibm.websphere.security")) && (object = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_TOKEN.toString());
            }
            ((SecurityManager)object).checkPermission(UPDATE_TOKEN);
        }
        if (!this.isReadOnly && (object = this.kerberosData.put(string, string2)) != null) {
            String[] stringArray = new String[]{object};
            return stringArray;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return this.kerberosData.keys();
    }

    public Object clone() {
        return null;
    }

    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }
}

