/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.AllServerConfigs;
import com.ibm.ws.security.spnego.Context;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.ws.security.spnego.Util;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.IOException;
import java.security.Principal;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public final class SpnegoHandler {
    private static final String USER_PRINCIPAL = "com.ibm.ws.security.spnego.UserPrincipal";
    private static final String ME = SpnegoHandler.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    protected static final byte[] _SPNEGO_IOD = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};

    public static void initializeServerCreds(AllServerConfigs allServerConfigs) throws TAIConfigurationException {
        logger.entering(ME, "initializeServerCreds");
        ServerCredentialsFactory.initializeServerCreds(allServerConfigs);
        logger.exiting(ME, "initializeServerCreds");
    }

    public static TAIResult handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AllServerConfigs allServerConfigs) throws WebTrustAssociationFailedException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "handleRequest");
        }
        TAIResult tAIResult = null;
        try {
            String string;
            Subject subject;
            boolean bl;
            boolean bl2;
            Integer n;
            String string2 = null;
            String string3 = httpServletRequest.getHeader("Authorization");
            String string4 = httpServletRequest.getServerName();
            if (allServerConfigs.isIncludePortInSPN() && (n = new Integer(httpServletRequest.getServerPort())) != 80) {
                string4 = string4 + ":" + n.toString();
            }
            boolean bl3 = bl2 = string3 == null;
            if (bl2) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "No Authorization header found, sending 401 challenge to the client");
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.setHeader("WWW-Authenticate", "Negotiate");
                try {
                    httpServletResponse.getWriter().println(allServerConfigs.getServerConfig(string4).getSpnegoNotSupportedPage());
                }
                catch (IOException iOException) {
                    logger.logp(Level.FINER, ME, "handleRequest", "Error getting the HttpServletResponse's PrintWriter");
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(ME, "handleRequest: Handshake not finished");
                }
                return TAIResult.create(401);
            }
            if (SpnegoHandler.isAuthHeaderNotSPNEGO(string3)) {
                block33: {
                    httpServletResponse.setStatus(401);
                    try {
                        httpServletResponse.getWriter().println(allServerConfigs.getServerConfig(string4).getNTLMTokenReceivedPage());
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.FINER)) break block33;
                        logger.logp(Level.FINER, ME, "handleRequest", "Error getting the HttpServletResponse's PrintWriter");
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(ME, "handleRequest: Received a non-SPNEGO Authorization Header");
                }
                return TAIResult.create(401);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Found Authorization header, processing SPNEGO request token..");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Client request token before decoding:" + Util.showHex(string5.getBytes()));
            }
            byte[] byArray = Base64Coder.base64Decode(string5.getBytes());
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Client request token as follows...\r\n" + Util.showHex(byArray));
            }
            Context context = ServerCredentialsFactory.createContext(string4);
            byte[] byArray2 = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Context.begin started.");
            }
            byArray2 = context.begin(byArray);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Context.begin completed.");
            }
            if (bl = context.isEstablished()) {
                Object object;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "SPNEGO request token successfully processed.");
                }
                string2 = context.getPrincipalName();
                logger.logp(Level.INFO, ME, "handleRequest", "security.spnego.login", new Object[]{string2, new Integer(string3.length())});
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "Kerberos client principal: " + string2);
                }
                httpServletRequest.setAttribute(USER_PRINCIPAL, string2);
                if (byArray2 != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        object = "handleRequest: Sending back SPNEGO response token\nServer response token as follows...\r\n" + Util.showHex(byArray2);
                        logger.logp(Level.FINER, ME, "handleRequest", (String)object);
                    }
                    object = new String(Base64Coder.base64Encode(byArray2));
                    httpServletResponse.setHeader("WWW-Authenticate", "Negotiate " + (String)object);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "handleRequest", "Encoded response: " + (String)object);
                    }
                }
                object = new KerberosPrincipal(string2);
                subject = new Subject();
                subject.getPrincipals().add((Principal)object);
                string = SpnegoHandler.trimUsername(httpServletRequest, string2, allServerConfigs);
                if (allServerConfigs.getServerConfig(string4).isEnableCredDelegate()) {
                    try {
                        GSSCredential gSSCredential = context.getDelegateCred();
                        if (gSSCredential != null) {
                            subject.getPrivateCredentials().add(gSSCredential);
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, ME, "handleRequest", "clientCredential for Principal = " + string + " has been stored in Subject = " + subject);
                            }
                        } else {
                            logger.logp(Level.WARNING, ME, "handleRequest", "security.spnego.no.delegated.credentials.found", new Object[]{string2.toString()});
                        }
                    }
                    catch (GSSException gSSException) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, ME, "handleRequest", "Delegated GSSCredential has not been saved in the HttpSession, GSSException: " + gSSException.getMessage());
                        }
                    }
                }
            } else {
                httpServletResponse.setStatus(401);
                context.dispose();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "Error processing SPNEGO token, server response token as follows...\r\n" + Util.showHex(byArray2));
                }
                return TAIResult.create(403);
            }
            tAIResult = TAIResult.create(200, string, subject);
            context.dispose();
        }
        catch (GSSException gSSException) {
            FFDCFilter.processException(gSSException, "com.ibm.ws.security.spnego.SpnegoHandler.handleRequest", "295");
            logger.logp(Level.SEVERE, ME, "handleRequest", "security.spnego.bad.token", new Object[]{"GSSException: " + gSSException});
            return TAIResult.create(403);
        }
        logger.exiting(ME, "handleRequest", "Successful completion, HttpServletResponse.SC_OK");
        return tAIResult;
    }

    private static String trimUsername(HttpServletRequest httpServletRequest, String string, AllServerConfigs allServerConfigs) {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "trimUsername", "Kerberos principal name = " + string);
        }
        String string2 = httpServletRequest.getServerName();
        if (allServerConfigs.isIncludePortInSPN() && (Integer)(object = new Integer(httpServletRequest.getServerPort())) != 80) {
            string2 = string2 + ":" + ((Integer)object).toString();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "trimUsername", "serverName = " + string2);
        }
        object = string;
        boolean bl = allServerConfigs.getServerConfig(string2).isTrimUserName();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "trimUsername", "isTrimUserName() = " + bl);
        }
        if (bl) {
            int n = ((String)object).indexOf("@");
            if (n < 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "trimUsername", "There is nothing to trim in the principal name.");
                }
            } else {
                object = ((String)object).substring(0, n);
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "trimUsername", "Principal name was trimmed to: " + (String)object);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "trimUsername: " + (String)object);
        }
        return object;
    }

    private static boolean isAuthHeaderNotSPNEGO(String string) {
        boolean bl = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isAuthHeaderNotSPNEGO", string);
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            byte[] byArray = Base64Coder.base64Decode(string2.getBytes());
            byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            if (string2.length() >= 12) {
                byArray2 = new byte[]{byArray[4], byArray[5], byArray[6], byArray[7], byArray[8], byArray[9], byArray[10], byArray[11]};
            }
            if (!new String(byArray2).equals(new String(_SPNEGO_IOD))) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "isAuthHeaderNotSPNEGO", "Client sent back a non-SPNEGO authentication header: " + Util.showHex(byArray2) + "-" + Util.showHex(_SPNEGO_IOD) + "\nRequest: " + Util.showHex(byArray));
                }
                bl = true;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isAuthHeaderNotSPNEGO", Boolean.toString(bl));
        }
        return bl;
    }
}

