/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.CertificateMapper;
import com.ibm.ws.security.registry.ldap.CertificateMapperException;
import com.ibm.ws.security.registry.ldap.EntryEnumeration;
import com.ibm.ws.security.registry.ldap.IdMap;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapRegistryImpl
implements UserRegistry {
    private static TraceComponent tc = Tr.register(LdapRegistryImpl.class, null, "com.ibm.ejs.resources.security");
    private static final int RETRIES = 3;
    public static final String USER_FILTER = "user.filter";
    public static final String GROUP_FILTER = "group.filter";
    public static final String CERTIFICATE_MAP_MODE = "certificate.map.mode";
    public static final String CERTIFICATE_MAP_FILTER = "certificate.map.filter";
    private static final String[] noAttrs = new String[]{"1.1"};
    public static final String OBJECT_FILTER = "(objectclass=*)";
    private static boolean URLContextImpl = false;
    private static String LdapURL = null;
    private static int searchTimeLimit = 120000;
    private static final String[] dnAttrib = new String[]{"dn"};
    private final String[] krbAttr = new String[]{"krbprincipalname"};
    private static final String RACF_GROUP_ATTRIBUTE = "racfconnectgroupname";
    private static final String[] GROUP_ATTRIBUTES = new String[]{"nsroledn", "nsrole", "ibm-allGroups", "memberof"};
    private static final String iPlanet_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static final String MS_OBJECT_FILTER = "(objectCategory=*)";
    private static String objectFilter = "(objectclass=*)";
    private static boolean ignoreCaseMatch = false;
    private static boolean useAttributeGroupMethod = false;
    private static boolean registryExist = false;
    private Vector DirContextPool = new Vector();
    private int ContextPoolSize = 0;
    private static boolean recursiveSearch = false;
    private int busyCount = 0;
    private static Object lockObj1 = new Object();
    private static Object lockObj2 = new Object();
    private Vector table1 = new Vector();
    private Vector table2 = new Vector();
    private Vector table3 = new Vector();
    private static Thread LdapMonitorThread = null;
    private String realm = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString = RegistryUtil.nullString;
    protected static final String[] nullStringArray = RegistryUtil.nullStringArray;
    protected static final byte[] nullByteArray = RegistryUtil.nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private LdapConfig ldapConfig;
    private IdMap idMap;
    private CertificateMapper certMap;
    private static boolean refresh = false;
    private static String bindDN = null;
    private static String bindPWD = null;
    private static String bindHost = null;
    private String currentActiveLDAP = null;
    private int maxContextPerConnection = 5;
    private int maxIdleContext = 30;
    private static TraceComponent innerTc = Tr.register(LdapMonitor.class.getName(), null, "com.ibm.ejs.resources.security");

    protected DirContext getRootDSE() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootDSE");
        }
        DirContext dirContext = null;
        while (this.DirContextPool != null && this.DirContextPool.size() > 30) {
            try {
                dirContext = (DirContext)this.DirContextPool.lastElement();
                this.DirContextPool.removeElement(dirContext);
                dirContext.close();
                --this.ContextPoolSize;
            }
            catch (Exception exception) {}
        }
        try {
            dirContext = (DirContext)this.DirContextPool.lastElement();
            this.DirContextPool.removeElement(dirContext);
            Tr.exit(tc, "getRootDSE");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRootDSE");
            }
            return dirContext;
        }
        catch (Exception exception) {
            DirContext dirContext2 = this.ldapConfig.getRootDSE();
            if (this.ContextPoolSize == 0) {
                for (int i = 0; i < 10; ++i) {
                    dirContext = (DirContext)dirContext2.lookup(NONE);
                    this.DirContextPool.addElement(dirContext);
                    ++this.ContextPoolSize;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "DirContext pool initialized.");
                }
            }
            dirContext = (DirContext)dirContext2.lookup(NONE);
            ++this.ContextPoolSize;
            if (tc.isDebugEnabled() && this.ContextPoolSize > 30) {
                Tr.debug(tc, "DirContext pool size = " + this.ContextPoolSize);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRootDSE");
            }
            return dirContext;
        }
    }

    protected void disconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disconnect");
        }
        while (!this.DirContextPool.isEmpty()) {
            try {
                DirContext dirContext = (DirContext)this.DirContextPool.lastElement();
                this.DirContextPool.removeElement(dirContext);
                dirContext.close();
            }
            catch (Exception exception) {}
        }
        this.ContextPoolSize = 0;
        this.ldapConfig.disconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disconnect");
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", string);
        }
        String string3 = null;
        try {
            Result result;
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticating", string);
            }
            if (string.length() == 0 || string2.length() == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("The userId and/or password is empty");
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", passwordCheckFailedException);
                }
                throw passwordCheckFailedException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for users");
            }
            if (!this.fullDN(string, this.ldapConfig.getBaseDn())) {
                string = LdapRegistryImpl.escapeChar(string, '*');
            }
            if ((n = (result = this.getUsers(string, 2)).getList().size()) > 1) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Multiple users with the name of " + string);
                Tr.error(tc, "security.authn.failed.multiusers", new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", passwordCheckFailedException);
                }
                throw passwordCheckFailedException;
            }
            if (n == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("No user " + string + " found");
                Tr.error(tc, "security.authn.failed.nouser", new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", passwordCheckFailedException);
                }
                throw passwordCheckFailedException;
            }
            string = (String)result.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found user", string);
            }
            string3 = this.authenticate(string, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticated with", string);
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof com.ibm.websphere.security.auth.AuthenticationNotSupportedException || exception instanceof AuthenticationFailedException || exception instanceof RegistryErrorException)) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.checkPassword", "330", this);
                Tr.error(tc, "security.authn.error", new Object[]{string, exception.toString()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", exception);
            }
            if (exception.getCause() != null) {
                throw new CustomRegistryException(exception.getCause().toString(), exception);
            }
            throw new CustomRegistryException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword", string3);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String authenticate(String string, String string2) throws AuthenticationFailedException, com.ibm.websphere.security.auth.AuthenticationNotSupportedException, RegistryErrorException, CustomRegistryException {
        Object object;
        Object object2;
        long l = 0L;
        LdapConfig ldapConfig = new LdapConfig(this.ldapConfig);
        ldapConfig.setAuthenticationPrincipal(string);
        ldapConfig.setAuthenticationCredentials(string2);
        String string3 = this.ldapConfig.getDirectoryUrl();
        boolean bl = this.ldapConfig.isRetryBind();
        if (bl && string.equalsIgnoreCase(this.ldapConfig.getAuthenticationPrincipal())) {
            object2 = new StringTokenizer(string3);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                ldapConfig.setDirectoryUrl((String)object);
                try {
                    CharSequence charSequence;
                    l = System.currentTimeMillis();
                    this.enterJNDI();
                    InitialDirContext initialDirContext = new InitialDirContext(ldapConfig);
                    this.exitJNDI();
                    initialDirContext.close();
                    if (tc.isDebugEnabled()) {
                        charSequence = new StringBuffer("Same DN - Time elapsed to open/close DirContext: ");
                        charSequence = ((StringBuffer)charSequence).append(System.currentTimeMillis() - l);
                        Tr.debug(tc, ((StringBuffer)charSequence).toString());
                    }
                    charSequence = string;
                    return charSequence;
                }
                catch (NamingException namingException) {
                    this.exitJNDI();
                }
                finally {
                    this.exitJNDI();
                }
            }
        }
        if (!bl) {
            object2 = null;
            if (this.currentActiveLDAP != null) {
                object2 = this.currentActiveLDAP;
            } else if (string3 != null && ((StringTokenizer)(object = new StringTokenizer(string3))).hasMoreTokens()) {
                object2 = ((StringTokenizer)object).nextToken();
            }
            if (object2 != null) {
                ldapConfig.setDirectoryUrl((String)object2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRetry:false Bind to " + ldapConfig.getDirectoryUrl());
            }
        } else if (string3 != null && this.currentActiveLDAP != null && !string3.startsWith(this.currentActiveLDAP)) {
            string3 = this.currentActiveLDAP + " " + string3;
            ldapConfig.setDirectoryUrl(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Bind to " + ldapConfig.getDirectoryUrl());
            }
        }
        try {
            l = System.currentTimeMillis();
            this.enterJNDI();
            object2 = new InitialDirContext(ldapConfig);
            this.exitJNDI();
            object2.close();
            if (tc.isDebugEnabled()) {
                object = new StringBuffer("Time elapsed to open/close DirContext: ");
                object = ((StringBuffer)object).append(System.currentTimeMillis() - l);
                Tr.debug(tc, ((StringBuffer)object).toString());
            }
            object = string;
            return object;
        }
        catch (AuthenticationNotSupportedException authenticationNotSupportedException) {
            this.exitJNDI();
            FFDCFilter.processException((Throwable)authenticationNotSupportedException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "438", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, authenticationNotSupportedException.toString()});
            throw new com.ibm.websphere.security.auth.AuthenticationNotSupportedException(authenticationNotSupportedException.getMessage(), authenticationNotSupportedException);
        }
        catch (AuthenticationException authenticationException) {
            this.exitJNDI();
            FFDCFilter.processException((Throwable)authenticationException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "444", this);
            throw new AuthenticationFailedException(authenticationException.getMessage(), authenticationException);
        }
        catch (NamingException namingException) {
            this.exitJNDI();
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "450", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, namingException.toString()});
            this.logNamingException(namingException, string);
            if (namingException instanceof CommunicationException) {
                object = this.ldapConfig.getDirectoryUrl();
                Tr.audit(tc, "security.registry.ldap.connect.audit", new Object[]{object});
            }
            throw new RegistryErrorException(namingException.getMessage(), namingException);
        }
        finally {
            this.exitJNDI();
        }
    }

    private static String normalizeDN(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        boolean bl2 = true;
        int n2 = 32;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c != ' ') {
                    if (bl2) {
                        stringBuffer.append(Character.toLowerCase(c));
                    } else {
                        stringBuffer.append(c);
                        bl = false;
                    }
                    if (c == '=') {
                        bl2 = false;
                    }
                }
            } else {
                if ((c == ',' || c == ';') && n2 != 92) {
                    bl = true;
                    bl2 = true;
                }
                stringBuffer.append(c);
            }
            n2 = c;
        }
        return stringBuffer.toString();
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        try {
            string3 = this.certMap.getLdapSearchFilter(x509Certificate);
            n = this.certMap.getLdapSearchScope();
        }
        catch (CertificateMapperException certificateMapperException) {
            FFDCFilter.processException((Throwable)certificateMapperException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", "533", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CertificatMapperException caught during LDAP operation while looking for: " + x509Certificate.getSubjectDN().getName());
            }
            Tr.error(tc, "security.registry.ldap.mapcredentialBadFilter", new Object[]{x509Certificate.getSubjectDN().getName()});
            throw new CertificateMapFailedException(certificateMapperException.getMessage(), certificateMapperException);
        }
        try {
            if (n == 0) {
                Result result;
                int n2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Searching for users");
                }
                if ((n2 = (result = this.getUsers(string3, 2)).getList().size()) > 1) {
                    CertificateMapFailedException certificateMapFailedException = new CertificateMapFailedException("Multiple users with the name of " + string2);
                    Tr.error(tc, "security.authn.failed.multiusers", new Object[]{string2});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "mapCertificate", certificateMapFailedException);
                    }
                    throw certificateMapFailedException;
                }
                if (n2 == 0) {
                    CertificateMapFailedException certificateMapFailedException = new CertificateMapFailedException("No user " + string2 + " found");
                    Tr.error(tc, "security.authn.failed.nouser", new Object[]{string2});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "mapCertificate", certificateMapFailedException);
                    }
                    throw certificateMapFailedException;
                }
                string = (String)result.getList().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "certificate dn =", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "normalized  dn =", string);
                }
            } else {
                EntryEnumeration entryEnumeration = this.search(n, string3, 2);
                if (entryEnumeration.hasMoreElements()) {
                    string = (String)entryEnumeration.nextElement();
                    if (entryEnumeration.hasMoreElements()) {
                        entryEnumeration.close();
                        Tr.error(tc, "security.authn.failed.multiusers", new Object[]{x509Certificate.getSubjectDN().getName()});
                        throw new CertificateMapFailedException("Multiple users with the name of " + x509Certificate.getSubjectDN().getName());
                    }
                }
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", "590", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NamingException caught during LDAP operation while looking for: " + x509Certificate.getSubjectDN().getName());
            }
            Tr.error(tc, "security.registry.ldap.mapcredentialNamingEx", new Object[]{x509Certificate.getSubjectDN().getName(), string3});
            this.logNamingException(namingException);
            throw new CertificateMapFailedException(namingException.getMessage(), namingException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", "598", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during LDAP operation while looking for: " + x509Certificate.getSubjectDN().getName());
            }
            throw new CertificateMapFailedException(exception.getMessage(), exception);
        }
        if (string == null) {
            Tr.error(tc, "security.registry.ldap.mapcredentialNotFound", new Object[]{x509Certificate.getSubjectDN().getName(), string3});
            throw new CertificateMapFailedException("The name in the certificate: " + x509Certificate.getSubjectDN().getName() + " cannot be found in the registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate");
        }
        return string;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", string);
        }
        String string2 = null;
        try {
            Attributes attributes = this.getAttributes(string, this.idMap.getAttributes());
            string2 = this.idMap.getGroupName(attributes);
            if (tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security name =", string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attributes =", attributes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Name =", attributes);
                }
            }
        }
        catch (NamingException namingException) {
            this.logNamingException(namingException);
        }
        if (string2 == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName", string2);
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", string);
        }
        String string3 = null;
        try {
            string3 = string;
            Result result = this.getGroups(string3, 2);
            int n = result.getList().size();
            if (n > 1) {
                CustomRegistryException customRegistryException = new CustomRegistryException("Multiple groups with the name of " + string3);
                Tr.error(tc, "security.authn.failed.multiusers", new Object[]{string3});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId", customRegistryException);
                }
                throw customRegistryException;
            }
            if (n == 0) {
                CustomRegistryException customRegistryException = new CustomRegistryException("No group " + string3 + " found");
                Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId", customRegistryException);
                }
                throw customRegistryException;
            }
            string2 = (String)result.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found group", string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUniqueGroupId", "697", this);
            if (!(exception instanceof CustomRegistryException)) {
                Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{string3});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueGroupId");
            }
            throw new CustomRegistryException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", string2);
        }
        return string2;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", string);
        }
        List list = this.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds");
        }
        return list;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", string + typeSeparator + n);
        }
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", string + typeSeparator + n);
            }
            return result;
        }
        EntryEnumeration entryEnumeration = null;
        int n2 = n++;
        int n3 = 0;
        if (n2 == 0 || n2 < Integer.MAX_VALUE) {
            // empty if block
        }
        try {
            ArrayList<Object> arrayList;
            block21: {
                if (this.fullDN(string, this.ldapConfig.getGroupBaseDn())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pattern is full DN");
                    }
                    entryEnumeration = this.search(string, 0, objectFilter, n);
                } else {
                    arrayList = this.ldapConfig.getFilter(GROUP_FILTER).prepare(string);
                    entryEnumeration = this.search(this.ldapConfig.getGroupBaseDn(), 2, (String)((Object)arrayList), n);
                }
                if (entryEnumeration == null) {
                    arrayList = new ArrayList<Object>(0);
                    result.setList(arrayList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No groups found");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getGroups", string + typeSeparator + n2);
                    }
                    return result;
                }
                arrayList = new ArrayList();
                if (n2 != 0) {
                    arrayList = new ArrayList(n);
                }
                while (entryEnumeration.hasMoreElements()) {
                    arrayList.add(entryEnumeration.nextElement());
                    if (n2 == 0 || ++n3 != n2) continue;
                }
                result.setList(arrayList);
                try {
                    if (entryEnumeration.hasMoreElements()) {
                        result.setHasMore();
                        entryEnumeration.close();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "no more groups");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of groups returned = " + arrayList.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", string + typeSeparator + n2);
            }
            return result;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroups", "798", this);
            this.logNamingException(namingException);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", namingException);
            }
            throw new CustomRegistryException(namingException.getMessage(), namingException);
        }
    }

    private void getAllGroupMembersByGroupObject(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, IdMap.IdEntry[] idEntryArray, String string) throws CustomRegistryException {
        Object object;
        if (arrayList.isEmpty()) {
            return;
        }
        boolean bl = true;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            if (arrayList3.contains(string2)) continue;
            bl = false;
            arrayList3.add(string2);
        }
        if (bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("(|");
        for (int i = 0; i < n; ++i) {
            object = (String)arrayList.get(i);
            for (int j = 0; j < idEntryArray.length; ++j) {
                if (idEntryArray[j].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
                stringBuffer.append("(&(").append(string).append("=").append(idEntryArray[j].getObjectClassName()).append(")(");
                stringBuffer.append(idEntryArray[j].getAttributeName()).append("=").append((String)object).append("))");
            }
        }
        stringBuffer.append(")");
        String string3 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filter =", string3);
        }
        object = new ArrayList();
        try {
            String string4 = this.ldapConfig.getBaseDn();
            EntryEnumeration entryEnumeration = new EntryEnumeration(this.ldapConfig.getGroupBaseDn(), this.search(this.ldapConfig.getBaseDn(), 2, string3, noAttrs, 0));
            while (entryEnumeration.hasMoreElements()) {
                ((ArrayList)object).add((String)entryEnumeration.nextElement());
            }
            if (((ArrayList)object).isEmpty()) {
                return;
            }
            int n2 = ((ArrayList)object).size();
            for (int i = 0; i < n2; ++i) {
                String string5 = (String)((ArrayList)object).get(i);
                arrayList2.add(string5);
            }
            if (recursiveSearch) {
                this.getAllGroupMembersByGroupObject((ArrayList)object, arrayList2, arrayList3, idEntryArray, string);
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", "877", this);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{arrayList3.get(0)});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", namingException);
            }
            throw new CustomRegistryException(namingException.getMessage(), namingException);
        }
    }

    private void getAllGroupMembershipsByUserObject(String string, ArrayList arrayList, ArrayList arrayList2, String string2) throws EntryNotFoundException {
        if (arrayList2.contains(string)) {
            return;
        }
        arrayList2.add(string);
        String[] stringArray = new String[]{string2};
        Vector<String> vector = new Vector<String>(5);
        try {
            Object object;
            NamingEnumeration namingEnumeration;
            if (this.fullDN(string, this.ldapConfig.getBaseDn())) {
                namingEnumeration = this.search(string, 0, objectFilter, stringArray, 0);
            } else {
                object = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                namingEnumeration = this.search(this.ldapConfig.getBaseDn(), 2, (String)object, stringArray, 0);
            }
            if (namingEnumeration.hasMoreElements()) {
                String string3;
                Object object2;
                object = (SearchResult)namingEnumeration.next();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = ((SearchResult)object).getAttributes().getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    object2 = namingEnumeration2.next();
                    string3 = object2.getID();
                    if (!string3.equalsIgnoreCase(stringArray[0])) continue;
                    for (int i = 0; i < object2.size(); ++i) {
                        String string4 = (String)object2.get(i);
                        string4 = RegistryUtil.removeDNSpace(string4, 0);
                        vector.addElement(string4);
                    }
                }
                if (namingEnumeration.hasMoreElements()) {
                    namingEnumeration.close();
                }
                object2 = vector.listIterator();
                while (object2.hasNext()) {
                    string3 = (String)object2.next();
                    arrayList.add(string3);
                    if (!recursiveSearch) continue;
                    this.getAllGroupMembershipsByUserObject(string3, arrayList, arrayList2, string2);
                }
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", "948", this);
            this.logNamingException(namingException);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser");
            }
            throw new EntryNotFoundException(namingException.getMessage(), namingException);
        }
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException {
        IdMap.IdEntry[] idEntryArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", string);
        }
        if (!this.fullDN(string, this.ldapConfig.getBaseDn())) {
            string = this.getUniqueUserId(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using DN: " + string);
            }
        }
        if ((idEntryArray = this.idMap.getGroupMembers()).length == 0) {
            return new ArrayList(0);
        }
        ArrayList arrayList = new ArrayList();
        if (useAttributeGroupMethod) {
            String string2 = idEntryArray[0].getObjectClassName();
            this.getAllGroupMembershipsByUserObject(string, arrayList, new ArrayList(), string2);
        } else {
            String string3 = "objectclass";
            for (int i = 0; i < idEntryArray.length; ++i) {
                if (!idEntryArray[i].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
                string3 = "objectCategory";
                break;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(string);
            this.getAllGroupMembersByGroupObject(arrayList2, arrayList, new ArrayList(), idEntryArray, string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of groups returned = " + arrayList.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", arrayList.toArray());
        }
        return arrayList;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup");
        }
        Result result = new Result();
        int n2 = 0;
        String string2 = null;
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        IdMap.IdEntry[] idEntryArray = this.idMap.getGroupMembers();
        if (idEntryArray.length == 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No filter specified for groupmeneber.idmap ");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        String[] stringArray = new String[idEntryArray.length];
        for (int i = 0; i < idEntryArray.length; ++i) {
            stringArray[i] = idEntryArray[i].getAttributeName();
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (n != 0 && n < Integer.MAX_VALUE) {
            arrayList = new ArrayList(n + 1);
        } else if (n == Integer.MAX_VALUE) {
            arrayList = new ArrayList(n);
        }
        try {
            NamingEnumeration namingEnumeration = this.search(string, 0, objectFilter, stringArray, 1);
            if (namingEnumeration.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = searchResult.getAttributes().getAll();
                block3: while (namingEnumeration2.hasMoreElements()) {
                    Attribute attribute = namingEnumeration2.next();
                    for (int i = 0; i < attribute.size(); ++i) {
                        string2 = (String)attribute.get(i);
                        string2 = RegistryUtil.removeDNSpace(string2, 0);
                        arrayList.add(string2);
                        if (n >= Integer.MAX_VALUE || n == 0 || ++n2 < n + 1) continue;
                        result.setHasMore();
                        arrayList.remove(string2);
                        continue block3;
                    }
                }
                if (namingEnumeration.hasMoreElements()) {
                    namingEnumeration.close();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsersForGroup");
                }
                result.setList(arrayList);
            }
        }
        catch (NamingException namingException) {
            this.logNamingException(namingException);
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsersForGroup", "1096", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup", namingException);
            }
            throw new CustomRegistryException(namingException.getMessage(), namingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup");
        }
        return result;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", string);
        }
        String string2 = this.getUniqueGroupId(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName", string2);
        }
        return string2;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", string);
        }
        String string2 = null;
        try {
            Attributes attributes = this.getAttributes(string, this.idMap.getAttributes());
            string2 = this.idMap.getUserName(attributes);
            if (tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "securityName =", string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attributes =", attributes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "userName =", string2);
                }
            }
        }
        catch (NamingException namingException) {
            this.logNamingException(namingException);
        }
        if (string2 == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName");
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", string);
        }
        String string3 = null;
        try {
            string3 = string;
            Result result = this.getUsers(string3, 2);
            int n = result.getList().size();
            if (n > 1) {
                CustomRegistryException customRegistryException = new CustomRegistryException("Multiple users with the name of " + string3);
                Tr.error(tc, "security.authn.failed.multiusers", new Object[]{string3});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId", customRegistryException);
                }
                throw customRegistryException;
            }
            if (n == 0) {
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{string3});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId");
                }
                throw new CustomRegistryException("Cannot find uniqueID for the user " + string3);
            }
            string2 = (String)result.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found user", string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUniqueUserId", "1206", this);
            if (!(exception instanceof CustomRegistryException)) {
                Tr.error(tc, "security.registry.uniqueusrid.error", new Object[]{string3});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId");
            }
            throw new CustomRegistryException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", string2);
        }
        return string2;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        ArrayList<Object> arrayList;
        int n2;
        Result result;
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUsers", new Object[]{string, new Integer(n)});
            }
            result = new Result();
            if (n < 0) {
                ArrayList arrayList2 = new ArrayList(0);
                result.setList(arrayList2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No users searched as the limit is a negative number.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{string, new Integer(n)});
                }
                return result;
            }
            EntryEnumeration entryEnumeration = null;
            n2 = n++;
            int n3 = 0;
            if (n2 == 0 || n2 < Integer.MAX_VALUE) {
                // empty if block
            }
            try {
                if (this.fullDN(string, this.ldapConfig.getBaseDn())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pattern is full DN");
                    }
                    entryEnumeration = this.search(string, 0, objectFilter, n);
                } else {
                    arrayList = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                    entryEnumeration = this.search(2, (String)((Object)arrayList), n);
                }
            }
            catch (AuthenticationException authenticationException) {
                FFDCFilter.processException((Throwable)authenticationException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsers", "1261", this);
                this.logNamingException(authenticationException);
                Tr.error(tc, "security.registry.getusers.error", new Object[]{string, authenticationException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{string, new Integer(n2), authenticationException});
                }
                throw new CustomRegistryException(authenticationException.getMessage(), authenticationException);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsers", "1268", this);
                this.logNamingException(namingException);
                Tr.error(tc, "security.registry.getusers.error", new Object[]{string, namingException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{string, new Integer(n2), namingException});
                }
                if (namingException.getCause() != null) {
                    throw new CustomRegistryException(namingException.getCause().toString(), namingException);
                }
                throw new CustomRegistryException(namingException.getMessage(), namingException);
            }
            if (entryEnumeration == null) {
                arrayList = new ArrayList<Object>(0);
                result.setList(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No users found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{string, new Integer(n2)});
                }
                return result;
            }
            arrayList = new ArrayList();
            if (n2 != 0) {
                arrayList = new ArrayList(n);
            }
            while (entryEnumeration.hasMoreElements()) {
                String string2 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism.OID");
                if (string2 != null && "oid:1.2.840.113554.1.2.2".endsWith(string2)) {
                    try {
                        Attributes attributes = this.getAttributes((String)entryEnumeration.nextElement(), this.idMap.getAttributes());
                        Attribute attribute = attributes.get(this.krbAttr[0]);
                        String string3 = (String)attribute.get();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "KrbPrincipalName = ", string3);
                        }
                        arrayList.add(string3);
                    }
                    catch (NamingException namingException) {
                        this.logNamingException(namingException);
                    }
                } else {
                    arrayList.add(entryEnumeration.nextElement());
                }
                if (n2 == 0 || ++n3 != n2) continue;
                break;
            }
            result.setList(arrayList);
            try {
                if (entryEnumeration.hasMoreElements()) {
                    result.setHasMore();
                    entryEnumeration.close();
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block29;
                Tr.debug(tc, "no more users");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of users returned = " + arrayList.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", new Object[]{string, new Integer(n2)});
        }
        return result;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", string);
        }
        String string2 = this.getUniqueUserId(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName", string2);
        }
        return string2;
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        IdMap.IdEntry[] idEntryArray;
        String string;
        block34: {
            block33: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "initialize");
                }
                String string2 = "LDAP";
                this.DirContextPool = new Vector();
                this.ContextPoolSize = 0;
                this.busyCount = 0;
                this.currentActiveLDAP = null;
                this.table1 = new Vector();
                this.table2 = new Vector();
                this.table3 = new Vector();
                try {
                    this.ldapConfig = new LdapConfig(properties);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.initialize", "1388", this);
                    Tr.error(tc, "security.registry.ldap.initerror", new Object[]{exception});
                    throw new CustomRegistryException(exception.toString(), exception);
                }
                string = this.ldapConfig.getDirectoryUrl();
                if (string == null || string.length() == 0) {
                    throw new CustomRegistryException("No Directory URL");
                }
                if (this.ldapConfig.getFilter(USER_FILTER) == null) {
                    throw new CustomRegistryException("No User Filter");
                }
                if (this.ldapConfig.getFilter(GROUP_FILTER) == null) {
                    throw new CustomRegistryException("No Group Filter");
                }
                this.realm = this.ldapConfig.getLogicRealm();
                if (this.realm == null || this.realm.length() == 0) {
                    this.realm = properties.getProperty("LDAP.server.realm");
                }
                if (this.realm == null || this.realm.length() == 0) {
                    int n = string.indexOf(" ");
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    int n2 = string.indexOf("://");
                    this.realm = string.endsWith(realmSeparator) ? string.substring(n2 + 3, string.length() - 1) : string.substring(n2 + 3, string.length());
                }
                if (this.realm == null) {
                    throw new CustomRegistryException("Realm is not specified in LDAPRegistry realm field of security.xml");
                }
                this.realm = this.realm.trim();
                this.idMap = new IdMap(this.ldapConfig);
                this.certMap = new CertificateMapper();
                try {
                    this.certMap.setLdapMapMode(properties.getProperty(CERTIFICATE_MAP_MODE));
                    this.certMap.setLdapFilterDescriptor(properties.getProperty(CERTIFICATE_MAP_FILTER));
                }
                catch (CertificateMapperException certificateMapperException) {
                    FFDCFilter.processException((Throwable)certificateMapperException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.initialize", "1451", this);
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "initialize", certificateMapperException);
                }
            }
            try {
                int n = -1;
                String string3 = properties.getProperty("security.registry.ldap.searchTimeLimit");
                if (string3 != null && string3.length() > 0) {
                    n = new Integer(string3);
                }
                if (n > 0) {
                    searchTimeLimit = n * 1000;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block34;
                Tr.debug(tc, "initialize", "will try for 2 minutes");
            }
        }
        try {
            idEntryArray = properties.getProperty("security.registry.ldap.reuseConn");
            if (idEntryArray.equalsIgnoreCase("false")) {
                URLContextImpl = true;
                LdapURL = string;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use URL Context Implementation.");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LdapMonitorThread == null) {
            LdapMonitorThread = new LdapMonitor();
            LdapMonitorThread.setDaemon(true);
            LdapMonitorThread.start();
        }
        if ((idEntryArray = this.idMap.getGroupMembers()).length > 0 && !registryExist) {
            recursiveSearch = this.ldapConfig.isRecursiveSearchEnabled();
            String string4 = this.ldapConfig.getFilter(GROUP_FILTER).prepare("*").toLowerCase();
            if (string4.indexOf("ldapsubentry") > -1) {
                objectFilter = iPlanet_OBJECT_FILTER;
            }
            if (string4.indexOf("objectcategory") > -1) {
                objectFilter = MS_OBJECT_FILTER;
            }
            boolean bl = true;
            String string5 = this.ldapConfig.getDirectoryUrl();
            StringTokenizer stringTokenizer = new StringTokenizer(string5);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                LdapConfig ldapConfig = new LdapConfig(this.ldapConfig);
                ldapConfig.setDirectoryUrl(string6);
                try {
                    InitialDirContext initialDirContext = new InitialDirContext(ldapConfig);
                    if (bl) {
                        bl = false;
                        try {
                            DirContext dirContext = initialDirContext.getSchema(NONE);
                            String string7 = "AttributeDefinition/" + idEntryArray[0].getObjectClassName();
                            DirContext dirContext2 = (DirContext)dirContext.lookup(string7);
                            useAttributeGroupMethod = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found attribute of LDAP user object that specifies the distinguished name of those groups to which this user belongs.");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initialDirContext.close();
                    break;
                }
                catch (NamingException namingException) {
                }
            }
            if (!useAttributeGroupMethod && tc.isDebugEnabled()) {
                Tr.debug(tc, "Will call getGroupsForUser() to get user's group memberships.");
            }
        }
        this.maxContextPerConnection = this.ldapConfig.getMaxConcurrentSearchNumberPerConnection();
        this.maxIdleContext = this.ldapConfig.getSizeOfIdleContextPool();
        registryExist = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void scanInactiveLDAP() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanInactiveLDAP");
        }
        String string = this.ldapConfig.getDirectoryUrl();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            LdapConfig ldapConfig = new LdapConfig(this.ldapConfig);
            ldapConfig.setDirectoryUrl(string2);
            try {
                InitialDirContext initialDirContext = new InitialDirContext(ldapConfig);
                initialDirContext.close();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + " is ready to accept request");
            }
            catch (NamingException namingException) {
                Tr.audit(tc, "security.registry.ldap.connect.audit", new Object[]{string2});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanInactiveLDAP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup");
        }
        try {
            boolean bl = this.getEntry(string) != null;
            return bl;
        }
        catch (InvalidNameException invalidNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Group or Group does not exist : " + string);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Group or Group does not exist : " + string);
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidGroup", "1604", this);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{string});
            this.logNamingException(namingException, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidGroup", "1609", this);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{string});
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup");
            }
        }
        return false;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser");
        }
        try {
            return this.getEntry(string) != null;
        }
        catch (InvalidNameException invalidNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid User or User does not exist : " + string);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid User or User does not exist : " + string);
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidUser", "1638", this);
            this.logNamingException(namingException, string);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string});
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidUser", "1643", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser");
        }
        return false;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    protected Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        NamingEnumeration namingEnumeration = this.search(string, 0, objectFilter, stringArray, 0);
        if (namingEnumeration.hasMoreElements()) {
            Attributes attributes;
            block4: {
                attributes = ((SearchResult)namingEnumeration.nextElement()).getAttributes();
                if (namingEnumeration.hasMoreElements()) {
                    try {
                        namingEnumeration.close();
                    }
                    catch (NamingException namingException) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug(tc, "Exception occurs while close NamingException.");
                    }
                }
            }
            return attributes;
        }
        return null;
    }

    protected String getEntry(String string) throws NamingException {
        String string2;
        block4: {
            EntryEnumeration entryEnumeration = this.search(string, 0, objectFilter, 0);
            string2 = null;
            if (entryEnumeration.hasMoreElements()) {
                string2 = (String)entryEnumeration.nextElement();
                if (entryEnumeration.hasMoreElements()) {
                    try {
                        entryEnumeration.close();
                    }
                    catch (NamingException namingException) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug(tc, "Exception occurs while close NamingException.");
                    }
                }
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getNormalizedDN(String string) throws NamingException {
        String string2 = null;
        EntryEnumeration entryEnumeration = null;
        int n = string.indexOf(44);
        if (n == -1) {
            n = string.indexOf(59);
        }
        if (n == -1) {
            try {
                string = LdapRegistryImpl.escapeChar(string, '*');
                entryEnumeration = this.search(string, 0, objectFilter, 0);
                if (!entryEnumeration.hasMoreElements()) return string2;
                string2 = (String)entryEnumeration.nextElement();
                if (!entryEnumeration.hasMoreElements()) return string2;
                entryEnumeration.close();
                return string2;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getNormalizedDN", "1745", this);
                Tr.error(tc, "security.registry.ldap.invalidID");
                this.logNamingException(namingException, string);
                throw namingException;
            }
        }
        try {
            int n2 = string.length();
            String string3 = string.substring(0, n);
            string3 = LdapRegistryImpl.escapeChar(string3, '*');
            String string4 = LdapRegistryImpl.escapeChar(string, '*');
            entryEnumeration = this.search(string4, 0, objectFilter, 0);
            String string5 = LdapRegistryImpl.normalizeDN(string);
            while (string2 == null && entryEnumeration.hasMoreElements()) {
                String string6 = (String)entryEnumeration.nextElement();
                String string7 = LdapRegistryImpl.normalizeDN(string6);
                if (!string7.equalsIgnoreCase(string5)) continue;
                string2 = string6;
            }
            if (!entryEnumeration.hasMoreElements()) return string2;
            entryEnumeration.close();
            return string2;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getNormalizedDN", "1787", this);
            Tr.error(tc, "security.registry.ldap.invalidID");
            this.logNamingException(namingException, string);
            throw namingException;
        }
    }

    private boolean fullDN(String string) {
        String string2;
        String string3;
        int n = string.indexOf(61);
        if (string.indexOf(61) < 0) {
            return false;
        }
        if (this.ldapConfig.getBaseDn().length() > 0 && (string3 = RegistryUtil.removeDNSpace(string, 0).toLowerCase()).endsWith(string2 = RegistryUtil.removeDNSpace(this.ldapConfig.getBaseDn(), 0).toLowerCase())) {
            return true;
        }
        if (this.ldapConfig.getBaseDn().length() < 1) {
            return true;
        }
        return string.indexOf(61, n + 1) < 0;
    }

    private boolean fullDN(String string, String string2) {
        String string3;
        String string4;
        if (string == null || string.length() < 3 || string.indexOf(61) < 0) {
            return false;
        }
        int n = string.indexOf(61);
        if (this.ldapConfig.isIgnoreBaseDn()) {
            if (string.indexOf(92) < 0 && string.indexOf(34) < 0) {
                return true;
            }
            if (string.charAt(n - 1) == '\\' && string.indexOf(61, n + 1) < 0) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '=') {
                    bl = true;
                }
                if (string.charAt(i) == '\\' && string.charAt(i + 1) == '=') {
                    bl = false;
                    ++i;
                    continue;
                }
                if (string.charAt(i) != '\"') continue;
                boolean bl2 = true;
                for (int j = i; j < string.length() && bl2; ++j) {
                    if (string.charAt(j) != '=') continue;
                    for (int k = j + 1; k < string.length() && bl2; ++k) {
                        if (string.charAt(k) != '\"') continue;
                        bl = false;
                        bl2 = false;
                        i = k;
                    }
                }
            }
            return bl;
        }
        if (string2.length() > 0 && (string4 = RegistryUtil.removeDNSpace(string, 0).toLowerCase()).endsWith(string3 = RegistryUtil.removeDNSpace(string2, 0).toLowerCase())) {
            return true;
        }
        if (string2.length() < 1) {
            return true;
        }
        return string.indexOf(61, n + 1) < 0;
    }

    protected EntryEnumeration search(int n, String string, int n2) throws NamingException {
        return this.search(this.ldapConfig.getBaseDn(), n, string, n2);
    }

    protected EntryEnumeration search(String string, int n, String string2, int n2) throws NamingException {
        return new EntryEnumeration(string, this.search(string, n, string2, noAttrs, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamingEnumeration search(String string, int n, String string2, String[] stringArray, int n2) throws NamingException {
        if (string.indexOf(35) > -1) {
            string = LdapRegistryImpl.escapeFirstChar(string, '#');
        }
        Name name = null;
        try {
            if (string != null && string.length() > 0) {
                name = new CompositeName().add(string);
            }
        }
        catch (Exception exception) {
            name = null;
        }
        if (name == null && string.indexOf(92) > 0) {
            string = LdapRegistryImpl.escapeChar(string, '\\');
        }
        if (string2.indexOf(92) > 0) {
            string2 = LdapRegistryImpl.escapeChar(string2, '\\');
        }
        StringBuffer stringBuffer = null;
        long l = 0L;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "search");
            stringBuffer = new StringBuffer("DN: ");
            stringBuffer.append(string);
            Tr.debug(tc, stringBuffer.toString());
            stringBuffer = new StringBuffer("Search scope: ");
            stringBuffer.append(n);
            Tr.debug(tc, stringBuffer.toString());
            stringBuffer = new StringBuffer("Filter: ");
            stringBuffer.append(string2);
            Tr.debug(tc, stringBuffer.toString());
            stringBuffer = new StringBuffer("Time limit: ");
            stringBuffer.append(n2);
            Tr.debug(tc, stringBuffer.toString());
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer = new StringBuffer("Attr[");
                stringBuffer.append(i);
                stringBuffer.append("]: ");
                stringBuffer.append(stringArray[i]);
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        NamingException namingException = null;
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(n);
        searchControls.setReturningAttributes(stringArray);
        searchControls.setReturningObjFlag(false);
        if (n2 != 0) {
            searchControls.setCountLimit(n2);
        }
        searchControls.setTimeLimit(searchTimeLimit);
        String string3 = null;
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> namingEnumeration = null;
        for (int i = 0; i < 3; ++i) {
            try {
                l = System.currentTimeMillis();
                if (LdapURL == null) {
                    dirContext = this.getDirContext();
                    this.enterJNDI();
                    namingEnumeration = name != null ? dirContext.search(name, string2, searchControls) : dirContext.search(string, string2, searchControls);
                    this.exitJNDI();
                    string3 = (String)dirContext.getEnvironment().get("java.naming.provider.url");
                    if (string3 != null && string3.equals(this.currentActiveLDAP)) {
                        this.DirContextPool.addElement(dirContext);
                    } else {
                        try {
                            dirContext.close();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    this.enterJNDI();
                    dirContext = new InitialDirContext(this.ldapConfig);
                    this.exitJNDI();
                    this.enterJNDI();
                    namingEnumeration = name != null ? dirContext.search(name, string2, searchControls) : dirContext.search(string, string2, searchControls);
                    this.exitJNDI();
                    dirContext.close();
                }
                if (tc.isDebugEnabled()) {
                    stringBuffer = new StringBuffer("Time elapsed: ");
                    stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                    Tr.debug(tc, stringBuffer.toString());
                    Tr.exit(tc, "search");
                }
                NamingEnumeration<SearchResult> namingEnumeration2 = namingEnumeration;
                return namingEnumeration2;
            }
            catch (NamingException namingException2) {
                this.exitJNDI();
                if (tc.isDebugEnabled()) {
                    stringBuffer = new StringBuffer("Time elapsed: ");
                    stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                    Tr.debug(tc, stringBuffer.toString());
                }
                this.logNamingException(namingException2);
                namingException = namingException2;
                String string4 = null;
                try {
                    if (dirContext != null) {
                        string4 = (String)dirContext.getEnvironment().get("java.naming.provider.url");
                        dirContext.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Tr.debug(tc, "Search against " + string4 + " fails.");
                if (string4 != null && !string4.equalsIgnoreCase(this.currentActiveLDAP)) continue;
                if (namingException2 instanceof NameNotFoundException) break;
                this.recycle();
                continue;
            }
            finally {
                this.exitJNDI();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "search");
        }
        FFDCFilter.processException(namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.search", "2055", this);
        throw namingException;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        Object object;
        Object object2;
        String string2;
        Object object3;
        String[] stringArray;
        Object object4;
        String[] stringArray2;
        Object object5;
        String string3;
        String string4;
        Cloneable cloneable;
        WSCredential wSCredential;
        block61: {
            String string5;
            Serializable serializable;
            Object object6;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredential", string);
            }
            wSCredential = null;
            cloneable = null;
            string4 = null;
            string3 = null;
            if (!useAttributeGroupMethod) {
                block60: {
                    object5 = new String[1];
                    stringArray2 = this.idMap.getAttributes();
                    object5[0] = stringArray2[1];
                    object4 = this.ldapConfig.getBaseDn();
                    try {
                        if (this.fullDN(string)) {
                            stringArray = this.search(string, 0, objectFilter, (String[])object5, 0);
                        } else {
                            string = LdapRegistryImpl.escapeChar(string, '*');
                            object3 = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                            stringArray = this.search((String)object4, 2, (String)object3, (String[])object5, 0);
                        }
                        if (!stringArray.hasMoreElements()) break block60;
                        object3 = stringArray.next();
                        object6 = (NameClassPair)object3;
                        string2 = ((NameClassPair)object6).getName();
                        if (string2 != null && string2.trim().length() > 1 && ((NameClassPair)object6).isRelative()) {
                            try {
                                string2 = new CompositeName(string2).get(0);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (string2.charAt(0) == '\"') {
                                string2 = string2.substring(1, string2.length() - 1);
                            }
                        }
                        if (string2 != null && string2.length() > 0 && ((NameClassPair)object6).isRelative()) {
                            string = string2;
                            if (object4 != null && ((String)object4).trim().length() > 1) {
                                string = string2 + "," + (String)object4;
                            }
                        }
                        if (!((NameClassPair)object6).isRelative() && string2 != null && string2.length() > 0) {
                            int n = string2.indexOf(47, 9);
                            if (n > -1 && string2.length() > n + 1) {
                                try {
                                    string2 = URLDecoder.decode(string2, "UTF8");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                string = string2.substring(n + 1);
                            } else {
                                string = NONE;
                            }
                        }
                        string4 = RegistryUtil.removeDNSpace(string, 0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "uniqueUserId = " + string4);
                        }
                        object2 = (SearchResult)object3;
                        object = ((SearchResult)object2).getAttributes().getAll();
                        while (object.hasMoreElements()) {
                            serializable = (Attribute)object.next();
                            string5 = serializable.getID();
                            if (!string5.equalsIgnoreCase((String)object5[0])) continue;
                            string3 = (String)serializable.get(0);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "displayName = " + string3);
                        }
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2156", this);
                        Tr.error(tc, "security.registry.createcredential.error", new Object[]{string});
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "createCredential", namingException);
                        }
                        throw new EntryNotFoundException(namingException.toString(), namingException);
                    }
                }
                cloneable = this.getUniqueGroupIds(string4);
            } else {
                object5 = this.idMap.getGroupMembers();
                stringArray2 = new String[2];
                object4 = this.idMap.getAttributes();
                stringArray2[0] = object4[1];
                if (((Object[])object5).length > 0) {
                    stringArray2[1] = ((IdMap.IdEntry)object5[0]).getObjectClassName();
                    if (RACF_GROUP_ATTRIBUTE.equalsIgnoreCase(stringArray2[1]) && !this.fullDN(string, this.ldapConfig.getBaseDn())) {
                        string = this.getUniqueUserId(string);
                    }
                }
                stringArray = new Vector(5);
                object3 = null;
                object6 = null;
                string2 = this.ldapConfig.getBaseDn();
                try {
                    if (this.fullDN(string, this.ldapConfig.getBaseDn())) {
                        object2 = this.search(string, 0, objectFilter, stringArray2, 0);
                    } else {
                        string = LdapRegistryImpl.escapeChar(string, '*');
                        object = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                        object2 = this.search(string2, 2, (String)object, stringArray2, 0);
                    }
                    if (object2.hasMoreElements()) {
                        Cloneable cloneable2;
                        object = object2.next();
                        serializable = (NameClassPair)object;
                        string5 = ((NameClassPair)serializable).getName();
                        if (string5 != null && string5.trim().length() > 1 && ((NameClassPair)serializable).isRelative()) {
                            try {
                                string5 = new CompositeName(string5).get(0);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (string5.charAt(0) == '\"') {
                                string5 = string5.substring(1, string5.length() - 1);
                            }
                        }
                        if (string5 != null && string5.length() > 0 && ((NameClassPair)serializable).isRelative()) {
                            string = string5;
                            if (string2 != null && string2.trim().length() > 1) {
                                string = string5 + "," + string2;
                            }
                        }
                        if (!((NameClassPair)serializable).isRelative() && string5 != null && string5.length() > 0) {
                            int n = string5.indexOf(47, 9);
                            if (n > -1 && string5.length() > n + 1) {
                                try {
                                    string5 = URLDecoder.decode(string5, "UTF8");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                string = string5.substring(n + 1);
                            } else {
                                string = NONE;
                            }
                        }
                        string4 = RegistryUtil.removeDNSpace(string, 0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "uniqueUserId = " + string4);
                        }
                        SearchResult searchResult = (SearchResult)object;
                        NamingEnumeration<? extends Attribute> namingEnumeration = searchResult.getAttributes().getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            cloneable2 = namingEnumeration.next();
                            String string6 = cloneable2.getID();
                            if (string6.equalsIgnoreCase(stringArray2[0])) {
                                string3 = (String)cloneable2.get(0);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "displayName = " + string3);
                                continue;
                            }
                            if (!string6.equalsIgnoreCase(stringArray2[1])) continue;
                            for (int i = 0; i < cloneable2.size(); ++i) {
                                object6 = (String)cloneable2.get(i);
                                object6 = RegistryUtil.removeDNSpace((String)object6, 0);
                                stringArray.addElement(object6);
                            }
                        }
                        if (stringArray.size() > 0) {
                            object3 = new String[stringArray.size()];
                            stringArray.copyInto((Object[])object3);
                            cloneable = new ArrayList<Object>(((Object[])object3).length);
                            cloneable2 = new ArrayList();
                            if (recursiveSearch) {
                                this.getAllGroupMembershipsByUserObject(string4, (ArrayList)cloneable2, new ArrayList(), stringArray2[1]);
                                cloneable = cloneable2;
                            }
                            for (int i = 0; i < ((Object[])object3).length; ++i) {
                                cloneable.add(object3[i]);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "groups name = " + (String)object3[i]);
                            }
                        }
                        if (object2.hasMoreElements()) {
                            object2.close();
                        }
                        break block61;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createCredential", "no users with name: " + string + " found");
                    }
                    Tr.error(tc, "security.registry.createcredential.nouser", new Object[]{string});
                    throw new EntryNotFoundException("Cannot find the user: " + string);
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2298", this);
                    Tr.error(tc, "security.registry.createcredential.error", new Object[]{string});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createCredential", namingException);
                    }
                    throw new EntryNotFoundException(namingException.toString(), namingException);
                }
            }
        }
        if (string3 == null || string3.trim().length() <= 0) {
            string3 = string4;
        }
        try {
            object5 = RegistryUtil.appendRealm(USERTYPE, string4, this.realm);
            stringArray2 = string4;
            object4 = new ArrayList();
            stringArray = null;
            object3 = null;
            if (cloneable != null && cloneable.size() > 0) {
                stringArray = cloneable.toArray(new String[cloneable.size()]);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i == 0) {
                        object3 = RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], this.realm);
                    }
                    ((ArrayList)object4).add(RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], this.realm));
                }
            }
            final String string7 = this.realm;
            string2 = string3;
            object2 = object3;
            object = object4;
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction((String)stringArray2, (String)object2, (String)object5, (ArrayList)object){
                    private final /* synthetic */ String val$longSecurityName;
                    private final /* synthetic */ String val$primaryGroupIdPriv;
                    private final /* synthetic */ String val$accessId;
                    private final /* synthetic */ ArrayList val$groupListPriv;
                    {
                        this.val$longSecurityName = string3;
                        this.val$primaryGroupIdPriv = string4;
                        this.val$accessId = string5;
                        this.val$groupListPriv = arrayList;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string7, string2, this.val$longSecurityName, this.val$primaryGroupIdPriv != null ? this.val$primaryGroupIdPriv : nullString, this.val$accessId, null, this.val$groupListPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2359", this);
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2365", this);
            Tr.error(tc, "security.registry.createcredential.error", new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCredential", exception);
            }
            throw new EntryNotFoundException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", string);
        }
        return wSCredential;
    }

    protected static String escapeChar(String string, char c) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuffer.append('\\').append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static String escapeFirstChar(String string, char c) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 32;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (i > 1) {
                n2 = string.charAt(i - 1);
            }
            if (c2 == c && n2 == 61) {
                stringBuffer.append('\\').append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private void logNamingException(NamingException namingException) {
        this.logNamingException(namingException, null);
    }

    private void logNamingException(NamingException namingException, String string) {
        if (string != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "name = " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, namingException.getMessage());
        }
        if (namingException.getExplanation() != null && tc.isDebugEnabled()) {
            Tr.debug(tc, namingException.getExplanation());
        }
        if (namingException.getRootCause() != null && tc.isDebugEnabled()) {
            Tr.debug(tc, namingException.getRootCause().getMessage(), namingException.getRootCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirContext getDirContext() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDirContext");
        }
        DirContext dirContext = null;
        Object object = lockObj1;
        synchronized (object) {
            if (refresh) {
                this.refresh();
                refresh = false;
            }
            while (this.DirContextPool != null && this.DirContextPool.size() > this.maxIdleContext) {
                try {
                    dirContext = (DirContext)this.DirContextPool.lastElement();
                    this.DirContextPool.removeElement(dirContext);
                    dirContext.close();
                    --this.ContextPoolSize;
                }
                catch (Exception exception) {}
            }
            try {
                if (this.DirContextPool != null && this.DirContextPool.size() > 0) {
                    dirContext = (DirContext)this.DirContextPool.lastElement();
                    this.DirContextPool.removeElement(dirContext);
                    Tr.exit(tc, "getDirContext");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDirContext");
                    }
                    return dirContext;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        Object object2 = lockObj2;
        synchronized (object2) {
            try {
                if (this.DirContextPool != null && this.DirContextPool.size() > 0) {
                    dirContext = (DirContext)this.DirContextPool.lastElement();
                    this.DirContextPool.removeElement(dirContext);
                    Tr.exit(tc, "getRootDSE");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDirContext");
                    }
                    return dirContext;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = this.ldapConfig.getDirectoryUrl();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                LdapConfig ldapConfig = new LdapConfig(this.ldapConfig);
                ldapConfig.setDirectoryUrl(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "try connect to " + string2);
                }
                try {
                    this.enterJNDI();
                    object = new InitialDirContext(ldapConfig);
                    this.exitJNDI();
                    break;
                }
                catch (NamingException namingException) {
                    this.exitJNDI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, namingException.toString());
                    }
                    if (stringTokenizer.hasMoreTokens()) continue;
                    if (namingException instanceof CommunicationException) {
                        Tr.audit(tc, "security.registry.ldap.connect.audit", new Object[]{string});
                    }
                    throw namingException;
                }
            }
            for (int i = 0; i < this.maxContextPerConnection; ++i) {
                try {
                    this.enterJNDI();
                    dirContext = (DirContext)object.lookup(NONE);
                    this.exitJNDI();
                    this.DirContextPool.addElement(dirContext);
                    ++this.ContextPoolSize;
                    continue;
                }
                catch (Exception exception) {
                    this.exitJNDI();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "create DirContext pool for this connection.");
            }
            ++this.ContextPoolSize;
        }
        if (tc.isDebugEnabled() && this.DirContextPool.size() + this.busyCount > 30) {
            Tr.debug(tc, "DirContext pool size => " + this.DirContextPool.size() + this.busyCount);
        }
        this.currentActiveLDAP = (String)object.getEnvironment().get("java.naming.provider.url");
        Tr.audit(tc, "security.registry.ldap.connected.audit", new Object[]{this.currentActiveLDAP});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDirContext");
        }
        return object;
    }

    protected void recycle() {
        if (this.DirContextPool == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recycle");
        }
        while (!this.DirContextPool.isEmpty()) {
            try {
                DirContext dirContext = (DirContext)this.DirContextPool.lastElement();
                this.DirContextPool.removeElement(dirContext);
                dirContext.close();
            }
            catch (Exception exception) {}
        }
        this.ContextPoolSize = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recycle");
        }
    }

    private synchronized void refresh() {
        block9: {
            LdapConfig ldapConfig = new LdapConfig(this.ldapConfig);
            if (bindDN != null) {
                ldapConfig.setAuthenticationPrincipal(bindDN);
            }
            if (bindPWD != null) {
                ldapConfig.setAuthenticationCredentials(bindPWD);
            }
            if (bindHost != null) {
                ldapConfig.setDirectoryUrl(bindHost);
            }
            try {
                InitialDirContext initialDirContext = new InitialDirContext(ldapConfig);
                initialDirContext.close();
                if (bindHost != null) {
                    this.ldapConfig.setDirectoryUrl(bindHost);
                }
                if (bindDN != null) {
                    this.ldapConfig.setAuthenticationPrincipal(bindDN);
                }
                if (bindPWD != null) {
                    this.ldapConfig.setAuthenticationCredentials(bindPWD);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LDAP registry has been refreshed.");
                }
                bindHost = null;
                bindDN = null;
                bindPWD = null;
                Tr.audit(tc, "security.registry.ldap.updated.audit");
                this.recycle();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "LDAP registry can NOT be refreshed.");
            }
        }
    }

    public static synchronized void refreshRegistry(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshRegistry");
        }
        bindHost = null;
        bindDN = null;
        bindPWD = null;
        if (string3 != null && string3.length() > 0) {
            bindHost = string3;
        }
        if (string != null && string != NONE && string2 != null && string2 != NONE) {
            bindDN = string;
            bindPWD = string2;
        }
        refresh = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshRegistry");
        }
    }

    private void exitJNDI() {
        Thread thread2 = Thread.currentThread();
        if (this.table1.contains(thread2)) {
            this.table1.remove(thread2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exitJNDI:" + thread2.getName());
            }
        }
        if (this.table2.contains(thread2)) {
            this.table2.remove(thread2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exitJNDI:" + thread2.getName());
            }
        }
        if (this.table3.contains(thread2)) {
            this.table3.remove(thread2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exitJNDI:" + thread2.getName());
            }
        }
    }

    private void enterJNDI() {
        Thread thread2 = Thread.currentThread();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enterJNDI:" + thread2.getName());
        }
        this.table1.add(thread2);
    }

    void interruptJNDI() {
        Thread thread2 = null;
        while (this.table3 != null && !this.table3.isEmpty()) {
            thread2 = (Thread)this.table3.lastElement();
            this.table3.remove(thread2);
            try {
                thread2.interrupt();
                thread2.interrupted();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Thread interrupted: " + thread2.getName());
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not interrupt thread: " + thread2.getName());
            }
        }
        while (this.table2 != null && !this.table2.isEmpty()) {
            thread2 = (Thread)this.table2.lastElement();
            this.table2.removeElement(thread2);
            this.table3.addElement(thread2);
        }
        while (this.table1 != null && !this.table1.isEmpty()) {
            thread2 = (Thread)this.table1.lastElement();
            this.table1.removeElement(thread2);
            this.table2.addElement(thread2);
        }
    }

    private final class LdapMonitor
    extends Thread {
        private LdapMonitor() {
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(innerTc, "run");
            }
            LdapRegistryImpl.this.scanInactiveLDAP();
            try {
                while (true) {
                    try {
                        LdapMonitorThread;
                        Thread.sleep(searchTimeLimit / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LdapRegistryImpl.this.interruptJNDI();
                }
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                return;
            }
        }
    }
}

