/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class LdapLoadBalanceImpl {
    private static TraceComponent tc = Tr.register(LdapLoadBalanceImpl.class, null, "com.ibm.ejs.resources.security");
    private static int selectionCursor = -1;
    private static int loadBalancePolicy = 1;
    private static final int RoundRobin = 1;
    private static final int WeightedRoundRobin = 2;
    private static final int RandomWalk = 3;
    private static final int WeightedRandomWalk = 4;
    private static final int UsePrefer = 5;
    private static int maintainWindowTime = 300000;
    private static Vector ldapServers = new Vector();
    private static Hashtable contextTable = new Hashtable();
    private static Hashtable ldapStatusTable = new Hashtable();
    private static Vector ldapLoads = new Vector();
    private static LdapConfig baseLdapConfig;
    private static Thread ldapServiceThread;
    private static TraceComponent innerTc;

    public LdapLoadBalanceImpl(LdapConfig ldapConfig) {
        this.initialize(ldapConfig);
    }

    public synchronized void initialize(LdapConfig ldapConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize Ldap Load Balance.");
        }
        if (ldapServiceThread == null) {
            baseLdapConfig = new LdapConfig(ldapConfig);
            selectionCursor = 0;
            this.readLoadBalancePolicy();
            this.readGroupOfLdapServers();
            this.createCtxPool();
            ldapServiceThread = new LdapServiceMonitor();
            ldapServiceThread.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize Ldap Load Balance.");
        }
    }

    private void readLoadBalancePolicy() {
        loadBalancePolicy = 1;
        if (tc.isEntryEnabled()) {
            String string = new Integer(loadBalancePolicy).toString();
            Tr.debug(tc, "Use load balance policy: ", string);
        }
    }

    private void readGroupOfLdapServers() {
        ldapServers.clear();
        ldapLoads.clear();
        String string = "ldap://secfvt2.austin.ibm.com:389/";
        ldapServers.addElement(string);
        ldapStatusTable.put(string, "-1");
        ldapLoads.addElement("2");
        string = "ldap://cliang.austin.ibm.com:389/";
        ldapServers.addElement(string);
        ldapStatusTable.put(string, "-1");
        ldapLoads.addElement("1");
        if (ldapServers.size() == 1) {
            loadBalancePolicy = 1;
        }
    }

    private synchronized void createCtxPool() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Create Ldap context pools.");
        }
        String string = null;
        Enumeration enumeration = ldapServers.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            LdapConfig ldapConfig = new LdapConfig(baseLdapConfig);
            ldapConfig.put("java.naming.provider.url", string);
            InitialDirContext initialDirContext = null;
            try {
                initialDirContext = new InitialDirContext(ldapConfig);
                contextTable.put(string, initialDirContext);
                ldapStatusTable.put(string, "0");
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "create context for ", string);
            }
            catch (NamingException namingException) {
                ldapStatusTable.put(string, "-1");
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "can not create context for ", string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create Ldap context pools.");
        }
    }

    public String getLdapServer() {
        if (!this.isLdapOnLine()) {
            this.recoverLdapService();
            selectionCursor = 0;
        }
        if (!this.isLdapOnLine()) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "can not connect to any Ldap server.");
            }
            return null;
        }
        if (ldapServers.size() == 1) {
            return (String)ldapServers.firstElement();
        }
        String string = null;
        switch (loadBalancePolicy) {
            case 1: {
                string = this.RoundRobinWithRotation();
                break;
            }
            case 2: {
                string = this.WeightedRoundRobinWithRotation();
                break;
            }
            case 3: {
                string = this.RandomSchedule();
                break;
            }
            case 4: {
                string = this.WeightedRandomSchedule();
                break;
            }
            case 5: {
                string = this.FailOverWithPrefer();
                break;
            }
            default: {
                string = this.RoundRobinWithRotation();
            }
        }
        String string2 = (String)ldapStatusTable.get(string);
        if (string2.equals("0")) {
            ldapStatusTable.put(string, "1");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The target Ldap server is ", string);
        }
        return string;
    }

    private boolean isLdapOnLine() {
        String string = null;
        int n = 0;
        for (n = 0; n < ldapServers.size(); ++n) {
            string = (String)ldapServers.elementAt(n);
            String string2 = (String)ldapStatusTable.get(string);
            if (string2.equals("-1")) continue;
            return true;
        }
        return false;
    }

    private int getTotalLdapOnLine() {
        String string = null;
        int n = 0;
        int n2 = 0;
        for (n = 0; n < ldapServers.size(); ++n) {
            string = (String)ldapServers.elementAt(n);
            String string2 = (String)ldapStatusTable.get(string);
            if (string2.equals("-1")) continue;
            ++n2;
        }
        return n2;
    }

    private synchronized String RoundRobinWithRotation() {
        String string;
        String string2 = null;
        int n = selectionCursor;
        boolean bl = false;
        for (n = selectionCursor; n < ldapServers.size(); ++n) {
            string2 = (String)ldapServers.elementAt(n);
            string = (String)ldapStatusTable.get(string2);
            if (string.equals("-1")) continue;
            selectionCursor = n + 1;
            if (selectionCursor == ldapServers.size()) {
                selectionCursor = 0;
            }
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < selectionCursor; ++n) {
                string2 = (String)ldapServers.elementAt(n);
                string = (String)ldapStatusTable.get(string2);
                if (string.equals("-1")) continue;
                selectionCursor = n + 1;
                break;
            }
        }
        return string2;
    }

    private synchronized String WeightedRoundRobinWithRotation() {
        String string;
        String string2;
        String string3 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        for (n = 0; n < ldapServers.size(); ++n) {
            string3 = (String)ldapServers.elementAt(n);
            string2 = (String)ldapStatusTable.get(string3);
            string = (String)ldapLoads.elementAt(n);
            if (!string2.equals("-1") && !string2.equals(string)) {
                bl2 = false;
            }
            if (!bl2) break;
        }
        if (bl2) {
            for (n = 0; n < ldapServers.size(); ++n) {
                string3 = (String)ldapServers.elementAt(n);
                string2 = (String)ldapStatusTable.get(string3);
                if (string2.equals("-1")) continue;
                ldapStatusTable.put(string3, "0");
            }
            selectionCursor = 0;
        }
        n = selectionCursor;
        for (n = selectionCursor; n < ldapServers.size(); ++n) {
            string3 = (String)ldapServers.elementAt(n);
            string2 = (String)ldapStatusTable.get(string3);
            string = (String)ldapLoads.elementAt(n);
            if (string2.equals("-1") || string2.equals(string)) continue;
            selectionCursor = n + 1;
            if (selectionCursor == ldapServers.size()) {
                selectionCursor = 0;
            }
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < selectionCursor; ++n) {
                string3 = (String)ldapServers.elementAt(n);
                string2 = (String)ldapStatusTable.get(string3);
                string = (String)ldapLoads.elementAt(n);
                if (string2.equals("-1") || string2.equals(string)) continue;
                selectionCursor = n + 1;
                break;
            }
        }
        string2 = (String)ldapStatusTable.get(string3);
        Integer n2 = new Integer(string2);
        int n3 = n2 + 1;
        n2 = new Integer(n3);
        ldapStatusTable.put(string3, n2.toString());
        return string3;
    }

    private String RandomSchedule() {
        String string;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        for (n = 0; n < ldapServers.size(); ++n) {
            string2 = (String)ldapServers.elementAt(n);
            string = (String)ldapStatusTable.get(string2);
            if (string.equals("-1")) continue;
            ++n2;
        }
        Random random = new Random();
        int n3 = random.nextInt(n2);
        n2 = 0;
        for (n = 0; n < ldapServers.size() && ((string = (String)ldapStatusTable.get(string2 = (String)ldapServers.elementAt(n))).equals("-1") || ++n2 != n3); ++n) {
        }
        return string2;
    }

    private String WeightedRandomSchedule() {
        Integer n;
        String string;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < ldapServers.size(); ++n2) {
            string2 = (String)ldapServers.elementAt(n2);
            string = (String)ldapStatusTable.get(string2);
            if (string.equals("-1")) continue;
            n = new Integer((String)ldapLoads.elementAt(n2));
            n3 += n.intValue();
        }
        String string3 = new Integer(n3).toString();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "total loads = : ", string3);
        }
        Random random = new Random();
        int n4 = random.nextInt(n3);
        n3 = 0;
        for (n2 = 0; n2 < ldapServers.size() && ((string = (String)ldapStatusTable.get(string2 = (String)ldapServers.elementAt(n2))).equals("-1") || n4 >= (n3 += (n = new Integer((String)ldapLoads.elementAt(n2))).intValue())); ++n2) {
        }
        return string2;
    }

    private String FailOverWithPrefer() {
        String string = null;
        int n = 0;
        string = (String)ldapServers.elementAt(n);
        String string2 = (String)ldapStatusTable.get(string);
        if (!string2.equals("-1")) {
            return string;
        }
        string = this.RoundRobinWithRotation();
        return string;
    }

    public InitialDirContext getLdapContext(String string) throws NamingException {
        InitialDirContext initialDirContext = (InitialDirContext)contextTable.get(string);
        return initialDirContext;
    }

    public void removeCtx(String string, InitialDirContext initialDirContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close context of ", string);
        }
        try {
            ldapStatusTable.put(string, "-1");
            contextTable.remove(string);
            initialDirContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close context of ", string);
        }
    }

    private synchronized void recoverLdapService() {
        String string = null;
        int n = 0;
        for (n = 0; n < ldapServers.size(); ++n) {
            string = (String)ldapServers.elementAt(n);
            String string2 = (String)ldapStatusTable.get(string);
            if (!string2.equals("-1")) continue;
            LdapConfig ldapConfig = baseLdapConfig;
            ldapConfig.put("java.naming.provider.url", string);
            InitialDirContext initialDirContext = null;
            try {
                initialDirContext = new InitialDirContext(ldapConfig);
                contextTable.put(string, initialDirContext);
                ldapStatusTable.put(string, "0");
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Reconnect to Ldap server: ", string);
                continue;
            }
            catch (NamingException namingException) {
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Fail to reconnect to Ldap server: ", string);
            }
        }
    }

    public void pingLdap() {
        String string = null;
        int n = 0;
        for (n = 0; n < ldapServers.size(); ++n) {
            string = (String)ldapServers.elementAt(n);
            String string2 = (String)ldapStatusTable.get(string);
            if (string2.equals("0")) {
                InitialDirContext initialDirContext = (InitialDirContext)contextTable.get(string);
                try {
                    String[] stringArray = new String[]{"port"};
                    Attributes attributes = initialDirContext.getAttributes(string, stringArray);
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Ldap server is functional: ", string);
                }
                catch (NamingException namingException) {
                    this.removeCtx(string, initialDirContext);
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Ldap server is unavailable: ", string);
                }
                continue;
            }
            if (string2.equals("-1")) continue;
            ldapStatusTable.put(string, "0");
        }
    }

    private void updateLdapAccessTime(String string) {
        long l = new Date().getTime();
        Long l2 = new Long(l);
        String string2 = l2.toString();
        ldapStatusTable.put(string, string2);
    }

    static {
        innerTc = Tr.register(LdapServiceMonitor.class.getName(), null, "com.ibm.ejs.resources.security");
    }

    private final class LdapServiceMonitor
    extends Thread {
        private LdapServiceMonitor() {
        }

        public void run() {
            Tr.entry(innerTc, "run");
            try {
                while (true) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(innerTc, "Ldap service Thread going to sleep...");
                    }
                    try {
                        ldapServiceThread;
                        Thread.sleep(maintainWindowTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(innerTc, "Ldap service Thread is waking up and dispatching...");
                    }
                    LdapLoadBalanceImpl.this.pingLdap();
                    LdapLoadBalanceImpl.this.recoverLdapService();
                }
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                return;
            }
        }
    }
}

