/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.provider;

import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Group;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.provider.WSPolicyConfigurationImpl;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import org.eclipse.jst.j2ee.common.SecurityRole;

public class JaccProvider {
    private static TraceComponent tc = Tr.register(JaccProvider.class, null, "com.ibm.ejs.resources.security");
    private static JaccProvider jaccProvider;
    private static boolean initialized;
    private static boolean ignoreCase;

    public static JaccProvider getInstance() {
        if (!initialized) {
            jaccProvider = new JaccProvider();
            initialized = true;
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (bl != null && bl.booleanValue()) {
                ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase is set");
                }
            }
        }
        return jaccProvider;
    }

    private JaccProvider() {
    }

    public boolean checkUncheckedPerm(WSPolicyConfigurationImpl wSPolicyConfigurationImpl, Permission permission) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkUncheckedPerm: " + permission);
        }
        if ((arrayList = wSPolicyConfigurationImpl.getUncheckedList()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Permission permission2 = (Permission)arrayList.get(i);
                if (!permission2.implies(permission)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The permission: " + permission + " is in the uncheckedList. exit value:true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "The permission: " + permission + " is not in the uncheckedList. exit value:false");
        }
        return false;
    }

    public boolean checkExcludedPerm(WSPolicyConfigurationImpl wSPolicyConfigurationImpl, Permission permission) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkExcludedPerm: " + permission);
        }
        if ((arrayList = wSPolicyConfigurationImpl.getExcludedList()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((Permission)arrayList.get(i)).implies(permission)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The permission: " + permission + " is in the excludedList. exit value:false");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "The permission: " + permission + " is not in the excludedList. exit value:true");
        }
        return false;
    }

    public boolean isEveryoneGranted(WSPolicyConfigurationImpl wSPolicyConfigurationImpl, Permission permission, String string) {
        int n;
        Object object;
        Object object2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isEveryoneGranted: " + permission);
        }
        HashMap hashMap = wSPolicyConfigurationImpl.getRoleToPermMap();
        ArrayList<Object> arrayList = null;
        if (!hashMap.isEmpty()) {
            arrayList = new ArrayList<Object>();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (ArrayList)hashMap.get(object2);
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Permission permission2 = (Permission)((ArrayList)object).get(n);
                    if (!permission2.implies(permission)) continue;
                    arrayList.add(object2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added role: " + (String)object2 + " to the requiredRoleList for Permission: " + permission);
                }
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            List list;
            int n2 = string.lastIndexOf("/");
            object2 = null;
            if (n2 != -1) {
                object = string.substring(0, n2);
                n = ((String)object).lastIndexOf("/");
                object2 = n != -1 ? ((String)object).substring(n + 1) : object;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "application name is: " + (String)object2);
            }
            if ((object = WSAccessManager.getAuthorizationTable((String)object2)) != null && (list = object.getRolesForSubject(Constants.EVERYONE)) != null) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!arrayList.contains(((SecurityRole)list.get(n2)).getRoleName())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Everyone is granted access: . exit value:true");
                    }
                    return true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Everyone is not granted access:");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRolePerm(WSPolicyConfigurationImpl wSPolicyConfigurationImpl, Permission permission, String string) {
        String[] stringArray;
        String string2;
        List list;
        AuthorizationTable authorizationTable;
        ArrayList<String> arrayList;
        block49: {
            Subject subject;
            block48: {
                Object object;
                HashMap hashMap;
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "checkRolePerm: " + permission);
                }
                if ((hashMap = wSPolicyConfigurationImpl.getRoleToPermMap()).isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "No required roles list in the PolicyConfiguration for ContextID: " + string + " . exit value:true");
                    }
                    return true;
                }
                arrayList = new ArrayList<String>();
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    object = (ArrayList)hashMap.get(string3);
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        Permission permission2 = (Permission)((ArrayList)object).get(i);
                        if (!permission2.implies(permission)) continue;
                        arrayList.add(string3);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added role: " + string3 + " to the requiredRoleList for Permission: " + permission);
                    }
                }
                if (!(permission instanceof WebRoleRefPermission) && !(permission instanceof EJBRoleRefPermission) && arrayList.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "No required roles. exit value:true");
                    }
                    return true;
                }
                int n = string.lastIndexOf("/");
                object = null;
                if (n != -1) {
                    String string4 = string.substring(0, n);
                    int n2 = string4.lastIndexOf("/");
                    object = n2 != -1 ? string4.substring(n2 + 1) : string4;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application name is: " + (String)object);
                }
                if ((authorizationTable = WSAccessManager.getAuthorizationTable((String)object)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "cannot get the authorization table for application : " + (String)object + ". exit value:false");
                    }
                    return false;
                }
                list = null;
                if (!(permission instanceof WebResourcePermission) && (list = authorizationTable.getRolesForSubject(Constants.EVERYONE)) != null) {
                    for (n = 0; n < list.size(); ++n) {
                        if (!arrayList.contains(((SecurityRole)list.get(n)).getRoleName())) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "Everyone is granted access: . exit value:true");
                        }
                        return true;
                    }
                }
                Object object2 = null;
                try {
                    object2 = PolicyContext.getContext("javax.security.auth.Subject.container");
                }
                catch (PolicyContextException policyContextException) {
                    FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.authorize.JaccProvider.implies", "246", this);
                    Tr.error(tc, "security.jacc.provider.pcontextkey.error", new Object[]{"javax.security.auth.Subject.container", policyContextException});
                    object2 = null;
                }
                if (object2 == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Cannot get the subject from the policy context. exit value:false");
                    }
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Object returned from the policy context is: " + object2);
                }
                subject = null;
                if (object2 instanceof Subject) {
                    subject = (Subject)object2;
                }
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (subject == null || wSCredential.isUnauthenticated()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Subject is null or Unauthenticated, exit value:false");
                    }
                    return false;
                }
                ContextManager contextManager = ContextManagerFactory.getInstance();
                try {
                    if (wSCredential.isBasicAuth()) {
                        subject = contextManager.login(wSCredential);
                    }
                }
                catch (Exception exception) {
                    subject = null;
                    if (!tc.isDebugEnabled()) break block48;
                    Tr.debug(tc, "authentication failed:" + exception);
                }
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGrantedAnyRole, getActualCredential() thru an exception, exit value:false");
                }
                return false;
            }
            List list2 = authorizationTable.getRolesForSubject(Constants.ALL_AUTHENTICATED_USERS);
            if (list2 != null) {
                for (int i = 0; i < list2.size(); ++i) {
                    if (!arrayList.contains(((SecurityRole)list2.get(i)).getRoleName())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "granted access to authenticated user, exit value:true");
                    }
                    return true;
                }
            }
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            string2 = null;
            try {
                string2 = this.getAccessId(wSCredential);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAccessId throw an exception:" + generalSecurityException);
                }
                string2 = "???";
            }
            User user = WCCMHelper.createUser("user", "user");
            list = null;
            User user2 = user;
            synchronized (user2) {
                user.setAccessId(string2);
                user.setName(string2);
                list = authorizationTable.getRolesForSubject(user);
            }
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!arrayList.contains(((SecurityRole)list.get(i)).getRoleName())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "granted access, exit value:true");
                    }
                    return true;
                }
            }
            list = null;
            stringArray = null;
            try {
                stringArray = this.getGroupIds(wSCredential);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (!tc.isDebugEnabled()) break block49;
                Tr.debug(tc, "getGroupId throw an exception:" + generalSecurityException);
            }
        }
        int n = stringArray == null ? 0 : stringArray.length;
        Group group = WCCMHelper.createGroup("group", "group");
        for (int i = 0; i < n; ++i) {
            Group group2 = group;
            synchronized (group2) {
                group.setAccessId(stringArray[i]);
                group.setName(stringArray[i]);
                list = authorizationTable.getRolesForSubject(group);
            }
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                if (!arrayList.contains(((SecurityRole)list.get(j)).getRoleName())) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Group subjects.contains() accessId[" + string2 + "], exit value:true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "No role or group role found for accessId[" + string2 + "], exit value:false");
        }
        return false;
    }

    private String getAccessId(WSCredential wSCredential) throws GeneralSecurityException {
        String string = wSCredential.getAccessId();
        if (string != null && string.length() > 0 && ignoreCase) {
            string = string.toLowerCase();
        }
        return string;
    }

    private String[] getGroupIds(WSCredential wSCredential) throws GeneralSecurityException {
        ArrayList arrayList = wSCredential.getGroupIds();
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (ignoreCase) {
            int n = stringArray == null ? 0 : stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringArray[i].toLowerCase();
            }
        }
        return stringArray;
    }

    static {
        initialized = false;
        ignoreCase = false;
    }
}

