/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

class FilePathUtil {
    private static BitSet encodingRequired = new BitSet(256);

    static String encodeFilePath(String string) {
        int n = 0;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
                continue;
            }
            if (c < '\u0080') {
                if (encodingRequired.get(c)) {
                    FilePathUtil.escape(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u07ff') {
                FilePathUtil.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                FilePathUtil.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                FilePathUtil.escape(stringBuffer, (char)(0x80 | c & 0x3F));
                continue;
            }
            FilePathUtil.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
            FilePathUtil.escape(stringBuffer, (char)(0x80 | c & 0x3F));
        }
        return stringBuffer.toString();
    }

    static String decodeFilePath(String string) throws DecodeException {
        int n = 0;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n + 32);
        int n2 = 0;
        block4: while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '%') {
                ++n2;
                stringBuffer.append(c);
                continue;
            }
            c = FilePathUtil.unescpae(string.charAt(n2 + 1), string.charAt(n2 + 2));
            n2 += 3;
            if ((c & 0x80) != 0) {
                switch (c >> 4) {
                    case 12: 
                    case 13: {
                        char c2 = string.charAt(n2);
                        if (c2 != '%') {
                            throw new DecodeException("Expect '%', but found '" + c2 + "'");
                        }
                        c2 = FilePathUtil.unescpae(string.charAt(n2 + 1), string.charAt(n2 + 2));
                        n2 += 3;
                        stringBuffer.append((char)((c & 0x1F) << 6 | c2 & 0x3F));
                        continue block4;
                    }
                    case 14: {
                        char c2 = string.charAt(n2);
                        if (c2 != '%') {
                            throw new DecodeException("Expect '%', but found '" + c2 + "'");
                        }
                        c2 = FilePathUtil.unescpae(string.charAt(n2 + 1), string.charAt(n2 + 2));
                        char c3 = string.charAt(n2 += 3);
                        if (c3 != '%') {
                            throw new DecodeException("Expect '%', but found '" + c2 + "'");
                        }
                        c3 = FilePathUtil.unescpae(string.charAt(n2 + 1), string.charAt(n2 + 2));
                        n2 += 3;
                        stringBuffer.append((char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F));
                        continue block4;
                    }
                }
                throw new DecodeException("Unknown encoding sequence \"" + new String(new char[]{'%', string.charAt(n2 + 1), string.charAt(n2 + 2)}) + "\"");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static URL filePathToURL(File file) throws MalformedURLException {
        String string = FilePathUtil.encodeFilePath(file.getAbsolutePath());
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    static URL filePathToURL(File file, String string) throws MalformedURLException {
        String string2 = FilePathUtil.encodeFilePath(file.getAbsolutePath());
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        if (file.isDirectory()) {
            string2 = string2 + string;
        }
        return new URL("file", "", string2);
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c & 0xF, 16));
    }

    private static char unescpae(char c, char c2) throws DecodeException {
        int n = Character.digit(c, 16);
        int n2 = Character.digit(c2, 16);
        if (n == -1 || n2 == -1) {
            throw new DecodeException("Can not unescape \"" + new String(new char[]{'%', c, c2}) + "\"");
        }
        return (char)(n << 4 | n2);
    }

    private FilePathUtil() {
    }

    static {
        encodingRequired.set(61);
        encodingRequired.set(59);
        encodingRequired.set(63);
        encodingRequired.set(47);
        encodingRequired.set(35);
        encodingRequired.set(32);
        encodingRequired.set(60);
        encodingRequired.set(62);
        encodingRequired.set(37);
        encodingRequired.set(34);
        encodingRequired.set(123);
        encodingRequired.set(125);
        encodingRequired.set(124);
        encodingRequired.set(39);
        encodingRequired.set(94);
        encodingRequired.set(91);
        encodingRequired.set(93);
        encodingRequired.set(96);
        encodingRequired.set(127);
        for (int i = 0; i < 32; ++i) {
            encodingRequired.set(i);
        }
    }

    static class DecodeException
    extends Exception {
        private static final long serialVersionUID = 8237803124662929625L;

        private DecodeException(String string) {
            super(string);
        }
    }
}

