/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.util.ByteArray;
import java.security.PrivateKey;

public final class LTPAPrivateKey
implements PrivateKey {
    private byte[][] rawKey;
    private byte[] encodedKey;
    private int eLength = 3;
    private int pLength = 65;
    private int qLength = 65;
    private int privExponentLength;

    public LTPAPrivateKey() {
    }

    LTPAPrivateKey(byte[][] byArray) {
        this.rawKey = byArray;
        LTPACrypto.setRSAKey(byArray);
        this.privExponentLength = byArray[1].length;
        this.encodedKey = this.encode();
    }

    LTPAPrivateKey(byte[] byArray) {
        this.encodedKey = byArray;
        this.rawKey = this.decode(byArray);
    }

    private byte[][] decode(byte[] byArray) {
        byte[][] byArrayArray = new byte[8][];
        if (byArray.length > this.eLength + this.pLength + this.qLength) {
            byte[] byArray2 = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray2[i] = byArray[i];
            }
            this.privExponentLength = LTPAPrivateKey.toInt(byArray2);
            byArrayArray[1] = new byte[this.privExponentLength];
            byArrayArray[2] = new byte[this.eLength];
            byArrayArray[3] = new byte[this.pLength];
            byArrayArray[4] = new byte[this.qLength];
            ByteArray.copy(byArray, 4, this.privExponentLength, byArrayArray[1], 0);
            ByteArray.copy(byArray, this.privExponentLength + 4, this.eLength, byArrayArray[2], 0);
            ByteArray.copy(byArray, this.privExponentLength + this.eLength + 4, this.pLength, byArrayArray[3], 0);
            ByteArray.copy(byArray, this.privExponentLength + this.eLength + this.pLength + 4, this.qLength, byArrayArray[4], 0);
        } else {
            byArrayArray[2] = new byte[this.eLength];
            byArrayArray[3] = new byte[this.pLength];
            byArrayArray[4] = new byte[this.qLength];
            ByteArray.copy(byArray, 0, this.eLength, byArrayArray[2], 0);
            ByteArray.copy(byArray, this.eLength, this.pLength, byArrayArray[3], 0);
            ByteArray.copy(byArray, this.eLength + this.pLength, this.qLength, byArrayArray[4], 0);
        }
        return byArrayArray;
    }

    private byte[] encode() {
        int n = this.privExponentLength + this.eLength + this.pLength + this.qLength + 4;
        byte[] byArray = new byte[n];
        byte[] byArray2 = LTPAPrivateKey.toByteArray(this.privExponentLength);
        ByteArray.copy(byArray2, 0, 4, byArray, 0);
        ByteArray.copy(this.rawKey[1], 0, this.privExponentLength, byArray, 4);
        ByteArray.copy(this.rawKey[2], 0, this.eLength, byArray, this.privExponentLength + 4);
        ByteArray.copy(this.rawKey[3], 0, this.pLength, byArray, this.privExponentLength + this.eLength + 4);
        ByteArray.copy(this.rawKey[4], 0, this.qLength, byArray, this.privExponentLength + this.pLength + this.eLength + 4);
        this.encodedKey = (byte[])byArray.clone();
        return byArray;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        int n;
        if (this == object) {
            return true;
        }
        if (object instanceof LTPAPrivateKey && (n = this.encodedKey.length) == (byArray = ((LTPAPrivateKey)object).getEncoded()).length) {
            for (int i = 0; i < n; ++i) {
                if (this.encodedKey[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAlgorithm() {
        return "RSA/SHA-1";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        return this.encode();
    }

    public String getFormat() {
        return "LTPAFormat";
    }

    byte[][] getRawKey() {
        return (byte[][])this.rawKey.clone();
    }

    public static int toInt(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        n |= byArray[2] << 8 & 0xFF00;
        n |= byArray[1] << 16 & 0xFF0000;
        return n |= byArray[0] << 24 & 0xFF000000;
    }

    public static byte[] toByteArray(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
        return byArray;
    }
}

