/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import java.security.Key;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class LTPAKeyGenerator
implements KeyGenerator {
    private static final TraceComponent tc = Tr.register(LTPAKeyGenerator.class, null, "com.ibm.ejs.resources.security");
    private Properties customProperties = null;
    private LTPACrypto crypto = null;
    private Key ltpaSecretKey = null;

    public void init(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{properties});
        }
        this.customProperties = properties;
        this.crypto = new LTPACrypto();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public Key generateKey() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey");
        }
        try {
            if (this.crypto != null) {
                LTPAKeyGenerator lTPAKeyGenerator = this;
                this.ltpaSecretKey = new SecretKeySpec(lTPAKeyGenerator.crypto.generate3DESKey(), 0, 24, "3DES");
            }
            if (this.ltpaSecretKey != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateKeyPair");
                }
                return this.ltpaSecretKey;
            }
            throw new KeyException("Key could not be generated.");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAKeyGenerator.generateKey", "98", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error generating key.", new Object[]{exception});
            }
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(exception.getMessage(), exception);
        }
    }
}

