/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.icsf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.ws.security.icsf.ICSFLoginToken;
import com.ibm.ws.security.icsf.UserData;
import com.ibm.ws.security.util.StringUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ICSFToken
implements Serializable {
    private static final TraceComponent tc = Tr.register(ICSFToken.class, null, "com.ibm.ejs.resources.security");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd kk:mm:ss:SSS z");
    private UserData userData;
    private long expiration;
    private byte[] signature;
    public static final String DELIM = "%";
    private int defaultExpirationMins = 10;
    private ICSFLoginToken icsfLoginToken;
    private byte[] encryptedBytes = null;

    public ICSFToken(String string) {
        this.userData = new UserData(string);
        this.expiration = new Date().getTime() + (long)(this.defaultExpirationMins * 60 * 1000);
        this.icsfLoginToken = new ICSFLoginToken(string, this.expiration);
    }

    public ICSFToken(String string, long l) {
        this.userData = new UserData(string);
        this.expiration = l;
        this.icsfLoginToken = new ICSFLoginToken(string, l);
    }

    void encrypt(byte[] byArray) {
        System.out.println("sharedKey :" + new String(byArray));
        this.icsfLoginToken.encrypt(byArray);
        this.encryptedBytes = this.icsfLoginToken.getEncoded();
    }

    private static String toStrings(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 Strings =" + unsupportedEncodingException.toString());
        }
        return string;
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 bytes =" + unsupportedEncodingException.toString());
        }
        return byArray;
    }

    public String getAccessID() {
        return this.userData.getID();
    }

    public byte[] getBytes() {
        return this.encryptedBytes;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public static ICSFToken getInstance(byte[] byArray, byte[] byArray2) throws InvalidTokenException {
        ICSFLoginToken iCSFLoginToken = ICSFLoginToken.getInstance(byArray, byArray2);
        ICSFToken iCSFToken = new ICSFToken(iCSFLoginToken.getUserid(), iCSFLoginToken.getExpiresTimestamp());
        iCSFToken.encryptedBytes = byArray;
        return iCSFToken;
    }

    byte[] getSignature() {
        return this.signature;
    }

    UserData getUserData() {
        return this.userData;
    }

    public boolean isValid() {
        Date date = new Date();
        Date date2 = new Date(this.expiration);
        boolean bl = date.before(date2);
        if (!bl) {
            StringBuffer stringBuffer = this.getLogInfo();
            stringBuffer.insert(0, "token expired ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        return bl;
    }

    void setAttribute(String string, String string2) {
        this.userData.setAttribute(string, string2);
    }

    void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public String toString() {
        if (this.encryptedBytes != null) {
            return StringUtil.toString(this.encryptedBytes);
        }
        return "";
    }

    private StringBuffer getLogInfo() {
        StringBuffer stringBuffer = new StringBuffer(this.getAccessID());
        stringBuffer.append(" Expiration time: ");
        stringBuffer.append(dateFormat.format(new Date(this.expiration)));
        return stringBuffer;
    }
}

