/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.delegation.MethodDelegation;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.security.zOS.authz.SAFRoleMapperFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.security.auth.Subject;

class SAFMethodDelegation
extends MethodDelegation {
    private static final TraceComponent tc = Tr.register(SAFMethodDelegation.class, "Security", "com.ibm.ejs.resources.security");
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final SAFRoleMapper _roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();

    public SAFMethodDelegation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        Tr.audit(tc, "security.zos.saf.delegation.enabled");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected Subject getRunAsSpecifiedUserSubject(String string, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSpecifiedUserSubject", new Object[]{string, string2});
        }
        Subject subject = null;
        String string3 = _roleMapper.getProfileFromRole(string2, string);
        PlatformCredentialManager platformCredentialManager = PlatformCredentialManager.instance();
        final PlatformCredential platformCredential = platformCredentialManager.createRoleCredential(string2, string, string3);
        if (platformCredential != null) {
            object = platformCredential.getUserId();
            try {
                Subject subject2 = new Subject();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("com.ibm.wsspi.security.cred.cacheKey", platformCredential.getCacheKeyString());
                subject2.getPublicCredentials().add(hashtable);
                String string4 = contextManager.getDefaultRealm();
                String string5 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.defaultLoginConfig");
                subject = contextManager.login(string4, (String)object, string5, null, null, null, subject2);
                final WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        wSCredential.set("com.ibm.ws.security.zos.PlatformCredential", platformCredential);
                        return null;
                    }
                });
                this.clearPropagationTokenIfCallerSubjectNullOrUnauthenticated();
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.delegation.SAFMethodDelegation.getRoleCredential", "139", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception setting PlatformCredential", privilegedActionException.getException());
                }
                subject = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.delegation.SAFMethodDelegation.getRoleCredential", "145", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during SAF role to user mapping", exception);
                }
                Tr.audit(tc, "security.authn.failed.foruser", new Object[]{object});
                subject = null;
            }
        }
        if (platformCredential == null) {
            object = SAFServiceResult.getSafServiceResult();
            Tr.error(tc, "security.zos.saf.delegation.service.error", new Object[]{string, string2, object});
        }
        if (subject == null) {
            Tr.warning(tc, "security.zos.saf.delegation.using.caller.warning", (Object)new Object[]{string, string2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSpecifiedUserSubject", subject);
        }
        return subject;
    }
}

