/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.ServiceInit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.iiop.channel.IIOPServiceContextFilter;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ForwardRequest;

public class CSIv2ServiceContextFilter
implements IIOPServiceContextFilter {
    private static final TraceComponent tc = Tr.register(CSIv2ServiceContextFilter.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static String FORWARD_REQUEST_KEY = "CSIv2ForwardRequest";
    private static CSIv2ServiceContextFilter _instance = null;
    private ORB thisOrb = null;
    private CSIClientRIBase _csiClientRIBase = null;
    private CSIServerRIBase _csiServerRIBase = null;

    public static CSIv2ServiceContextFilter instance(ORB oRB) {
        if (_instance == null) {
            _instance = new CSIv2ServiceContextFilter(oRB);
        }
        return _instance;
    }

    private CSIv2ServiceContextFilter(ORB oRB) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.thisOrb = oRB;
        if (ConfigURLProperties.isSecurityEnabled()) {
            if (this.thisOrb != null) {
                if (!ServiceInit.isInitialized()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initializing ServiceInit in SC Filter.");
                    }
                    ServiceInit serviceInit = ServiceInit.getInstance();
                    serviceInit.initialize(this.thisOrb);
                }
                this._csiClientRIBase = new CSIClientRIBase();
                this._csiClientRIBase.init(this.thisOrb);
                this._csiServerRIBase = new CSIServerRIBase();
                this._csiServerRIBase.init(this.thisOrb);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ORB is not available during init.");
                }
                throw new INITIALIZE("ORB not available for initialization");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void processIncomingContext(ORB oRB, GIOPMessageContext gIOPMessageContext, GIOPConnectionContext gIOPConnectionContext, ConnectionStateElement connectionStateElement) throws Exception {
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processIncomingContext", new Object[]{oRB, gIOPMessageContext, gIOPConnectionContext, connectionStateElement});
        }
        if (gIOPMessageContext == null) {
            throw new IllegalArgumentException("GIOPMessageContext is null");
        }
        if (gIOPConnectionContext == null) {
            throw new IllegalArgumentException("GIOPConnectionContext is null");
        }
        if (connectionStateElement == null) {
            throw new IllegalArgumentException("ConnectionStateElement is null");
        }
        ConnectionHandle connectionHandle = connectionStateElement.getConnectionHandle();
        try {
            if (connectionHandle.isInternal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Internal request");
                }
            } else if (gIOPMessageContext.getType() == 0) {
                this._csiServerRIBase.removePrivateContext(gIOPMessageContext);
                this._csiServerRIBase.removeSeedContext(gIOPMessageContext);
                this._csiServerRIBase.doFilterReceiveRequest(gIOPConnectionContext, gIOPMessageContext, connectionStateElement);
            } else if (gIOPMessageContext.getType() == 1) {
                String string = FORWARD_REQUEST_KEY + gIOPMessageContext.getRequestId();
                if (connectionStateElement.getConnectionState(string) != null) {
                    connectionStateElement.setConnectionState(string, null);
                } else {
                    this._csiServerRIBase.removePrivateContext(gIOPMessageContext);
                    this._csiServerRIBase.removeSeedContext(gIOPMessageContext);
                }
                this._csiClientRIBase.doFilterReceiveReply(gIOPConnectionContext, gIOPMessageContext, connectionStateElement);
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processIncomingContext", "165", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException while processing incoming service context", (Object)systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processIncomingContext", "171", this);
            INTERNAL iNTERNAL = new INTERNAL("Exception while processing incoming CSIv2 service context");
            iNTERNAL.initCause((Throwable)exception);
            throw iNTERNAL;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processIncomingContext");
        }
    }

    public void processOutgoingContext(ORB oRB, GIOPMessageContext gIOPMessageContext, GIOPConnectionContext gIOPConnectionContext, ConnectionStateElement connectionStateElement) throws Exception {
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processOutgoingContext", new Object[]{oRB, gIOPMessageContext, gIOPConnectionContext, connectionStateElement});
        }
        if (gIOPMessageContext == null) {
            throw new IllegalArgumentException("GIOPMessageContext is null");
        }
        if (gIOPConnectionContext == null) {
            throw new IllegalArgumentException("GIOPConnectionContext is null");
        }
        if (connectionStateElement == null) {
            throw new IllegalArgumentException("ConnectionStateElement is null");
        }
        ConnectionHandle connectionHandle = connectionStateElement.getConnectionHandle();
        try {
            if (connectionHandle.isInternal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Internal request");
                }
            } else if (gIOPMessageContext.getType() == 0) {
                this._csiClientRIBase.doFilterSendRequest(gIOPConnectionContext, gIOPMessageContext, connectionStateElement);
                this._csiServerRIBase.removePrivateContext(gIOPMessageContext);
                this._csiServerRIBase.removeSeedContext(gIOPMessageContext);
            } else if (gIOPMessageContext.getType() == 1) {
                this._csiServerRIBase.doFilterSendReply(gIOPConnectionContext, gIOPMessageContext, connectionStateElement);
                this._csiServerRIBase.removePrivateContext(gIOPMessageContext);
                this._csiServerRIBase.removeSeedContext(gIOPMessageContext);
            }
        }
        catch (ForwardRequest forwardRequest) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Percolating ForwardRequest", (Object)forwardRequest);
            }
            String string = FORWARD_REQUEST_KEY + gIOPMessageContext.getRequestId();
            connectionStateElement.setConnectionState(string, (Object)new Boolean(true));
            throw forwardRequest;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processOutgoingContext", "245", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException while processing outgoing service context", (Object)systemException);
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processOutgoingContext", "251", this);
            INTERNAL iNTERNAL = new INTERNAL("Exception while processing outgoing CSIv2 service context");
            iNTERNAL.initCause((Throwable)exception);
            throw iNTERNAL;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processOutgoingContext");
        }
    }
}

